/* This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include "error.h"

/* General purpose error message handler; beware, if the printf-style
 * string is followed by arguments of the wrong type or missing
 * arguments, the program will probably crash in a nasty and silent
 * way. */

void
error (unsigned short flags, char *fmt,...)
{

  unsigned short fatal = flags & FATAL;
  unsigned short syserr = flags & SYSERR;

  va_list args;

  va_start (args, fmt);
  vfprintf (stderr, fmt, args);
  va_end (args);
  if (syserr)
    fprintf (stderr, " : %s", strerror (errno));
  fprintf (stderr, "\n");

  if (fatal)
    exit (1);
}
