/*
 * dstore.c - PTX global storage for lsof
 */


/*
 * Copyright 1995 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1995 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.2 97/04/07 09:28:00 abe Exp $";
#endif


#include "lsof.h"


/*
 * Global storage definitions
 */

struct clone *Clone = NULL;		/* clone devices */
int CloneMajor;				/* clone major device number */


/*
 * Drive_Nl -- table to drive the building of Nl[] via build_Nl()
 *             (See lsof.h and misc.c.)
 */

struct drive_Nl Drive_Nl[] = {
	{ "asoplg",	"asops_large"	},
	{ "asopsm",	"asops_small"	},
	{ "cvops",	"cdfs_vnodeops"	},
	{ "clmaj",	"clone_c_major"	},
	{ "fvops",	"fifo_vnodeops"	},
        { X_NCACHE,	"ncache"	},
        { X_NCSIZE,	"ncsize"	},
        { "nfsvops",	"nfs_vnodeops"	},
        { "nmvops",	"nm_vnodeops"	},
        { "nofile",	"Nofile"	},
        { "proc",	"proc"		},
	{ "sckvops",	"sock_vnodeops"	},
	{ "spvops",	"spec_vnodeops"	},
	{ "uvops",	"ufs_vnodeops"	},
	{ "var",	"v"		},
	{ "vvops",	"vx_vnodeops"	},
	{ "vxdnlc",	"vx_dnlc_hash"	},
	{ "vxndnlc",	"vx_dnlc_nhash"	},
	{ "",		""		},
	{ NULL,		NULL,		}
};

int HaveCloneMajor = 0;			/* CloneMajor status */
int Kd = -1;				/* /dev/kmem file descriptor */
struct l_vfs *Lvfs = NULL;		/* local vfs structure table */
int Notkmem = 0;			/* core file is not /dev/kmem */

# if	PTXV<400
int Swap = -1;				/* swap device file descriptor */
# endif	/* PTXV<400 */
