/*
 * day menu widgets.
 *
 *	destroy_day_menu()		remove day menu
 *	create_day_menu()		Create all widgets in day calendar
 *					window.
 *
 * the day menu is actually rather similar to the week menu, and uses the
 * same node tree structure to describe the display. Since week views came
 * first the structure is called "struct week".
 */

#ifndef MIPS
#include <stdlib.h>
#endif
#include <stdio.h>
#include <time.h>
#include <varargs.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelP.h>
#include <Xm/ArrowBP.h>
#include <Xm/ArrowBG.h>
#include <Xm/PushBP.h>
#include <Xm/PushBG.h>
#include <Xm/Text.h>
#include <Xm/ScrolledW.h>
#include <Xm/DrawingA.h>
#include <Xm/Protocols.h>
#include "cal.h"

static void resize_canvas();
static void done_callback(), edit_callback(), sync_callback();
static void day_callback(), prev_callback(), next_callback();

extern Display		*display;	/* everybody uses the same server */
extern struct config	config;		/* global configuration data */
extern struct plist	*mainlist;	/* list of all schedule entries */
extern Widget		mainwindow;	/* popup menus hang off main window */
extern time_t		curr_day;	/* day being displayed, time in sec */
extern struct week	day;		/* info on day view */

static Widget		parent_form;	/* if in mainwindow, parent form */
static Widget		shell;		/* week window, 0 if none */


/*
 * destroy the day menu. Remove it from the screen, and destroy its widgets.
 */

void destroy_day_menu()
{
	if (shell) {
		if (!parent_form)
			XtPopdown(shell);
		XTDESTROYWIDGET(shell);
		destroy_day();
		shell = 0;
		day.canvas = 0;
	}
}


/*
 * create the day menu for the day beginning on curr_day.
 */

void create_day_menu(parent)
	Widget		parent;
{
	Arg		args[15];
	int		n;
	Widget		form, w;
	Atom		closewindow;

	build_day(FALSE, FALSE);

	form = create_view_form(&shell, parent_form = parent, 'd',
				day.canvas_xs, day.canvas_ys, "Day View");
	if (!form) {
		draw_day_calendar(NULL);
		return;
	}
	XtAddCallback(form, XmNhelpCallback, help_callback, (XtPointer)"day");

							/*-- buttons --*/
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		50);			n++;
	w = XtCreateManagedWidget("Prev", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, prev_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"day_prev");
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNleftWidget,	w);			n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		50);			n++;
	w = XtCreateManagedWidget("Next", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback,next_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,    help_callback, (XtPointer)
								"day_next");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Done", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, done_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"day_done");
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Help", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback,help_callback, (XtPointer)"day");
	XtAddCallback(w, XmNhelpCallback,    help_callback, (XtPointer)"day");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Edit", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, edit_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"day_edit");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	XtSetArg(args[n], XmNsensitive,		!all_files_served());	n++;
	w = XtCreateManagedWidget("Sync", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, sync_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"day_sync");

							/*--- infotext --- */
	n = 0;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNbottomWidget,	w);			n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNalignment,         XmALIGNMENT_BEGINNING);	n++;
	day.info = XtCreateManagedWidget(" ", xmLabelWidgetClass,
			form, args, n);

							/*--- day view ---*/
	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopOffset,		8);			n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNbottomWidget,	day.info);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		day.canvas_xs +4);	n++;
	XtSetArg(args[n], XmNheight,		day.canvas_ys +4);	n++;
	XtSetArg(args[n], XmNscrollingPolicy,	XmAUTOMATIC);		n++;
	day.scroll = XtCreateWidget("scroll", xmScrolledWindowWidgetClass,
			form, args, n);

	n = 0;
	XtSetArg(args[n], XmNwidth,		day.canvas_xs);		n++;
	XtSetArg(args[n], XmNheight,		day.canvas_ys);		n++;
	day.canvas = XtCreateWidget("daycal", xmDrawingAreaWidgetClass,
					day.scroll, args, n);
	XtAddCallback(day.canvas, XmNinputCallback,
					day_callback, (XtPointer)NULL);
	XtAddCallback(day.canvas, XmNexposeCallback,
					day_callback, (XtPointer)NULL);
	XtManageChild(day.canvas);
	XtManageChild(day.scroll);
	XtManageChild(form);

	if (!parent) {
		XtPopup(shell, XtGrabNone);
		closewindow = XmInternAtom(display, "WM_DELETE_WINDOW", False);
		XmAddWMProtocolCallback(shell, closewindow,
				done_callback, (XtPointer)shell);
	}
}


/*
 * resize a DrawingArea canvas, and resize the shell that contains it by
 * the same amount. Also, resize the scrolling widget around the canvas.
 * Make it a bit larger for the shadow.
 */

static void resize_canvas(shell, scroll, canvas, xs, ys)
	Widget		shell;		/* shell with the DrawingArea */
	Widget		scroll;		/* scrolling area around canvas */
	Widget		canvas;		/* DrawingArea */
	int		xs, ys;		/* new DrawingArea size */
{
	Dimension	sh_xs, sh_ys;	/* previous size of the shell */
	Dimension	can_xs, can_ys;	/* previous size of the canvas */

	if (parent_form)
		return;
	get_widget_size(shell,  &sh_xs,  &sh_ys);
	get_widget_size(canvas, &can_xs, &can_ys);
	set_widget_size(canvas, xs,      ys);
	set_widget_size(scroll, xs+4,    ys+4);
	set_widget_size(shell,  sh_xs - can_xs + xs,
				sh_ys - can_ys + ys);
}


/*-------------------------------------------------- callbacks --------------*/
/*
 * All of these routines are direct X callbacks.
 */

/*ARGSUSED*/
static void prev_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	curr_day -= 86400;
	build_day(FALSE, FALSE);
	draw_day_calendar(NULL);
}


/*ARGSUSED*/
static void next_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	curr_day += 86400;
	build_day(FALSE, FALSE);
	draw_day_calendar(NULL);
}


/*ARGSUSED*/
static void done_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	if (parent_form)
		create_view('m');
	else
		destroy_day_menu();
}


/*ARGSUSED*/
static void edit_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	create_list_popup(mainlist, curr_day, config.day_ndays*86400,
					0, (struct entry *)0, 0, 0);
}


/*ARGSUSED*/
static void sync_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	if (!can_edit_appts())
		return;
	if (mainlist->modified) {
		write_mainlist();
		resynchronize_daemon();
	}
	read_mainlist();
	update_all_listmenus();
	redraw_all_views();
}


/*ARGSUSED*/
static void day_callback(w, data, info)
	Widget				w;
	XtPointer			data;
	XmDrawingAreaCallbackStruct	*info;
{
	if (info->reason == XmCR_INPUT && info->event->xany.type ==ButtonPress)
		clicked_day_calendar(info->event->xbutton.x,
				      info->event->xbutton.y,
				      info->event->xbutton.time);

	else if (info->reason == XmCR_EXPOSE) {
		XEvent dummy;
		Region region = XCreateRegion();
		XtAddExposureToRegion(info->event, region);
		while (XCheckWindowEvent(display, info->window, ExposureMask,
								&dummy))
			XtAddExposureToRegion(&dummy, region);
		draw_day_calendar(region);
	}
}
