// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   MLRendererOptions.h

   Stephane Rehel

   September 14 1997
*/

#ifndef __MLRendererOptions_h
#define __MLRendererOptions_h

#ifndef __IBOOL_h
#include "tools/IBOOL.h"
#endif

#ifndef __Color_h
#include "tools/Color.h"
#endif

#ifndef __OString_h
#include "tools/OString.h"
#endif

class MLScene;

/////////////////////////////////////////////////////////////////////////////

class MLRendererOptions
{
protected:
  MLScene* scene;

public:
  int xres, yres;

  int maxRayDepth; // >= 1

  IBOOL verticesShader;

  Color backgroundColor;

  IBOOL use_system_gamma_correction;
  double current_system_gamma_correction; // set or not by the graphics
                                          // system
  double gamma_correction;

  // trace shadows when necessary
  IBOOL trace_shadows;

  // trace radiosity shadows
  IBOOL trace_global_shadows;

  IBOOL trace_reflections;
  IBOOL trace_transmissions;

  IBOOL writeImage;
  OString imageFilename;
  int imageFormat; // from MLImageFormat
  IBOOL compress_tiff;
  IBOOL progressive_jpeg;
  int jpeg_quality;

  IBOOL has_constrain_ratio;
  double constrain_ratio;

  IBOOL emitBeep;

public:
  MLRendererOptions( MLScene* _scene );

  virtual ~MLRendererOptions();

  MLScene* getScene() const
    {
    return scene;
    }

  void clear();

  double getGammaCorrection() const;
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLRendererOptions_h

