// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoStatusBars.h

  Stephane Rehel

  October 25 1997
*/

#ifndef __PhotoStatusBars_h
#define __PhotoStatusBars_h

#ifndef __MLActionHandler_h
#include "interface/MLActionHandler.h"
#endif

class PhotoModule;
class MLStatusBars;
class MLStatusLineText;
class MLStatusLineButton;


/////////////////////////////////////////////////////////////////////////////

class PhotoStatusBars: public MLActionHandler
{
  friend class PhotoModule;
protected:
  PhotoModule* photo;
  MLStatusBars* statusBars;

  MLStatusLineText* modeInfo;
  MLStatusLineText* message;

  MLStatusLineButton* single_multiple;

public:
  PhotoStatusBars( PhotoModule* _photo, MLStatusBars* _statusBars );

  virtual ~PhotoStatusBars();

  void init();

  void update();

protected:
  virtual IBOOL handleAction( MLAction* action );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __PhotoStatusBars_h
