### Copyright (C) 1995-1997 Jesper K. Pedersen
### This program is free software; you can redistribute it and/or modify
### it under the terms of the GNU General Public License as published by
### the Free Software Foundation; either version 2 of the License, or
### (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


######################################################################
#   function to insert information about the actual info
#   into the info list.
######################################################################
proc print {args} {
  global __answers __editInfo __fileHandles setup
  if {[string match [lindex $args 0]* "-file"] && [lindex $args 0] != ""} {
    set handler [lindex $args 1]
    set args [lrange $args 2 end]
    if {![info exists __fileHandles($handler)]} {
	    error "Wrong handler: \"$handler\", should be one of" \
          "\"[array names __fileHandles]\""
    }
  } else {
    set handler [lindex [lindex $setup(dotfile) 0] 0]
  }
  append __answers($handler) [join $args] "\n"
}

######################################################################
#                    set the description
######################################################################
proc Desc {args} {
  global __editInfo __desc
  set function $__editInfo(name)
  set __desc($function) [makeText $args]
}

######################################################################
### This function set help for the given widget
######################################################################
proc Help {widget args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
  if {![info exists __widgetArgs(${function}__${widget}__type)]} {
    error "While setting help, widget \"$widget\" didn't exists"\
        "in page \"$function\""
  } elseif {$__widgetArgs(${function}__${widget}__help) != "No Help"} {
      error "Help text given more than once for widget \"$widget\""\
          "on page \"$function\""
  } else {
    set __widgetArgs(${function}__${widget}__help) [makeText $args]
  }
}

######################################################################
### This function add entry help for a combobox, listbox, menu or
### radio element
######################################################################
proc EntryHelp {widget entry args} {
  global __widgetArgs __editInfo
  set function $__editInfo(name)
    if {![info exists __widgetArgs(${function}__${widget}__type)]} {
    error "While setting entryhelp: widget \"$widget\" didn't exists"\
        "in page \"$function\""
  }
  set type $__widgetArgs(${function}__${widget}__type)
  if {$type != "menu" && $type != "listbox" && $type != "combobox" &&
      $type != "radio"} {
    error "While setting entryhelp: widget \"$widget\" has an illigal type"\
        "\"$type\" no entryhelp may be specified for this type."
  }

  set entries $__widgetArgs(${function}__${widget}__entries)
  set entryhelp $__widgetArgs(${function}__${widget}__entryhelp)

  set index 0
  set found 0
  set result {}
  foreach elm $entries {
    lappend result $elm
    if {$elm == $entry} {
      lappend result [makeText $args]
      set found 1
    } else {
      lappend result [lindex $entryhelp [expr 2*$index+1]]
    }
    incr index
  }
  if {!$found} {
    error "While setting entryhelp: entry \"$entry\" not found in -entries"\
        "list"
  }
  set __widgetArgs(${function}__${widget}__entryhelp) $result 
}

######################################################################
#               set the short description
######################################################################
proc ShortDesc {args} {
  global __shortDesc setup __editInfo
  set function $__editInfo(name)
  
  append __shortDesc($function) "[makeText $args]"
}

######################################################################
#             function to create save functions
######################################################################
proc Save {funk} {
  global __ok __editInfo
  set function $__editInfo(name)
  append __ok($function) $funk\n
}

######################################################################
#      create function to be called whenever changes
#      are made to the scheme
######################################################################
proc Change {funk} {
  global __editInfo __changeFunc
  set function $__editInfo(name)
  append __changeFunc($function) $funk\n
}
######################################################################
#  create function to be called at startup the first time
######################################################################
proc Init {funk} {
  global __initFunc __editInfo
  set function $__editInfo(name)
  append __initFunc($function) $funk\n
}
######################################################################
#      create function to be called whenever changes
#      are made to the scheme
######################################################################
proc PageEnd {funk} {
  global __editInfo __pageEnd
  set function $__editInfo(name)
  append __pageEnd($function) $funk\n
}
######################################################################
### This function is called from the dotdotfile to give the
### ShowPage functoin
######################################################################
proc ShowPage {funk} {
  global __editInfo __showPage
  set function $__editInfo(name)
  append __showPage($function) $funk\n
}
 
######################################################################
# This function activates the change function which it
# read in changeFunc($function)
######################################################################
proc setChangeFunc {} {
  global __editInfo __changeFunc
  set function $__editInfo(name)
  if {$__changeFunc($function) == ""} {
    proc makeChange {name prefix {menuCreate 0}} "global __changed;UpdateActive \$name \$prefix; if {!\$menuCreate} {set __changed 1}"
  } else {
    proc makeChange {name prefix {menuCreate 0}} "global __changed changeElm;set changeElm \$name;UpdateActive \$name \$prefix;if {!\$menuCreate} {set __changed 1}; uplevel \#0 \{$__changeFunc($function)\}"
  }
}

######################################################################
#                        Edit WINDOW
######################################################################
proc makeEdit {} {
  global module setup __editInfo
  toplevel .edit
  wm resizable .edit 0 0
  pack [frame .edit.name]
  pack [frame .edit.save -bd 2 -relief ridge] -side bottom -fill x -expand yes 
  pack [frame .edit.description -bd 0] -side bottom -fill x

  
  label .edit.description.desc -justify left
  pack .edit.description.desc -fill x

  wm withdraw .edit
  if {$setup(placeWindows)} {
    wm geometry .edit +300+0
  }
  wm deiconify .edit
  wm title .edit "$module(name) module"
  if {[info exists __editInfo(windowLocation)]} {
    wm geometry .edit $__editInfo(windowLocation)
  } else {
    set x [winfo reqwidth .]
    wm geometry .edit +[expr $x+10]+0
  }
  bind .edit.description.desc <3> "setDesc \$__desc(\$__editInfo(name)) .edit"
  wm protocol .edit  WM_DELETE_WINDOW {
    if {[checkPage] == 0} {
      return
    }
    destroy .edit
  }
}


######################################################################
#           This function set the description
######################################################################
proc setDesc {desc widget} {
  set top [winfo toplevel $widget]
  $top.description.desc configure -text ""
  update
  set width [winfo reqwidth $top]
  $top.description.desc configure -text $desc \
      -wrap [expr $width-20]
}


######################################################################
#               Quit
######################################################################
proc quit {} {
  global __changed
  if {$__changed} {
    set answer [tk_dialog .dialog "Unsaved Information" \
		    "There's information, which haven't been saved what do you want to do" questhead 2 Quit "Dont Quit" Save "Save As..."]
    if {$answer == 2 || $answer == 3} {
      if {[checkPage] == 0} {
        return
      }
    }
    if {$answer == 2} save
    if {$answer == 3} {saveOrExport user-save}
    if {$answer == 1} return
  }
  exit
}

######################################################################
# This function is call be the dotdotfiles when refering
# variable in fillout element on another page.
# Please refer to the dotdotfile manual in the section
# concerning "Referencing variable in other configuration files"
######################################################################
proc expand {name {array ""}} {
  global  __func
  global $__func$name
  if {$array == ""} {
    eval return [set [set __func][set name]]
  } else {
    eval return [set [set __func][set name]($array)]
  }
}

######################################################################
# This function set the What To Generate buttons on the
# bottom of the configuration page
######################################################################
proc setWhatToGenerate {} {
  global setup __editInfo
  if {![winfo exists .edit.save]} return

  if {$setup(whatToGenerate) == "one" || $setup(whatToGenerate) == "all"} {
    if {[winfo exists .edit.save.yes]} {
      catch "destroy .edit.save.yes .edit.save.no"
    }
    if {![winfo exists .edit.save.label]} {
      pack [label .edit.save.label]
    }
    if {$setup(whatToGenerate) == "one"} {
      .edit.save.label configure -text "Only this page will be generated"
    } else {
      .edit.save.label configure -text "All pages will be generated"
    }
  } else { ;# selected
    if {[winfo exist .edit.save.label]} {
      catch "destroy .edit.save.label"
    }
    if {![winfo exist .edit.save.yes]} {
      radiobutton .edit.save.yes -text "Will be generated" -value 1
      radiobutton .edit.save.no -text "Will not be generated" -value 0
      pack .edit.save.yes .edit.save.no -side left -expand 1
    }
    .edit.save.yes configure -variable __saveInfo($__editInfo(name))
    .edit.save.no configure -variable __saveInfo($__editInfo(name))
  }
}

######################################################################
# This function tell the Dotfile Generator which global
# variable, the module what to save.
######################################################################
proc SaveVars {args} {
  global __saveVars
  foreach var $args {
    uniqAppend __saveVars $var
  }
}
  
######################################################################
# This function creates a temp. window
######################################################################
proc makeTempWindow {title} {
  set counter 0
  while {[winfo exists .temp$counter]} {
    incr counter
  }
  set w .temp$counter
  toplevel $w
  wm title $w $title
  set x [expr [winfo screenwidth $w]/2 - 100 \
	     - [winfo vrootx [winfo parent $w]]]
  set y [expr [winfo screenheight $w]/2 - 100 \
	     - [winfo vrooty [winfo parent $w]]]
  wm geom $w +$x+$y
  return $w
}
######################################################################
### This function is used from the init function to add a tuple
### to an ExtEntry from the Init function
######################################################################
proc AddTuple {name} {
  global __editInfo __widgetArgs __scrollBar __children

  set function $__editInfo(name)
  if {![info exists __widgetArgs(${function}__${name}__type)]} {
    error "AddTuple: widget \"$name\" doesn't exists on page \"$function\""
  }

  if {$__widgetArgs(${function}__${name}__type) != "extentry"} {
    error "AddTuple: widget \"$widget\" isn't an ExtEntry"
  }

  set prefix [buildPath $name $function]
  set offset [lindex $__scrollBar(${prefix}_$name) 0]
  set total [lindex $__scrollBar(${prefix}_$name) 1]

  foreach child $__children(${function}__$name) {
    setVariable $function $child ${prefix}_$name$total \
        $__widgetArgs(${function}__${child}__default) 0
    changeState $function ${prefix}_$name$total $child normal 1
  }

  UpdateActive $child ${prefix}_$name$total
  set __scrollBar(${prefix}_$name) [list $offset [expr $total+1]]
}

