#include "config.h"
#if HAVE_OSF_PARTITION

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <asm/types.h>
#include "byteorder.h"

#include "fdisk.h"

int parse_osf_partition(char *device, int fd)
{
    int i;
    struct disklabel {
	__u32 d_magic;
	__u16 d_type,d_subtype;
	__u8 d_typename[16];
	__u8 d_packname[16];
	__u32 d_secsize;
	__u32 d_nsectors;
	__u32 d_ntracks;
	__u32 d_ncylinders;
	__u32 d_secpercyl;
	__u32 d_secprtunit;
	__u16 d_sparespertrack;
	__u16 d_sparespercyl;
	__u32 d_acylinders;
	__u16 d_rpm, d_interleave, d_trackskew, d_cylskew;
	__u32 d_headswitch, d_trkseek, d_flags;
	__u32 d_drivedata[5];
	__u32 d_spare[5];
	__u32 d_magic2;
	__u16 d_checksum;
	__u16 d_npartitions;
	__u32 d_bbsize, d_sbsize;
	struct d_partition {
	    __u32 p_size;
	    __u32 p_offset;
	    __u32 p_fsize;
	    __u8  p_fstype;
	    __u8  p_frag;
	    __u16 p_cpg;
	} d_partitions[8];
    } * label;
    struct d_partition * partition;
#define DISKLABELMAGIC (0x82564557UL)
    unsigned char data[512];
    int minor = 1;

    if (!sread( fd, 0, data ))
	return -1;
    label = (struct disklabel *) (data+64);
    partition = label->d_partitions;
    if (label->d_magic != __cpu_to_le32(DISKLABELMAGIC) ||
	label->d_magic2 != __cpu_to_le32(DISKLABELMAGIC))
	return 0;
    for (i = 0 ; i < __le16_to_cpu(label->d_npartitions); i++, partition++) {
	if (__le32_to_cpu(partition->p_size) && partition->p_fstype != 0)
	    fdisk_add_partition(device, minor,
				PTYPE_PREFIX_OSF | partition->p_fstype,
				__le32_to_cpu(partition->p_size)/2);
	minor++;
    }
    return 1;
}

#endif /* HAVE_OSF_PARTITION */
