#include <stdio.h>
#include <glob.h>
#include <sys/mount.h>
#include "dinstall.h"
#include <newt.h>
#include "../busybox/internal.h"
#include "lang.h"

#ifndef _TESTING_
#define CM_MOUNTPOINT_DIR "/instmnt"
#else
#define CM_MOUNTPOINT_DIR "instmnt"
#endif

int dirc=0;
char **dirv;
char *pattern;


#include <string.h>
#include <dirent.h>

/* ED: floppy filesystem type is not the same for all architectures */
#if #cpu(sparc)
static char *fs_type = "ext2";
#else
static char *fs_type = "msdos";
#endif

extern int mount_one(char *blockDevice, char *directory, char *filesystemType, 
  unsigned long flags, char *string_flags, int noMtab, int fake);

int mount_and_check_floppy (char *device, const char *type, const char *text) {
  int dinam=0,it,status;
  char *actualType=NULL;
  newtComponent f1, t1, b1, lb;
  FILE *tmpstream;
  struct stat statbuf;

  for (;;) {
    do_umount("/floppy",0);
    if (!device) {
      it=0;
      dinam=1;
      newtOpenWindow (10, 8, 60, 15, MSG_SELECT_DISK_DRIVE);
      t1 = newtTextbox (1, 0, 58, 2, NEWT_FLAG_WRAP);
      sprintf(prtbuf,MSG_SELECT_FLOPPY_DRIVE, text);
      newtTextboxSetText(t1, prtbuf);
      lb = newtListbox(5, 2, 3, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
      if (strcmp(InstallationRootDevice,"/dev/fd0")) {
        newtListboxAddEntry(lb,MSG_FLOPPY_FD0,"/dev/fd0");
        it++;
      }
      if (strcmp(InstallationRootDevice,"/dev/fd1")) {
        newtListboxAddEntry(lb,MSG_FLOPPY_FD1,"/dev/fd1");
        it++;
      }
      f1 = newtForm(NULL, NULL, 0);
      b1 = newtCompactButton ( 35, it+6, MSG_CANCEL );
      newtFormAddComponents (f1 , t1, lb, b1, NULL);
      if ( newtRunForm(f1) == b1) {
        return -1;
      }
      device=newtListboxGetCurrent(lb);
      newtPopWindow();
      newtFormDestroy(f1);
    }
    if (! strncmp(device,"/dev/fd",7) ){
      sprintf(prtbuf,MSG_PLACE_FLOPPY,text,
        ((device[7]=='0')?MSG_FIRST:MSG_SECOND));
      if (twoButtonBox(prtbuf,MSG_PLEASE_INSERT_DISK,
			MSG_CONTINUE,MSG_CANCEL)==0) {
        if(dinam) free(device);
        return -1;
      }
    }
    
    if ( mount_one(device,"/floppy",fs_type,MS_RDONLY,"\0",0,0) ) {
      sprintf(prtbuf,MSG_UNABLE_TO_MOUNT,text);
      problemBox(prtbuf,MSG_MOUNT_FAILED);
      if(dinam) free(device);
      continue;
    }

    if (! NAME_ISREG( T_FILE("/floppy/type.txt"), &statbuf ) ) {
      sprintf(prtbuf,MSG_WRONG_FLOPPY_L,text,text,((device[7]=='0')?MSG_FIRST:MSG_SECOND));
      continue;
    }
    if ((tmpstream=fopen("/floppy/type.txt","r"))==NULL) {
      perrorBox(MSG_CANNOT_OPEN_TYPE_TXT);
      continue;
    }
    actualType=(char *)malloc(10);
    status=fscanf(tmpstream,"%10s",actualType)-1;
    fclose(tmpstream);
    if(status) {
      perrorBox(MSG_CANNOT_READ_TYPE_TXT);
    } else {
      status=strcmp(type,actualType);
      if(status) {
        sprintf(prtbuf,MSG_WRONG_FLOPPY_L,text,text,((device[7]=='0')?MSG_FIRST:MSG_SECOND));
        problemBox(prtbuf,MSG_WRONG_FLOPPY);
      }
    }
    free(actualType);
    if (!status) {
      if(dinam) free(device);
      return 0;
    }
  }
}

int match_find(const struct FileInfo * i) {
  char *name,*source;
  struct stat statbuf;
  
  source=strdup(i->source);
  name=strrchr(source,'/');
  if (name) {
    *name='\0';
    name++;
  } else {
    name=source;
  }
  if (! strcmp(name,pattern) ) {
    sprintf(prtbuf,"%s/%s",source,DRVDISKIMG);
    if ( ( disqtype == base ) || 
         (NAME_ISREG( T_FILE(prtbuf),&statbuf)) ) {
      if ( (dirc) && (!(dirc%5)) ) 
        dirv=(char**)realloc(dirv,(dirc+5)*sizeof(char *));
      dirv[dirc]=strdup(source);
      dirc++;
    }
  }
  free(source);
  return 0;
}

static int choose_archive_dir (char *text) {
#define ARC_default     100
#define ARC_list        101
#define ARC_manually    102
  char *mountpoint, *descr, *path=NULL, *def, *inputdir;
  static char *preventry=NULL;
  newtComponent f1, t1, b1, lb;
  int *data, arc[]={ ARC_default, ARC_list, ARC_manually};
/*  glob_t globbuf; */
  struct stat statbuf;
  struct FileInfo finfo;
  int i,status=0,it=0;

  if (text==NULL) {
   text=MSG_CHOOSE_DIR;
   mountpoint="";
  } else {
    mountpoint=CM_MOUNTPOINT_DIR;
  }
  /* keep user entry between calls to choose_archive_dir */
  if (!preventry) preventry=strdup("/debian");
  for (;;) {
    path=inputBox(text,MSG_CHOOSE_PATH,preventry);
    if (! path) return 1;
    free(preventry);
    preventry=path;
    sprintf(prtbuf,"%s/%s",mountpoint,(path[0]=='/')?path+1:path);
    if ( NAME_ISDIR(T_FILE(prtbuf),&statbuf)) break;
  }
  mountpoint=strdup(prtbuf);

  switch (disqtype) {
    case kernel:
      /* this could be a wildcard pattern but no multiple match */
      pattern=KERDISKIMG;
      descr=MSG_KERNEL_AND_MODULES;
      break;
    default:
      pattern=BASETGZ;
      descr=MSG_THE_BASE_SYSTEM;
      break;
  }

  def=NULL;

/* FIXME. This isn't working fine yet.
**
**  sprintf(prtbuf,"%s/dists/""*""/main/disks-%s/current",mountpoint,ARCHNAME);
**  globbuf.gl_offs = 0;
**  i=glob( T_FILE(prtbuf), 0, NULL, &globbuf); 
**  if ( i != GLOB_NOMATCH ) {
**    for (i=0;i<globbuf.gl_pathc;i++) {
**      sprintf(prtbuf,"%s/%s",globbuf.gl_pathv[i],pattern);
**      if (NAME_ISREG( T_FILE(prtbuf),&statbuf)) {
**        sprintf(prtbuf,"%s/%s",globbuf.gl_pathv[i],DRVDISKIMG);
**        if ( (disqtype != kernel) ||
**             (NAME_ISREG( T_FILE(prtbuf),&statbuf)) ){
**          def=strdup(globbuf.gl_pathv[i]);
**          break;
**        }
**      } 
**    }
**  }
**  globfree(&globbuf);
**
*/

  sprintf(prtbuf,"%s/stable/main/disks-%s/current/%s",mountpoint,ARCHNAME,
      pattern);
  if (NAME_ISREG( T_FILE(prtbuf),&statbuf)) {
    sprintf(prtbuf,"%s/stable/main/disks-%s/current/%s",mountpoint,ARCHNAME,
        DRVDISKIMG);
    if ( (disqtype != kernel) || (NAME_ISREG( T_FILE(prtbuf),&statbuf)) ){
      sprintf(prtbuf,"%s/stable/main/disks-%s/current",mountpoint,ARCHNAME);
      def=strdup(prtbuf);
    }
  }
  t1 = newtTextbox (1, 0, 68, 3, NEWT_FLAG_WRAP);
  lb = newtListbox(2, 3, 0, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
  if (def) {
    sprintf(prtbuf,MSG_SELECT_DIR2,pattern,descr);
    newtListboxAddEntry(lb,MSG_DEFAULT_ARCHIVE,&arc[0]);
    it++;
  }

  if (it==0) sprintf(prtbuf,MSG_SELECT_DIR, pattern,descr);
  newtListboxAddEntry(lb,MSG_CHOOSE_FROM_LIST, &arc[1]);
  it++;
  
  if (it==0) sprintf(prtbuf,MSG_IFILE_NOT_FOUND, pattern,pattern,descr);
  newtTextboxSetText(t1,prtbuf);
  newtListboxAddEntry(lb,MSG_ENTER_DIR, &arc[2]);
  b1 = newtCompactButton ( 30, it+6, MSG_CANCEL );
  newtOpenWindow (5, 8, 70, 7+it, MSG_SELECT_PATH);
  f1 = newtForm(NULL, NULL, 0);
  newtFormAddComponents (f1 , t1, lb, b1, NULL);
  if ( newtRunForm(f1) == b1) {
    status = -1;
    newtPopWindow();
    newtFormDestroy(f1);
  } else {
    data = newtListboxGetCurrent(lb);
    newtPopWindow();
    newtFormDestroy(f1);

    switch (*data) {
      case ARC_default:
        Archive_Dir=strdup(def);
        free(def);
        break;
      case ARC_list:
	/*
	 * Build the list.
	 */
	sprintf(prtbuf,MSG_BUILDING_LIST,pattern,descr);
	pleaseWaitBox(prtbuf);
	dirc=0;
	dirv=(char **)malloc(5*sizeof(char *));
	memset((void *)&finfo, 0, sizeof(struct FileInfo));
	finfo.source=strdup(mountpoint);
	stat(finfo.source,&finfo.stat);
	finfo.processDirectoriesAfterTheirContents=1;
	descend(&finfo,match_find);
	newtPopWindow();

	/*
	 * List menu
	 */
	if (dirc) {
          newtOpenWindow (8, 8-dirc/2, 64, 6+dirc, MSG_SELECT_PATH);
          t1 = newtTextbox (1, 0, 62, 2, NEWT_FLAG_WRAP);
          sprintf(prtbuf, MSG_SELECT_DIR_USE,descr);
          newtTextboxSetText(t1,prtbuf);
          lb = newtListbox(2, 3, dirc + 2, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
          for (i=0;i<dirc;i++) {
	    /*
	     * This shortens paths that are too long to be displayed.
	     */
	    if(strlen(dirv[i])>56-3-2) /* text - left - 2 */
	      {
	        strcpy(prtbuf,"...");
	        strcat(prtbuf+3,dirv[i]+strlen(dirv[i])-56+3+3);
	      }
	    else
	      strcpy(prtbuf,dirv[i]);
            newtListboxAddEntry(lb,prtbuf,dirv[i]);
          }
          f1 = newtForm(NULL, NULL, 0);
          b1 = newtCompactButton ( 27, dirc+5, MSG_CANCEL );
          newtFormAddComponents (f1 , t1, lb, b1, NULL);
          if ( newtRunForm(f1) == b1) {
            status = -1;
          } else {
            Archive_Dir= strdup((char *) newtListboxGetCurrent(lb));
          }
          newtPopWindow();
          newtFormDestroy(f1);
	} else {
	  sprintf(prtbuf,MSG_COULDNT_FIND_DIR,pattern);
          problemBox(prtbuf,MSG_FILE_NOT_FOUND);
          status = -1;
	}
        break;
      case ARC_manually:
        sprintf(prtbuf,MSG_ENTER_ARCHIVE_DIR,mountpoint);
        inputdir=inputBox(prtbuf,MSG_ENTER_ARCHIVE_DIR_T,mountpoint);
        if (! inputdir) {
          status = -1;
        } else {
	  Archive_Dir=inputdir;
          sprintf(prtbuf,"%s/%s",Archive_Dir,pattern);
          if (! NAME_ISREG(T_FILE(prtbuf),&statbuf)) {
            sprintf(prtbuf,MSG_NOT_CONTAIN_FILE,Archive_Dir,pattern,descr);
            problemBox(prtbuf,MSG_FILE_NOT_FOUND);
            status = -1;
          } else {
            sprintf(prtbuf,"%s/%s",Archive_Dir,DRVDISKIMG);
            if ( (disqtype == kernel) &&
                 (! NAME_ISREG(T_FILE(prtbuf),&statbuf)) ) {
              sprintf(prtbuf,MSG_NOT_CONTAIN_FILE,Archive_Dir,DRVDISKIMG,descr);
              problemBox(prtbuf,MSG_FILE_NOT_FOUND);
              status = -1;
            }
          }
        }
        break;
    }
  }
  free(mountpoint);
  while(dirc) {
    dirc--;
    free(dirv[dirc]);
  }
  free (dirv);
  return status;
}


static int choose_cdrom (void) {
  char *devs[10]={"/dev/scd0","/dev/hda","/dev/hdb","/dev/hdc","/dev/hdd",
       "/dev/hde","/dev/hdf","/dev/hdg","/dev/hdh","propietary"},*choice;
  newtComponent f1, t1, b1, lb;
  int status;

  newtOpenWindow (3, 5, 74, 15, MSG_SELECT_CD_TYPE_T);
  t1 = newtTextbox(1, 0, 70, 1, NEWT_FLAG_WRAP);
  newtTextboxSetText(t1,MSG_SELECT_CD_TYPE);
  lb = newtListbox(0, 2, 12, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
  newtListboxAddEntry(lb,MSG_CD_SCSI,devs[0]);
  newtListboxAddEntry(lb,
    MSG_CD_HDA,devs[1]);
  newtListboxAddEntry(lb,
    MSG_CD_HDB,devs[2]);
  newtListboxAddEntry(lb,
    MSG_CD_HDC,devs[3]);
  newtListboxAddEntry(lb,
    MSG_CD_HDD,devs[4]);
  newtListboxAddEntry(lb,
    MSG_CD_HDE,devs[5]);
  newtListboxAddEntry(lb,
    MSG_CD_HDF,devs[6]);
  newtListboxAddEntry(lb,
    MSG_CD_HDG,devs[7]);
  newtListboxAddEntry(lb,
    MSG_CD_HDH,devs[8]);
  newtListboxAddEntry(lb,
    MSG_CD_PROPIETARY,devs[9]);
  f1 = newtForm(NULL, NULL, 0);
  b1 = newtCompactButton ( 35, 14, MSG_CANCEL );
  newtFormAddComponents (f1 , t1, lb, b1, NULL);
  if ( newtRunForm(f1) == b1) {
    return -1;
  }
  choice=(char *)newtListboxGetCurrent(lb);
  newtPopWindow();
  newtFormDestroy(f1);

  if (!strncmp(choice,"/dev",4)) {
    if (!strcmp(choice,"/dev/scd0")) {
      if (no_match("/proc/scsi","0",S_IFREG)) {
        problemBox(MSG_NO_CD_SCSI,MSG_NO_CD_SCSI_T);
      }
    }
    chdir("/dev");
    unlink("cdrom");
    symlink(choice,"cdrom");
  } else {
    /* propietary */
    if (no_match("/target/lib/modules","cdrom",S_IFDIR)) {
      if(mount_and_check_floppy(NULL,"drivers",MSG_DRIVERS_FLOPPY))
	      return -1;
      newtSuspend();
      system("/floppy/modconf --libdir /floppy --source floppy \
	--restrict-section cdrom --run-shell cdromsymlink");
      newtResume();
      do_umount("/floppy",0);
    } else {
      newtSuspend();
      system("modconf --restrict-section cdrom --run-shell cdromsymlink");
      newtResume();
    }
  }

  problemBox(MSG_PLACE_CD,MSG_PLACE_CD_T);
  do_umount(CM_MOUNTPOINT_DIR,0);
  if (system("mount -t iso9660 -o nojoliet -r /dev/cdrom " CM_MOUNTPOINT_DIR)) {
/* FIXME   write_it_down "The CD-ROM was not mounted successfully." */
    problemBox(MSG_CD_FAILED,MSG_MOUNT_FAILED);
    return 1;
  }
  if ((status=choose_archive_dir(MSG_CHOOSE_PATH_CD))) {
    do_umount(CM_MOUNTPOINT_DIR,0);
  }
  return status;
}

static int choose_harddisk(void) {
  struct fdisk_partition *p;
  int status;
  char *type;

  do_umount(CM_MOUNTPOINT_DIR,0);
  p=select_not_mounted(MSG_SELECT_PARTITION_ARCHIVE,MSG_SELECT_PARTITION,
	5,FSTYPE_EXT2,FSTYPE_MINIX,FSTYPE_MSDOS,FSTYPE_AFFS,FSTYPE_HFS);
  if (!p) return 1;

  type = fdisk_fstype_name_of(p->type);
  if (!type) {
    sprintf(prtbuf,MSG_FILESYSTEM_UNKNOW,sysname(p->type));
    problemBox(prtbuf,MSG_CANNOT_MOUNT);
    return 1;
  }
  sprintf(prtbuf,"mount -t %s -r %s " CM_MOUNTPOINT_DIR,type,p->name);
  if (system(prtbuf)) {
/* FIXME   write_it_down "The Partition was not mounted successfully." */
    problemBox(MSG_MOUNT_FAILED_L,MSG_MOUNT_FAILED);
    return 1;
  }
  if ((status=choose_archive_dir(MSG_CHOOSE_PATH_HD))) {
    do_umount(CM_MOUNTPOINT_DIR,0);
  }
  return status;
}

static int choose_NFS_server(void){
  char *nfsmountpath;
  static char *preventry=NULL;
  int status;

  sprintf(prtbuf,"modprobe nfs");
  system(prtbuf);
  /* keep user entry between calls to choose_NFS_server */
  if (!preventry) preventry=strdup("");
  for (;;) {
    nfsmountpath=inputBox(MSG_CHOOSE_NFS,MSG_CHOOSE_NFS_T,preventry);
    if (! nfsmountpath) return 1;
    free(preventry);
    preventry=nfsmountpath;
    do_umount(CM_MOUNTPOINT_DIR,0);
    sprintf(prtbuf,"mount -t nfs %s " CM_MOUNTPOINT_DIR,nfsmountpath);
    if (system(prtbuf)) {
/* FIXME:                     write_it_down */
      sprintf(prtbuf,MSG_MOUNT_FAILED_NFS,nfsmountpath);
      problemBox(prtbuf,MSG_MOUNT_FAILED_NFS_T);
    } else {
      break;
    }
  }
  if ((status =choose_archive_dir(MSG_CHOOSE_PATH_NFS))) {
    do_umount(CM_MOUNTPOINT_DIR,0);
  }
  return status;
}

int choose_medium (void) {
#define MED_none          100
#define MED_default       101
#define MED_fd0           102
#define MED_fd1           103
#define MED_cdrom         104
#define MED_harddisk      105
#define MED_mounted       106
#define MED_nfs           107
  int med[]={ MED_default, MED_fd0, MED_fd1, MED_cdrom, 
    MED_harddisk, MED_mounted, MED_nfs };
  newtComponent f1, t1, b1, lb;
  static int Medium_Device=MED_none;
  char *old_archive_dir;
  int old_medium_device, offer_default=0, it=0, status=0;
  struct stat statbuf;

  newtOpenWindow (10, 6, 55, 12, MSG_SELECT_MEDIUM_T);
  t1 = newtTextbox (1, 0, 54, 2, NEWT_FLAG_WRAP);
  newtTextboxSetText(t1, MSG_SELECT_MEDIUM);
  lb = newtListbox(5, 2, 9, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);

  if (Archive_Dir) {
    switch (disqtype) {
      case kernel:
        sprintf(prtbuf,"%s/%s",Archive_Dir,KERDISKIMG);
        if (NAME_ISREG( T_FILE(prtbuf),&statbuf)) {
          sprintf(prtbuf,"%s/%s",Archive_Dir,DRVDISKIMG);
          if (NAME_ISREG( T_FILE(prtbuf),&statbuf)) offer_default=1;
        }
        break;	
      case base:
        sprintf(prtbuf,"%s/%s",Archive_Dir,BASETGZ);
        if (NAME_ISREG( T_FILE(prtbuf),&statbuf)) offer_default=1;
        break;	
    }
    if (offer_default) {
      newtListboxAddEntry(lb,MSG_DEFAULT_PREVIOUS,&med[0]);
      it++;
    }
  }
  if (strcmp(InstallationRootDevice,"/dev/fd0")) {
    newtListboxAddEntry(lb,MSG_FLOPPY_FD0,&med[1]);
    it++;
  }
  if (strcmp(InstallationRootDevice,"/dev/fd1")) {
    newtListboxAddEntry(lb,MSG_FLOPPY_FD1,&med[2]);
    it++;
  }
  newtListboxAddEntry(lb,MSG_MENU_MEDIUM_CD,&med[3]);
  newtListboxAddEntry(lb,MSG_MENU_MEDIUM_HD,&med[4]);
  newtListboxAddEntry(lb,MSG_MENU_MEDIUM_MOUNT,&med[5]);
#ifndef _TESTING_
  if ( (NAME_ISREG(T_FILE("/target/etc/init.d/network"),&statbuf)) &&
       (NAME_ISEXE(T_FILE("/sbin/ifconfig"),&statbuf)) ) {
#else
  if (1) {
#endif
    newtListboxAddEntry(lb,MSG_MENU_MEDIUM_NFS,&med[6]);
    it++;
  }
  f1 = newtForm(NULL, NULL, 0);
  b1 = newtCompactButton ( 22, 11, MSG_CANCEL );
  newtFormAddComponents (f1 , t1, lb, b1, NULL);
  if ( newtRunForm(f1) == b1) {
    newtPopWindow();
    newtFormDestroy(f1);
    return -1;
  }
  old_medium_device= Medium_Device;
  Medium_Device = *((int *)newtListboxGetCurrent(lb));
  newtPopWindow();
  newtFormDestroy(f1);

  old_archive_dir=Archive_Dir;
  switch (Medium_Device) {
    case MED_default:
      Medium_Device=old_medium_device;
      return 0;
    case MED_fd0:
      Archive_Dir=strdup("/dev/fd0");
      break;
    case MED_fd1:
      Archive_Dir=strdup("/dev/fd1");
      break;
    case MED_mounted:
      status=choose_archive_dir(NULL);
      break;
    case MED_cdrom:
      status=choose_cdrom();
      break;
    case MED_harddisk:
      status=choose_harddisk();
      break;
    case MED_nfs:
      status=choose_NFS_server();
      break;
  }
  if (status==0) free(old_archive_dir);
  return status;
}

#ifdef DO_EJECT
int do_eject (void) {
#define EJ_none          100
#define EJ_fd0           101
#define EJ_fd1           102
  int med[]={ EJ_none, EJ_fd0, EJ_fd1 };
  newtComponent f1, t1, b1, lb;
  static int Eject_Device=EJ_none;

  newtOpenWindow (10, 11, 55, 6, MSG_SELECT_DISK2EJECT_T);
  t1 = newtTextbox (1, 0, 54, 2, NEWT_FLAG_WRAP);
  newtTextboxSetText(t1, MSG_SELECT_DISK2EJECT);
  lb = newtListbox(5, 2, 2, NEWT_FLAG_RETURNEXIT);

  newtListboxAddEntry(lb,MSG_FLOPPY_FD0,&med[1]);
  newtListboxAddEntry(lb,MSG_FLOPPY_FD1,&med[2]);
  f1 = newtForm(NULL, NULL, 0);
  b1 = newtCompactButton ( 22, 5, "Cancel" );
  newtFormAddComponents (f1 , t1, lb, b1, NULL);
  if ( newtRunForm(f1) == b1) {
    Eject_Device = EJ_none;
    newtPopWindow();
    newtFormDestroy(f1);
    return -1;
  }
  Eject_Device = *((int *)newtListboxGetCurrent(lb));
  newtPopWindow();
  newtFormDestroy(f1);

  switch (Eject_Device) {
    case EJ_fd0:
      eject_floppy("/dev/fd0");
      break;
    case EJ_fd1:
      eject_floppy("/dev/fd1");
      break;
  }
  return 0;
}
#endif

#ifdef _TESTING_
/*
 * To test, compile using:
   cc -Wall -o ./the_test -D_TESTING_ -DARCHNAME=\"i386\" -g \
   choose_medium.c boxes.c select_not_mounted.c lists.c no_match.c \
   ../busybox/umount.c ../busybox/mount.c ../busybox/utility.c \
   ../busybox/descend.c ../busybox/findmount.c ../busybox/postprocess.c \
   -lnewt -lslang ../libfdisk/libfdisk.a
 */
void main(void) {
  Archive_Dir=NULL;
  disqtype=base;
  InstallationRootDevice=strdup("/dev/sdc");
  newtInit();
  newtCls();
  newtDrawRootText(0, 0, "Choose Medium test program");
  newtOpenWindow(7, 2, 65, 18, "Root Window");
  newtPushHelpLine(NULL);
  if ( choose_medium() ) {
    fprintf(stderr,"Failed!\n");
  } else {
    fprintf(stderr,"Archive_Dir = %s\n",Archive_Dir);
  }  
  if ( choose_medium() ) {
    fprintf(stderr,"Failed!\n");
  } else {
    fprintf(stderr,"Archive_Dir = %s\n",Archive_Dir);
  }  
  newtPopWindow();
  newtFinished();
  free(Archive_Dir);
}
#endif

