// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qradiobt.h>
#include "Canvas.h"
#include "FormRenderer.h"
#include "RadioRenderer.h"

RadioRenderer::RadioRenderer( bool           checked,
                              const QString* value,
                              Canvas*        canvas,
                              int            clipWidth,
                              QObject*       parent,
                              const char*    name )
        : FormObjectRenderer( canvas, clipWidth, parent, name ),
          _checked( checked )
{
    if ( value ) {
        _value = value->copy();
    }

    _radio = new QRadioButton( canvas->clip(), name );
    _radio->setChecked( checked );
    canvas->registerWidget( this, _radio );
    
    FormRenderer* f;
    if ( ( f = form() ) ) {
        f->registerRadioButton( _radio );
    }
    int w = _radio->sizeHint().width();
    int h = _radio->sizeHint().height();
    _radio->setGeometry( 4, 4, w, h );
    _minimumWidth = w + 8;
    _maximumWidth = w + 8;
    resize( w + 8, h + 8 );
}

QString RadioRenderer::value()
{
    if ( _radio->isChecked() ) {
        QString nm  = name();
        QString val = _value.copy();
        
        if ( ( nm.length() == 0 ) || ( val.length() == 0 ) ) {
            return "";
        }
        
        Url::encode( nm );
        Url::encode( val );
        
        QString tmp;
        tmp.sprintf( "%s=%s", nm.data(), val.data() );
        return tmp;
    } else {
        return 0;
    }
}

void RadioRenderer::reset()
{
    _radio->setChecked( _checked );
}

bool RadioRenderer::redraw()
{
    return FALSE;
}

void RadioRenderer::endOfData()
{
}
