/*
 * maillock.c	Locks the mailbox with a .lock file.
 *		This code is based in the impementation
 *		in mail.local.c as shipped with sendmail 8.7.x
 */

#include <stdio.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/stat.h>
#include "popper.h"


#if DOTLOCK

static char lockfile[MAXPATHLEN];
static int  islocked = 0;

/*
 *	Lock a file. This looks a lot like the SVR4 lockmbox() thingy.
 *	Arguments: lusername, retries.
 */
int maillock(name, retries)
char *name;
int retries;
{
	int statfailed = 0;
	int first = 1;
	int i;
	int fd;
	struct stat st;
	time_t now;

	if (islocked) return 0;

	sprintf(lockfile, "%s/%s.lock", POP_MAILDIR, name);
	for (i = 0; i < retries && retries > 0; i++) {
		if (!first)
			sleep(5);
		else
			first = 0;
		if ((fd = open(lockfile, O_WRONLY|O_EXCL|O_CREAT, 0644)) > 0) {
			islocked = 1;
			close(fd);
			return;
		}
		if (stat(lockfile, &st) < 0) {
			if (statfailed++ > 5)
				return -1;
			continue;
		}
		statfailed = 0;
		time(&now);
		/* Locks are invalid after 5 minutes. */
		if (now < st.st_ctime + 300)
			continue;
		unlink(lockfile);
	}
	return 0;
}

void mailunlock()
{
	if (!islocked) return;
	unlink(lockfile);
	islocked = 0;
}

#endif

