# include <stdio.h>
# include <stdlib.h>
# include <string.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "hformat.h"

/*
 * NAME:	hformat->main()
 * DESCRIPTION:	implement hformat command
 */
int hformat_main(int argc, char *argv[])
{
  int nargc = argc;
  char **nargv = argv;
  char *path, *vname;
  hfsvol *vol;
  hfsvolent ent;
  int partno, result = 0;

  vname = "Untitled";

  if (nargc > 2 && strcmp(nargv[1], "-l") == 0)
    {
      vname = nargv[2];
      nargv += 2, nargc -= 2;
    }

  if (nargc < 2 || nargc > 3)
    {
      fprintf(stderr, "Usage: %s [-l label] device-path [partition-no]\n",
	      argv[0]);
      return 1;
    }

  path   = nargv[1];
  partno = (nargc == 3) ? atoi(nargv[2]) : 0;

  if (hfs_format(path, partno, vname) < 0)
    {
      hfs_perror(path);
      return 1;
    }

  vol = hfs_mount(path, partno);
  if (vol == 0)
    {
      hfs_perror(path);
      return 1;
    }

  hfs_vstat(vol, &ent);
  hfs_pinfo(&ent);

  if (hcwd_mounted(ent.name, ent.crdate, path, partno) < 0)
    {
      perror("Failed to record mount");
      result = 1;
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  return result;
}
