/* constant.h
 $Header: /al/acs/src/RCS/constant.h,v 9.24 95/10/24 22:45:33 al Exp $
 * defined constants for just about everything
 */
#ifndef CONSTANT_H
#define CONSTANT_H
/*--------------------------------------------------------------------------*/
#define RANSCALE	(16384)
#define RANOFSET	(16384)
#define kPIx2		(6.2831853071795864769252867665590057683944)
#define kPI		(3.1415926535897932384626433832795028841972)
#define kPId2		(1.5707963267948966192313216916397514420986)
#define DTOR		(0.0174532925199432957692369076848861271344)
#define RTOD	       (57.2957795130823208768)
#define ONE_OVER_PI	(0.3183098861837906715377675267450287240689)
#define ABS_ZERO     (-273.15)
#define	E_0	(8.854214871e-12)  /* permittivity of air 		  */
#define	E_SI	(11.7*E_0)	   /* permittivity of silicon (1.0359e-10)*/
#define	E_OX	(3.9*E_0)	   /* permittivity of oxide (3.45e-11)	  */
#define K       (1.3806226e-23)    /* Boltzmann's constant		  */
#define Q       (1.6021918e-19)    /* electronic charge			  */
#define NOT_INPUT   (-(DBL_MAX)*(.8347658))	/* unlikely number	  */
#define NOT_VALID   (-(DBL_MAX)*(.8547958))	/* unlikely number	  */
#define LINEAR	    (-(DBL_MAX)*(.8747958))	/* unlikely number	  */
#define BIGBIG	    ( (DBL_MAX)*(.9747958))	/* unlikely number	  */
#define VOLTMIN	    (1.0e-50)
#define DBVOLTMIN   (20.*log10(VOLTMIN))
#define PWRMIN	    (1.0e-100)
#define DBPWRMIN    (10.*log10(PWRMIN))
#define TOKENTERM   ",=()[]"

#define	BAD	(-1)
#define	GOOD	(0)
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
