/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static char rcsid[] = "$Id: xaw.c,v 1.9 1995/04/11 14:07:15 pierre Exp $";

/*
 * Couche Toolkit ATHENA
 */
#include "xtel.h"
#include <sys/types.h>
#include <signal.h>
#include <errno.h>
#include <string.h>
#include <malloc.h>

#ifndef NO_XPM
#include <X11/xpm.h>
#include "pf.xpm"
#else
#include "bitmaps/pf.bit"
#endif

#include "bitmaps/zero.bit"
#include "bitmaps/wind.bit"
#include "bitmaps/rewind.bit"
#include "bitmaps/play.bit"
#include "bitmaps/stop.bit"
#include "bitmaps/lecteur.bit"
#include "bitmaps/aide.bit"

#include <X11/Xaw/Form.h>
#include <X11/Xaw/Command.h>

/* works under R4 and later only */
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Label.h>

#define K_Charge		0
#define K_Sauve			1
#define K_Compose		2
#define K_Fin			3
#define SAUVE            	0
#define CHARGE           	1
#define IMPRIME           	2
#define LIGNE_BLANCHE		3
#define QUITTE           	4
#define NOUVEAU            	0
#define DEMARRE           	1
#define ARRETE          	2
#define LECTEUR          	3

/* Nom des entrees du menu "Fichier" */
static String entree_fichier[] = {
    "sauve",
    "charge",
    "imprime",
    "blanc",
    "quitte",
    NULL
};

static String entree_enregistrement[] = {
    "nouveau",
    "demarre",
    "arrete",
    "lecteur",
    NULL,
};

static char *toolkit = "Athena";
static Arg args[30];
static int n;
static char buf[256];
static FILE *fpproc;
static Widget em, top;
static Widget bouton_enregistrement, menu_enregistrement;
static Widget bouton_fichier, menu_fichier, menu_compose, menu_procedure;
static Widget annule_confirmation, forme_base, nouveau, demarre, arrete, lecteur;
static Widget popup_sortie, popup_saisie, popup_erreur, quitte_lecteur, titre_arret_lecteur;
static Widget boite_saisie, confirmation_sortie, message_erreur;
static Widget compteur_lecteur_titre, compteur_lecteur_caractere, compteur_lecteur_page;
static Widget ok_boite_saisie, ok_message_erreur, annule_boite_saisie;
static Widget ok_confirmation_sortie, annule_confirmation_sortie;
static Widget popup_lecteur, forme_lecteur, play_lecteur, stop_lecteur, wind_lecteur;
static Widget rewind_lecteur, zero_lecteur, oui_arret_page_lecteur;
static Widget non_arret_page_lecteur, titre_arret_page_lecteur;
static Widget menu_aide, bouton_aide;

static void arret_a_chaque_page ();
static void Popdown ();
static void positionnement_widget ();
static void prepare_dialogue ();

static void Selection_menu_fichier();
static void Affiche_copyright ();
static void Selection_menu_compose();
static void Selection_menu_compose_direct();
static void Selection_menu_procedure(), Selection_menu_enregistrement();
static void Validation_dialogue(), Validation_erreur();

static XrmOptionDescRec options[] = {
    {"-serveur",	"*serveur",	XrmoptionSepArg, NULL},
    {"-service",	"*nomService",	XrmoptionSepArg, NULL},
    {"-petit",		"*petiteFonte",	XrmoptionNoArg, "True"},
    {"-ng",		"*nGris",	XrmoptionNoArg, "True"},
    {"-br",		"*boutonRaccrocher",	XrmoptionNoArg, "True"}
};


/*
 * Initialisation du toolkit 
 */
Widget init_toolkit (pargc, argv)
int *pargc;
char **argv; 
{
#ifdef DEBUG
    printf ("Initialisation du toolkit\n");
#endif

    toolkit_utilise = toolkit;
    top = XtAppInitialize (&app_context, "XTel", options, XtNumber(options), pargc, argv, NULL, NULL, 0);

    if (*pargc > 1) {
	fprintf (stderr, "Usage : xtel [-ng -petit -br -service service_xtel -serveur serveur_xtel [options_standards]]\n");
	exit (1);
    }

    return (top);
}

/*
 * Initialisation des widgets
 */
Widget init_widgets (topLevel)
Widget topLevel;
{
    register int i;
    Widget entry, typein;
#ifdef DEBUG
    printf ("Initialisation des widgets\n");
#endif

    /* forme de base */
    forme_base = XtCreateManagedWidget ("forme_base", formWidgetClass, topLevel, NULL, 0);

    /*
     * Creation des menus 
     */

    /* Fichier */

    /* titre du menu */
    bouton_fichier = XtVaCreateManagedWidget("bouton_fichier", menuButtonWidgetClass, forme_base, XtNmenuName, "menu_fichier", NULL);

    /* le menu en lui meme */
    menu_fichier = XtCreatePopupShell("menu_fichier", simpleMenuWidgetClass, bouton_fichier, NULL, 0);

    /* creation des entrees */
    for (i = 0;  entree_fichier[i] != NULL ; i++) {
        String item = entree_fichier[i];

        if (i == LIGNE_BLANCHE)
            entry = XtCreateManagedWidget(item, smeLineObjectClass, menu_fichier, NULL, 0);
        else {
            entry = XtCreateManagedWidget(item, smeBSBObjectClass, menu_fichier, NULL, 0);
            XtAddCallback(entry, XtNcallback, Selection_menu_fichier, (XtPointer) i);
        }
    }

    /* Enregistrement */

    /* titre du menu */
    bouton_enregistrement = XtVaCreateManagedWidget("bouton_enregistrement", menuButtonWidgetClass, forme_base,
		  XtNmenuName, "menu_enregistrement",
		  XtNfromHoriz, bouton_fichier, NULL);

    /* le menu en lui meme */
    menu_enregistrement = XtCreatePopupShell("menu_enregistrement", simpleMenuWidgetClass, bouton_enregistrement, NULL, 0);

    /* creation des entrees */
    nouveau = XtCreateManagedWidget(entree_enregistrement[NOUVEAU], smeBSBObjectClass, menu_enregistrement, NULL, 0);
    XtAddCallback(nouveau, XtNcallback, Selection_menu_enregistrement, (XtPointer) NOUVEAU);
    demarre = XtCreateManagedWidget(entree_enregistrement[DEMARRE], smeBSBObjectClass, menu_enregistrement, NULL, 0);
    XtAddCallback(demarre, XtNcallback, Selection_menu_enregistrement, (XtPointer) DEMARRE);
    arrete = XtCreateManagedWidget(entree_enregistrement[ARRETE], smeBSBObjectClass, menu_enregistrement, NULL, 0);
    XtAddCallback(arrete, XtNcallback, Selection_menu_enregistrement, (XtPointer) ARRETE);
    lecteur = XtCreateManagedWidget(entree_enregistrement[LECTEUR], smeBSBObjectClass, menu_enregistrement, NULL, 0);
    XtAddCallback(lecteur, XtNcallback, Selection_menu_enregistrement, (XtPointer) LECTEUR);

    /* 
     *  Composition : les entree de ce menu sont creees dynamiquement a partir 
     *  du fichier "xtel.services"
     */

    if (nb_services != 0) {
	/* titre du menu */
	bouton_compose = XtVaCreateManagedWidget("bouton_compose", menuButtonWidgetClass, forme_base,
		  XtNmenuName, "menu_compose",
		  XtNfromHoriz, bouton_enregistrement, NULL);
	
	/* le menu en lui meme */
	menu_compose = XtCreatePopupShell("menu_compose", simpleMenuWidgetClass, bouton_compose, NULL, 0);

	/* creation des entrees */
	for (i = 0; i < nb_services ; i++) {
	    register int j, jj;

	    /*
	     * On tient compte des caracteres accentues (\xyz en octal)
	     */
	    j = jj = 0;
	    while (entree_compose[i][j] != 0) {
	    
		if (entree_compose[i][j] == '\\') {
		    int x;

		    sscanf (&entree_compose[i][j+1], "%o", &x);
		    buf[jj] = (char)x;
		    j += 4;
		}
		else
		    buf[jj] = entree_compose[i][j++];

		jj++;
	    }

	    buf[jj] = 0;

	    entry = XtCreateManagedWidget(buf, smeBSBObjectClass, menu_compose, NULL, 0);

	    if (i == nb_services-1 && !strcmp (entree_compose[i], "Direct"))
		XtAddCallback(entry, XtNcallback, Selection_menu_compose_direct, (XtPointer) i);
	    else
		XtAddCallback(entry, XtNcallback, Selection_menu_compose, (XtPointer) i);
	}
    }
    
    /* 
     *  Procedures : les entree de ce menu sont creees dynamiquement a partir 
     *  du fichier ".xtelproc"
     */
    if (nb_procedures != 0) {
	
	/* titre du menu */
	if (nb_services == 0)
	    bouton_procedure = XtVaCreateManagedWidget("bouton_procedure", menuButtonWidgetClass, forme_base,
		  XtNmenuName, "menu_procedure",
		  XtNfromHoriz, bouton_enregistrement, NULL);
	else
	    bouton_procedure = XtVaCreateManagedWidget("bouton_procedure", menuButtonWidgetClass, forme_base,
		  XtNmenuName, "menu_procedure",
		  XtNfromHoriz, bouton_compose, NULL);
	
	/* le menu en lui meme */
	menu_procedure = XtCreatePopupShell("menu_procedure", simpleMenuWidgetClass, bouton_procedure, NULL, 0);
	
	/* creation des entrees */
	for (i = 0 ; i != nb_procedures ; i++) {
	    char nomproc[5];
	    
	    sprintf (nomproc, "p%d", i);
	    entry = XtVaCreateManagedWidget(nomproc, smeBSBObjectClass, menu_procedure, XtNlabel, procedures[i].nom, NULL);
	    
	    XtAddCallback(entry, XtNcallback, Selection_menu_procedure, (XtPointer)i);
	}
    }

    /* Aide */
    /* titre du menu */
    bouton_aide = XtVaCreateManagedWidget("bouton_aide", menuButtonWidgetClass, forme_base,
		  XtNmenuName, "menu_aide",
		  XtNbitmap, XCreateBitmapFromData (XtDisplay(topLevel), XtScreen(topLevel)->root, aide_bits, aide_width, aide_height),
		  XtNfromHoriz, bouton_fichier, 
                  XtNhorizDistance, (rsc_xtel.petiteFonte ? 220 : 500), NULL);
	
    /* le menu en lui meme */
    menu_aide = XtCreatePopupShell("menu_aide", simpleMenuWidgetClass, bouton_aide, NULL, 0);
    entry = XtCreateManagedWidget ("a_propos", smeBSBObjectClass, menu_aide, NULL, 0);
    XtAddCallback(entry, XtNcallback, Affiche_copyright, (XtPointer)i);

    /*
     * Ecran/clavier du minitel  
     */

    /* ecran */
    n = 0;
    XtSetArg (args[n], XtNcommandeDeconnexion, CHAINE_COMMANDE_FIN); n++;

    if (rsc_xtel.nGris) {
	XtSetArg (args[n], XtNnGris, True);
	n++;
    }
    
    if (rsc_xtel.petiteFonte) {
	XtSetArg (args[n], XtNpetiteFonte, True);
	n++;
    }

    em = XtCreateManagedWidget ("ecran_minitel", videotexWidgetClass, forme_base, args, n);

    /* Clavier = popup menu */
    menu_clavier = XtCreatePopupShell ("menu_clavier", simpleMenuWidgetClass, em, NULL, 0);

    /* creation des entrees */
    for (i = 0; i < 14 ; i++) {
        String item = touches[i].nom;

        if (strcmp (item, "blanc") == 0)
            entry = XtCreateManagedWidget(item, smeLineObjectClass, menu_clavier, NULL, 0);
	else {
	    entry = XtCreateManagedWidget(item, smeBSBObjectClass, menu_clavier, NULL, 0);
	    if (i > 3)
		XtAddCallback(entry, XtNcallback, (XtCallbackProc)commandes, (XtPointer) touches[i].code);
	    else
		XtAddCallback(entry, XtNcallback, (XtCallbackProc)selection_mode_emulation, (XtPointer) touches[i].code);
	}
    }

    if (rsc_xtel.boutonRaccrocher) {
	entry = XtCreateManagedWidget("raccrocher", smeBSBObjectClass, menu_clavier, NULL, 0);
	XtAddCallback(entry, XtNcallback, (XtCallbackProc)raccrocher, (XtPointer)NULL);
    }

    /*
     * Popups pour les boites de dialogue 
     */

    popup_saisie = XtCreatePopupShell ("popup_saisie", overrideShellWidgetClass, forme_base, NULL, 0);
    popup_sortie = XtCreatePopupShell ("popup_sortie", overrideShellWidgetClass, forme_base, NULL, 0);

    /* Confirmation de sortie */
    confirmation_sortie = XtCreateManagedWidget ("confirmation_sortie", dialogWidgetClass, popup_sortie, NULL, 0);

    /* 2 boutons : Ok, Annule */
    ok_confirmation_sortie = XtCreateManagedWidget ("ok_confirmation_sortie", commandWidgetClass, confirmation_sortie, NULL, 0);
    XtAddCallback (ok_confirmation_sortie, XtNcallback, Validation_dialogue, (XtPointer) K_Fin);
    XawDialogAddButton (confirmation_sortie, "annule_confirmation_sortie", Popdown, popup_sortie);

    /*
     * Boite de saisie pour chargement / sauvegarde / composition
     */
    boite_saisie = XtCreateManagedWidget ("boite_saisie", dialogWidgetClass, popup_saisie, NULL, 0);	        
    
    ok_boite_saisie = XtCreateManagedWidget ("ok_boite_saisie", commandWidgetClass, boite_saisie, NULL, 0);
    XawDialogAddButton (boite_saisie, "annule_boite_saisie", Popdown, popup_saisie);

    /* Installation de l'accelerateur : Return <==> cliquer "Ok" */
    if ((typein = XtNameToWidget(boite_saisie, "value")) != 0) {
	XtInstallAccelerators(typein, ok_boite_saisie);
    }


    /*
     * Creation du lecteur
     */
    n = 0;
    XtSetArg(args[n], XtNiconPixmap, 
	     XCreateBitmapFromData(XtDisplay(topLevel),
				   XtScreen(topLevel)->root,
				   lecteur_bits, lecteur_width, lecteur_height)); n++;
    popup_lecteur = XtCreatePopupShell ("popup_lecteur", applicationShellWidgetClass, forme_base, args, n);
    forme_lecteur = XtCreateManagedWidget ("forme_lecteur", formWidgetClass, popup_lecteur, NULL, 0);

    /*
     * Boutons du lecteur
     */
    n = 0;
    XtSetArg(args[n], XtNbitmap, 
	     XCreateBitmapFromData(XtDisplay(topLevel),
				   XtScreen(topLevel)->root,
				   zero_bits, zero_width, zero_height)); n++;
    zero_lecteur = XtCreateManagedWidget ("zero_lecteur", commandWidgetClass, forme_lecteur, args, n);

    n = 0;
    XtSetArg(args[n], XtNbitmap, 
	     XCreateBitmapFromData(XtDisplay(topLevel),
				   XtScreen(topLevel)->root,
				   rewind_bits, rewind_width, rewind_height)); n++;
    rewind_lecteur = XtCreateManagedWidget ("rewind_lecteur", commandWidgetClass, forme_lecteur, args, n);

    n = 0;
    XtSetArg(args[n], XtNbitmap, 
	     XCreateBitmapFromData(XtDisplay(topLevel),
				   XtScreen(topLevel)->root,
				   stop_bits, stop_width, stop_height)); n++;
    stop_lecteur = XtCreateManagedWidget ("stop_lecteur", toggleWidgetClass, forme_lecteur, args, n);

    n  = 0;
    XtSetArg (args[n], XtNradioGroup, stop_lecteur); n++;
    XtSetArg(args[n], XtNbitmap, 
	     XCreateBitmapFromData(XtDisplay(topLevel),
				   XtScreen(topLevel)->root,
				   play_bits, play_width, play_height)); n++;
    play_lecteur = XtCreateManagedWidget ("play_lecteur", toggleWidgetClass, forme_lecteur, args, n);

    XtSetArg(args[n], XtNbitmap, 
	     XCreateBitmapFromData(XtDisplay(topLevel),
				   XtScreen(topLevel)->root,
				   wind_bits, wind_width, wind_height)); n++;
    wind_lecteur = XtCreateManagedWidget ("wind_lecteur", commandWidgetClass, forme_lecteur, args, n);

    /* le compteur */
    compteur_lecteur_titre = XtCreateManagedWidget ("compteur_lecteur_titre", labelWidgetClass, forme_lecteur, NULL, 0);
    compteur_lecteur_caractere = XtCreateManagedWidget ("compteur_lecteur_caractere", labelWidgetClass, forme_lecteur, NULL, 0);
    compteur_lecteur_page = XtCreateManagedWidget ("compteur_lecteur_page", labelWidgetClass, forme_lecteur, NULL, 0);

    /* Arret a chaque page */
    titre_arret_lecteur = XtCreateManagedWidget ("titre_arret_lecteur", labelWidgetClass, forme_lecteur, NULL, 0);
    oui_arret_page_lecteur = XtCreateManagedWidget ("oui_arret_page_lecteur", toggleWidgetClass, forme_lecteur, NULL, 0);
    n  = 0;
    XtSetArg (args[n], XtNradioGroup, oui_arret_page_lecteur); n++;
    non_arret_page_lecteur = XtCreateManagedWidget ("non_arret_page_lecteur", toggleWidgetClass, forme_lecteur, args, n);

    /* le bouton pour quitter */
    quitte_lecteur = XtCreateManagedWidget ("quitte_lecteur", commandWidgetClass, forme_lecteur, NULL, 0);

    XtAddCallback (play_lecteur, XtNcallback, Play_lecteur, NULL);
    XtAddCallback (zero_lecteur, XtNcallback, Zero_lecteur, NULL);
    XtAddCallback (stop_lecteur, XtNcallback, Stop_lecteur, NULL);
    XtAddCallback (rewind_lecteur, XtNcallback, Rewind_lecteur, NULL);
    XtAddCallback (wind_lecteur, XtNcallback, Wind_lecteur, NULL);
    XtAddCallback (quitte_lecteur, XtNcallback, fin_lecteur, NULL);
    XtAddCallback (oui_arret_page_lecteur, XtNcallback, arret_a_chaque_page, (XtPointer)True);
    XtAddCallback (non_arret_page_lecteur, XtNcallback, arret_a_chaque_page, (XtPointer)False);

    XtAddEventHandler (popup_saisie, EnterWindowMask, False, (XtEventHandler)evenement_entre_widget, NULL);

    XtAddEventHandler (forme_lecteur, LeaveWindowMask, False, (XtEventHandler)sauve_l_ecran, NULL);

    classe_forme_copyright = formWidgetClass;

    return (em);
}


/*
 * Positionnement du widget "w" par rapport au widget "r"
 */ 
static void positionnement_widget (r, w)
Widget r, w;
{
    Dimension xr, yr, xr_a, yr_a;

    /* calcul de la position et des dimensions de la reference */
    n = 0;
    XtSetArg (args[n], XtNx, &xr); n++;
    XtSetArg (args[n], XtNy, &yr); n++;
    XtGetValues (r, args, n);

    /* calcul des coordonnees absolues de la reference */
    XtTranslateCoords (r, xr, yr, &xr_a, &yr_a);

    /* fixe les coordonnees centrees */
    n = 0;
    XtSetArg (args[n], XtNx, xr_a + 10); n++;
    XtSetArg (args[n], XtNy, yr_a + 10); n++;
    XtSetValues (w, args, n);
}

/*
 * Preparation du widget dialogue :
 *
 *	- fixe le callback adequat sur le bouton Ok
 *	- positionne le popup-shell
 *	- affiche...
 */
static void prepare_dialogue (ok, popup, code)
Widget ok, popup;
int code;
{
    if (popup == popup_saisie)
      XtAddCallback (ok, XtNcallback, Validation_dialogue, (XtPointer) code);

    positionnement_widget (em, popup);
    XtPopup (popup, XtGrabNonexclusive);
    XSetInputFocus (XtDisplay(popup), XtWindow (popup), RevertToNone, CurrentTime);
}


/*
 * Popdown d'un menu (efface le popup-menu de l'ecran)
 */
static void
Popdown (w, popup, call_data)
Widget w, popup;
XtPointer call_data;	
{
    /*
     * Si boite de saisie, on supprime le callback du bouton "Ok"
     */
    if (popup == popup_saisie)
      XtRemoveAllCallbacks (ok_boite_saisie, XtNcallback);

    XtPopdown (popup);
    XSetInputFocus (XtDisplay(popup), PointerRoot, 0, CurrentTime);
}

/*
 * Confirmation d'une erreur : destruction du popup d'erreur et du "dialog" 
 * d'erreur
 */
static void
Validation_erreur (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;	
{
    XtPopdown (popup_erreur);
    XtDestroyWidget (popup_erreur);
    XtDestroyWidget (message_erreur);
}


/*
 * Callback du bouton "Ok" d'une boite de saisie
 */
static void Validation_dialogue (w, code, call_data)
Widget w;
int code;
XtPointer call_data;
{
    Boolean flag_connexion;
    XSetInputFocus (XtDisplay(w), PointerRoot, 0, CurrentTime);

    switch (code) {

      case K_Fin : /* quitte le programme */

	  XtVaGetValues (ecran_minitel, XtNconnecte, &flag_connexion, NULL);
	  if (flag_connexion) {
	      write (socket_xteld, CHAINE_COMMANDE_FIN, 1);
	      sortie_violente = 1;
	      break;
	  }
	  else
	    ce_n_est_qu_un_au_revoir ();

#ifdef NO_SEL_FILE

      case K_Sauve : /* sauve sur le fichier */

	XtRemoveAllCallbacks (ok_boite_saisie, XtNcallback);
	XtPopdown(popup_saisie);
	strcpy (nom_fichier_sauve, XawDialogGetValueString(boite_saisie));
	Sauve ();

	break;

      case K_Charge : /* charge un fichier */

	XtRemoveAllCallbacks (ok_boite_saisie, XtNcallback);
	XtPopdown(popup_saisie);
	strcpy (nom_fichier_charge, XawDialogGetValueString(boite_saisie));
	Charge ();

	break;

#endif /* NO_SEL_FILE */

      case K_Compose : /* composition numero direct */

	XtRemoveAllCallbacks (ok_boite_saisie, XtNcallback);
	XtPopdown(popup_saisie);
	if (strlen (XawDialogGetValueString(boite_saisie)) > 0) {
	    strcpy (numero_courant, XawDialogGetValueString(boite_saisie));
	    init_xtel ();
	    connexion_service (XawDialogGetValueString(boite_saisie));
	}
	
	break;

	default : break;
    }
}


/*
 * Traitement du menu "fichier"
 */
/* ARGSUSED */
static void
Selection_menu_fichier(w, option_choisie, garbage)
Widget w;
int option_choisie;	        /* client_data */
XtPointer garbage;		/* call_data */
{
#ifndef NO_SEL_FILE
    FILE *fp;
    extern FILE *XsraSelFile();
    String name;
#endif /* NO_SEL_FILE */

    switch (option_choisie) {

      case SAUVE :

#ifdef NO_SEL_FILE
	n = 0;
	XtSetArg (args[n], XtNlabel, "Sauve l'enregistrement:"); n++;
	XtSetArg (args[n], XtNvalue, nom_fichier_sauve); n++;
	XtSetValues (boite_saisie, args, n);
	prepare_dialogue (ok_boite_saisie, popup_saisie, K_Sauve);
#else
	fp = XsraSelFile (top, "Sauve l'enregistrement:", "Ok", "Annule", "Erreur: ", nom_fichier_sauve, "w", NULL, (char*)&name);
	if (fp) {
	    fclose (fp);
	    strcpy (nom_fichier_sauve, name);
	    XtFree (name);
	    Sauve ();
	}
#endif /* NO_SEL_FILE */
	break ;

      case CHARGE :

#ifdef NO_SEL_FILE
	n = 0;
	XtSetArg (args[n], XtNlabel, "Charge l'enregistrement :"); n++;
	XtSetArg (args[n], XtNvalue, nom_fichier_charge); n++; 
	XtSetValues (boite_saisie, args, n);
	prepare_dialogue (ok_boite_saisie, popup_saisie, K_Charge);
#else
	fp = XsraSelFile (top, "Charge l'enregistrement :", "Ok", "Annule", "Erreur: ", nom_fichier_charge, "r", NULL, (char*)&name);
	if (fp) {
	    fclose (fp);
	    strcpy (nom_fichier_charge, name);
	    XtFree (name);
	    Charge ();
	}
#endif /* NO_SEL_FILE */
	break ;


      case IMPRIME :

	  imprime_page_courante ();

	break;

      case QUITTE :

	prepare_dialogue (ok_confirmation_sortie, popup_sortie, K_Fin);
	break;

	default : 
	  
	  break;
    }
}

/* 
 * Menu "enregistrement" 
 */
/* ARGSUSED */
static void
Selection_menu_enregistrement(w, option_choisie, garbage)
Widget w;
int option_choisie;	        /* client_data */
XtPointer garbage;		/* call_data */
{
    switch (option_choisie) {

      case NOUVEAU :

	  cpt_buffer = 0;
	  taille_zone_enregistrement = 1000;
	  zone_enregistrement = realloc (zone_enregistrement, taille_zone_enregistrement);
	  break;

	case DEMARRE :

	  flag_enregistrement = 1;
	  XtSetSensitive (demarre, False);
	  XtSetSensitive (arrete, True);
	  break;

	case ARRETE :

	  flag_enregistrement = 0;
	  XtSetSensitive (demarre, True);
	  XtSetSensitive (arrete, False);
	  break;

	case LECTEUR :

	    debut_lecteur ();
	  break;

	default : 
	  
	  break;
    }
}

/*
 * Traitement du menu "compose"
 */
/* ARGSUSED */
static void
Selection_menu_compose(w, numero_choisi, garbage)
Widget w;
int numero_choisi;	     
XtPointer garbage;	
{
    /* composition */
#ifdef DEBUG
    printf ("service uucp %s\n", definition_services[numero_choisi].nom_uucp);
#endif

    init_xtel ();
    connexion_service (definition_services[numero_choisi].nom_uucp);
}

/* ARGSUSED */
static void
Selection_menu_compose_direct(w, numero_choisi, garbage)
Widget w;
int numero_choisi;	     
XtPointer garbage;	
{
    n = 0;
    XtSetArg (args[n], XtNlabel, "Num\351ro \340 composer :"); n++;
    XtSetArg (args[n], XtNvalue, numero_courant); n++;
    XtSetValues (boite_saisie, args, n);

    prepare_dialogue (ok_boite_saisie, popup_saisie, K_Compose);
}

/*
 * Traitement du menu "procedure"
 */
/* ARGSUSED */
static void
Selection_menu_procedure(w, numero_procedure, garbage)
Widget w;
int numero_procedure;	     
XtPointer garbage;	
{
#ifdef DEBUG
    printf ("Procedure numero %%d\n", numero_procedure);
#endif

    /* Composition du service */
    chat_courant = procedures[numero_procedure].chat;
    init_xtel ();
    /* Si M1, on compose a la main... */
    if (!nb_services)
	connexion_service (NULL);
    else
	connexion_service (procedures[numero_procedure].service);
}

/*
 * Affichage du copyright
 */
static void Affiche_copyright (w, client_data, call_data)
Widget w;
XtPointer client_data, call_data;
{
    Pixmap pixmap_pf;

    if (!flag_copyright_affiche) {
#ifndef NO_XPM
	XpmAttributes xpma;
	XpmColorSymbol xpmcs[1];

	xpmcs[0].name = NULL;
	xpmcs[0].value = "None";
	xpmcs[0].pixel = BlackPixel(XtDisplay(top), DefaultScreen(XtDisplay(top)));
	xpma.valuemask = XpmReturnInfos | XpmColorSymbols;	
	xpma.colorsymbols = &xpmcs[0];
	xpma.numsymbols = 1;
	XpmCreatePixmapFromData (XtDisplay(top), XtWindow(top), pf_xpm, &pixmap_pf, NULL, &xpma);
#else
	pixmap_pf = XCreateBitmapFromData (XtDisplay(top), XtWindow(top), pf_bits, pf_width, pf_height);
#endif /* NO_XPM */
	affiche_copyright (top, formWidgetClass, pixmap_pf);
    }
}


/* 
 * Affichage d'une erreur donnee par code_erreur
 * 
 * Remarque: On est oblige de creer le widget a chaque fois car la largeur
 *	     d'un widget dialog est calculee a la creation...
 */
void affiche_erreur(s, code_erreur)
char *s;
int code_erreur;
{
    if (code_erreur != 0)
	sprintf (buf, "%s : %s", s, sys_errlist[code_erreur]);
    else
	strcpy (buf, s);

    popup_erreur = XtCreatePopupShell ("popup_erreur", overrideShellWidgetClass, forme_base, NULL, 0);

    /*
     * Boite d'erreur 
     */
    message_erreur = XtVaCreateManagedWidget ("message_erreur", dialogWidgetClass, popup_erreur, XtNlabel, buf, NULL);
    XawDialogAddButton (message_erreur, "ok_message_erreur", Validation_erreur, NULL);
    positionnement_widget (em, popup_erreur);
    XtPopup (popup_erreur, XtGrabNonexclusive);
}

/*
 * fonctions appelees dans lecteur.c
 */

/* validation/invalidation */

void lecteur_valide (flag)
char flag;
{
    XtSetSensitive (lecteur, flag);
}

/* Affiche/efface le lecteur */

void efface_lecteur ()
{
    XtPopdown (popup_lecteur);
}

void affiche_lecteur ()
{
    XtPopup (popup_lecteur, XtGrabNone);    
}

/* Affiche les compteurs */

void affiche_compteur_lecteur_caractere ()
{
    sprintf (buf, "%05d", numero_caractere_courant);

    n = 0;
    XtSetArg (args[n], XtNlabel, buf); n++;
    XtSetValues (compteur_lecteur_caractere, args, n);
}

void affiche_compteur_lecteur_page ()
{
    sprintf (buf, "%03d", numero_page_courante);

    n = 0;
    XtSetArg (args[n], XtNlabel, buf); n++;
    XtSetValues (compteur_lecteur_page, args, n);
}

/* Force le bouton STOP valide si appel de stop_rapide() */

void activation_bouton_stop ()
{
    /* Valide le STOP, invalide la PLAY */
    n = 0;
    XtSetArg (args[n], XtNstate, False); n++;
    XtSetValues (play_lecteur, args, n);
    n = 0;
    XtSetArg (args[n], XtNstate, True); n++;
    XtSetValues (stop_lecteur, args, n);
}


/*
 * Callback des boutons "oui/non_arret_page_lecteur"
 */

static void arret_a_chaque_page (w, flag, call_data)
Widget w;
Boolean flag;
XtPointer call_data;
{
    flag_arret_a_chaque_page = (flag == True ? 1 : 0);
}


