/* 
 * voice.h
 *
 * This is the main header file for vgetty, zplay and the pvf tools.
 * It includes other header files and defines some global variables.
 *
 */

#ifdef MAIN
#include "version.h"
char voice_h[] = "$Id: voice.h,v 1.2 1995/04/11 19:18:34 marc Exp $";
#endif

#include <stdio.h>
#include <string.h>
#include <unistd.h>

#ifndef _NOSTDLIB_H
#include <stdlib.h>
#endif

#include "mgetty.h"
#include "policy.h"
#include "config.h"
#include "vconfig.h"

typedef char *path_t;

#ifdef MAIN
path_t dist_ring_init = NULL;
path_t vgetty_log_path = NULL;
path_t fft_program = NULL;
path_t voice_dir = NULL;
path_t message_flag_file = NULL;
path_t vgetty_answer_file = NULL;
path_t vgetty_receive_dir = NULL;
path_t vgetty_message_dir = NULL;
path_t vgetty_message_list = NULL;
path_t vgetty_backup_message = NULL;
path_t message_program = NULL;
path_t button_program = NULL;
path_t dtmf_program = NULL;
path_t call_program = NULL;
path_t vgetty_ata = NULL;
path_t zplay_log_path = NULL;
int dist_ring_voice;
int dist_ring_data;
int dist_ring_fax;
int dtmf_len;
double dtmf_threshold;
int rec_compression;
int rec_silence_len;
double rec_silence_threshold;
boolean rec_remove_silence;
int rec_max_len;
double speaker_answer_volume;
int toll_saver_rings;
boolean rec_always_keep_message;
boolean dist_ring;
int zplay_max_rings;
double zplay_speaker_volume;
int zplay_send_baud;
int zyxel_rom;
#else
extern path_t dist_ring_init;
extern path_t vgetty_log_path;
extern path_t fft_program;
extern path_t voice_dir;
extern path_t message_flag_file;
extern path_t vgetty_answer_file;
extern path_t vgetty_receive_dir;
extern path_t vgetty_message_dir;
extern path_t vgetty_message_list;
extern path_t vgetty_backup_message;
extern path_t message_program;
extern path_t button_program;
extern path_t dtmf_program;
extern path_t call_program;
extern path_t vgetty_ata;
extern path_t zplay_log_path;
extern int dist_ring_voice;
extern int dist_ring_data;
extern int dist_ring_fax;
extern int dtmf_len;
extern double dtmf_threshold;
extern int rec_compression;
extern int rec_silence_len;
extern double rec_silence_threshold;
extern boolean rec_remove_silence;
extern int rec_max_len;
extern double speaker_answer_volume;
extern int toll_saver_rings;
extern boolean rec_always_keep_message;
extern boolean dist_ring;
extern int zplay_max_rings;
extern double zplay_speaker_volume;
extern int zplay_send_baud;
extern int zyxel_rom;
#endif

extern boolean verbose;
extern int messages_waiting_ack;
extern int voice_modem;
extern char *vgetty_version;

extern char *make_path _PROTO((char *path, char *name));
extern char *make_string _PROTO((char *content));
extern void voice_config _PROTO((int argc, char *argv[]));

/*
 * Old defines follow
 */

/* modem types */

#define VM_ZYXEL 0
#define VM_DOLPHIN 1
#define VM_ROCKWELL 2

/* i/o devices */

#define VIO_TELCO 0
#define VIO_MIC 1
#define VIO_SPEAKER 2

extern int voice_wait_for _PROTO(( char * s_in, int fd ));
extern int voice_command _PROTO(( char * send, char * expect, int fd ));
extern int voice_open_device _PROTO((char * voice_tty));
extern int voice_open _PROTO((char * voice_ttys));
extern void voice_close _PROTO((int fd));
extern boolean voice_format_supported _PROTO((int compr));
extern int voice_data_rate _PROTO((int compr));
extern int voice_beep _PROTO((int fd, int voc_io, char *beep));
extern int voice_dialout _PROTO((int fd, int voc_io, char *dialout));
extern int voice_send_file _PROTO((char * voc_file, int fd,
				   int voc_io, int silence));
extern int voice_record_file _PROTO(( char *voc_file, int fd, int voc_io,
			     int compr, int silence, double threshold,
			     int timeout, boolean do_fft));
extern int voice_send_init _PROTO((int fd, int vocfd, int voc_io));
extern int voice_record_init _PROTO((int fd, int compr, int voc_io,
				     int silence, double threshold,
				     char *header));
extern void voice_mode_off _PROTO((int fd));
extern void voice_message_light _PROTO((void));
extern void voice_rings _PROTO((int *rings_wanted));
extern void voice_button _PROTO((int rings));
extern void voice_answer _PROTO((int rings, int rings_wanted,
				 action_t what_action));
extern void voice_activate_digits _PROTO((void));
extern char* voice_get_digits _PROTO((void));
extern char* voice_flush _PROTO((int fd));
extern void voice_set_ignore _PROTO((char *ignore));
extern void enter_data_mode _PROTO((int answer_mode));

#define ETX	003
#define DLE	020
#define DC2	022
#define XON	021
#define XOFF	023

#define	ERROR	-1
#define NOERROR	0

#define ANSWER_DATA  0x01
#define ANSWER_FAX   0x02
#define ANSWER_VOICE 0x04
