/* common.h  -  Common data structures and functions. */

/* Copyright 1992-1995 Werner Almesberger. See file COPYING for details. */


#ifndef COMMON_H
#define COMMON_H

#include <linux/genhd.h>
#include <sys/stat.h>

#include "lilo.h"


#define O_NOACCESS 3  /* open a file for "no access" */


typedef struct {
    unsigned char sector,track; /* CX */
    unsigned char device,head; /* DX */
    unsigned char num_sect; /* AL */
} SECTOR_ADDR;

typedef struct {
    char name[MAX_IMAGE_NAME+1];
    char password[MAX_PW+1];
    SECTOR_ADDR start;
    unsigned char write_part; /* drive to write partition table to */
    unsigned short flags,vga_mode;
} IMAGE_DESCR;

typedef struct {
    char jump[2]; /* jump over the data */
    char signature[4]; /* "LILO" */
    unsigned short stage,version;
    unsigned short timeout; /* 54 msec delay until input time-out,
			       0xffff: never */
    unsigned short delay; /* delay: wait that many 54 msec units. */
    unsigned char port; /* COM port. 0 = none, 1 = COM1, etc. */
    unsigned char ser_param; /* RS-232 parameters, must be 0 if unused */
    unsigned long timestamp; /* timestamp for restoration */
    SECTOR_ADDR descr[3];
    unsigned char prompt; /* 0 = only on demand, =! 0 = always */
    unsigned short msg_len; /* 0 if none */
    SECTOR_ADDR msg;
    SECTOR_ADDR secondary[MAX_SECONDARY+1];
} BOOT_PARAMS_1; /* first stage boot loader */

typedef struct {
    char jump[2]; /* jump over the data */
    char signature[4]; /* "LILO" */
    unsigned short stage,version;
} BOOT_PARAMS_2; /* second stage boot loader */

typedef struct {
    char jump[2]; /* jump over the data */
    char signature[4]; /* "LILO" */
    unsigned short stage,version; /* stage is 0x10 */
    unsigned short offset; /* partition entry offset */
    unsigned char drive; /* BIOS drive code */
} BOOT_PARAMS_C; /* chain loader */

#define PART(s,n) (((struct partition *) ((char *) &(s)+PART_TABLE_OFFSET)) \
  [(n)])

typedef union {
    BOOT_PARAMS_1 par_1;
    BOOT_PARAMS_2 par_2;
    BOOT_PARAMS_C par_c;
    unsigned char sector[SECTOR_SIZE];
} BOOT_SECTOR;

typedef union {
    struct {
	unsigned short checksum;
	IMAGE_DESCR descr[MAX_IMAGES]; /* boot file descriptors */
    } d;
    unsigned char sector[SECTOR_SIZE*2];
} DESCR_SECTORS;


#define alloc_t(t) ((t *) alloc(sizeof(t)))


extern int verbose,test,compact,linear,nowarn;
extern int boot_dev_nr;


volatile void pdie(char *msg);

/* Do a perror and then exit. */

volatile void die(char *fmt,...);

/* fprintf an error message and then exit. */

void *alloc(int size);

/* Allocates the specified number of bytes. Dies on error. */

void *ralloc(void *old,int size);

/* Changes the size of an allocated memory area. Dies on error. */

char *stralloc(char *str);

/* Like strdup, but dies on error. */

int to_number(char *num);

/* Converts a string to a number. Dies if the number is invalid. */

void check_version(BOOT_SECTOR *sect,int stage);

/* Verify that a boot sector has the correct version number. */

int stat_equal(struct stat *a,struct stat *b);

/* Compares two stat structures. Returns a non-zero integer if they describe
   the same file, zero if they don't. */

#endif
