/*
 * dlsof.h - HP-UX header file for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */


/*
 * $Id: dlsof.h,v 1.10 96/03/05 12:52:22 abe Exp $
 */


#if	!defined(HPUX_LSOF_H)
#define	HPUX_LSOF_H	1

#include <stdlib.h>
#include <dirent.h>
#include <mntent.h>
#include <setjmp.h>
#include <string.h>
#include <nlist.h>
#include <unistd.h>
#include <sys/vnode.h>
#include <sys/domain.h>
#include <sys/file.h>
#include <sys/mbuf.h>

# if	_HPUXV>=800
#undef	_PROTOTYPES
#include <sys/pstat.h>
# endif	/* _HPUXV>=800 */

#include <sys/resource.h>
#include <sys/proc.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <net/route.h>
#include <net/raw_cb.h>
#include <netinet/in_pcb.h>
#include <rpc/types.h>

# if	_HPUXV>=1000
#include <rpc/xdr.h>
#include <rpc/auth.h>
#include <rpc/clnt.h>
#include <sys/cdfsdir.h>
#include <sys/cdfs.h>
#include <sys/cdnode.h>
# endif	/* _HPUXV>=1000 */

#include <nfs/nfs.h>
#include <nfs/nfs_clnt.h>
#include <nfs/rnode.h>
#include <nfs/snode.h>

# if	_HPUXV>=1000
#define	_KERNEL
#include <nfs/fifonode.h>
#undef	_KERNEL
# endif	/* _HPUXV>=1000 */

# if	defined(DTYPE_LLA)
#define	_KERNEL	1
#include <sio/lla.h>
#undef	_KERNEL
# endif

#include <sys/un.h>
#include <sys/unpcb.h>
#include <sys/vfs.h>
#include <sys/vmmac.h>
#include <sys/user.h>

/*
 * This is from <sys/mount.h>, defined under the _KERNEL symbol.
 * Unfortunately, defining _KERNEL causes <sys/mount.h> to include
 * other header files not in <sys>.
 */

struct mount {
	struct	mount *m_hforw;  /* forward hash pointer */
	struct	mount *m_hback;  /* backward hash pointer */
	struct	mount *m_rhforw; /* forward hash pointer for real device */
	struct	mount *m_rhback; /* backward hash pointer for real device */
	struct vfs	*m_vfsp; /* vfs structure for this filesystem */
	dev_t	m_dev;		 /* device mounted */
   };

# if	_HPUXV>=800
/*
 * These definitions are from <sys/vfs.h>, defined under the _KERNEL symbol.
 * Unfortunately, defining _KERNEL causes <sys/vfs.h> to include other
 * header files not in <sys>.
 */
#define MOUNT_UFS 0
#define MOUNT_NFS 1
#define MOUNT_CDFS 2
# endif	/* _HPUXV>=800 */

# if	defined(HAS_CONST)
#define	COMP_P		const void
# else	/* !defined(HAS_CONST) */
#define	COMP_P		void
# endif	/* defined(HAS_CONST) */

# if	_HPUXV>=800
#define	CURDIR	p->p_cdir
#define	FILEPTR	oft.ofile[j-1]
#define	ROOTDIR	p->p_rdir
# else	/* _HPUXV<800 */
#define CURDIR	u->u_cdir
#define	FILEPTR	u->u_ofile.ofile[j-1]
#define	ROOTDIR	u->u_rdir
# endif	/* _HPUXV>=800 */

#define DEVINCR		1024	/* device table malloc() increment */
#define	KA_T		off_t
#define	KMEM		"/dev/kmem"
#define MALLOC_P	void
#define FREE_P		void
#define MALLOC_S	unsigned
#define MOUNTED		MNT_MNTTAB

# if	_HPUXV<1000
#define N_UNIX		"/hp-ux"
# else	/* _HPUXV>=1000 */
#define N_UNIX		"/stand/vmunix"
# endif	/* _HPUXV<1000 */

#define QSORT_P		void
#define	READLEN_T	int
#define STRNCPY_L	size_t
#define SWAP		"/dev/swap"

# if	_HPUXV<800
#define unp_addr	unp_locaddr
/*
 * HP-UX <8 SWAP must be read in DEV_BSIZE chunks.
 */
#define U_SIZE		(((DEV_BSIZE+sizeof(struct user))/DEV_BSIZE)*DEV_BSIZE)
# endif	/* _HPUXV<800 */

# if	_HPUXV>=800
#define	U_SIZE		sizeof(struct user)
# endif	/* _HPUXV>=800 */


# if	defined(HAS_AFS)
/*
 * AFS definitions
 */

#define	AFSAPATHDEF	"/usr/adm/afs/kload"
#define	AFSDEV		1		/* AFS "fake" device number */

#  if	defined(HASAOPT)
extern char *AFSApath;			/* alternate AFS name list path
					 * (from -A) */
#  endif	/* defined(HASAOPT) */

extern struct vfs *AFSVfsp;		/* AFS struct vfs kernel pointer */
# endif	/* defined(HAS_AFS) */


/*
 * Global storage definitions (including their structure definitions)
 */

extern int Kmem;

struct l_vfs {
	struct vfs *addr;		/* kernel address */
	dev_t dev;			/* device */
	char *dir;			/* mounted directory */
	char *fsname;			/* file system name */

# if	defined(HASFSINO)
	ino_t fs_ino;			/* file system inode number */
# endif	/* defined(HASFSINO) */

	struct l_vfs *next;		/* forward link */
};
extern struct l_vfs *Lvfs;

# if	_HPUXV<800
extern int Mem;
# endif	/* _HPUXV<800 */

struct mounts {
        dev_t dev;              	/* st_dev */
        char *dir;              	/* directory */
        char *fsname;           	/* file system */
	ino_t inode;			/* st_ino */
	mode_t mode;			/* st_mode */
        struct mounts *next;    	/* forward link */
	dev_t rdev;			/* st_rdev */
};

# if	defined(hp9000s300)
#define	X_AFS_FID	0
#define	X_AFS_OPS	1
#define	X_AFS_VOL	2
#define	X_NCACHE	3
#define	X_NCSIZE	4
#define X_PROC          5
#define X_NFS_OPS	6
#define X_NPROC         7
#define X_VN_FOPS	8

#  if	_HPUXV<800
#define X_USRPTMAP	9
#define X_USRPT		10
#define	X_LAST		11
#  else	/* _HPUXV>=800 */
#define	X_LAST		9
#  endif	/* _HPUXV<800 */
# endif	/* defined(hp9000s300) */

# if	defined(hp9000s800)
#define	X_AFS_FID	0
#define	X_AFS_OPS	1
#define	X_AFS_VOL	2
#define	X_NCACHE	3
#define	X_NCSIZE	4
#define X_PROC          5
#define X_NFS_OPS	6
#define X_NPROC         7
#define X_VN_FOPS	8

#  if	_HPUXV<800
#define X_UBASE		9
#define X_NPIDS		10
#define	X_LAST		11
#  else	/* _HPUXV>=800 */
#   if	_HPUXV>=1000
#define	X_CDFS_OPS	9
#define	X_FIFO_OPS	10
#define	X_PIPE_OPS	11
#define	X_SPEC_OPS	12
#define X_VXFS_OPS	13
#define	X_LAST		14
#   else	/* _HPUXV<1000 */
#define	X_LAST		9
#   endif	/* _HPUXV>=1000 */
#  endif	/* _HPUXV<800 */
# endif	defined(hp9000s800)

# if	_HPUXV<800 && defined(hp9000s800)
extern int npids;
extern struct proc *proc;
# endif	/* _HPUXV<800 && defined(hp9000s800) */

struct sfile {
	char *aname;			/* argument file name */
	char *name;			/* file name (after readlink()) */
	char *devnm;			/* device name (optional) */
	dev_t dev;			/* device */
	u_short mode;			/* S_IFMT mode bits from stat() */
	int type;			/* file type: 0 = file system
				 	 *	      1 = regular file */
	ino_t i;			/* inode number */
	int f;				/* file found flag */
	struct sfile *next;		/* forward link */
};

# if	_HPUXV<800
extern int Swap;
# endif	/* _HPUXV<800 */

# if	_HPUXV<800 && defined(hp9000s800)
extern struct user *ubase;
# endif	/* _HPUXV<800 && defined(hp9000s800) */

# if	_HPUXV<800 && defined(hp9000s300)
extern struct pte *Usrptmap;
extern struct pte *usrpt;
# endif	/* _HPUXV<800 && defined(hp9000s300) */

extern struct fileops *Vnfops;

#endif	/* HPUX_LSOF_H */
