;;;
;;; tm-rich.el --- text/enriched and text/richtext style
;;;                richtext filter for tm-view
;;;
;;; Copyright (C) 1995 Free Software Foundation, Inc.
;;; Copyright (C) 1994,1995 MORIOKA Tomohiko
;;;
;;; Author: MORIOKA Tomohiko <morioka@jaist.ac.jp>
;;; Version:
;;;	$Id: tm-rich.el,v 7.1 1995/10/20 10:40:06 morioka Exp $
;;; Keywords: mail, news, MIME, multimedia, richtext, enriched
;;;
;;; This file is part of tm (Tools for MIME).
;;;

(require 'tm-view)


(defvar tm-rich/richtext-module
  (if (or (< emacs-major-version 19)
	  (and (= emacs-major-version 19)
	       (< emacs-minor-version 29))
	  )
      'tinyrich
    'richtext))
(require tm-rich/richtext-module)


;;; @ content filters for tm-view
;;;

(defun mime-viewer/filter-text/richtext (ctype params encoding)
  (let* ((mode mime::preview/original-major-mode)
	 (m (assq mode mime-viewer/code-converter-alist))
	 (charset (assoc "charset" params))
	 ;; 1995/9/21 (c.f. tm-eng:105), 1995/10/3 (c.f. tm-eng:121)
	 ;;   modified by Eric Ding <ericding@San-Jose.ate.slb.com>
	 (beg (point-min)) (end (point-max))
	 )
    (remove-text-properties beg end '(face nil))
    (mime/decode-region encoding beg end)
    (if (and m (fboundp (setq m (cdr m))))
	(funcall m beg (point-max) charset encoding)
      (mime-viewer/default-code-convert-region beg (point-max)
					       charset encoding)
      )
    (richtext-decode beg (point-max))
    ))

(defun mime-viewer/filter-text/enriched (ctype params encoding)
  (let* ((mode mime::preview/original-major-mode)
	 (m (assq mode mime-viewer/code-converter-alist))
	 (charset (assoc "charset" params))
	 ;; 1995/9/21 (c.f. tm-eng:105), 1995/10/3 (c.f. tm-eng:121)
	 ;;   modified by Eric Ding <ericding@San-Jose.ate.slb.com>
	 (beg (point-min)) (end (point-max))
	 )
    (remove-text-properties beg end '(face nil))
    (mime/decode-region encoding beg end)
    (if (and m (fboundp (setq m (cdr m))))
	(funcall m beg (point-max) charset encoding)
      (mime-viewer/default-code-convert-region beg (point-max)
					       charset encoding)
      )
    (enriched-decode beg (point-max))
    ))


;;; @ setting
;;;

(set-alist 'mime-viewer/content-filter-alist
	   "text/richtext" (function mime-viewer/filter-text/richtext))

(set-alist 'mime-viewer/content-filter-alist
	   "text/enriched" (function mime-viewer/filter-text/enriched))


;;; @ end
;;;

(provide 'tm-rich)

(run-hooks 'tm-rich-load-hook)
