dnl Copyright (c) 1993 by Sanjay Ghemawat
dnl
acaux_fail=''
define(ACAUX_FAIL,
[AC_PROVIDE([$0])
echo ""
echo "*** I could not find the $1."
echo "    Please set the environment variable \"$2\" to the directory"
echo "    that contains the $1 and rerun configure."
echo ""
acaux_fail=yes])
dnl
dnl Look for a library
dnl
define(ACAUX_LIB_FINDPATH,
[AC_PROVIDE([$0])
if test -z "[$]$1[lib]"; then
  AC_CHECKING(for $1 library)
  $1[lib]=nope
  if test -z "$prefix"; then
    dirs="/usr/local/lib /usr/lib"
  else
    dirs="$prefix/lib /usr/local/lib /usr/lib"
  fi
  for d in $dirs; do
    if test -f "$d/lib$1.a"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so"; then
      $1[lib]=$d
      break
    fi
    if test -f "$d/lib$1.so.*"; then
      $1[lib]=$d
      break
    fi
  done
  if test "[$]$1[lib]" = nope; then
    ACAUX_FAIL($1 library,$1lib)
  fi
fi
# Plug -L in front of it
$1[libdir]="$[$1][lib]"
$1[lib]="-L$[$1][lib]"
AC_VERBOSE(setting $1[lib] to [$]$1[lib])
AC_VERBOSE(setting $1[libdir] to [$]$1[libdir])
AC_SUBST($1[lib])
AC_SUBST($1[libdir])])dnl
define(ACAUX_INC_FINDPATH,
[AC_PROVIDE([$0])
if test -z "$[$1]"; then
  AC_CHECKING(for include file $2)
  $1=nope
  if test -z "$prefix"; then
    dirs="/usr/local/include /usr/include"
  else
    dirs="$prefix/include /usr/local/include /usr/include"
  fi
  for d in $dirs; do
    if test -f "$d/$2"; then
      $1=$d
      break
    fi
  done
  if test "[$]$1" = nope; then
    ACAUX_FAIL(include file $2,$1)
  fi
  if test "[$]$1" = "/usr/include"; then
    # Never put /usr/include in explicitly
    $1=
  fi
fi
# Plug -I in front of it
if test -n "$[$1]"; then
  $1="-I$[$1]"
fi
AC_VERBOSE(setting $1 to [$]$1)
AC_SUBST($1)])dnl
dnl
dnl Find Tcl stuff
dnl
define(ACAUX_FIND_TCL,
[AC_PROVIDE([$0])
ACAUX_LIB_FINDPATH(tcl)
ACAUX_INC_FINDPATH(tclinc,tcl.h)
if test -z "$tclscripts"; then
  AC_CHECKING(for tcl scripts)
  dirs="/usr/local/lib/tcl /usr/lib/tcl"
  if test -n "$prefix"; then
     dirs="$prefix/lib/tcl $dirs"
  fi
  if test -n "$tcllib"; then
     d=`echo "$tcllib" | sed 's/^-L//'`
     dirs="$d/tcl $dirs"
  fi
  for d in $dirs; do
    if test -f "$d/init.tcl"; then
      tclscripts=$d
      break
    fi
  done
  if test -z "$tclscripts"; then
    ACAUX_FAIL(tcl scripts,tclscripts)
  fi
fi
AC_VERBOSE(setting tclscripts to $tclscripts)
AC_SUBST(tclscripts)])dnl
dnl
dnl Find Tk stuff
dnl
define(ACAUX_FIND_TK,
[AC_PROVIDE([$0])
ACAUX_LIB_FINDPATH(tk)
ACAUX_INC_FINDPATH(tkinc,tk.h)
if test -z "$tkscripts"; then
  AC_CHECKING(for tk scripts)
  dirs="/usr/local/lib/tk /usr/lib/tk"
  if test -n "$prefix"; then
     dirs="$prefix/lib/tk $dirs"
  fi
  if test -n "$tklib"; then
     d=`echo "$tklib" | sed 's/^-L//'`
     dirs="$d/tk $dirs"
  fi
  for d in $dirs; do
    if test -f "$d/tk.tcl"; then
      tkscripts=$d
      break
    fi
  done
  if test -z "$tkscripts"; then
    ACAUX_FAIL(tk scripts,tkscripts)
  fi
fi
AC_VERBOSE(setting tkscripts to $tkscripts)
AC_SUBST(tkscripts)])dnl
dnl
dnl Exit if something failed
dnl
define(ACAUX_FAIL_CHECK,
[if test -n "$acaux_fail"; then
  AC_ERROR(Configuration failed.)
fi])dnl
