/* trvolts.c  94.04.30
 * Copyright 1983-1992   Albert Davis
 * dc and tr volts between two nodes (4 different versions)
 */
#include "ecah.h"
#include "branch.h"
#include "nodestat.h"
#include "options.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	double	dc_volts(const node_t*,const node_t*);
	double	tr_volts(const node_t*,const node_t*);
	double	tr_volts_limited(const node_t*,const node_t*);
	double	tr_volts_t1(const node_t*,const node_t*);
	double	logicval(const node_t*);
/*--------------------------------------------------------------------------*/
extern       struct nodestuff ns;
extern const struct nodestat *nstat;
extern const struct options opt;
/*--------------------------------------------------------------------------*/
/* dc_volts: dc voltage for bias calculations
 */
double dc_volts(const node_t *n1, const node_t *n2)
{
 return ns.vdc[n1->m]- ns.vdc[n2->m];
}
/*--------------------------------------------------------------------------*/
/* tr_volts: transient voltage, best approximation, no limiting
 */
double tr_volts(const node_t *n1, const node_t *n2)
{
 return ns.v0[n1->m] - ns.v0[n2->m];
}
/*--------------------------------------------------------------------------*/
/* tr_volts_limited: transient voltage, best approximation, with limiting
 */
double tr_volts_limited(const node_t *n1, const node_t *n2)
{
 double v1 = torange(opt.vmin,ns.v0[n1->m],opt.vmax);
 double v2 = torange(opt.vmin,ns.v0[n2->m],opt.vmax);
 double v = v1 - v2;
 double vo = torange(-opt.limit, v, opt.limit);
 if (opt.foooo == 93){
    if (v1 != ns.v0[n1->m]) printf("v1=%g,%g\n", v1, ns.v0[n1->m]);
    if (v2 != ns.v0[n2->m]) printf("v2=%g,%g\n", v2, ns.v0[n2->m]);
    if (vo != v) printf("vo=%g,%g\n", vo, v);
 }
 return vo;
}
/*--------------------------------------------------------------------------*/
/* tr_volts_t1: transient voltage, 1 time ago
 */
double tr_volts_t1(const node_t *n1, const node_t *n2)
{
 return ns.vt1[n1->m]- ns.vt1[n2->m];
}
/*--------------------------------------------------------------------------*/
double logicval(const node_t *n1)  /* cryptic interpretation of logic value */
{
 struct nodestat s;
 s = nstat[n1->m];
 return (	 (2*s.lv0 + s.lv1)
	+ (.1  * (opt.transits - s.quality))
	+ (.01 * (2 - s.nodemode)));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
