/* dev_logic.h  01/11/93
 * Copyright 1983-1992   Albert Davis
 * data structures and defaults for logic model.
 */
#define PORTSPERGATE (10)

#define lNONE	(0)
#define	lAND	(1)
#define	lNAND	(2)
#define	lOR	(3)
#define	lNOR	(4)
#define	lXOR	(5)
#define lINV	(6)

#define lDEFAULT_modelname	"-error-"
#define lDEFAULT_type	(lINV)
#define lDEFAULT_delay	(1e-9)
#define lDEFAULT_rise	(lDEFAULT_delay/2.)
#define lDEFAULT_fall	(lDEFAULT_delay/2.)
#define lDEFAULT_rs	(1e2)
#define lDEFAULT_rw	(1e9)
#define lDEFAULT_th1	(.75)
#define lDEFAULT_th0	(.25)
#define lDEFAULT_mr	(5.)
#define lDEFAULT_mf	(5.)
#define lDEFAULT_over	(.1)
#define lDEFAULT_vmax	(5.)
#define lDEFAULT_vmin	(0.)
#define lDEFAULT_range	(5.)

struct logic {
   generic_t	*x;
   size_t	ssize;
   const struct lmod *m;
   char 	modelname[LABELEN+1];
   node_t	n[PORTSPERGATE+1];	/* up to here must match subckt */
   					/* PORTSPERGATE <= PORTSPERSUBCKT */
   int		type;			/* and, or, etc. */
   unsigned	incount;		/* count input nodes */
   int		gatemode;
};

struct lmod {
   generic_t	*x;
   size_t	ssize;
   double	delay;
   double	rise;
   double	fall;
   double	rs;
   double	rw;
   double	th1;
   double	th0;
   double	mr;
   double	mf;
   double	over;
   double	vmax;
   double	vmin;
   double	range;
};
