#!@@PERL@@ @@PERLOPTS@@

# Copyright 1999, 2000, 2001 (c) Thomas Erskine <@@AUTHOR@@>
# See the COPYRIGHT file with the distribution.

# make-path - read traceroute outputs and reduce to one line per host
# $Id: make-path.pl,v 1.8 2001/08/28 15:22:24 remstats Exp $

# - - -   Configuration   - - -

use strict;

# What is this program called, for error-messages and file-names
$main::prog = 'make-path';

# - - -   Version History   - - -

(undef, $main::version) = split(' ', '$Revision: 1.8 $');

# - - -   Setup   - - -

# Parse the command-line
use Getopt::Std;
my %opt = ();
getopts('d:h', \%opt);

if (defined $opt{'h'}) { &usage; } # no return
if (defined $opt{'d'}) { $main::debug = $opt{'d'}; } else { $main::debug = 0; }
if (@ARGV < 1 ) { push @ARGV, '-'; }

# - - -   Mainline   - - -

%main::paths = ();
foreach my $file (@ARGV) {
	&trace_path($file);
}

foreach (sort keys %main::paths) {
	print $main::paths{$_} .' '. $_ . "\n";
}

exit 0;

#------------------------------------------------------------ trace_path ---
sub trace_path {
	my ($file) = @_;
	my ($host, $ip);
	
	open (FILE, "<$file") or die "Can't open $file: $!\n";

# Which host is this for
	my $firstline = <FILE>;
	chomp $firstline;
	if ($firstline =~ /^traceroute\s+to\s+(\S+)\s+\(([^\)]+)\)/i) {
		$host = $1;
		$ip = $2;
	}
	else {
		&error("first line wrong: $firstline");
		return;
	}

# Read the data from the file
	my ($hop, $line, $asn, @temp);
	while (<FILE>) {
		chomp;
		if (/\s\((\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})\)\s/) {
			$hop = $1;
			if (/\[no RADB record\]/i) {
				undef $asn;
			}
			elsif (/\[([^\]]+)\]/) {
				@temp = split('/', $1);
				$asn = pop @temp;
				$asn = substr($asn,2);
				$hop .= ':'. $asn;
			}
		}
		else { $hop = '-'; }

		if (defined $line) { $line .= ' '. $hop; }
		else { $line = $hop; }
	}
	close (FILE);

# Purge traces that didn't reach the destination of trailing crud
	while ($line =~ s/ -$//) {};

	$main::paths{$line} = $host .' '. $ip;

	&debug("$host $ip = $line") if ($main::debug);
}

#----------------------------------------------------------------- usage ---
sub usage {
	print STDERR <<"EOD_USAGE";
$main::prog version $main::version
usage: $main::prog [options] file ...
where options are:
	-d	enable debugging output
	-h	show this help
EOD_USAGE
	exit 0;
}

#----------------------------------------------------------------- debug ---
sub debug {
	my $msg = join('', @_);
	print STDERR "DEBUG: $msg\n";
}

#------------------------------------------------------------------ error ---
sub error {
	my $msg = join('', @_);
	print STDERR "$main::prog: ERROR $msg\n";
}
