#define ALT_BITSTREAM_READER_LE
#include "avcodec.h"
#include "bitstream.h"
#include "dsputil.h"

typedef struct {
    uint_fast8_t dimensions;
    uint_fast8_t lookup_type;
    uint_fast8_t maxdepth;
    VLC vlc;
    float *codevectors;
    unsigned int nb_bits;
} vorbis_codebook;

typedef union vorbis_floor_u vorbis_floor_data;
typedef struct vorbis_floor0_s vorbis_floor0;
typedef struct vorbis_floor1_s vorbis_floor1;
struct vorbis_context_s;
typedef
uint_fast8_t (* vorbis_floor_decode_func)
             (struct vorbis_context_s *, vorbis_floor_data *, float *);
typedef struct {
    uint_fast8_t floor_type;
    vorbis_floor_decode_func decode;
    union vorbis_floor_u
    {
        struct vorbis_floor0_s
        {
            uint_fast8_t order;
            uint_fast16_t rate;
            uint_fast16_t bark_map_size;
            int_fast32_t * map[2];
            uint_fast32_t map_size[2];
            uint_fast8_t amplitude_bits;
            uint_fast8_t amplitude_offset;
            uint_fast8_t num_books;
            uint_fast8_t * book_list;
            float * lsp;
        } t0;
        struct vorbis_floor1_s
        {
            uint_fast8_t partitions;
            uint_fast8_t maximum_class;
            uint_fast8_t partition_class[32];
            uint_fast8_t class_dimensions[16];
            uint_fast8_t class_subclasses[16];
            uint_fast8_t class_masterbook[16];
            int_fast16_t subclass_books[16][8];
            uint_fast8_t multiplier;
            uint_fast16_t x_list_dim;
            uint_fast16_t *x_list;
            uint_fast16_t *x_list_order;
            uint_fast16_t *low_neighbour;
            uint_fast16_t *high_neighbour;
        } t1;
    } data;
} vorbis_floor;

typedef struct {
    uint_fast16_t type;
    uint_fast32_t begin;
    uint_fast32_t end;
    uint_fast32_t partition_size;
    uint_fast8_t classifications;
    uint_fast8_t classbook;
    int_fast16_t books[64][8];
    uint_fast8_t maxpass;
} vorbis_residue;

typedef struct {
    uint_fast8_t submaps;
    uint_fast16_t coupling_steps;
    uint_fast8_t *magnitude;
    uint_fast8_t *angle;
    uint_fast8_t *mux;
    uint_fast8_t submap_floor[16];
    uint_fast8_t submap_residue[16];
} vorbis_mapping;

typedef struct {
    uint_fast8_t blockflag;
    uint_fast16_t windowtype;
    uint_fast16_t transformtype;
    uint_fast8_t mapping;
} vorbis_mode;

typedef struct vorbis_context_s {
    AVCodecContext *avccontext;
    GetBitContext gb;
    DSPContext dsp;

    MDCTContext mdct[2];
    uint_fast8_t first_frame;
    uint_fast32_t version;
    uint_fast8_t audio_channels;
    uint_fast32_t audio_samplerate;
    uint_fast32_t bitrate_maximum;
    uint_fast32_t bitrate_nominal;
    uint_fast32_t bitrate_minimum;
    uint_fast32_t blocksize[2];
    const float * win[2];
    uint_fast16_t codebook_count;
    vorbis_codebook *codebooks;
    uint_fast8_t floor_count;
    vorbis_floor *floors;
    uint_fast8_t residue_count;
    vorbis_residue *residues;
    uint_fast8_t mapping_count;
    vorbis_mapping *mappings;
    uint_fast8_t mode_count;
    vorbis_mode *modes;
    uint_fast8_t mode_number; // mode number for the current packet
    float *channel_residues;
    float *channel_floors;
    float *saved;
    uint_fast16_t saved_start;
    float *ret;
    float *buf;
    float *buf_tmp;
    uint_fast32_t add_bias; // for float->int conversion
    uint_fast32_t exp_bias;
} vorbis_context;



static const float vwin64[32] = {
  0.0009460463F, 0.0085006468F, 0.0235352254F, 0.0458950567F,
  0.0753351908F, 0.1115073077F, 0.1539457973F, 0.2020557475F,
  0.2551056759F, 0.3122276645F, 0.3724270287F, 0.4346027792F,
  0.4975789974F, 0.5601459521F, 0.6211085051F, 0.6793382689F,
  0.7338252629F, 0.7837245849F, 0.8283939355F, 0.8674186656F,
  0.9006222429F, 0.9280614787F, 0.9500073081F, 0.9669131782F,
  0.9793740220F, 0.9880792941F, 0.9937636139F, 0.9971582668F,
  0.9989462667F, 0.9997230082F, 0.9999638688F, 0.9999995525F,
};

static const float vwin128[64] = {
  0.0002365472F, 0.0021280687F, 0.0059065254F, 0.0115626550F,
  0.0190823442F, 0.0284463735F, 0.0396300935F, 0.0526030430F,
  0.0673285281F, 0.0837631763F, 0.1018564887F, 0.1215504095F,
  0.1427789367F, 0.1654677960F, 0.1895342001F, 0.2148867160F,
  0.2414252576F, 0.2690412240F, 0.2976177952F, 0.3270303960F,
  0.3571473350F, 0.3878306189F, 0.4189369387F, 0.4503188188F,
  0.4818259135F, 0.5133064334F, 0.5446086751F, 0.5755826278F,
  0.6060816248F, 0.6359640047F, 0.6650947483F, 0.6933470543F,
  0.7206038179F, 0.7467589810F, 0.7717187213F, 0.7954024542F,
  0.8177436264F, 0.8386902831F, 0.8582053981F, 0.8762669622F,
  0.8928678298F, 0.9080153310F, 0.9217306608F, 0.9340480615F,
  0.9450138200F, 0.9546851041F, 0.9631286621F, 0.9704194171F,
  0.9766389810F, 0.9818741197F, 0.9862151938F, 0.9897546035F,
  0.9925852598F, 0.9947991032F, 0.9964856900F, 0.9977308602F,
  0.9986155015F, 0.9992144193F, 0.9995953200F, 0.9998179155F,
  0.9999331503F, 0.9999825563F, 0.9999977357F, 0.9999999720F,
};

static const float vwin256[128] = {
  0.0000591390F, 0.0005321979F, 0.0014780301F, 0.0028960636F,
  0.0047854363F, 0.0071449926F, 0.0099732775F, 0.0132685298F,
  0.0170286741F, 0.0212513119F, 0.0259337111F, 0.0310727950F,
  0.0366651302F, 0.0427069140F, 0.0491939614F, 0.0561216907F,
  0.0634851102F, 0.0712788035F, 0.0794969160F, 0.0881331402F,
  0.0971807028F, 0.1066323515F, 0.1164803426F, 0.1267164297F,
  0.1373318534F, 0.1483173323F, 0.1596630553F, 0.1713586755F,
  0.1833933062F, 0.1957555184F, 0.2084333404F, 0.2214142599F,
  0.2346852280F, 0.2482326664F, 0.2620424757F, 0.2761000481F,
  0.2903902813F, 0.3048975959F, 0.3196059553F, 0.3344988887F,
  0.3495595160F, 0.3647705766F, 0.3801144597F, 0.3955732382F,
  0.4111287047F, 0.4267624093F, 0.4424557009F, 0.4581897696F,
  0.4739456913F, 0.4897044744F, 0.5054471075F, 0.5211546088F,
  0.5368080763F, 0.5523887395F, 0.5678780103F, 0.5832575361F,
  0.5985092508F, 0.6136154277F, 0.6285587300F, 0.6433222619F,
  0.6578896175F, 0.6722449294F, 0.6863729144F, 0.7002589187F,
  0.7138889597F, 0.7272497662F, 0.7403288154F, 0.7531143679F,
  0.7655954985F, 0.7777621249F, 0.7896050322F, 0.8011158947F,
  0.8122872932F, 0.8231127294F, 0.8335866365F, 0.8437043850F,
  0.8534622861F, 0.8628575905F, 0.8718884835F, 0.8805540765F,
  0.8888543947F, 0.8967903616F, 0.9043637797F, 0.9115773078F,
  0.9184344360F, 0.9249394562F, 0.9310974312F, 0.9369141608F,
  0.9423961446F, 0.9475505439F, 0.9523851406F, 0.9569082947F,
  0.9611289005F, 0.9650563408F, 0.9687004405F, 0.9720714191F,
  0.9751798427F, 0.9780365753F, 0.9806527301F, 0.9830396204F,
  0.9852087111F, 0.9871715701F, 0.9889398207F, 0.9905250941F,
  0.9919389832F, 0.9931929973F, 0.9942985174F, 0.9952667537F,
  0.9961087037F, 0.9968351119F, 0.9974564312F, 0.9979827858F,
  0.9984239359F, 0.9987892441F, 0.9990876435F, 0.9993276081F,
  0.9995171241F, 0.9996636648F, 0.9997741654F, 0.9998550016F,
  0.9999119692F, 0.9999502656F, 0.9999744742F, 0.9999885497F,
  0.9999958064F, 0.9999989077F, 0.9999998584F, 0.9999999983F,
};

static const float vwin512[256] = {
  0.0000147849F, 0.0001330607F, 0.0003695946F, 0.0007243509F,
  0.0011972759F, 0.0017882983F, 0.0024973285F, 0.0033242588F,
  0.0042689632F, 0.0053312973F, 0.0065110982F, 0.0078081841F,
  0.0092223540F, 0.0107533880F, 0.0124010466F, 0.0141650703F,
  0.0160451800F, 0.0180410758F, 0.0201524373F, 0.0223789233F,
  0.0247201710F, 0.0271757958F, 0.0297453914F, 0.0324285286F,
  0.0352247556F, 0.0381335972F, 0.0411545545F, 0.0442871045F,
  0.0475306997F, 0.0508847676F, 0.0543487103F, 0.0579219038F,
  0.0616036982F, 0.0653934164F, 0.0692903546F, 0.0732937809F,
  0.0774029356F, 0.0816170305F, 0.0859352485F, 0.0903567428F,
  0.0948806375F, 0.0995060259F, 0.1042319712F, 0.1090575056F,
  0.1139816300F, 0.1190033137F, 0.1241214941F, 0.1293350764F,
  0.1346429333F, 0.1400439046F, 0.1455367974F, 0.1511203852F,
  0.1567934083F, 0.1625545735F, 0.1684025537F, 0.1743359881F,
  0.1803534820F, 0.1864536069F, 0.1926349000F, 0.1988958650F,
  0.2052349715F, 0.2116506555F, 0.2181413191F, 0.2247053313F,
  0.2313410275F, 0.2380467105F, 0.2448206500F, 0.2516610835F,
  0.2585662164F, 0.2655342226F, 0.2725632448F, 0.2796513950F,
  0.2867967551F, 0.2939973773F, 0.3012512852F, 0.3085564739F,
  0.3159109111F, 0.3233125375F, 0.3307592680F, 0.3382489922F,
  0.3457795756F, 0.3533488602F, 0.3609546657F, 0.3685947904F,
  0.3762670121F, 0.3839690896F, 0.3916987634F, 0.3994537572F,
  0.4072317788F, 0.4150305215F, 0.4228476653F, 0.4306808783F,
  0.4385278181F, 0.4463861329F, 0.4542534630F, 0.4621274424F,
  0.4700057001F, 0.4778858615F, 0.4857655502F, 0.4936423891F,
  0.5015140023F, 0.5093780165F, 0.5172320626F, 0.5250737772F,
  0.5329008043F, 0.5407107971F, 0.5485014192F, 0.5562703465F,
  0.5640152688F, 0.5717338914F, 0.5794239366F, 0.5870831457F,
  0.5947092801F, 0.6023001235F, 0.6098534829F, 0.6173671907F,
  0.6248391059F, 0.6322671161F, 0.6396491384F, 0.6469831217F,
  0.6542670475F, 0.6614989319F, 0.6686768267F, 0.6757988210F,
  0.6828630426F, 0.6898676592F, 0.6968108799F, 0.7036909564F,
  0.7105061843F, 0.7172549043F, 0.7239355032F, 0.7305464154F,
  0.7370861235F, 0.7435531598F, 0.7499461068F, 0.7562635986F,
  0.7625043214F, 0.7686670148F, 0.7747504721F, 0.7807535410F,
  0.7866751247F, 0.7925141825F, 0.7982697296F, 0.8039408387F,
  0.8095266395F, 0.8150263196F, 0.8204391248F, 0.8257643590F,
  0.8310013848F, 0.8361496236F, 0.8412085555F, 0.8461777194F,
  0.8510567129F, 0.8558451924F, 0.8605428730F, 0.8651495278F,
  0.8696649882F, 0.8740891432F, 0.8784219392F, 0.8826633797F,
  0.8868135244F, 0.8908724888F, 0.8948404441F, 0.8987176157F,
  0.9025042831F, 0.9062007791F, 0.9098074886F, 0.9133248482F,
  0.9167533451F, 0.9200935163F, 0.9233459472F, 0.9265112712F,
  0.9295901680F, 0.9325833632F, 0.9354916263F, 0.9383157705F,
  0.9410566504F, 0.9437151618F, 0.9462922398F, 0.9487888576F,
  0.9512060252F, 0.9535447882F, 0.9558062262F, 0.9579914516F,
  0.9601016078F, 0.9621378683F, 0.9641014348F, 0.9659935361F,
  0.9678154261F, 0.9695683830F, 0.9712537071F, 0.9728727198F,
  0.9744267618F, 0.9759171916F, 0.9773453842F, 0.9787127293F,
  0.9800206298F, 0.9812705006F, 0.9824637665F, 0.9836018613F,
  0.9846862258F, 0.9857183066F, 0.9866995544F, 0.9876314227F,
  0.9885153662F, 0.9893528393F, 0.9901452948F, 0.9908941823F,
  0.9916009470F, 0.9922670279F, 0.9928938570F, 0.9934828574F,
  0.9940354423F, 0.9945530133F, 0.9950369595F, 0.9954886562F,
  0.9959094633F, 0.9963007242F, 0.9966637649F, 0.9969998925F,
  0.9973103939F, 0.9975965351F, 0.9978595598F, 0.9981006885F,
  0.9983211172F, 0.9985220166F, 0.9987045311F, 0.9988697776F,
  0.9990188449F, 0.9991527924F, 0.9992726499F, 0.9993794157F,
  0.9994740570F, 0.9995575079F, 0.9996306699F, 0.9996944099F,
  0.9997495605F, 0.9997969190F, 0.9998372465F, 0.9998712678F,
  0.9998996704F, 0.9999231041F, 0.9999421807F, 0.9999574732F,
  0.9999695157F, 0.9999788026F, 0.9999857885F, 0.9999908879F,
  0.9999944746F, 0.9999968817F, 0.9999984010F, 0.9999992833F,
  0.9999997377F, 0.9999999317F, 0.9999999911F, 0.9999999999F,
};

static const float vwin1024[512] = {
  0.0000036962F, 0.0000332659F, 0.0000924041F, 0.0001811086F,
  0.0002993761F, 0.0004472021F, 0.0006245811F, 0.0008315063F,
  0.0010679699F, 0.0013339631F, 0.0016294757F, 0.0019544965F,
  0.0023090133F, 0.0026930125F, 0.0031064797F, 0.0035493989F,
  0.0040217533F, 0.0045235250F, 0.0050546946F, 0.0056152418F,
  0.0062051451F, 0.0068243817F, 0.0074729278F, 0.0081507582F,
  0.0088578466F, 0.0095941655F, 0.0103596863F, 0.0111543789F,
  0.0119782122F, 0.0128311538F, 0.0137131701F, 0.0146242260F,
  0.0155642855F, 0.0165333111F, 0.0175312640F, 0.0185581042F,
  0.0196137903F, 0.0206982797F, 0.0218115284F, 0.0229534910F,
  0.0241241208F, 0.0253233698F, 0.0265511886F, 0.0278075263F,
  0.0290923308F, 0.0304055484F, 0.0317471241F, 0.0331170013F,
  0.0345151222F, 0.0359414274F, 0.0373958560F, 0.0388783456F,
  0.0403888325F, 0.0419272511F, 0.0434935347F, 0.0450876148F,
  0.0467094213F, 0.0483588828F, 0.0500359261F, 0.0517404765F,
  0.0534724575F, 0.0552317913F, 0.0570183983F, 0.0588321971F,
  0.0606731048F, 0.0625410369F, 0.0644359070F, 0.0663576272F,
  0.0683061077F, 0.0702812571F, 0.0722829821F, 0.0743111878F,
  0.0763657775F, 0.0784466526F, 0.0805537129F, 0.0826868561F,
  0.0848459782F, 0.0870309736F, 0.0892417345F, 0.0914781514F,
  0.0937401128F, 0.0960275056F, 0.0983402145F, 0.1006781223F,
  0.1030411101F, 0.1054290568F, 0.1078418397F, 0.1102793336F,
  0.1127414119F, 0.1152279457F, 0.1177388042F, 0.1202738544F,
  0.1228329618F, 0.1254159892F, 0.1280227980F, 0.1306532471F,
  0.1333071937F, 0.1359844927F, 0.1386849970F, 0.1414085575F,
  0.1441550230F, 0.1469242403F, 0.1497160539F, 0.1525303063F,
  0.1553668381F, 0.1582254875F, 0.1611060909F, 0.1640084822F,
  0.1669324936F, 0.1698779549F, 0.1728446939F, 0.1758325362F,
  0.1788413055F, 0.1818708232F, 0.1849209084F, 0.1879913785F,
  0.1910820485F, 0.1941927312F, 0.1973232376F, 0.2004733764F,
  0.2036429541F, 0.2068317752F, 0.2100396421F, 0.2132663552F,
  0.2165117125F, 0.2197755102F, 0.2230575422F, 0.2263576007F,
  0.2296754753F, 0.2330109540F, 0.2363638225F, 0.2397338646F,
  0.2431208619F, 0.2465245941F, 0.2499448389F, 0.2533813719F,
  0.2568339669F, 0.2603023956F, 0.2637864277F, 0.2672858312F,
  0.2708003718F, 0.2743298135F, 0.2778739186F, 0.2814324472F,
  0.2850051576F, 0.2885918065F, 0.2921921485F, 0.2958059366F,
  0.2994329219F, 0.3030728538F, 0.3067254799F, 0.3103905462F,
  0.3140677969F, 0.3177569747F, 0.3214578205F, 0.3251700736F,
  0.3288934718F, 0.3326277513F, 0.3363726468F, 0.3401278914F,
  0.3438932168F, 0.3476683533F, 0.3514530297F, 0.3552469734F,
  0.3590499106F, 0.3628615659F, 0.3666816630F, 0.3705099239F,
  0.3743460698F, 0.3781898204F, 0.3820408945F, 0.3858990095F,
  0.3897638820F, 0.3936352274F, 0.3975127601F, 0.4013961936F,
  0.4052852405F, 0.4091796123F, 0.4130790198F, 0.4169831732F,
  0.4208917815F, 0.4248045534F, 0.4287211965F, 0.4326414181F,
  0.4365649248F, 0.4404914225F, 0.4444206167F, 0.4483522125F,
  0.4522859146F, 0.4562214270F, 0.4601584538F, 0.4640966984F,
  0.4680358644F, 0.4719756548F, 0.4759157726F, 0.4798559209F,
  0.4837958024F, 0.4877351199F, 0.4916735765F, 0.4956108751F,
  0.4995467188F, 0.5034808109F, 0.5074128550F, 0.5113425550F,
  0.5152696149F, 0.5191937395F, 0.5231146336F, 0.5270320028F,
  0.5309455530F, 0.5348549910F, 0.5387600239F, 0.5426603597F,
  0.5465557070F, 0.5504457754F, 0.5543302752F, 0.5582089175F,
  0.5620814145F, 0.5659474793F, 0.5698068262F, 0.5736591704F,
  0.5775042283F, 0.5813417176F, 0.5851713571F, 0.5889928670F,
  0.5928059689F, 0.5966103856F, 0.6004058415F, 0.6041920626F,
  0.6079687761F, 0.6117357113F, 0.6154925986F, 0.6192391705F,
  0.6229751612F, 0.6267003064F, 0.6304143441F, 0.6341170137F,
  0.6378080569F, 0.6414872173F, 0.6451542405F, 0.6488088741F,
  0.6524508681F, 0.6560799742F, 0.6596959469F, 0.6632985424F,
  0.6668875197F, 0.6704626398F, 0.6740236662F, 0.6775703649F,
  0.6811025043F, 0.6846198554F, 0.6881221916F, 0.6916092892F,
  0.6950809269F, 0.6985368861F, 0.7019769510F, 0.7054009085F,
  0.7088085484F, 0.7121996632F, 0.7155740484F, 0.7189315023F,
  0.7222718263F, 0.7255948245F, 0.7289003043F, 0.7321880760F,
  0.7354579530F, 0.7387097518F, 0.7419432921F, 0.7451583966F,
  0.7483548915F, 0.7515326059F, 0.7546913723F, 0.7578310265F,
  0.7609514077F, 0.7640523581F, 0.7671337237F, 0.7701953535F,
  0.7732371001F, 0.7762588195F, 0.7792603711F, 0.7822416178F,
  0.7852024259F, 0.7881426654F, 0.7910622097F, 0.7939609356F,
  0.7968387237F, 0.7996954579F, 0.8025310261F, 0.8053453193F,
  0.8081382324F, 0.8109096638F, 0.8136595156F, 0.8163876936F,
  0.8190941071F, 0.8217786690F, 0.8244412960F, 0.8270819086F,
  0.8297004305F, 0.8322967896F, 0.8348709171F, 0.8374227481F,
  0.8399522213F, 0.8424592789F, 0.8449438672F, 0.8474059356F,
  0.8498454378F, 0.8522623306F, 0.8546565748F, 0.8570281348F,
  0.8593769787F, 0.8617030779F, 0.8640064080F, 0.8662869477F,
  0.8685446796F, 0.8707795899F, 0.8729916682F, 0.8751809079F,
  0.8773473059F, 0.8794908626F, 0.8816115819F, 0.8837094713F,
  0.8857845418F, 0.8878368079F, 0.8898662874F, 0.8918730019F,
  0.8938569760F, 0.8958182380F, 0.8977568194F, 0.8996727552F,
  0.9015660837F, 0.9034368465F, 0.9052850885F, 0.9071108577F,
  0.9089142057F, 0.9106951869F, 0.9124538591F, 0.9141902832F,
  0.9159045233F, 0.9175966464F, 0.9192667228F, 0.9209148257F,
  0.9225410313F, 0.9241454187F, 0.9257280701F, 0.9272890704F,
  0.9288285075F, 0.9303464720F, 0.9318430576F, 0.9333183603F,
  0.9347724792F, 0.9362055158F, 0.9376175745F, 0.9390087622F,
  0.9403791881F, 0.9417289644F, 0.9430582055F, 0.9443670283F,
  0.9456555521F, 0.9469238986F, 0.9481721917F, 0.9494005577F,
  0.9506091252F, 0.9517980248F, 0.9529673894F, 0.9541173540F,
  0.9552480557F, 0.9563596334F, 0.9574522282F, 0.9585259830F,
  0.9595810428F, 0.9606175542F, 0.9616356656F, 0.9626355274F,
  0.9636172915F, 0.9645811114F, 0.9655271425F, 0.9664555414F,
  0.9673664664F, 0.9682600774F, 0.9691365355F, 0.9699960034F,
  0.9708386448F, 0.9716646250F, 0.9724741103F, 0.9732672685F,
  0.9740442683F, 0.9748052795F, 0.9755504729F, 0.9762800205F,
  0.9769940950F, 0.9776928703F, 0.9783765210F, 0.9790452223F,
  0.9796991504F, 0.9803384823F, 0.9809633954F, 0.9815740679F,
  0.9821706784F, 0.9827534063F, 0.9833224312F, 0.9838779332F,
  0.9844200928F, 0.9849490910F, 0.9854651087F, 0.9859683274F,
  0.9864589286F, 0.9869370940F, 0.9874030054F, 0.9878568447F,
  0.9882987937F, 0.9887290343F, 0.9891477481F, 0.9895551169F,
  0.9899513220F, 0.9903365446F, 0.9907109658F, 0.9910747662F,
  0.9914281260F, 0.9917712252F, 0.9921042433F, 0.9924273593F,
  0.9927407516F, 0.9930445982F, 0.9933390763F, 0.9936243626F,
  0.9939006331F, 0.9941680631F, 0.9944268269F, 0.9946770982F,
  0.9949190498F, 0.9951528537F, 0.9953786808F, 0.9955967011F,
  0.9958070836F, 0.9960099963F, 0.9962056061F, 0.9963940787F,
  0.9965755786F, 0.9967502693F, 0.9969183129F, 0.9970798704F,
  0.9972351013F, 0.9973841640F, 0.9975272151F, 0.9976644103F,
  0.9977959036F, 0.9979218476F, 0.9980423932F, 0.9981576901F,
  0.9982678862F, 0.9983731278F, 0.9984735596F, 0.9985693247F,
  0.9986605645F, 0.9987474186F, 0.9988300248F, 0.9989085193F,
  0.9989830364F, 0.9990537085F, 0.9991206662F, 0.9991840382F,
  0.9992439513F, 0.9993005303F, 0.9993538982F, 0.9994041757F,
  0.9994514817F, 0.9994959330F, 0.9995376444F, 0.9995767286F,
  0.9996132960F, 0.9996474550F, 0.9996793121F, 0.9997089710F,
  0.9997365339F, 0.9997621003F, 0.9997857677F, 0.9998076311F,
  0.9998277836F, 0.9998463156F, 0.9998633155F, 0.9998788692F,
  0.9998930603F, 0.9999059701F, 0.9999176774F, 0.9999282586F,
  0.9999377880F, 0.9999463370F, 0.9999539749F, 0.9999607685F,
  0.9999667820F, 0.9999720773F, 0.9999767136F, 0.9999807479F,
  0.9999842344F, 0.9999872249F, 0.9999897688F, 0.9999919127F,
  0.9999937009F, 0.9999951749F, 0.9999963738F, 0.9999973342F,
  0.9999980900F, 0.9999986724F, 0.9999991103F, 0.9999994297F,
  0.9999996543F, 0.9999998049F, 0.9999999000F, 0.9999999552F,
  0.9999999836F, 0.9999999957F, 0.9999999994F, 1.0000000000F,
};

static const float vwin2048[1024] = {
  0.0000009241F, 0.0000083165F, 0.0000231014F, 0.0000452785F,
  0.0000748476F, 0.0001118085F, 0.0001561608F, 0.0002079041F,
  0.0002670379F, 0.0003335617F, 0.0004074748F, 0.0004887765F,
  0.0005774661F, 0.0006735427F, 0.0007770054F, 0.0008878533F,
  0.0010060853F, 0.0011317002F, 0.0012646969F, 0.0014050742F,
  0.0015528307F, 0.0017079650F, 0.0018704756F, 0.0020403610F,
  0.0022176196F, 0.0024022497F, 0.0025942495F, 0.0027936173F,
  0.0030003511F, 0.0032144490F, 0.0034359088F, 0.0036647286F,
  0.0039009061F, 0.0041444391F, 0.0043953253F, 0.0046535621F,
  0.0049191472F, 0.0051920781F, 0.0054723520F, 0.0057599664F,
  0.0060549184F, 0.0063572052F, 0.0066668239F, 0.0069837715F,
  0.0073080449F, 0.0076396410F, 0.0079785566F, 0.0083247884F,
  0.0086783330F, 0.0090391871F, 0.0094073470F, 0.0097828092F,
  0.0101655700F, 0.0105556258F, 0.0109529726F, 0.0113576065F,
  0.0117695237F, 0.0121887200F, 0.0126151913F, 0.0130489335F,
  0.0134899422F, 0.0139382130F, 0.0143937415F, 0.0148565233F,
  0.0153265536F, 0.0158038279F, 0.0162883413F, 0.0167800889F,
  0.0172790660F, 0.0177852675F, 0.0182986882F, 0.0188193231F,
  0.0193471668F, 0.0198822141F, 0.0204244594F, 0.0209738974F,
  0.0215305225F, 0.0220943289F, 0.0226653109F, 0.0232434627F,
  0.0238287784F, 0.0244212519F, 0.0250208772F, 0.0256276481F,
  0.0262415582F, 0.0268626014F, 0.0274907711F, 0.0281260608F,
  0.0287684638F, 0.0294179736F, 0.0300745833F, 0.0307382859F,
  0.0314090747F, 0.0320869424F, 0.0327718819F, 0.0334638860F,
  0.0341629474F, 0.0348690586F, 0.0355822122F, 0.0363024004F,
  0.0370296157F, 0.0377638502F, 0.0385050960F, 0.0392533451F,
  0.0400085896F, 0.0407708211F, 0.0415400315F, 0.0423162123F,
  0.0430993552F, 0.0438894515F, 0.0446864926F, 0.0454904698F,
  0.0463013742F, 0.0471191969F, 0.0479439288F, 0.0487755607F,
  0.0496140836F, 0.0504594879F, 0.0513117642F, 0.0521709031F,
  0.0530368949F, 0.0539097297F, 0.0547893979F, 0.0556758894F,
  0.0565691941F, 0.0574693019F, 0.0583762026F, 0.0592898858F,
  0.0602103410F, 0.0611375576F, 0.0620715250F, 0.0630122324F,
  0.0639596688F, 0.0649138234F, 0.0658746848F, 0.0668422421F,
  0.0678164838F, 0.0687973985F, 0.0697849746F, 0.0707792005F,
  0.0717800645F, 0.0727875547F, 0.0738016591F, 0.0748223656F,
  0.0758496620F, 0.0768835359F, 0.0779239751F, 0.0789709668F,
  0.0800244985F, 0.0810845574F, 0.0821511306F, 0.0832242052F,
  0.0843037679F, 0.0853898056F, 0.0864823050F, 0.0875812525F,
  0.0886866347F, 0.0897984378F, 0.0909166480F, 0.0920412513F,
  0.0931722338F, 0.0943095813F, 0.0954532795F, 0.0966033140F,
  0.0977596702F, 0.0989223336F, 0.1000912894F, 0.1012665227F,
  0.1024480185F, 0.1036357616F, 0.1048297369F, 0.1060299290F,
  0.1072363224F, 0.1084489014F, 0.1096676504F, 0.1108925534F,
  0.1121235946F, 0.1133607577F, 0.1146040267F, 0.1158533850F,
  0.1171088163F, 0.1183703040F, 0.1196378312F, 0.1209113812F,
  0.1221909370F, 0.1234764815F, 0.1247679974F, 0.1260654674F,
  0.1273688740F, 0.1286781995F, 0.1299934263F, 0.1313145365F,
  0.1326415121F, 0.1339743349F, 0.1353129866F, 0.1366574490F,
  0.1380077035F, 0.1393637315F, 0.1407255141F, 0.1420930325F,
  0.1434662677F, 0.1448452004F, 0.1462298115F, 0.1476200814F,
  0.1490159906F, 0.1504175195F, 0.1518246482F, 0.1532373569F,
  0.1546556253F, 0.1560794333F, 0.1575087606F, 0.1589435866F,
  0.1603838909F, 0.1618296526F, 0.1632808509F, 0.1647374648F,
  0.1661994731F, 0.1676668546F, 0.1691395880F, 0.1706176516F,
  0.1721010238F, 0.1735896829F, 0.1750836068F, 0.1765827736F,
  0.1780871610F, 0.1795967468F, 0.1811115084F, 0.1826314234F,
  0.1841564689F, 0.1856866221F, 0.1872218600F, 0.1887621595F,
  0.1903074974F, 0.1918578503F, 0.1934131947F, 0.1949735068F,
  0.1965387630F, 0.1981089393F, 0.1996840117F, 0.2012639560F,
  0.2028487479F, 0.2044383630F, 0.2060327766F, 0.2076319642F,
  0.2092359007F, 0.2108445614F, 0.2124579211F, 0.2140759545F,
  0.2156986364F, 0.2173259411F, 0.2189578432F, 0.2205943168F,
  0.2222353361F, 0.2238808751F, 0.2255309076F, 0.2271854073F,
  0.2288443480F, 0.2305077030F, 0.2321754457F, 0.2338475493F,
  0.2355239869F, 0.2372047315F, 0.2388897560F, 0.2405790329F,
  0.2422725350F, 0.2439702347F, 0.2456721043F, 0.2473781159F,
  0.2490882418F, 0.2508024539F, 0.2525207240F, 0.2542430237F,
  0.2559693248F, 0.2576995986F, 0.2594338166F, 0.2611719498F,
  0.2629139695F, 0.2646598466F, 0.2664095520F, 0.2681630564F,
  0.2699203304F, 0.2716813445F, 0.2734460691F, 0.2752144744F,
  0.2769865307F, 0.2787622079F, 0.2805414760F, 0.2823243047F,
  0.2841106637F, 0.2859005227F, 0.2876938509F, 0.2894906179F,
  0.2912907928F, 0.2930943447F, 0.2949012426F, 0.2967114554F,
  0.2985249520F, 0.3003417009F, 0.3021616708F, 0.3039848301F,
  0.3058111471F, 0.3076405901F, 0.3094731273F, 0.3113087266F,
  0.3131473560F, 0.3149889833F, 0.3168335762F, 0.3186811024F,
  0.3205315294F, 0.3223848245F, 0.3242409552F, 0.3260998886F,
  0.3279615918F, 0.3298260319F, 0.3316931758F, 0.3335629903F,
  0.3354354423F, 0.3373104982F, 0.3391881247F, 0.3410682882F,
  0.3429509551F, 0.3448360917F, 0.3467236642F, 0.3486136387F,
  0.3505059811F, 0.3524006575F, 0.3542976336F, 0.3561968753F,
  0.3580983482F, 0.3600020179F, 0.3619078499F, 0.3638158096F,
  0.3657258625F, 0.3676379737F, 0.3695521086F, 0.3714682321F,
  0.3733863094F, 0.3753063055F, 0.3772281852F, 0.3791519134F,
  0.3810774548F, 0.3830047742F, 0.3849338362F, 0.3868646053F,
  0.3887970459F, 0.3907311227F, 0.3926667998F, 0.3946040417F,
  0.3965428125F, 0.3984830765F, 0.4004247978F, 0.4023679403F,
  0.4043124683F, 0.4062583455F, 0.4082055359F, 0.4101540034F,
  0.4121037117F, 0.4140546246F, 0.4160067058F, 0.4179599190F,
  0.4199142277F, 0.4218695956F, 0.4238259861F, 0.4257833627F,
  0.4277416888F, 0.4297009279F, 0.4316610433F, 0.4336219983F,
  0.4355837562F, 0.4375462803F, 0.4395095337F, 0.4414734797F,
  0.4434380815F, 0.4454033021F, 0.4473691046F, 0.4493354521F,
  0.4513023078F, 0.4532696345F, 0.4552373954F, 0.4572055533F,
  0.4591740713F, 0.4611429123F, 0.4631120393F, 0.4650814151F,
  0.4670510028F, 0.4690207650F, 0.4709906649F, 0.4729606651F,
  0.4749307287F, 0.4769008185F, 0.4788708972F, 0.4808409279F,
  0.4828108732F, 0.4847806962F, 0.4867503597F, 0.4887198264F,
  0.4906890593F, 0.4926580213F, 0.4946266753F, 0.4965949840F,
  0.4985629105F, 0.5005304176F, 0.5024974683F, 0.5044640255F,
  0.5064300522F, 0.5083955114F, 0.5103603659F, 0.5123245790F,
  0.5142881136F, 0.5162509328F, 0.5182129997F, 0.5201742774F,
  0.5221347290F, 0.5240943178F, 0.5260530070F, 0.5280107598F,
  0.5299675395F, 0.5319233095F, 0.5338780330F, 0.5358316736F,
  0.5377841946F, 0.5397355596F, 0.5416857320F, 0.5436346755F,
  0.5455823538F, 0.5475287304F, 0.5494737691F, 0.5514174337F,
  0.5533596881F, 0.5553004962F, 0.5572398218F, 0.5591776291F,
  0.5611138821F, 0.5630485449F, 0.5649815818F, 0.5669129570F,
  0.5688426349F, 0.5707705799F, 0.5726967564F, 0.5746211290F,
  0.5765436624F, 0.5784643212F, 0.5803830702F, 0.5822998743F,
  0.5842146984F, 0.5861275076F, 0.5880382669F, 0.5899469416F,
  0.5918534968F, 0.5937578981F, 0.5956601107F, 0.5975601004F,
  0.5994578326F, 0.6013532732F, 0.6032463880F, 0.6051371429F,
  0.6070255039F, 0.6089114372F, 0.6107949090F, 0.6126758856F,
  0.6145543334F, 0.6164302191F, 0.6183035092F, 0.6201741706F,
  0.6220421700F, 0.6239074745F, 0.6257700513F, 0.6276298674F,
  0.6294868903F, 0.6313410873F, 0.6331924262F, 0.6350408745F,
  0.6368864001F, 0.6387289710F, 0.6405685552F, 0.6424051209F,
  0.6442386364F, 0.6460690702F, 0.6478963910F, 0.6497205673F,
  0.6515415682F, 0.6533593625F, 0.6551739194F, 0.6569852082F,
  0.6587931984F, 0.6605978593F, 0.6623991609F, 0.6641970728F,
  0.6659915652F, 0.6677826081F, 0.6695701718F, 0.6713542268F,
  0.6731347437F, 0.6749116932F, 0.6766850461F, 0.6784547736F,
  0.6802208469F, 0.6819832374F, 0.6837419164F, 0.6854968559F,
  0.6872480275F, 0.6889954034F, 0.6907389556F, 0.6924786566F,
  0.6942144788F, 0.6959463950F, 0.6976743780F, 0.6993984008F,
  0.7011184365F, 0.7028344587F, 0.7045464407F, 0.7062543564F,
  0.7079581796F, 0.7096578844F, 0.7113534450F, 0.7130448359F,
  0.7147320316F, 0.7164150070F, 0.7180937371F, 0.7197681970F,
  0.7214383620F, 0.7231042077F, 0.7247657098F, 0.7264228443F,
  0.7280755871F, 0.7297239147F, 0.7313678035F, 0.7330072301F,
  0.7346421715F, 0.7362726046F, 0.7378985069F, 0.7395198556F,
  0.7411366285F, 0.7427488034F, 0.7443563584F, 0.7459592717F,
  0.7475575218F, 0.7491510873F, 0.7507399471F, 0.7523240803F,
  0.7539034661F, 0.7554780839F, 0.7570479136F, 0.7586129349F,
  0.7601731279F, 0.7617284730F, 0.7632789506F, 0.7648245416F,
  0.7663652267F, 0.7679009872F, 0.7694318044F, 0.7709576599F,
  0.7724785354F, 0.7739944130F, 0.7755052749F, 0.7770111035F,
  0.7785118815F, 0.7800075916F, 0.7814982170F, 0.7829837410F,
  0.7844641472F, 0.7859394191F, 0.7874095408F, 0.7888744965F,
  0.7903342706F, 0.7917888476F, 0.7932382124F, 0.7946823501F,
  0.7961212460F, 0.7975548855F, 0.7989832544F, 0.8004063386F,
  0.8018241244F, 0.8032365981F, 0.8046437463F, 0.8060455560F,
  0.8074420141F, 0.8088331080F, 0.8102188253F, 0.8115991536F,
  0.8129740810F, 0.8143435957F, 0.8157076861F, 0.8170663409F,
  0.8184195489F, 0.8197672994F, 0.8211095817F, 0.8224463853F,
  0.8237777001F, 0.8251035161F, 0.8264238235F, 0.8277386129F,
  0.8290478750F, 0.8303516008F, 0.8316497814F, 0.8329424083F,
  0.8342294731F, 0.8355109677F, 0.8367868841F, 0.8380572148F,
  0.8393219523F, 0.8405810893F, 0.8418346190F, 0.8430825345F,
  0.8443248294F, 0.8455614974F, 0.8467925323F, 0.8480179285F,
  0.8492376802F, 0.8504517822F, 0.8516602292F, 0.8528630164F,
  0.8540601391F, 0.8552515928F, 0.8564373733F, 0.8576174766F,
  0.8587918990F, 0.8599606368F, 0.8611236868F, 0.8622810460F,
  0.8634327113F, 0.8645786802F, 0.8657189504F, 0.8668535195F,
  0.8679823857F, 0.8691055472F, 0.8702230025F, 0.8713347503F,
  0.8724407896F, 0.8735411194F, 0.8746357394F, 0.8757246489F,
  0.8768078479F, 0.8778853364F, 0.8789571146F, 0.8800231832F,
  0.8810835427F, 0.8821381942F, 0.8831871387F, 0.8842303777F,
  0.8852679127F, 0.8862997456F, 0.8873258784F, 0.8883463132F,
  0.8893610527F, 0.8903700994F, 0.8913734562F, 0.8923711263F,
  0.8933631129F, 0.8943494196F, 0.8953300500F, 0.8963050083F,
  0.8972742985F, 0.8982379249F, 0.8991958922F, 0.9001482052F,
  0.9010948688F, 0.9020358883F, 0.9029712690F, 0.9039010165F,
  0.9048251367F, 0.9057436357F, 0.9066565195F, 0.9075637946F,
  0.9084654678F, 0.9093615456F, 0.9102520353F, 0.9111369440F,
  0.9120162792F, 0.9128900484F, 0.9137582595F, 0.9146209204F,
  0.9154780394F, 0.9163296248F, 0.9171756853F, 0.9180162296F,
  0.9188512667F, 0.9196808057F, 0.9205048559F, 0.9213234270F,
  0.9221365285F, 0.9229441704F, 0.9237463629F, 0.9245431160F,
  0.9253344404F, 0.9261203465F, 0.9269008453F, 0.9276759477F,
  0.9284456648F, 0.9292100080F, 0.9299689889F, 0.9307226190F,
  0.9314709103F, 0.9322138747F, 0.9329515245F, 0.9336838721F,
  0.9344109300F, 0.9351327108F, 0.9358492275F, 0.9365604931F,
  0.9372665208F, 0.9379673239F, 0.9386629160F, 0.9393533107F,
  0.9400385220F, 0.9407185637F, 0.9413934501F, 0.9420631954F,
  0.9427278141F, 0.9433873208F, 0.9440417304F, 0.9446910576F,
  0.9453353176F, 0.9459745255F, 0.9466086968F, 0.9472378469F,
  0.9478619915F, 0.9484811463F, 0.9490953274F, 0.9497045506F,
  0.9503088323F, 0.9509081888F, 0.9515026365F, 0.9520921921F,
  0.9526768723F, 0.9532566940F, 0.9538316742F, 0.9544018300F,
  0.9549671786F, 0.9555277375F, 0.9560835241F, 0.9566345562F,
  0.9571808513F, 0.9577224275F, 0.9582593027F, 0.9587914949F,
  0.9593190225F, 0.9598419038F, 0.9603601571F, 0.9608738012F,
  0.9613828546F, 0.9618873361F, 0.9623872646F, 0.9628826591F,
  0.9633735388F, 0.9638599227F, 0.9643418303F, 0.9648192808F,
  0.9652922939F, 0.9657608890F, 0.9662250860F, 0.9666849046F,
  0.9671403646F, 0.9675914861F, 0.9680382891F, 0.9684807937F,
  0.9689190202F, 0.9693529890F, 0.9697827203F, 0.9702082347F,
  0.9706295529F, 0.9710466953F, 0.9714596828F, 0.9718685362F,
  0.9722732762F, 0.9726739240F, 0.9730705005F, 0.9734630267F,
  0.9738515239F, 0.9742360134F, 0.9746165163F, 0.9749930540F,
  0.9753656481F, 0.9757343198F, 0.9760990909F, 0.9764599829F,
  0.9768170175F, 0.9771702164F, 0.9775196013F, 0.9778651941F,
  0.9782070167F, 0.9785450909F, 0.9788794388F, 0.9792100824F,
  0.9795370437F, 0.9798603449F, 0.9801800080F, 0.9804960554F,
  0.9808085092F, 0.9811173916F, 0.9814227251F, 0.9817245318F,
  0.9820228343F, 0.9823176549F, 0.9826090160F, 0.9828969402F,
  0.9831814498F, 0.9834625674F, 0.9837403156F, 0.9840147169F,
  0.9842857939F, 0.9845535692F, 0.9848180654F, 0.9850793052F,
  0.9853373113F, 0.9855921062F, 0.9858437127F, 0.9860921535F,
  0.9863374512F, 0.9865796287F, 0.9868187085F, 0.9870547136F,
  0.9872876664F, 0.9875175899F, 0.9877445067F, 0.9879684396F,
  0.9881894112F, 0.9884074444F, 0.9886225619F, 0.9888347863F,
  0.9890441404F, 0.9892506468F, 0.9894543284F, 0.9896552077F,
  0.9898533074F, 0.9900486502F, 0.9902412587F, 0.9904311555F,
  0.9906183633F, 0.9908029045F, 0.9909848019F, 0.9911640779F,
  0.9913407550F, 0.9915148557F, 0.9916864025F, 0.9918554179F,
  0.9920219241F, 0.9921859437F, 0.9923474989F, 0.9925066120F,
  0.9926633054F, 0.9928176012F, 0.9929695218F, 0.9931190891F,
  0.9932663254F, 0.9934112527F, 0.9935538932F, 0.9936942686F,
  0.9938324012F, 0.9939683126F, 0.9941020248F, 0.9942335597F,
  0.9943629388F, 0.9944901841F, 0.9946153170F, 0.9947383593F,
  0.9948593325F, 0.9949782579F, 0.9950951572F, 0.9952100516F,
  0.9953229625F, 0.9954339111F, 0.9955429186F, 0.9956500062F,
  0.9957551948F, 0.9958585056F, 0.9959599593F, 0.9960595769F,
  0.9961573792F, 0.9962533869F, 0.9963476206F, 0.9964401009F,
  0.9965308483F, 0.9966198833F, 0.9967072261F, 0.9967928971F,
  0.9968769164F, 0.9969593041F, 0.9970400804F, 0.9971192651F,
  0.9971968781F, 0.9972729391F, 0.9973474680F, 0.9974204842F,
  0.9974920074F, 0.9975620569F, 0.9976306521F, 0.9976978122F,
  0.9977635565F, 0.9978279039F, 0.9978908736F, 0.9979524842F,
  0.9980127547F, 0.9980717037F, 0.9981293499F, 0.9981857116F,
  0.9982408073F, 0.9982946554F, 0.9983472739F, 0.9983986810F,
  0.9984488947F, 0.9984979328F, 0.9985458132F, 0.9985925534F,
  0.9986381711F, 0.9986826838F, 0.9987261086F, 0.9987684630F,
  0.9988097640F, 0.9988500286F, 0.9988892738F, 0.9989275163F,
  0.9989647727F, 0.9990010597F, 0.9990363938F, 0.9990707911F,
  0.9991042679F, 0.9991368404F, 0.9991685244F, 0.9991993358F,
  0.9992292905F, 0.9992584038F, 0.9992866914F, 0.9993141686F,
  0.9993408506F, 0.9993667526F, 0.9993918895F, 0.9994162761F,
  0.9994399273F, 0.9994628576F, 0.9994850815F, 0.9995066133F,
  0.9995274672F, 0.9995476574F, 0.9995671978F, 0.9995861021F,
  0.9996043841F, 0.9996220573F, 0.9996391352F, 0.9996556310F,
  0.9996715579F, 0.9996869288F, 0.9997017568F, 0.9997160543F,
  0.9997298342F, 0.9997431088F, 0.9997558905F, 0.9997681914F,
  0.9997800236F, 0.9997913990F, 0.9998023292F, 0.9998128261F,
  0.9998229009F, 0.9998325650F, 0.9998418296F, 0.9998507058F,
  0.9998592044F, 0.9998673362F, 0.9998751117F, 0.9998825415F,
  0.9998896358F, 0.9998964047F, 0.9999028584F, 0.9999090066F,
  0.9999148590F, 0.9999204253F, 0.9999257148F, 0.9999307368F,
  0.9999355003F, 0.9999400144F, 0.9999442878F, 0.9999483293F,
  0.9999521472F, 0.9999557499F, 0.9999591457F, 0.9999623426F,
  0.9999653483F, 0.9999681708F, 0.9999708175F, 0.9999732959F,
  0.9999756132F, 0.9999777765F, 0.9999797928F, 0.9999816688F,
  0.9999834113F, 0.9999850266F, 0.9999865211F, 0.9999879009F,
  0.9999891721F, 0.9999903405F, 0.9999914118F, 0.9999923914F,
  0.9999932849F, 0.9999940972F, 0.9999948336F, 0.9999954989F,
  0.9999960978F, 0.9999966349F, 0.9999971146F, 0.9999975411F,
  0.9999979185F, 0.9999982507F, 0.9999985414F, 0.9999987944F,
  0.9999990129F, 0.9999992003F, 0.9999993596F, 0.9999994939F,
  0.9999996059F, 0.9999996981F, 0.9999997732F, 0.9999998333F,
  0.9999998805F, 0.9999999170F, 0.9999999444F, 0.9999999643F,
  0.9999999784F, 0.9999999878F, 0.9999999937F, 0.9999999972F,
  0.9999999990F, 0.9999999997F, 1.0000000000F, 1.0000000000F,
};

static const float vwin4096[2048] = {
  0.0000002310F, 0.0000020791F, 0.0000057754F, 0.0000113197F,
  0.0000187121F, 0.0000279526F, 0.0000390412F, 0.0000519777F,
  0.0000667623F, 0.0000833949F, 0.0001018753F, 0.0001222036F,
  0.0001443798F, 0.0001684037F, 0.0001942754F, 0.0002219947F,
  0.0002515616F, 0.0002829761F, 0.0003162380F, 0.0003513472F,
  0.0003883038F, 0.0004271076F, 0.0004677584F, 0.0005102563F,
  0.0005546011F, 0.0006007928F, 0.0006488311F, 0.0006987160F,
  0.0007504474F, 0.0008040251F, 0.0008594490F, 0.0009167191F,
  0.0009758351F, 0.0010367969F, 0.0010996044F, 0.0011642574F,
  0.0012307558F, 0.0012990994F, 0.0013692880F, 0.0014413216F,
  0.0015151998F, 0.0015909226F, 0.0016684898F, 0.0017479011F,
  0.0018291565F, 0.0019122556F, 0.0019971983F, 0.0020839845F,
  0.0021726138F, 0.0022630861F, 0.0023554012F, 0.0024495588F,
  0.0025455588F, 0.0026434008F, 0.0027430847F, 0.0028446103F,
  0.0029479772F, 0.0030531853F, 0.0031602342F, 0.0032691238F,
  0.0033798538F, 0.0034924239F, 0.0036068338F, 0.0037230833F,
  0.0038411721F, 0.0039610999F, 0.0040828664F, 0.0042064714F,
  0.0043319145F, 0.0044591954F, 0.0045883139F, 0.0047192696F,
  0.0048520622F, 0.0049866914F, 0.0051231569F, 0.0052614583F,
  0.0054015953F, 0.0055435676F, 0.0056873748F, 0.0058330166F,
  0.0059804926F, 0.0061298026F, 0.0062809460F, 0.0064339226F,
  0.0065887320F, 0.0067453738F, 0.0069038476F, 0.0070641531F,
  0.0072262899F, 0.0073902575F, 0.0075560556F, 0.0077236838F,
  0.0078931417F, 0.0080644288F, 0.0082375447F, 0.0084124891F,
  0.0085892615F, 0.0087678614F, 0.0089482885F, 0.0091305422F,
  0.0093146223F, 0.0095005281F, 0.0096882592F, 0.0098778153F,
  0.0100691958F, 0.0102624002F, 0.0104574281F, 0.0106542791F,
  0.0108529525F, 0.0110534480F, 0.0112557651F, 0.0114599032F,
  0.0116658618F, 0.0118736405F, 0.0120832387F, 0.0122946560F,
  0.0125078917F, 0.0127229454F, 0.0129398166F, 0.0131585046F,
  0.0133790090F, 0.0136013292F, 0.0138254647F, 0.0140514149F,
  0.0142791792F, 0.0145087572F, 0.0147401481F, 0.0149733515F,
  0.0152083667F, 0.0154451932F, 0.0156838304F, 0.0159242777F,
  0.0161665345F, 0.0164106001F, 0.0166564741F, 0.0169041557F,
  0.0171536443F, 0.0174049393F, 0.0176580401F, 0.0179129461F,
  0.0181696565F, 0.0184281708F, 0.0186884883F, 0.0189506084F,
  0.0192145303F, 0.0194802535F, 0.0197477772F, 0.0200171008F,
  0.0202882236F, 0.0205611449F, 0.0208358639F, 0.0211123801F,
  0.0213906927F, 0.0216708011F, 0.0219527043F, 0.0222364019F,
  0.0225218930F, 0.0228091769F, 0.0230982529F, 0.0233891203F,
  0.0236817782F, 0.0239762259F, 0.0242724628F, 0.0245704880F,
  0.0248703007F, 0.0251719002F, 0.0254752858F, 0.0257804565F,
  0.0260874117F, 0.0263961506F, 0.0267066722F, 0.0270189760F,
  0.0273330609F, 0.0276489263F, 0.0279665712F, 0.0282859949F,
  0.0286071966F, 0.0289301753F, 0.0292549303F, 0.0295814607F,
  0.0299097656F, 0.0302398442F, 0.0305716957F, 0.0309053191F,
  0.0312407135F, 0.0315778782F, 0.0319168122F, 0.0322575145F,
  0.0325999844F, 0.0329442209F, 0.0332902231F, 0.0336379900F,
  0.0339875208F, 0.0343388146F, 0.0346918703F, 0.0350466871F,
  0.0354032640F, 0.0357616000F, 0.0361216943F, 0.0364835458F,
  0.0368471535F, 0.0372125166F, 0.0375796339F, 0.0379485046F,
  0.0383191276F, 0.0386915020F, 0.0390656267F, 0.0394415008F,
  0.0398191231F, 0.0401984927F, 0.0405796086F, 0.0409624698F,
  0.0413470751F, 0.0417334235F, 0.0421215141F, 0.0425113457F,
  0.0429029172F, 0.0432962277F, 0.0436912760F, 0.0440880610F,
  0.0444865817F, 0.0448868370F, 0.0452888257F, 0.0456925468F,
  0.0460979992F, 0.0465051816F, 0.0469140931F, 0.0473247325F,
  0.0477370986F, 0.0481511902F, 0.0485670064F, 0.0489845458F,
  0.0494038074F, 0.0498247899F, 0.0502474922F, 0.0506719131F,
  0.0510980514F, 0.0515259060F, 0.0519554756F, 0.0523867590F,
  0.0528197550F, 0.0532544624F, 0.0536908800F, 0.0541290066F,
  0.0545688408F, 0.0550103815F, 0.0554536274F, 0.0558985772F,
  0.0563452297F, 0.0567935837F, 0.0572436377F, 0.0576953907F,
  0.0581488412F, 0.0586039880F, 0.0590608297F, 0.0595193651F,
  0.0599795929F, 0.0604415117F, 0.0609051202F, 0.0613704170F,
  0.0618374009F, 0.0623060704F, 0.0627764243F, 0.0632484611F,
  0.0637221795F, 0.0641975781F, 0.0646746555F, 0.0651534104F,
  0.0656338413F, 0.0661159469F, 0.0665997257F, 0.0670851763F,
  0.0675722973F, 0.0680610873F, 0.0685515448F, 0.0690436684F,
  0.0695374567F, 0.0700329081F, 0.0705300213F, 0.0710287947F,
  0.0715292269F, 0.0720313163F, 0.0725350616F, 0.0730404612F,
  0.0735475136F, 0.0740562172F, 0.0745665707F, 0.0750785723F,
  0.0755922207F, 0.0761075143F, 0.0766244515F, 0.0771430307F,
  0.0776632505F, 0.0781851092F, 0.0787086052F, 0.0792337371F,
  0.0797605032F, 0.0802889018F, 0.0808189315F, 0.0813505905F,
  0.0818838773F, 0.0824187903F, 0.0829553277F, 0.0834934881F,
  0.0840332697F, 0.0845746708F, 0.0851176899F, 0.0856623252F,
  0.0862085751F, 0.0867564379F, 0.0873059119F, 0.0878569954F,
  0.0884096867F, 0.0889639840F, 0.0895198858F, 0.0900773902F,
  0.0906364955F, 0.0911972000F, 0.0917595019F, 0.0923233995F,
  0.0928888909F, 0.0934559745F, 0.0940246485F, 0.0945949110F,
  0.0951667604F, 0.0957401946F, 0.0963152121F, 0.0968918109F,
  0.0974699893F, 0.0980497454F, 0.0986310773F, 0.0992139832F,
  0.0997984614F, 0.1003845098F, 0.1009721267F, 0.1015613101F,
  0.1021520582F, 0.1027443692F, 0.1033382410F, 0.1039336718F,
  0.1045306597F, 0.1051292027F, 0.1057292990F, 0.1063309466F,
  0.1069341435F, 0.1075388878F, 0.1081451776F, 0.1087530108F,
  0.1093623856F, 0.1099732998F, 0.1105857516F, 0.1111997389F,
  0.1118152597F, 0.1124323121F, 0.1130508939F, 0.1136710032F,
  0.1142926379F, 0.1149157960F, 0.1155404755F, 0.1161666742F,
  0.1167943901F, 0.1174236211F, 0.1180543652F, 0.1186866202F,
  0.1193203841F, 0.1199556548F, 0.1205924300F, 0.1212307078F,
  0.1218704860F, 0.1225117624F, 0.1231545349F, 0.1237988013F,
  0.1244445596F, 0.1250918074F, 0.1257405427F, 0.1263907632F,
  0.1270424667F, 0.1276956512F, 0.1283503142F, 0.1290064537F,
  0.1296640674F, 0.1303231530F, 0.1309837084F, 0.1316457312F,
  0.1323092193F, 0.1329741703F, 0.1336405820F, 0.1343084520F,
  0.1349777782F, 0.1356485582F, 0.1363207897F, 0.1369944704F,
  0.1376695979F, 0.1383461700F, 0.1390241842F, 0.1397036384F,
  0.1403845300F, 0.1410668567F, 0.1417506162F, 0.1424358061F,
  0.1431224240F, 0.1438104674F, 0.1444999341F, 0.1451908216F,
  0.1458831274F, 0.1465768492F, 0.1472719844F, 0.1479685308F,
  0.1486664857F, 0.1493658468F, 0.1500666115F, 0.1507687775F,
  0.1514723422F, 0.1521773031F, 0.1528836577F, 0.1535914035F,
  0.1543005380F, 0.1550110587F, 0.1557229631F, 0.1564362485F,
  0.1571509124F, 0.1578669524F, 0.1585843657F, 0.1593031499F,
  0.1600233024F, 0.1607448205F, 0.1614677017F, 0.1621919433F,
  0.1629175428F, 0.1636444975F, 0.1643728047F, 0.1651024619F,
  0.1658334665F, 0.1665658156F, 0.1672995067F, 0.1680345371F,
  0.1687709041F, 0.1695086050F, 0.1702476372F, 0.1709879978F,
  0.1717296843F, 0.1724726938F, 0.1732170237F, 0.1739626711F,
  0.1747096335F, 0.1754579079F, 0.1762074916F, 0.1769583819F,
  0.1777105760F, 0.1784640710F, 0.1792188642F, 0.1799749529F,
  0.1807323340F, 0.1814910049F, 0.1822509628F, 0.1830122046F,
  0.1837747277F, 0.1845385292F, 0.1853036062F, 0.1860699558F,
  0.1868375751F, 0.1876064613F, 0.1883766114F, 0.1891480226F,
  0.1899206919F, 0.1906946164F, 0.1914697932F, 0.1922462194F,
  0.1930238919F, 0.1938028079F, 0.1945829643F, 0.1953643583F,
  0.1961469868F, 0.1969308468F, 0.1977159353F, 0.1985022494F,
  0.1992897859F, 0.2000785420F, 0.2008685145F, 0.2016597005F,
  0.2024520968F, 0.2032457005F, 0.2040405084F, 0.2048365175F,
  0.2056337247F, 0.2064321269F, 0.2072317211F, 0.2080325041F,
  0.2088344727F, 0.2096376240F, 0.2104419547F, 0.2112474618F,
  0.2120541420F, 0.2128619923F, 0.2136710094F, 0.2144811902F,
  0.2152925315F, 0.2161050301F, 0.2169186829F, 0.2177334866F,
  0.2185494381F, 0.2193665340F, 0.2201847712F, 0.2210041465F,
  0.2218246565F, 0.2226462981F, 0.2234690680F, 0.2242929629F,
  0.2251179796F, 0.2259441147F, 0.2267713650F, 0.2275997272F,
  0.2284291979F, 0.2292597739F, 0.2300914518F, 0.2309242283F,
  0.2317581001F, 0.2325930638F, 0.2334291160F, 0.2342662534F,
  0.2351044727F, 0.2359437703F, 0.2367841431F, 0.2376255875F,
  0.2384681001F, 0.2393116776F, 0.2401563165F, 0.2410020134F,
  0.2418487649F, 0.2426965675F, 0.2435454178F, 0.2443953122F,
  0.2452462474F, 0.2460982199F, 0.2469512262F, 0.2478052628F,
  0.2486603262F, 0.2495164129F, 0.2503735194F, 0.2512316421F,
  0.2520907776F, 0.2529509222F, 0.2538120726F, 0.2546742250F,
  0.2555373760F, 0.2564015219F, 0.2572666593F, 0.2581327845F,
  0.2589998939F, 0.2598679840F, 0.2607370510F, 0.2616070916F,
  0.2624781019F, 0.2633500783F, 0.2642230173F, 0.2650969152F,
  0.2659717684F, 0.2668475731F, 0.2677243257F, 0.2686020226F,
  0.2694806601F, 0.2703602344F, 0.2712407419F, 0.2721221789F,
  0.2730045417F, 0.2738878265F, 0.2747720297F, 0.2756571474F,
  0.2765431760F, 0.2774301117F, 0.2783179508F, 0.2792066895F,
  0.2800963240F, 0.2809868505F, 0.2818782654F, 0.2827705647F,
  0.2836637447F, 0.2845578016F, 0.2854527315F, 0.2863485307F,
  0.2872451953F, 0.2881427215F, 0.2890411055F, 0.2899403433F,
  0.2908404312F, 0.2917413654F, 0.2926431418F, 0.2935457567F,
  0.2944492061F, 0.2953534863F, 0.2962585932F, 0.2971645230F,
  0.2980712717F, 0.2989788356F, 0.2998872105F, 0.3007963927F,
  0.3017063781F, 0.3026171629F, 0.3035287430F, 0.3044411145F,
  0.3053542736F, 0.3062682161F, 0.3071829381F, 0.3080984356F,
  0.3090147047F, 0.3099317413F, 0.3108495414F, 0.3117681011F,
  0.3126874163F, 0.3136074830F, 0.3145282972F, 0.3154498548F,
  0.3163721517F, 0.3172951841F, 0.3182189477F, 0.3191434385F,
  0.3200686525F, 0.3209945856F, 0.3219212336F, 0.3228485927F,
  0.3237766585F, 0.3247054271F, 0.3256348943F, 0.3265650560F,
  0.3274959081F, 0.3284274465F, 0.3293596671F, 0.3302925657F,
  0.3312261382F, 0.3321603804F, 0.3330952882F, 0.3340308574F,
  0.3349670838F, 0.3359039634F, 0.3368414919F, 0.3377796651F,
  0.3387184789F, 0.3396579290F, 0.3405980113F, 0.3415387216F,
  0.3424800556F, 0.3434220091F, 0.3443645779F, 0.3453077578F,
  0.3462515446F, 0.3471959340F, 0.3481409217F, 0.3490865036F,
  0.3500326754F, 0.3509794328F, 0.3519267715F, 0.3528746873F,
  0.3538231759F, 0.3547722330F, 0.3557218544F, 0.3566720357F,
  0.3576227727F, 0.3585740610F, 0.3595258964F, 0.3604782745F,
  0.3614311910F, 0.3623846417F, 0.3633386221F, 0.3642931280F,
  0.3652481549F, 0.3662036987F, 0.3671597548F, 0.3681163191F,
  0.3690733870F, 0.3700309544F, 0.3709890167F, 0.3719475696F,
  0.3729066089F, 0.3738661299F, 0.3748261285F, 0.3757866002F,
  0.3767475406F, 0.3777089453F, 0.3786708100F, 0.3796331302F,
  0.3805959014F, 0.3815591194F, 0.3825227796F, 0.3834868777F,
  0.3844514093F, 0.3854163698F, 0.3863817549F, 0.3873475601F,
  0.3883137810F, 0.3892804131F, 0.3902474521F, 0.3912148933F,
  0.3921827325F, 0.3931509650F, 0.3941195865F, 0.3950885925F,
  0.3960579785F, 0.3970277400F, 0.3979978725F, 0.3989683716F,
  0.3999392328F, 0.4009104516F, 0.4018820234F, 0.4028539438F,
  0.4038262084F, 0.4047988125F, 0.4057717516F, 0.4067450214F,
  0.4077186172F, 0.4086925345F, 0.4096667688F, 0.4106413155F,
  0.4116161703F, 0.4125913284F, 0.4135667854F, 0.4145425368F,
  0.4155185780F, 0.4164949044F, 0.4174715116F, 0.4184483949F,
  0.4194255498F, 0.4204029718F, 0.4213806563F, 0.4223585987F,
  0.4233367946F, 0.4243152392F, 0.4252939281F, 0.4262728566F,
  0.4272520202F, 0.4282314144F, 0.4292110345F, 0.4301908760F,
  0.4311709343F, 0.4321512047F, 0.4331316828F, 0.4341123639F,
  0.4350932435F, 0.4360743168F, 0.4370555794F, 0.4380370267F,
  0.4390186540F, 0.4400004567F, 0.4409824303F, 0.4419645701F,
  0.4429468716F, 0.4439293300F, 0.4449119409F, 0.4458946996F,
  0.4468776014F, 0.4478606418F, 0.4488438162F, 0.4498271199F,
  0.4508105483F, 0.4517940967F, 0.4527777607F, 0.4537615355F,
  0.4547454165F, 0.4557293991F, 0.4567134786F, 0.4576976505F,
  0.4586819101F, 0.4596662527F, 0.4606506738F, 0.4616351687F,
  0.4626197328F, 0.4636043614F, 0.4645890499F, 0.4655737936F,
  0.4665585880F, 0.4675434284F, 0.4685283101F, 0.4695132286F,
  0.4704981791F, 0.4714831570F, 0.4724681577F, 0.4734531766F,
  0.4744382089F, 0.4754232501F, 0.4764082956F, 0.4773933406F,
  0.4783783806F, 0.4793634108F, 0.4803484267F, 0.4813334237F,
  0.4823183969F, 0.4833033419F, 0.4842882540F, 0.4852731285F,
  0.4862579608F, 0.4872427462F, 0.4882274802F, 0.4892121580F,
  0.4901967751F, 0.4911813267F, 0.4921658083F, 0.4931502151F,
  0.4941345427F, 0.4951187863F, 0.4961029412F, 0.4970870029F,
  0.4980709667F, 0.4990548280F, 0.5000385822F, 0.5010222245F,
  0.5020057505F, 0.5029891553F, 0.5039724345F, 0.5049555834F,
  0.5059385973F, 0.5069214716F, 0.5079042018F, 0.5088867831F,
  0.5098692110F, 0.5108514808F, 0.5118335879F, 0.5128155277F,
  0.5137972956F, 0.5147788869F, 0.5157602971F, 0.5167415215F,
  0.5177225555F, 0.5187033945F, 0.5196840339F, 0.5206644692F,
  0.5216446956F, 0.5226247086F, 0.5236045035F, 0.5245840759F,
  0.5255634211F, 0.5265425344F, 0.5275214114F, 0.5285000474F,
  0.5294784378F, 0.5304565781F, 0.5314344637F, 0.5324120899F,
  0.5333894522F, 0.5343665461F, 0.5353433670F, 0.5363199102F,
  0.5372961713F, 0.5382721457F, 0.5392478287F, 0.5402232159F,
  0.5411983027F, 0.5421730845F, 0.5431475569F, 0.5441217151F,
  0.5450955548F, 0.5460690714F, 0.5470422602F, 0.5480151169F,
  0.5489876368F, 0.5499598155F, 0.5509316484F, 0.5519031310F,
  0.5528742587F, 0.5538450271F, 0.5548154317F, 0.5557854680F,
  0.5567551314F, 0.5577244174F, 0.5586933216F, 0.5596618395F,
  0.5606299665F, 0.5615976983F, 0.5625650302F, 0.5635319580F,
  0.5644984770F, 0.5654645828F, 0.5664302709F, 0.5673955370F,
  0.5683603765F, 0.5693247850F, 0.5702887580F, 0.5712522912F,
  0.5722153800F, 0.5731780200F, 0.5741402069F, 0.5751019362F,
  0.5760632034F, 0.5770240042F, 0.5779843341F, 0.5789441889F,
  0.5799035639F, 0.5808624549F, 0.5818208575F, 0.5827787673F,
  0.5837361800F, 0.5846930910F, 0.5856494961F, 0.5866053910F,
  0.5875607712F, 0.5885156324F, 0.5894699703F, 0.5904237804F,
  0.5913770586F, 0.5923298004F, 0.5932820016F, 0.5942336578F,
  0.5951847646F, 0.5961353179F, 0.5970853132F, 0.5980347464F,
  0.5989836131F, 0.5999319090F, 0.6008796298F, 0.6018267713F,
  0.6027733292F, 0.6037192993F, 0.6046646773F, 0.6056094589F,
  0.6065536400F, 0.6074972162F, 0.6084401833F, 0.6093825372F,
  0.6103242736F, 0.6112653884F, 0.6122058772F, 0.6131457359F,
  0.6140849604F, 0.6150235464F, 0.6159614897F, 0.6168987862F,
  0.6178354318F, 0.6187714223F, 0.6197067535F, 0.6206414213F,
  0.6215754215F, 0.6225087501F, 0.6234414028F, 0.6243733757F,
  0.6253046646F, 0.6262352654F, 0.6271651739F, 0.6280943862F,
  0.6290228982F, 0.6299507057F, 0.6308778048F, 0.6318041913F,
  0.6327298612F, 0.6336548105F, 0.6345790352F, 0.6355025312F,
  0.6364252945F, 0.6373473211F, 0.6382686070F, 0.6391891483F,
  0.6401089409F, 0.6410279808F, 0.6419462642F, 0.6428637869F,
  0.6437805452F, 0.6446965350F, 0.6456117524F, 0.6465261935F,
  0.6474398544F, 0.6483527311F, 0.6492648197F, 0.6501761165F,
  0.6510866174F, 0.6519963186F, 0.6529052162F, 0.6538133064F,
  0.6547205854F, 0.6556270492F, 0.6565326941F, 0.6574375162F,
  0.6583415117F, 0.6592446769F, 0.6601470079F, 0.6610485009F,
  0.6619491521F, 0.6628489578F, 0.6637479143F, 0.6646460177F,
  0.6655432643F, 0.6664396505F, 0.6673351724F, 0.6682298264F,
  0.6691236087F, 0.6700165157F, 0.6709085436F, 0.6717996889F,
  0.6726899478F, 0.6735793167F, 0.6744677918F, 0.6753553697F,
  0.6762420466F, 0.6771278190F, 0.6780126832F, 0.6788966357F,
  0.6797796728F, 0.6806617909F, 0.6815429866F, 0.6824232562F,
  0.6833025961F, 0.6841810030F, 0.6850584731F, 0.6859350031F,
  0.6868105894F, 0.6876852284F, 0.6885589168F, 0.6894316510F,
  0.6903034275F, 0.6911742430F, 0.6920440939F, 0.6929129769F,
  0.6937808884F, 0.6946478251F, 0.6955137837F, 0.6963787606F,
  0.6972427525F, 0.6981057560F, 0.6989677678F, 0.6998287845F,
  0.7006888028F, 0.7015478194F, 0.7024058309F, 0.7032628340F,
  0.7041188254F, 0.7049738019F, 0.7058277601F, 0.7066806969F,
  0.7075326089F, 0.7083834929F, 0.7092333457F, 0.7100821640F,
  0.7109299447F, 0.7117766846F, 0.7126223804F, 0.7134670291F,
  0.7143106273F, 0.7151531721F, 0.7159946602F, 0.7168350885F,
  0.7176744539F, 0.7185127534F, 0.7193499837F, 0.7201861418F,
  0.7210212247F, 0.7218552293F, 0.7226881526F, 0.7235199914F,
  0.7243507428F, 0.7251804039F, 0.7260089715F, 0.7268364426F,
  0.7276628144F, 0.7284880839F, 0.7293122481F, 0.7301353040F,
  0.7309572487F, 0.7317780794F, 0.7325977930F, 0.7334163868F,
  0.7342338579F, 0.7350502033F, 0.7358654202F, 0.7366795059F,
  0.7374924573F, 0.7383042718F, 0.7391149465F, 0.7399244787F,
  0.7407328655F, 0.7415401041F, 0.7423461920F, 0.7431511261F,
  0.7439549040F, 0.7447575227F, 0.7455589797F, 0.7463592723F,
  0.7471583976F, 0.7479563532F, 0.7487531363F, 0.7495487443F,
  0.7503431745F, 0.7511364244F, 0.7519284913F, 0.7527193726F,
  0.7535090658F, 0.7542975683F, 0.7550848776F, 0.7558709910F,
  0.7566559062F, 0.7574396205F, 0.7582221314F, 0.7590034366F,
  0.7597835334F, 0.7605624194F, 0.7613400923F, 0.7621165495F,
  0.7628917886F, 0.7636658072F, 0.7644386030F, 0.7652101735F,
  0.7659805164F, 0.7667496292F, 0.7675175098F, 0.7682841556F,
  0.7690495645F, 0.7698137341F, 0.7705766622F, 0.7713383463F,
  0.7720987844F, 0.7728579741F, 0.7736159132F, 0.7743725994F,
  0.7751280306F, 0.7758822046F, 0.7766351192F, 0.7773867722F,
  0.7781371614F, 0.7788862848F, 0.7796341401F, 0.7803807253F,
  0.7811260383F, 0.7818700769F, 0.7826128392F, 0.7833543230F,
  0.7840945263F, 0.7848334471F, 0.7855710833F, 0.7863074330F,
  0.7870424941F, 0.7877762647F, 0.7885087428F, 0.7892399264F,
  0.7899698137F, 0.7906984026F, 0.7914256914F, 0.7921516780F,
  0.7928763607F, 0.7935997375F, 0.7943218065F, 0.7950425661F,
  0.7957620142F, 0.7964801492F, 0.7971969692F, 0.7979124724F,
  0.7986266570F, 0.7993395214F, 0.8000510638F, 0.8007612823F,
  0.8014701754F, 0.8021777413F, 0.8028839784F, 0.8035888849F,
  0.8042924592F, 0.8049946997F, 0.8056956048F, 0.8063951727F,
  0.8070934020F, 0.8077902910F, 0.8084858381F, 0.8091800419F,
  0.8098729007F, 0.8105644130F, 0.8112545774F, 0.8119433922F,
  0.8126308561F, 0.8133169676F, 0.8140017251F, 0.8146851272F,
  0.8153671726F, 0.8160478598F, 0.8167271874F, 0.8174051539F,
  0.8180817582F, 0.8187569986F, 0.8194308741F, 0.8201033831F,
  0.8207745244F, 0.8214442966F, 0.8221126986F, 0.8227797290F,
  0.8234453865F, 0.8241096700F, 0.8247725781F, 0.8254341097F,
  0.8260942636F, 0.8267530385F, 0.8274104334F, 0.8280664470F,
  0.8287210782F, 0.8293743259F, 0.8300261889F, 0.8306766662F,
  0.8313257566F, 0.8319734591F, 0.8326197727F, 0.8332646963F,
  0.8339082288F, 0.8345503692F, 0.8351911167F, 0.8358304700F,
  0.8364684284F, 0.8371049907F, 0.8377401562F, 0.8383739238F,
  0.8390062927F, 0.8396372618F, 0.8402668305F, 0.8408949977F,
  0.8415217626F, 0.8421471245F, 0.8427710823F, 0.8433936354F,
  0.8440147830F, 0.8446345242F, 0.8452528582F, 0.8458697844F,
  0.8464853020F, 0.8470994102F, 0.8477121084F, 0.8483233958F,
  0.8489332718F, 0.8495417356F, 0.8501487866F, 0.8507544243F,
  0.8513586479F, 0.8519614568F, 0.8525628505F, 0.8531628283F,
  0.8537613897F, 0.8543585341F, 0.8549542611F, 0.8555485699F,
  0.8561414603F, 0.8567329315F, 0.8573229832F, 0.8579116149F,
  0.8584988262F, 0.8590846165F, 0.8596689855F, 0.8602519327F,
  0.8608334577F, 0.8614135603F, 0.8619922399F, 0.8625694962F,
  0.8631453289F, 0.8637197377F, 0.8642927222F, 0.8648642821F,
  0.8654344172F, 0.8660031272F, 0.8665704118F, 0.8671362708F,
  0.8677007039F, 0.8682637109F, 0.8688252917F, 0.8693854460F,
  0.8699441737F, 0.8705014745F, 0.8710573485F, 0.8716117953F,
  0.8721648150F, 0.8727164073F, 0.8732665723F, 0.8738153098F,
  0.8743626197F, 0.8749085021F, 0.8754529569F, 0.8759959840F,
  0.8765375835F, 0.8770777553F, 0.8776164996F, 0.8781538162F,
  0.8786897054F, 0.8792241670F, 0.8797572013F, 0.8802888082F,
  0.8808189880F, 0.8813477407F, 0.8818750664F, 0.8824009653F,
  0.8829254375F, 0.8834484833F, 0.8839701028F, 0.8844902961F,
  0.8850090636F, 0.8855264054F, 0.8860423218F, 0.8865568131F,
  0.8870698794F, 0.8875815212F, 0.8880917386F, 0.8886005319F,
  0.8891079016F, 0.8896138479F, 0.8901183712F, 0.8906214719F,
  0.8911231503F, 0.8916234067F, 0.8921222417F, 0.8926196556F,
  0.8931156489F, 0.8936102219F, 0.8941033752F, 0.8945951092F,
  0.8950854244F, 0.8955743212F, 0.8960618003F, 0.8965478621F,
  0.8970325071F, 0.8975157359F, 0.8979975490F, 0.8984779471F,
  0.8989569307F, 0.8994345004F, 0.8999106568F, 0.9003854005F,
  0.9008587323F, 0.9013306526F, 0.9018011623F, 0.9022702619F,
  0.9027379521F, 0.9032042337F, 0.9036691074F, 0.9041325739F,
  0.9045946339F, 0.9050552882F, 0.9055145376F, 0.9059723828F,
  0.9064288246F, 0.9068838638F, 0.9073375013F, 0.9077897379F,
  0.9082405743F, 0.9086900115F, 0.9091380503F, 0.9095846917F,
  0.9100299364F, 0.9104737854F, 0.9109162397F, 0.9113573001F,
  0.9117969675F, 0.9122352430F, 0.9126721275F, 0.9131076219F,
  0.9135417273F, 0.9139744447F, 0.9144057750F, 0.9148357194F,
  0.9152642787F, 0.9156914542F, 0.9161172468F, 0.9165416576F,
  0.9169646877F, 0.9173863382F, 0.9178066102F, 0.9182255048F,
  0.9186430232F, 0.9190591665F, 0.9194739359F, 0.9198873324F,
  0.9202993574F, 0.9207100120F, 0.9211192973F, 0.9215272147F,
  0.9219337653F, 0.9223389504F, 0.9227427713F, 0.9231452290F,
  0.9235463251F, 0.9239460607F, 0.9243444371F, 0.9247414557F,
  0.9251371177F, 0.9255314245F, 0.9259243774F, 0.9263159778F,
  0.9267062270F, 0.9270951264F, 0.9274826774F, 0.9278688814F,
  0.9282537398F, 0.9286372540F, 0.9290194254F, 0.9294002555F,
  0.9297797458F, 0.9301578976F, 0.9305347125F, 0.9309101919F,
  0.9312843373F, 0.9316571503F, 0.9320286323F, 0.9323987849F,
  0.9327676097F, 0.9331351080F, 0.9335012816F, 0.9338661320F,
  0.9342296607F, 0.9345918694F, 0.9349527596F, 0.9353123330F,
  0.9356705911F, 0.9360275357F, 0.9363831683F, 0.9367374905F,
  0.9370905042F, 0.9374422108F, 0.9377926122F, 0.9381417099F,
  0.9384895057F, 0.9388360014F, 0.9391811985F, 0.9395250989F,
  0.9398677043F, 0.9402090165F, 0.9405490371F, 0.9408877680F,
  0.9412252110F, 0.9415613678F, 0.9418962402F, 0.9422298301F,
  0.9425621392F, 0.9428931695F, 0.9432229226F, 0.9435514005F,
  0.9438786050F, 0.9442045381F, 0.9445292014F, 0.9448525971F,
  0.9451747268F, 0.9454955926F, 0.9458151963F, 0.9461335399F,
  0.9464506253F, 0.9467664545F, 0.9470810293F, 0.9473943517F,
  0.9477064238F, 0.9480172474F, 0.9483268246F, 0.9486351573F,
  0.9489422475F, 0.9492480973F, 0.9495527087F, 0.9498560837F,
  0.9501582243F, 0.9504591325F, 0.9507588105F, 0.9510572603F,
  0.9513544839F, 0.9516504834F, 0.9519452609F, 0.9522388186F,
  0.9525311584F, 0.9528222826F, 0.9531121932F, 0.9534008923F,
  0.9536883821F, 0.9539746647F, 0.9542597424F, 0.9545436171F,
  0.9548262912F, 0.9551077667F, 0.9553880459F, 0.9556671309F,
  0.9559450239F, 0.9562217272F, 0.9564972429F, 0.9567715733F,
  0.9570447206F, 0.9573166871F, 0.9575874749F, 0.9578570863F,
  0.9581255236F, 0.9583927890F, 0.9586588849F, 0.9589238134F,
  0.9591875769F, 0.9594501777F, 0.9597116180F, 0.9599719003F,
  0.9602310267F, 0.9604889995F, 0.9607458213F, 0.9610014942F,
  0.9612560206F, 0.9615094028F, 0.9617616433F, 0.9620127443F,
  0.9622627083F, 0.9625115376F, 0.9627592345F, 0.9630058016F,
  0.9632512411F, 0.9634955555F, 0.9637387471F, 0.9639808185F,
  0.9642217720F, 0.9644616100F, 0.9647003349F, 0.9649379493F,
  0.9651744556F, 0.9654098561F, 0.9656441534F, 0.9658773499F,
  0.9661094480F, 0.9663404504F, 0.9665703593F, 0.9667991774F,
  0.9670269071F, 0.9672535509F, 0.9674791114F, 0.9677035909F,
  0.9679269921F, 0.9681493174F, 0.9683705694F, 0.9685907506F,
  0.9688098636F, 0.9690279108F, 0.9692448948F, 0.9694608182F,
  0.9696756836F, 0.9698894934F, 0.9701022503F, 0.9703139569F,
  0.9705246156F, 0.9707342291F, 0.9709428000F, 0.9711503309F,
  0.9713568243F, 0.9715622829F, 0.9717667093F, 0.9719701060F,
  0.9721724757F, 0.9723738210F, 0.9725741446F, 0.9727734490F,
  0.9729717369F, 0.9731690109F, 0.9733652737F, 0.9735605279F,
  0.9737547762F, 0.9739480212F, 0.9741402656F, 0.9743315120F,
  0.9745217631F, 0.9747110216F, 0.9748992901F, 0.9750865714F,
  0.9752728681F, 0.9754581829F, 0.9756425184F, 0.9758258775F,
  0.9760082627F, 0.9761896768F, 0.9763701224F, 0.9765496024F,
  0.9767281193F, 0.9769056760F, 0.9770822751F, 0.9772579193F,
  0.9774326114F, 0.9776063542F, 0.9777791502F, 0.9779510023F,
  0.9781219133F, 0.9782918858F, 0.9784609226F, 0.9786290264F,
  0.9787962000F, 0.9789624461F, 0.9791277676F, 0.9792921671F,
  0.9794556474F, 0.9796182113F, 0.9797798615F, 0.9799406009F,
  0.9801004321F, 0.9802593580F, 0.9804173813F, 0.9805745049F,
  0.9807307314F, 0.9808860637F, 0.9810405046F, 0.9811940568F,
  0.9813467232F, 0.9814985065F, 0.9816494095F, 0.9817994351F,
  0.9819485860F, 0.9820968650F, 0.9822442750F, 0.9823908186F,
  0.9825364988F, 0.9826813184F, 0.9828252801F, 0.9829683868F,
  0.9831106413F, 0.9832520463F, 0.9833926048F, 0.9835323195F,
  0.9836711932F, 0.9838092288F, 0.9839464291F, 0.9840827969F,
  0.9842183351F, 0.9843530464F, 0.9844869337F, 0.9846199998F,
  0.9847522475F, 0.9848836798F, 0.9850142993F, 0.9851441090F,
  0.9852731117F, 0.9854013101F, 0.9855287073F, 0.9856553058F,
  0.9857811087F, 0.9859061188F, 0.9860303388F, 0.9861537717F,
  0.9862764202F, 0.9863982872F, 0.9865193756F, 0.9866396882F,
  0.9867592277F, 0.9868779972F, 0.9869959993F, 0.9871132370F,
  0.9872297131F, 0.9873454304F, 0.9874603918F, 0.9875746001F,
  0.9876880581F, 0.9878007688F, 0.9879127348F, 0.9880239592F,
  0.9881344447F, 0.9882441941F, 0.9883532104F, 0.9884614962F,
  0.9885690546F, 0.9886758883F, 0.9887820001F, 0.9888873930F,
  0.9889920697F, 0.9890960331F, 0.9891992859F, 0.9893018312F,
  0.9894036716F, 0.9895048100F, 0.9896052493F, 0.9897049923F,
  0.9898040418F, 0.9899024006F, 0.9900000717F, 0.9900970577F,
  0.9901933616F, 0.9902889862F, 0.9903839343F, 0.9904782087F,
  0.9905718122F, 0.9906647477F, 0.9907570180F, 0.9908486259F,
  0.9909395742F, 0.9910298658F, 0.9911195034F, 0.9912084899F,
  0.9912968281F, 0.9913845208F, 0.9914715708F, 0.9915579810F,
  0.9916437540F, 0.9917288928F, 0.9918134001F, 0.9918972788F,
  0.9919805316F, 0.9920631613F, 0.9921451707F, 0.9922265626F,
  0.9923073399F, 0.9923875052F, 0.9924670615F, 0.9925460114F,
  0.9926243577F, 0.9927021033F, 0.9927792508F, 0.9928558032F,
  0.9929317631F, 0.9930071333F, 0.9930819167F, 0.9931561158F,
  0.9932297337F, 0.9933027728F, 0.9933752362F, 0.9934471264F,
  0.9935184462F, 0.9935891985F, 0.9936593859F, 0.9937290112F,
  0.9937980771F, 0.9938665864F, 0.9939345418F, 0.9940019460F,
  0.9940688018F, 0.9941351118F, 0.9942008789F, 0.9942661057F,
  0.9943307950F, 0.9943949494F, 0.9944585717F, 0.9945216645F,
  0.9945842307F, 0.9946462728F, 0.9947077936F, 0.9947687957F,
  0.9948292820F, 0.9948892550F, 0.9949487174F, 0.9950076719F,
  0.9950661212F, 0.9951240679F, 0.9951815148F, 0.9952384645F,
  0.9952949196F, 0.9953508828F, 0.9954063568F, 0.9954613442F,
  0.9955158476F, 0.9955698697F, 0.9956234132F, 0.9956764806F,
  0.9957290746F, 0.9957811978F, 0.9958328528F, 0.9958840423F,
  0.9959347688F, 0.9959850351F, 0.9960348435F, 0.9960841969F,
  0.9961330977F, 0.9961815486F, 0.9962295521F, 0.9962771108F,
  0.9963242274F, 0.9963709043F, 0.9964171441F, 0.9964629494F,
  0.9965083228F, 0.9965532668F, 0.9965977840F, 0.9966418768F,
  0.9966855479F, 0.9967287998F, 0.9967716350F, 0.9968140559F,
  0.9968560653F, 0.9968976655F, 0.9969388591F, 0.9969796485F,
  0.9970200363F, 0.9970600250F, 0.9970996170F, 0.9971388149F,
  0.9971776211F, 0.9972160380F, 0.9972540683F, 0.9972917142F,
  0.9973289783F, 0.9973658631F, 0.9974023709F, 0.9974385042F,
  0.9974742655F, 0.9975096571F, 0.9975446816F, 0.9975793413F,
  0.9976136386F, 0.9976475759F, 0.9976811557F, 0.9977143803F,
  0.9977472521F, 0.9977797736F, 0.9978119470F, 0.9978437748F,
  0.9978752593F, 0.9979064029F, 0.9979372079F, 0.9979676768F,
  0.9979978117F, 0.9980276151F, 0.9980570893F, 0.9980862367F,
  0.9981150595F, 0.9981435600F, 0.9981717406F, 0.9981996035F,
  0.9982271511F, 0.9982543856F, 0.9982813093F, 0.9983079246F,
  0.9983342336F, 0.9983602386F, 0.9983859418F, 0.9984113456F,
  0.9984364522F, 0.9984612638F, 0.9984857825F, 0.9985100108F,
  0.9985339507F, 0.9985576044F, 0.9985809743F, 0.9986040624F,
  0.9986268710F, 0.9986494022F, 0.9986716583F, 0.9986936413F,
  0.9987153535F, 0.9987367969F, 0.9987579738F, 0.9987788864F,
  0.9987995366F, 0.9988199267F, 0.9988400587F, 0.9988599348F,
  0.9988795572F, 0.9988989278F, 0.9989180487F, 0.9989369222F,
  0.9989555501F, 0.9989739347F, 0.9989920780F, 0.9990099820F,
  0.9990276487F, 0.9990450803F, 0.9990622787F, 0.9990792460F,
  0.9990959841F, 0.9991124952F, 0.9991287812F, 0.9991448440F,
  0.9991606858F, 0.9991763084F, 0.9991917139F, 0.9992069042F,
  0.9992218813F, 0.9992366471F, 0.9992512035F, 0.9992655525F,
  0.9992796961F, 0.9992936361F, 0.9993073744F, 0.9993209131F,
  0.9993342538F, 0.9993473987F, 0.9993603494F, 0.9993731080F,
  0.9993856762F, 0.9993980559F, 0.9994102490F, 0.9994222573F,
  0.9994340827F, 0.9994457269F, 0.9994571918F, 0.9994684793F,
  0.9994795910F, 0.9994905288F, 0.9995012945F, 0.9995118898F,
  0.9995223165F, 0.9995325765F, 0.9995426713F, 0.9995526029F,
  0.9995623728F, 0.9995719829F, 0.9995814349F, 0.9995907304F,
  0.9995998712F, 0.9996088590F, 0.9996176954F, 0.9996263821F,
  0.9996349208F, 0.9996433132F, 0.9996515609F, 0.9996596656F,
  0.9996676288F, 0.9996754522F, 0.9996831375F, 0.9996906862F,
  0.9996981000F, 0.9997053804F, 0.9997125290F, 0.9997195474F,
  0.9997264371F, 0.9997331998F, 0.9997398369F, 0.9997463500F,
  0.9997527406F, 0.9997590103F, 0.9997651606F, 0.9997711930F,
  0.9997771089F, 0.9997829098F, 0.9997885973F, 0.9997941728F,
  0.9997996378F, 0.9998049936F, 0.9998102419F, 0.9998153839F,
  0.9998204211F, 0.9998253550F, 0.9998301868F, 0.9998349182F,
  0.9998395503F, 0.9998440847F, 0.9998485226F, 0.9998528654F,
  0.9998571146F, 0.9998612713F, 0.9998653370F, 0.9998693130F,
  0.9998732007F, 0.9998770012F, 0.9998807159F, 0.9998843461F,
  0.9998878931F, 0.9998913581F, 0.9998947424F, 0.9998980473F,
  0.9999012740F, 0.9999044237F, 0.9999074976F, 0.9999104971F,
  0.9999134231F, 0.9999162771F, 0.9999190601F, 0.9999217733F,
  0.9999244179F, 0.9999269950F, 0.9999295058F, 0.9999319515F,
  0.9999343332F, 0.9999366519F, 0.9999389088F, 0.9999411050F,
  0.9999432416F, 0.9999453196F, 0.9999473402F, 0.9999493044F,
  0.9999512132F, 0.9999530677F, 0.9999548690F, 0.9999566180F,
  0.9999583157F, 0.9999599633F, 0.9999615616F, 0.9999631116F,
  0.9999646144F, 0.9999660709F, 0.9999674820F, 0.9999688487F,
  0.9999701719F, 0.9999714526F, 0.9999726917F, 0.9999738900F,
  0.9999750486F, 0.9999761682F, 0.9999772497F, 0.9999782941F,
  0.9999793021F, 0.9999802747F, 0.9999812126F, 0.9999821167F,
  0.9999829878F, 0.9999838268F, 0.9999846343F, 0.9999854113F,
  0.9999861584F, 0.9999868765F, 0.9999875664F, 0.9999882287F,
  0.9999888642F, 0.9999894736F, 0.9999900577F, 0.9999906172F,
  0.9999911528F, 0.9999916651F, 0.9999921548F, 0.9999926227F,
  0.9999930693F, 0.9999934954F, 0.9999939015F, 0.9999942883F,
  0.9999946564F, 0.9999950064F, 0.9999953390F, 0.9999956547F,
  0.9999959541F, 0.9999962377F, 0.9999965062F, 0.9999967601F,
  0.9999969998F, 0.9999972260F, 0.9999974392F, 0.9999976399F,
  0.9999978285F, 0.9999980056F, 0.9999981716F, 0.9999983271F,
  0.9999984724F, 0.9999986081F, 0.9999987345F, 0.9999988521F,
  0.9999989613F, 0.9999990625F, 0.9999991562F, 0.9999992426F,
  0.9999993223F, 0.9999993954F, 0.9999994625F, 0.9999995239F,
  0.9999995798F, 0.9999996307F, 0.9999996768F, 0.9999997184F,
  0.9999997559F, 0.9999997895F, 0.9999998195F, 0.9999998462F,
  0.9999998698F, 0.9999998906F, 0.9999999088F, 0.9999999246F,
  0.9999999383F, 0.9999999500F, 0.9999999600F, 0.9999999684F,
  0.9999999754F, 0.9999999811F, 0.9999999858F, 0.9999999896F,
  0.9999999925F, 0.9999999948F, 0.9999999965F, 0.9999999978F,
  0.9999999986F, 0.9999999992F, 0.9999999996F, 0.9999999998F,
  0.9999999999F, 1.0000000000F, 1.0000000000F, 1.0000000000F,
};

static const float vwin8192[4096] = {
  0.0000000578F, 0.0000005198F, 0.0000014438F, 0.0000028299F,
  0.0000046780F, 0.0000069882F, 0.0000097604F, 0.0000129945F,
  0.0000166908F, 0.0000208490F, 0.0000254692F, 0.0000305515F,
  0.0000360958F, 0.0000421021F, 0.0000485704F, 0.0000555006F,
  0.0000628929F, 0.0000707472F, 0.0000790635F, 0.0000878417F,
  0.0000970820F, 0.0001067842F, 0.0001169483F, 0.0001275744F,
  0.0001386625F, 0.0001502126F, 0.0001622245F, 0.0001746984F,
  0.0001876343F, 0.0002010320F, 0.0002148917F, 0.0002292132F,
  0.0002439967F, 0.0002592421F, 0.0002749493F, 0.0002911184F,
  0.0003077493F, 0.0003248421F, 0.0003423967F, 0.0003604132F,
  0.0003788915F, 0.0003978316F, 0.0004172335F, 0.0004370971F,
  0.0004574226F, 0.0004782098F, 0.0004994587F, 0.0005211694F,
  0.0005433418F, 0.0005659759F, 0.0005890717F, 0.0006126292F,
  0.0006366484F, 0.0006611292F, 0.0006860716F, 0.0007114757F,
  0.0007373414F, 0.0007636687F, 0.0007904576F, 0.0008177080F,
  0.0008454200F, 0.0008735935F, 0.0009022285F, 0.0009313250F,
  0.0009608830F, 0.0009909025F, 0.0010213834F, 0.0010523257F,
  0.0010837295F, 0.0011155946F, 0.0011479211F, 0.0011807090F,
  0.0012139582F, 0.0012476687F, 0.0012818405F, 0.0013164736F,
  0.0013515679F, 0.0013871235F, 0.0014231402F, 0.0014596182F,
  0.0014965573F, 0.0015339576F, 0.0015718190F, 0.0016101415F,
  0.0016489251F, 0.0016881698F, 0.0017278754F, 0.0017680421F,
  0.0018086698F, 0.0018497584F, 0.0018913080F, 0.0019333185F,
  0.0019757898F, 0.0020187221F, 0.0020621151F, 0.0021059690F,
  0.0021502837F, 0.0021950591F, 0.0022402953F, 0.0022859921F,
  0.0023321497F, 0.0023787679F, 0.0024258467F, 0.0024733861F,
  0.0025213861F, 0.0025698466F, 0.0026187676F, 0.0026681491F,
  0.0027179911F, 0.0027682935F, 0.0028190562F, 0.0028702794F,
  0.0029219628F, 0.0029741066F, 0.0030267107F, 0.0030797749F,
  0.0031332994F, 0.0031872841F, 0.0032417289F, 0.0032966338F,
  0.0033519988F, 0.0034078238F, 0.0034641089F, 0.0035208539F,
  0.0035780589F, 0.0036357237F, 0.0036938485F, 0.0037524331F,
  0.0038114775F, 0.0038709817F, 0.0039309456F, 0.0039913692F,
  0.0040522524F, 0.0041135953F, 0.0041753978F, 0.0042376599F,
  0.0043003814F, 0.0043635624F, 0.0044272029F, 0.0044913028F,
  0.0045558620F, 0.0046208806F, 0.0046863585F, 0.0047522955F,
  0.0048186919F, 0.0048855473F, 0.0049528619F, 0.0050206356F,
  0.0050888684F, 0.0051575601F, 0.0052267108F, 0.0052963204F,
  0.0053663890F, 0.0054369163F, 0.0055079025F, 0.0055793474F,
  0.0056512510F, 0.0057236133F, 0.0057964342F, 0.0058697137F,
  0.0059434517F, 0.0060176482F, 0.0060923032F, 0.0061674166F,
  0.0062429883F, 0.0063190183F, 0.0063955066F, 0.0064724532F,
  0.0065498579F, 0.0066277207F, 0.0067060416F, 0.0067848205F,
  0.0068640575F, 0.0069437523F, 0.0070239051F, 0.0071045157F,
  0.0071855840F, 0.0072671102F, 0.0073490940F, 0.0074315355F,
  0.0075144345F, 0.0075977911F, 0.0076816052F, 0.0077658768F,
  0.0078506057F, 0.0079357920F, 0.0080214355F, 0.0081075363F,
  0.0081940943F, 0.0082811094F, 0.0083685816F, 0.0084565108F,
  0.0085448970F, 0.0086337401F, 0.0087230401F, 0.0088127969F,
  0.0089030104F, 0.0089936807F, 0.0090848076F, 0.0091763911F,
  0.0092684311F, 0.0093609276F, 0.0094538805F, 0.0095472898F,
  0.0096411554F, 0.0097354772F, 0.0098302552F, 0.0099254894F,
  0.0100211796F, 0.0101173259F, 0.0102139281F, 0.0103109863F,
  0.0104085002F, 0.0105064700F, 0.0106048955F, 0.0107037766F,
  0.0108031133F, 0.0109029056F, 0.0110031534F, 0.0111038565F,
  0.0112050151F, 0.0113066289F, 0.0114086980F, 0.0115112222F,
  0.0116142015F, 0.0117176359F, 0.0118215252F, 0.0119258695F,
  0.0120306686F, 0.0121359225F, 0.0122416312F, 0.0123477944F,
  0.0124544123F, 0.0125614847F, 0.0126690116F, 0.0127769928F,
  0.0128854284F, 0.0129943182F, 0.0131036623F, 0.0132134604F,
  0.0133237126F, 0.0134344188F, 0.0135455790F, 0.0136571929F,
  0.0137692607F, 0.0138817821F, 0.0139947572F, 0.0141081859F,
  0.0142220681F, 0.0143364037F, 0.0144511927F, 0.0145664350F,
  0.0146821304F, 0.0147982791F, 0.0149148808F, 0.0150319355F,
  0.0151494431F, 0.0152674036F, 0.0153858168F, 0.0155046828F,
  0.0156240014F, 0.0157437726F, 0.0158639962F, 0.0159846723F,
  0.0161058007F, 0.0162273814F, 0.0163494142F, 0.0164718991F,
  0.0165948361F, 0.0167182250F, 0.0168420658F, 0.0169663584F,
  0.0170911027F, 0.0172162987F, 0.0173419462F, 0.0174680452F,
  0.0175945956F, 0.0177215974F, 0.0178490504F, 0.0179769545F,
  0.0181053098F, 0.0182341160F, 0.0183633732F, 0.0184930812F,
  0.0186232399F, 0.0187538494F, 0.0188849094F, 0.0190164200F,
  0.0191483809F, 0.0192807923F, 0.0194136539F, 0.0195469656F,
  0.0196807275F, 0.0198149394F, 0.0199496012F, 0.0200847128F,
  0.0202202742F, 0.0203562853F, 0.0204927460F, 0.0206296561F,
  0.0207670157F, 0.0209048245F, 0.0210430826F, 0.0211817899F,
  0.0213209462F, 0.0214605515F, 0.0216006057F, 0.0217411086F,
  0.0218820603F, 0.0220234605F, 0.0221653093F, 0.0223076066F,
  0.0224503521F, 0.0225935459F, 0.0227371879F, 0.0228812779F,
  0.0230258160F, 0.0231708018F, 0.0233162355F, 0.0234621169F,
  0.0236084459F, 0.0237552224F, 0.0239024462F, 0.0240501175F,
  0.0241982359F, 0.0243468015F, 0.0244958141F, 0.0246452736F,
  0.0247951800F, 0.0249455331F, 0.0250963329F, 0.0252475792F,
  0.0253992720F, 0.0255514111F, 0.0257039965F, 0.0258570281F,
  0.0260105057F, 0.0261644293F, 0.0263187987F, 0.0264736139F,
  0.0266288747F, 0.0267845811F, 0.0269407330F, 0.0270973302F,
  0.0272543727F, 0.0274118604F, 0.0275697930F, 0.0277281707F,
  0.0278869932F, 0.0280462604F, 0.0282059723F, 0.0283661287F,
  0.0285267295F, 0.0286877747F, 0.0288492641F, 0.0290111976F,
  0.0291735751F, 0.0293363965F, 0.0294996617F, 0.0296633706F,
  0.0298275231F, 0.0299921190F, 0.0301571583F, 0.0303226409F,
  0.0304885667F, 0.0306549354F, 0.0308217472F, 0.0309890017F,
  0.0311566989F, 0.0313248388F, 0.0314934211F, 0.0316624459F,
  0.0318319128F, 0.0320018220F, 0.0321721732F, 0.0323429663F,
  0.0325142013F, 0.0326858779F, 0.0328579962F, 0.0330305559F,
  0.0332035570F, 0.0333769994F, 0.0335508829F, 0.0337252074F,
  0.0338999728F, 0.0340751790F, 0.0342508259F, 0.0344269134F,
  0.0346034412F, 0.0347804094F, 0.0349578178F, 0.0351356663F,
  0.0353139548F, 0.0354926831F, 0.0356718511F, 0.0358514588F,
  0.0360315059F, 0.0362119924F, 0.0363929182F, 0.0365742831F,
  0.0367560870F, 0.0369383297F, 0.0371210113F, 0.0373041315F,
  0.0374876902F, 0.0376716873F, 0.0378561226F, 0.0380409961F,
  0.0382263077F, 0.0384120571F, 0.0385982443F, 0.0387848691F,
  0.0389719315F, 0.0391594313F, 0.0393473683F, 0.0395357425F,
  0.0397245537F, 0.0399138017F, 0.0401034866F, 0.0402936080F,
  0.0404841660F, 0.0406751603F, 0.0408665909F, 0.0410584576F,
  0.0412507603F, 0.0414434988F, 0.0416366731F, 0.0418302829F,
  0.0420243282F, 0.0422188088F, 0.0424137246F, 0.0426090755F,
  0.0428048613F, 0.0430010819F, 0.0431977371F, 0.0433948269F,
  0.0435923511F, 0.0437903095F, 0.0439887020F, 0.0441875285F,
  0.0443867889F, 0.0445864830F, 0.0447866106F, 0.0449871717F,
  0.0451881661F, 0.0453895936F, 0.0455914542F, 0.0457937477F,
  0.0459964738F, 0.0461996326F, 0.0464032239F, 0.0466072475F,
  0.0468117032F, 0.0470165910F, 0.0472219107F, 0.0474276622F,
  0.0476338452F, 0.0478404597F, 0.0480475056F, 0.0482549827F,
  0.0484628907F, 0.0486712297F, 0.0488799994F, 0.0490891998F,
  0.0492988306F, 0.0495088917F, 0.0497193830F, 0.0499303043F,
  0.0501416554F, 0.0503534363F, 0.0505656468F, 0.0507782867F,
  0.0509913559F, 0.0512048542F, 0.0514187815F, 0.0516331376F,
  0.0518479225F, 0.0520631358F, 0.0522787775F, 0.0524948475F,
  0.0527113455F, 0.0529282715F, 0.0531456252F, 0.0533634066F,
  0.0535816154F, 0.0538002515F, 0.0540193148F, 0.0542388051F,
  0.0544587222F, 0.0546790660F, 0.0548998364F, 0.0551210331F,
  0.0553426561F, 0.0555647051F, 0.0557871801F, 0.0560100807F,
  0.0562334070F, 0.0564571587F, 0.0566813357F, 0.0569059378F,
  0.0571309649F, 0.0573564168F, 0.0575822933F, 0.0578085942F,
  0.0580353195F, 0.0582624689F, 0.0584900423F, 0.0587180396F,
  0.0589464605F, 0.0591753049F, 0.0594045726F, 0.0596342635F,
  0.0598643774F, 0.0600949141F, 0.0603258735F, 0.0605572555F,
  0.0607890597F, 0.0610212862F, 0.0612539346F, 0.0614870049F,
  0.0617204968F, 0.0619544103F, 0.0621887451F, 0.0624235010F,
  0.0626586780F, 0.0628942758F, 0.0631302942F, 0.0633667331F,
  0.0636035923F, 0.0638408717F, 0.0640785710F, 0.0643166901F,
  0.0645552288F, 0.0647941870F, 0.0650335645F, 0.0652733610F,
  0.0655135765F, 0.0657542108F, 0.0659952636F, 0.0662367348F,
  0.0664786242F, 0.0667209316F, 0.0669636570F, 0.0672068000F,
  0.0674503605F, 0.0676943384F, 0.0679387334F, 0.0681835454F,
  0.0684287742F, 0.0686744196F, 0.0689204814F, 0.0691669595F,
  0.0694138536F, 0.0696611637F, 0.0699088894F, 0.0701570307F,
  0.0704055873F, 0.0706545590F, 0.0709039458F, 0.0711537473F,
  0.0714039634F, 0.0716545939F, 0.0719056387F, 0.0721570975F,
  0.0724089702F, 0.0726612565F, 0.0729139563F, 0.0731670694F,
  0.0734205956F, 0.0736745347F, 0.0739288866F, 0.0741836510F,
  0.0744388277F, 0.0746944166F, 0.0749504175F, 0.0752068301F,
  0.0754636543F, 0.0757208899F, 0.0759785367F, 0.0762365946F,
  0.0764950632F, 0.0767539424F, 0.0770132320F, 0.0772729319F,
  0.0775330418F, 0.0777935616F, 0.0780544909F, 0.0783158298F,
  0.0785775778F, 0.0788397349F, 0.0791023009F, 0.0793652755F,
  0.0796286585F, 0.0798924498F, 0.0801566492F, 0.0804212564F,
  0.0806862712F, 0.0809516935F, 0.0812175231F, 0.0814837597F,
  0.0817504031F, 0.0820174532F, 0.0822849097F, 0.0825527724F,
  0.0828210412F, 0.0830897158F, 0.0833587960F, 0.0836282816F,
  0.0838981724F, 0.0841684682F, 0.0844391688F, 0.0847102740F,
  0.0849817835F, 0.0852536973F, 0.0855260150F, 0.0857987364F,
  0.0860718614F, 0.0863453897F, 0.0866193211F, 0.0868936554F,
  0.0871683924F, 0.0874435319F, 0.0877190737F, 0.0879950175F,
  0.0882713632F, 0.0885481105F, 0.0888252592F, 0.0891028091F,
  0.0893807600F, 0.0896591117F, 0.0899378639F, 0.0902170165F,
  0.0904965692F, 0.0907765218F, 0.0910568740F, 0.0913376258F,
  0.0916187767F, 0.0919003268F, 0.0921822756F, 0.0924646230F,
  0.0927473687F, 0.0930305126F, 0.0933140545F, 0.0935979940F,
  0.0938823310F, 0.0941670653F, 0.0944521966F, 0.0947377247F,
  0.0950236494F, 0.0953099704F, 0.0955966876F, 0.0958838007F,
  0.0961713094F, 0.0964592136F, 0.0967475131F, 0.0970362075F,
  0.0973252967F, 0.0976147805F, 0.0979046585F, 0.0981949307F,
  0.0984855967F, 0.0987766563F, 0.0990681093F, 0.0993599555F,
  0.0996521945F, 0.0999448263F, 0.1002378506F, 0.1005312671F,
  0.1008250755F, 0.1011192757F, 0.1014138675F, 0.1017088505F,
  0.1020042246F, 0.1022999895F, 0.1025961450F, 0.1028926909F,
  0.1031896268F, 0.1034869526F, 0.1037846680F, 0.1040827729F,
  0.1043812668F, 0.1046801497F, 0.1049794213F, 0.1052790813F,
  0.1055791294F, 0.1058795656F, 0.1061803894F, 0.1064816006F,
  0.1067831991F, 0.1070851846F, 0.1073875568F, 0.1076903155F,
  0.1079934604F, 0.1082969913F, 0.1086009079F, 0.1089052101F,
  0.1092098975F, 0.1095149699F, 0.1098204270F, 0.1101262687F,
  0.1104324946F, 0.1107391045F, 0.1110460982F, 0.1113534754F,
  0.1116612359F, 0.1119693793F, 0.1122779055F, 0.1125868142F,
  0.1128961052F, 0.1132057781F, 0.1135158328F, 0.1138262690F,
  0.1141370863F, 0.1144482847F, 0.1147598638F, 0.1150718233F,
  0.1153841631F, 0.1156968828F, 0.1160099822F, 0.1163234610F,
  0.1166373190F, 0.1169515559F, 0.1172661714F, 0.1175811654F,
  0.1178965374F, 0.1182122874F, 0.1185284149F, 0.1188449198F,
  0.1191618018F, 0.1194790606F, 0.1197966960F, 0.1201147076F,
  0.1204330953F, 0.1207518587F, 0.1210709976F, 0.1213905118F,
  0.1217104009F, 0.1220306647F, 0.1223513029F, 0.1226723153F,
  0.1229937016F, 0.1233154615F, 0.1236375948F, 0.1239601011F,
  0.1242829803F, 0.1246062319F, 0.1249298559F, 0.1252538518F,
  0.1255782195F, 0.1259029586F, 0.1262280689F, 0.1265535501F,
  0.1268794019F, 0.1272056241F, 0.1275322163F, 0.1278591784F,
  0.1281865099F, 0.1285142108F, 0.1288422805F, 0.1291707190F,
  0.1294995259F, 0.1298287009F, 0.1301582437F, 0.1304881542F,
  0.1308184319F, 0.1311490766F, 0.1314800881F, 0.1318114660F,
  0.1321432100F, 0.1324753200F, 0.1328077955F, 0.1331406364F,
  0.1334738422F, 0.1338074129F, 0.1341413479F, 0.1344756472F,
  0.1348103103F, 0.1351453370F, 0.1354807270F, 0.1358164801F,
  0.1361525959F, 0.1364890741F, 0.1368259145F, 0.1371631167F,
  0.1375006805F, 0.1378386056F, 0.1381768917F, 0.1385155384F,
  0.1388545456F, 0.1391939129F, 0.1395336400F, 0.1398737266F,
  0.1402141724F, 0.1405549772F, 0.1408961406F, 0.1412376623F,
  0.1415795421F, 0.1419217797F, 0.1422643746F, 0.1426073268F,
  0.1429506358F, 0.1432943013F, 0.1436383231F, 0.1439827008F,
  0.1443274342F, 0.1446725229F, 0.1450179667F, 0.1453637652F,
  0.1457099181F, 0.1460564252F, 0.1464032861F, 0.1467505006F,
  0.1470980682F, 0.1474459888F, 0.1477942620F, 0.1481428875F,
  0.1484918651F, 0.1488411942F, 0.1491908748F, 0.1495409065F,
  0.1498912889F, 0.1502420218F, 0.1505931048F, 0.1509445376F,
  0.1512963200F, 0.1516484516F, 0.1520009321F, 0.1523537612F,
  0.1527069385F, 0.1530604638F, 0.1534143368F, 0.1537685571F,
  0.1541231244F, 0.1544780384F, 0.1548332987F, 0.1551889052F,
  0.1555448574F, 0.1559011550F, 0.1562577978F, 0.1566147853F,
  0.1569721173F, 0.1573297935F, 0.1576878135F, 0.1580461771F,
  0.1584048838F, 0.1587639334F, 0.1591233255F, 0.1594830599F,
  0.1598431361F, 0.1602035540F, 0.1605643131F, 0.1609254131F,
  0.1612868537F, 0.1616486346F, 0.1620107555F, 0.1623732160F,
  0.1627360158F, 0.1630991545F, 0.1634626319F, 0.1638264476F,
  0.1641906013F, 0.1645550926F, 0.1649199212F, 0.1652850869F,
  0.1656505892F, 0.1660164278F, 0.1663826024F, 0.1667491127F,
  0.1671159583F, 0.1674831388F, 0.1678506541F, 0.1682185036F,
  0.1685866872F, 0.1689552044F, 0.1693240549F, 0.1696932384F,
  0.1700627545F, 0.1704326029F, 0.1708027833F, 0.1711732952F,
  0.1715441385F, 0.1719153127F, 0.1722868175F, 0.1726586526F,
  0.1730308176F, 0.1734033121F, 0.1737761359F, 0.1741492886F,
  0.1745227698F, 0.1748965792F, 0.1752707164F, 0.1756451812F,
  0.1760199731F, 0.1763950918F, 0.1767705370F, 0.1771463083F,
  0.1775224054F, 0.1778988279F, 0.1782755754F, 0.1786526477F,
  0.1790300444F, 0.1794077651F, 0.1797858094F, 0.1801641771F,
  0.1805428677F, 0.1809218810F, 0.1813012165F, 0.1816808739F,
  0.1820608528F, 0.1824411530F, 0.1828217739F, 0.1832027154F,
  0.1835839770F, 0.1839655584F, 0.1843474592F, 0.1847296790F,
  0.1851122175F, 0.1854950744F, 0.1858782492F, 0.1862617417F,
  0.1866455514F, 0.1870296780F, 0.1874141211F, 0.1877988804F,
  0.1881839555F, 0.1885693461F, 0.1889550517F, 0.1893410721F,
  0.1897274068F, 0.1901140555F, 0.1905010178F, 0.1908882933F,
  0.1912758818F, 0.1916637828F, 0.1920519959F, 0.1924405208F,
  0.1928293571F, 0.1932185044F, 0.1936079625F, 0.1939977308F,
  0.1943878091F, 0.1947781969F, 0.1951688939F, 0.1955598998F,
  0.1959512141F, 0.1963428364F, 0.1967347665F, 0.1971270038F,
  0.1975195482F, 0.1979123990F, 0.1983055561F, 0.1986990190F,
  0.1990927873F, 0.1994868607F, 0.1998812388F, 0.2002759212F,
  0.2006709075F, 0.2010661974F, 0.2014617904F, 0.2018576862F,
  0.2022538844F, 0.2026503847F, 0.2030471865F, 0.2034442897F,
  0.2038416937F, 0.2042393982F, 0.2046374028F, 0.2050357071F,
  0.2054343107F, 0.2058332133F, 0.2062324145F, 0.2066319138F,
  0.2070317110F, 0.2074318055F, 0.2078321970F, 0.2082328852F,
  0.2086338696F, 0.2090351498F, 0.2094367255F, 0.2098385962F,
  0.2102407617F, 0.2106432213F, 0.2110459749F, 0.2114490220F,
  0.2118523621F, 0.2122559950F, 0.2126599202F, 0.2130641373F,
  0.2134686459F, 0.2138734456F, 0.2142785361F, 0.2146839168F,
  0.2150895875F, 0.2154955478F, 0.2159017972F, 0.2163083353F,
  0.2167151617F, 0.2171222761F, 0.2175296780F, 0.2179373670F,
  0.2183453428F, 0.2187536049F, 0.2191621529F, 0.2195709864F,
  0.2199801051F, 0.2203895085F, 0.2207991961F, 0.2212091677F,
  0.2216194228F, 0.2220299610F, 0.2224407818F, 0.2228518850F,
  0.2232632699F, 0.2236749364F, 0.2240868839F, 0.2244991121F,
  0.2249116204F, 0.2253244086F, 0.2257374763F, 0.2261508229F,
  0.2265644481F, 0.2269783514F, 0.2273925326F, 0.2278069911F,
  0.2282217265F, 0.2286367384F, 0.2290520265F, 0.2294675902F,
  0.2298834292F, 0.2302995431F, 0.2307159314F, 0.2311325937F,
  0.2315495297F, 0.2319667388F, 0.2323842207F, 0.2328019749F,
  0.2332200011F, 0.2336382988F, 0.2340568675F, 0.2344757070F,
  0.2348948166F, 0.2353141961F, 0.2357338450F, 0.2361537629F,
  0.2365739493F, 0.2369944038F, 0.2374151261F, 0.2378361156F,
  0.2382573720F, 0.2386788948F, 0.2391006836F, 0.2395227380F,
  0.2399450575F, 0.2403676417F, 0.2407904902F, 0.2412136026F,
  0.2416369783F, 0.2420606171F, 0.2424845185F, 0.2429086820F,
  0.2433331072F, 0.2437577936F, 0.2441827409F, 0.2446079486F,
  0.2450334163F, 0.2454591435F, 0.2458851298F, 0.2463113747F,
  0.2467378779F, 0.2471646389F, 0.2475916573F, 0.2480189325F,
  0.2484464643F, 0.2488742521F, 0.2493022955F, 0.2497305940F,
  0.2501591473F, 0.2505879549F, 0.2510170163F, 0.2514463311F,
  0.2518758989F, 0.2523057193F, 0.2527357916F, 0.2531661157F,
  0.2535966909F, 0.2540275169F, 0.2544585931F, 0.2548899193F,
  0.2553214948F, 0.2557533193F, 0.2561853924F, 0.2566177135F,
  0.2570502822F, 0.2574830981F, 0.2579161608F, 0.2583494697F,
  0.2587830245F, 0.2592168246F, 0.2596508697F, 0.2600851593F,
  0.2605196929F, 0.2609544701F, 0.2613894904F, 0.2618247534F,
  0.2622602586F, 0.2626960055F, 0.2631319938F, 0.2635682230F,
  0.2640046925F, 0.2644414021F, 0.2648783511F, 0.2653155391F,
  0.2657529657F, 0.2661906305F, 0.2666285329F, 0.2670666725F,
  0.2675050489F, 0.2679436616F, 0.2683825101F, 0.2688215940F,
  0.2692609127F, 0.2697004660F, 0.2701402532F, 0.2705802739F,
  0.2710205278F, 0.2714610142F, 0.2719017327F, 0.2723426830F,
  0.2727838644F, 0.2732252766F, 0.2736669191F, 0.2741087914F,
  0.2745508930F, 0.2749932235F, 0.2754357824F, 0.2758785693F,
  0.2763215837F, 0.2767648251F, 0.2772082930F, 0.2776519870F,
  0.2780959066F, 0.2785400513F, 0.2789844207F, 0.2794290143F,
  0.2798738316F, 0.2803188722F, 0.2807641355F, 0.2812096211F,
  0.2816553286F, 0.2821012574F, 0.2825474071F, 0.2829937773F,
  0.2834403673F, 0.2838871768F, 0.2843342053F, 0.2847814523F,
  0.2852289174F, 0.2856765999F, 0.2861244996F, 0.2865726159F,
  0.2870209482F, 0.2874694962F, 0.2879182594F, 0.2883672372F,
  0.2888164293F, 0.2892658350F, 0.2897154540F, 0.2901652858F,
  0.2906153298F, 0.2910655856F, 0.2915160527F, 0.2919667306F,
  0.2924176189F, 0.2928687171F, 0.2933200246F, 0.2937715409F,
  0.2942232657F, 0.2946751984F, 0.2951273386F, 0.2955796856F,
  0.2960322391F, 0.2964849986F, 0.2969379636F, 0.2973911335F,
  0.2978445080F, 0.2982980864F, 0.2987518684F, 0.2992058534F,
  0.2996600409F, 0.3001144305F, 0.3005690217F, 0.3010238139F,
  0.3014788067F, 0.3019339995F, 0.3023893920F, 0.3028449835F,
  0.3033007736F, 0.3037567618F, 0.3042129477F, 0.3046693306F,
  0.3051259102F, 0.3055826859F, 0.3060396572F, 0.3064968236F,
  0.3069541847F, 0.3074117399F, 0.3078694887F, 0.3083274307F,
  0.3087855653F, 0.3092438920F, 0.3097024104F, 0.3101611199F,
  0.3106200200F, 0.3110791103F, 0.3115383902F, 0.3119978592F,
  0.3124575169F, 0.3129173627F, 0.3133773961F, 0.3138376166F,
  0.3142980238F, 0.3147586170F, 0.3152193959F, 0.3156803598F,
  0.3161415084F, 0.3166028410F, 0.3170643573F, 0.3175260566F,
  0.3179879384F, 0.3184500023F, 0.3189122478F, 0.3193746743F,
  0.3198372814F, 0.3203000685F, 0.3207630351F, 0.3212261807F,
  0.3216895048F, 0.3221530069F, 0.3226166865F, 0.3230805430F,
  0.3235445760F, 0.3240087849F, 0.3244731693F, 0.3249377285F,
  0.3254024622F, 0.3258673698F, 0.3263324507F, 0.3267977045F,
  0.3272631306F, 0.3277287286F, 0.3281944978F, 0.3286604379F,
  0.3291265482F, 0.3295928284F, 0.3300592777F, 0.3305258958F,
  0.3309926821F, 0.3314596361F, 0.3319267573F, 0.3323940451F,
  0.3328614990F, 0.3333291186F, 0.3337969033F, 0.3342648525F,
  0.3347329658F, 0.3352012427F, 0.3356696825F, 0.3361382849F,
  0.3366070492F, 0.3370759749F, 0.3375450616F, 0.3380143087F,
  0.3384837156F, 0.3389532819F, 0.3394230071F, 0.3398928905F,
  0.3403629317F, 0.3408331302F, 0.3413034854F, 0.3417739967F,
  0.3422446638F, 0.3427154860F, 0.3431864628F, 0.3436575938F,
  0.3441288782F, 0.3446003158F, 0.3450719058F, 0.3455436478F,
  0.3460155412F, 0.3464875856F, 0.3469597804F, 0.3474321250F,
  0.3479046189F, 0.3483772617F, 0.3488500527F, 0.3493229914F,
  0.3497960774F, 0.3502693100F, 0.3507426887F, 0.3512162131F,
  0.3516898825F, 0.3521636965F, 0.3526376545F, 0.3531117559F,
  0.3535860003F, 0.3540603870F, 0.3545349157F, 0.3550095856F,
  0.3554843964F, 0.3559593474F, 0.3564344381F, 0.3569096680F,
  0.3573850366F, 0.3578605432F, 0.3583361875F, 0.3588119687F,
  0.3592878865F, 0.3597639402F, 0.3602401293F, 0.3607164533F,
  0.3611929117F, 0.3616695038F, 0.3621462292F, 0.3626230873F,
  0.3631000776F, 0.3635771995F, 0.3640544525F, 0.3645318360F,
  0.3650093496F, 0.3654869926F, 0.3659647645F, 0.3664426648F,
  0.3669206930F, 0.3673988484F, 0.3678771306F, 0.3683555390F,
  0.3688340731F, 0.3693127322F, 0.3697915160F, 0.3702704237F,
  0.3707494549F, 0.3712286091F, 0.3717078857F, 0.3721872840F,
  0.3726668037F, 0.3731464441F, 0.3736262047F, 0.3741060850F,
  0.3745860843F, 0.3750662023F, 0.3755464382F, 0.3760267915F,
  0.3765072618F, 0.3769878484F, 0.3774685509F, 0.3779493686F,
  0.3784303010F, 0.3789113475F, 0.3793925076F, 0.3798737809F,
  0.3803551666F, 0.3808366642F, 0.3813182733F, 0.3817999932F,
  0.3822818234F, 0.3827637633F, 0.3832458124F, 0.3837279702F,
  0.3842102360F, 0.3846926093F, 0.3851750897F, 0.3856576764F,
  0.3861403690F, 0.3866231670F, 0.3871060696F, 0.3875890765F,
  0.3880721870F, 0.3885554007F, 0.3890387168F, 0.3895221349F,
  0.3900056544F, 0.3904892748F, 0.3909729955F, 0.3914568160F,
  0.3919407356F, 0.3924247539F, 0.3929088702F, 0.3933930841F,
  0.3938773949F, 0.3943618021F, 0.3948463052F, 0.3953309035F,
  0.3958155966F, 0.3963003838F, 0.3967852646F, 0.3972702385F,
  0.3977553048F, 0.3982404631F, 0.3987257127F, 0.3992110531F,
  0.3996964838F, 0.4001820041F, 0.4006676136F, 0.4011533116F,
  0.4016390976F, 0.4021249710F, 0.4026109313F, 0.4030969779F,
  0.4035831102F, 0.4040693277F, 0.4045556299F, 0.4050420160F,
  0.4055284857F, 0.4060150383F, 0.4065016732F, 0.4069883899F,
  0.4074751879F, 0.4079620665F, 0.4084490252F, 0.4089360635F,
  0.4094231807F, 0.4099103763F, 0.4103976498F, 0.4108850005F,
  0.4113724280F, 0.4118599315F, 0.4123475107F, 0.4128351648F,
  0.4133228934F, 0.4138106959F, 0.4142985716F, 0.4147865201F,
  0.4152745408F, 0.4157626330F, 0.4162507963F, 0.4167390301F,
  0.4172273337F, 0.4177157067F, 0.4182041484F, 0.4186926583F,
  0.4191812359F, 0.4196698805F, 0.4201585915F, 0.4206473685F,
  0.4211362108F, 0.4216251179F, 0.4221140892F, 0.4226031241F,
  0.4230922221F, 0.4235813826F, 0.4240706050F, 0.4245598887F,
  0.4250492332F, 0.4255386379F, 0.4260281022F, 0.4265176256F,
  0.4270072075F, 0.4274968473F, 0.4279865445F, 0.4284762984F,
  0.4289661086F, 0.4294559743F, 0.4299458951F, 0.4304358704F,
  0.4309258996F, 0.4314159822F, 0.4319061175F, 0.4323963050F,
  0.4328865441F, 0.4333768342F, 0.4338671749F, 0.4343575654F,
  0.4348480052F, 0.4353384938F, 0.4358290306F, 0.4363196149F,
  0.4368102463F, 0.4373009241F, 0.4377916478F, 0.4382824168F,
  0.4387732305F, 0.4392640884F, 0.4397549899F, 0.4402459343F,
  0.4407369212F, 0.4412279499F, 0.4417190198F, 0.4422101305F,
  0.4427012813F, 0.4431924717F, 0.4436837010F, 0.4441749686F,
  0.4446662742F, 0.4451576169F, 0.4456489963F, 0.4461404118F,
  0.4466318628F, 0.4471233487F, 0.4476148690F, 0.4481064230F,
  0.4485980103F, 0.4490896302F, 0.4495812821F, 0.4500729654F,
  0.4505646797F, 0.4510564243F, 0.4515481986F, 0.4520400021F,
  0.4525318341F, 0.4530236942F, 0.4535155816F, 0.4540074959F,
  0.4544994365F, 0.4549914028F, 0.4554833941F, 0.4559754100F,
  0.4564674499F, 0.4569595131F, 0.4574515991F, 0.4579437074F,
  0.4584358372F, 0.4589279881F, 0.4594201595F, 0.4599123508F,
  0.4604045615F, 0.4608967908F, 0.4613890383F, 0.4618813034F,
  0.4623735855F, 0.4628658841F, 0.4633581984F, 0.4638505281F,
  0.4643428724F, 0.4648352308F, 0.4653276028F, 0.4658199877F,
  0.4663123849F, 0.4668047940F, 0.4672972143F, 0.4677896451F,
  0.4682820861F, 0.4687745365F, 0.4692669958F, 0.4697594634F,
  0.4702519387F, 0.4707444211F, 0.4712369102F, 0.4717294052F,
  0.4722219056F, 0.4727144109F, 0.4732069204F, 0.4736994336F,
  0.4741919498F, 0.4746844686F, 0.4751769893F, 0.4756695113F,
  0.4761620341F, 0.4766545571F, 0.4771470797F, 0.4776396013F,
  0.4781321213F, 0.4786246392F, 0.4791171544F, 0.4796096663F,
  0.4801021744F, 0.4805946779F, 0.4810871765F, 0.4815796694F,
  0.4820721561F, 0.4825646360F, 0.4830571086F, 0.4835495732F,
  0.4840420293F, 0.4845344763F, 0.4850269136F, 0.4855193407F,
  0.4860117569F, 0.4865041617F, 0.4869965545F, 0.4874889347F,
  0.4879813018F, 0.4884736551F, 0.4889659941F, 0.4894583182F,
  0.4899506268F, 0.4904429193F, 0.4909351952F, 0.4914274538F,
  0.4919196947F, 0.4924119172F, 0.4929041207F, 0.4933963046F,
  0.4938884685F, 0.4943806116F, 0.4948727335F, 0.4953648335F,
  0.4958569110F, 0.4963489656F, 0.4968409965F, 0.4973330032F,
  0.4978249852F, 0.4983169419F, 0.4988088726F, 0.4993007768F,
  0.4997926539F, 0.5002845034F, 0.5007763247F, 0.5012681171F,
  0.5017598801F, 0.5022516132F, 0.5027433157F, 0.5032349871F,
  0.5037266268F, 0.5042182341F, 0.5047098086F, 0.5052013497F,
  0.5056928567F, 0.5061843292F, 0.5066757664F, 0.5071671679F,
  0.5076585330F, 0.5081498613F, 0.5086411520F, 0.5091324047F,
  0.5096236187F, 0.5101147934F, 0.5106059284F, 0.5110970230F,
  0.5115880766F, 0.5120790887F, 0.5125700587F, 0.5130609860F,
  0.5135518700F, 0.5140427102F, 0.5145335059F, 0.5150242566F,
  0.5155149618F, 0.5160056208F, 0.5164962331F, 0.5169867980F,
  0.5174773151F, 0.5179677837F, 0.5184582033F, 0.5189485733F,
  0.5194388931F, 0.5199291621F, 0.5204193798F, 0.5209095455F,
  0.5213996588F, 0.5218897190F, 0.5223797256F, 0.5228696779F,
  0.5233595755F, 0.5238494177F, 0.5243392039F, 0.5248289337F,
  0.5253186063F, 0.5258082213F, 0.5262977781F, 0.5267872760F,
  0.5272767146F, 0.5277660932F, 0.5282554112F, 0.5287446682F,
  0.5292338635F, 0.5297229965F, 0.5302120667F, 0.5307010736F,
  0.5311900164F, 0.5316788947F, 0.5321677079F, 0.5326564554F,
  0.5331451366F, 0.5336337511F, 0.5341222981F, 0.5346107771F,
  0.5350991876F, 0.5355875290F, 0.5360758007F, 0.5365640021F,
  0.5370521327F, 0.5375401920F, 0.5380281792F, 0.5385160939F,
  0.5390039355F, 0.5394917034F, 0.5399793971F, 0.5404670159F,
  0.5409545594F, 0.5414420269F, 0.5419294179F, 0.5424167318F,
  0.5429039680F, 0.5433911261F, 0.5438782053F, 0.5443652051F,
  0.5448521250F, 0.5453389644F, 0.5458257228F, 0.5463123995F,
  0.5467989940F, 0.5472855057F, 0.5477719341F, 0.5482582786F,
  0.5487445387F, 0.5492307137F, 0.5497168031F, 0.5502028063F,
  0.5506887228F, 0.5511745520F, 0.5516602934F, 0.5521459463F,
  0.5526315103F, 0.5531169847F, 0.5536023690F, 0.5540876626F,
  0.5545728649F, 0.5550579755F, 0.5555429937F, 0.5560279189F,
  0.5565127507F, 0.5569974884F, 0.5574821315F, 0.5579666794F,
  0.5584511316F, 0.5589354875F, 0.5594197465F, 0.5599039080F,
  0.5603879716F, 0.5608719367F, 0.5613558026F, 0.5618395689F,
  0.5623232350F, 0.5628068002F, 0.5632902642F, 0.5637736262F,
  0.5642568858F, 0.5647400423F, 0.5652230953F, 0.5657060442F,
  0.5661888883F, 0.5666716272F, 0.5671542603F, 0.5676367870F,
  0.5681192069F, 0.5686015192F, 0.5690837235F, 0.5695658192F,
  0.5700478058F, 0.5705296827F, 0.5710114494F, 0.5714931052F,
  0.5719746497F, 0.5724560822F, 0.5729374023F, 0.5734186094F,
  0.5738997029F, 0.5743806823F, 0.5748615470F, 0.5753422965F,
  0.5758229301F, 0.5763034475F, 0.5767838480F, 0.5772641310F,
  0.5777442960F, 0.5782243426F, 0.5787042700F, 0.5791840778F,
  0.5796637654F, 0.5801433322F, 0.5806227778F, 0.5811021016F,
  0.5815813029F, 0.5820603814F, 0.5825393363F, 0.5830181673F,
  0.5834968737F, 0.5839754549F, 0.5844539105F, 0.5849322399F,
  0.5854104425F, 0.5858885179F, 0.5863664653F, 0.5868442844F,
  0.5873219746F, 0.5877995353F, 0.5882769660F, 0.5887542661F,
  0.5892314351F, 0.5897084724F, 0.5901853776F, 0.5906621500F,
  0.5911387892F, 0.5916152945F, 0.5920916655F, 0.5925679016F,
  0.5930440022F, 0.5935199669F, 0.5939957950F, 0.5944714861F,
  0.5949470396F, 0.5954224550F, 0.5958977317F, 0.5963728692F,
  0.5968478669F, 0.5973227244F, 0.5977974411F, 0.5982720163F,
  0.5987464497F, 0.5992207407F, 0.5996948887F, 0.6001688932F,
  0.6006427537F, 0.6011164696F, 0.6015900405F, 0.6020634657F,
  0.6025367447F, 0.6030098770F, 0.6034828621F, 0.6039556995F,
  0.6044283885F, 0.6049009288F, 0.6053733196F, 0.6058455606F,
  0.6063176512F, 0.6067895909F, 0.6072613790F, 0.6077330152F,
  0.6082044989F, 0.6086758295F, 0.6091470065F, 0.6096180294F,
  0.6100888977F, 0.6105596108F, 0.6110301682F, 0.6115005694F,
  0.6119708139F, 0.6124409011F, 0.6129108305F, 0.6133806017F,
  0.6138502139F, 0.6143196669F, 0.6147889599F, 0.6152580926F,
  0.6157270643F, 0.6161958746F, 0.6166645230F, 0.6171330088F,
  0.6176013317F, 0.6180694910F, 0.6185374863F, 0.6190053171F,
  0.6194729827F, 0.6199404828F, 0.6204078167F, 0.6208749841F,
  0.6213419842F, 0.6218088168F, 0.6222754811F, 0.6227419768F,
  0.6232083032F, 0.6236744600F, 0.6241404465F, 0.6246062622F,
  0.6250719067F, 0.6255373795F, 0.6260026799F, 0.6264678076F,
  0.6269327619F, 0.6273975425F, 0.6278621487F, 0.6283265800F,
  0.6287908361F, 0.6292549163F, 0.6297188201F, 0.6301825471F,
  0.6306460966F, 0.6311094683F, 0.6315726617F, 0.6320356761F,
  0.6324985111F, 0.6329611662F, 0.6334236410F, 0.6338859348F,
  0.6343480472F, 0.6348099777F, 0.6352717257F, 0.6357332909F,
  0.6361946726F, 0.6366558704F, 0.6371168837F, 0.6375777122F,
  0.6380383552F, 0.6384988123F, 0.6389590830F, 0.6394191668F,
  0.6398790631F, 0.6403387716F, 0.6407982916F, 0.6412576228F,
  0.6417167645F, 0.6421757163F, 0.6426344778F, 0.6430930483F,
  0.6435514275F, 0.6440096149F, 0.6444676098F, 0.6449254119F,
  0.6453830207F, 0.6458404356F, 0.6462976562F, 0.6467546820F,
  0.6472115125F, 0.6476681472F, 0.6481245856F, 0.6485808273F,
  0.6490368717F, 0.6494927183F, 0.6499483667F, 0.6504038164F,
  0.6508590670F, 0.6513141178F, 0.6517689684F, 0.6522236185F,
  0.6526780673F, 0.6531323146F, 0.6535863598F, 0.6540402024F,
  0.6544938419F, 0.6549472779F, 0.6554005099F, 0.6558535373F,
  0.6563063598F, 0.6567589769F, 0.6572113880F, 0.6576635927F,
  0.6581155906F, 0.6585673810F, 0.6590189637F, 0.6594703380F,
  0.6599215035F, 0.6603724598F, 0.6608232064F, 0.6612737427F,
  0.6617240684F, 0.6621741829F, 0.6626240859F, 0.6630737767F,
  0.6635232550F, 0.6639725202F, 0.6644215720F, 0.6648704098F,
  0.6653190332F, 0.6657674417F, 0.6662156348F, 0.6666636121F,
  0.6671113731F, 0.6675589174F, 0.6680062445F, 0.6684533538F,
  0.6689002450F, 0.6693469177F, 0.6697933712F, 0.6702396052F,
  0.6706856193F, 0.6711314129F, 0.6715769855F, 0.6720223369F,
  0.6724674664F, 0.6729123736F, 0.6733570581F, 0.6738015194F,
  0.6742457570F, 0.6746897706F, 0.6751335596F, 0.6755771236F,
  0.6760204621F, 0.6764635747F, 0.6769064609F, 0.6773491204F,
  0.6777915525F, 0.6782337570F, 0.6786757332F, 0.6791174809F,
  0.6795589995F, 0.6800002886F, 0.6804413477F, 0.6808821765F,
  0.6813227743F, 0.6817631409F, 0.6822032758F, 0.6826431785F,
  0.6830828485F, 0.6835222855F, 0.6839614890F, 0.6844004585F,
  0.6848391936F, 0.6852776939F, 0.6857159589F, 0.6861539883F,
  0.6865917815F, 0.6870293381F, 0.6874666576F, 0.6879037398F,
  0.6883405840F, 0.6887771899F, 0.6892135571F, 0.6896496850F,
  0.6900855733F, 0.6905212216F, 0.6909566294F, 0.6913917963F,
  0.6918267218F, 0.6922614055F, 0.6926958471F, 0.6931300459F,
  0.6935640018F, 0.6939977141F, 0.6944311825F, 0.6948644066F,
  0.6952973859F, 0.6957301200F, 0.6961626085F, 0.6965948510F,
  0.6970268470F, 0.6974585961F, 0.6978900980F, 0.6983213521F,
  0.6987523580F, 0.6991831154F, 0.6996136238F, 0.7000438828F,
  0.7004738921F, 0.7009036510F, 0.7013331594F, 0.7017624166F,
  0.7021914224F, 0.7026201763F, 0.7030486779F, 0.7034769268F,
  0.7039049226F, 0.7043326648F, 0.7047601531F, 0.7051873870F,
  0.7056143662F, 0.7060410902F, 0.7064675586F, 0.7068937711F,
  0.7073197271F, 0.7077454264F, 0.7081708684F, 0.7085960529F,
  0.7090209793F, 0.7094456474F, 0.7098700566F, 0.7102942066F,
  0.7107180970F, 0.7111417274F, 0.7115650974F, 0.7119882066F,
  0.7124110545F, 0.7128336409F, 0.7132559653F, 0.7136780272F,
  0.7140998264F, 0.7145213624F, 0.7149426348F, 0.7153636433F,
  0.7157843874F, 0.7162048668F, 0.7166250810F, 0.7170450296F,
  0.7174647124F, 0.7178841289F, 0.7183032786F, 0.7187221613F,
  0.7191407765F, 0.7195591239F, 0.7199772030F, 0.7203950135F,
  0.7208125550F, 0.7212298271F, 0.7216468294F, 0.7220635616F,
  0.7224800233F, 0.7228962140F, 0.7233121335F, 0.7237277813F,
  0.7241431571F, 0.7245582604F, 0.7249730910F, 0.7253876484F,
  0.7258019322F, 0.7262159422F, 0.7266296778F, 0.7270431388F,
  0.7274563247F, 0.7278692353F, 0.7282818700F, 0.7286942287F,
  0.7291063108F, 0.7295181160F, 0.7299296440F, 0.7303408944F,
  0.7307518669F, 0.7311625609F, 0.7315729763F, 0.7319831126F,
  0.7323929695F, 0.7328025466F, 0.7332118435F, 0.7336208600F,
  0.7340295955F, 0.7344380499F, 0.7348462226F, 0.7352541134F,
  0.7356617220F, 0.7360690478F, 0.7364760907F, 0.7368828502F,
  0.7372893259F, 0.7376955176F, 0.7381014249F, 0.7385070475F,
  0.7389123849F, 0.7393174368F, 0.7397222029F, 0.7401266829F,
  0.7405308763F, 0.7409347829F, 0.7413384023F, 0.7417417341F,
  0.7421447780F, 0.7425475338F, 0.7429500009F, 0.7433521791F,
  0.7437540681F, 0.7441556674F, 0.7445569769F, 0.7449579960F,
  0.7453587245F, 0.7457591621F, 0.7461593084F, 0.7465591631F,
  0.7469587259F, 0.7473579963F, 0.7477569741F, 0.7481556590F,
  0.7485540506F, 0.7489521486F, 0.7493499526F, 0.7497474623F,
  0.7501446775F, 0.7505415977F, 0.7509382227F, 0.7513345521F,
  0.7517305856F, 0.7521263229F, 0.7525217636F, 0.7529169074F,
  0.7533117541F, 0.7537063032F, 0.7541005545F, 0.7544945076F,
  0.7548881623F, 0.7552815182F, 0.7556745749F, 0.7560673323F,
  0.7564597899F, 0.7568519474F, 0.7572438046F, 0.7576353611F,
  0.7580266166F, 0.7584175708F, 0.7588082235F, 0.7591985741F,
  0.7595886226F, 0.7599783685F, 0.7603678116F, 0.7607569515F,
  0.7611457879F, 0.7615343206F, 0.7619225493F, 0.7623104735F,
  0.7626980931F, 0.7630854078F, 0.7634724171F, 0.7638591209F,
  0.7642455188F, 0.7646316106F, 0.7650173959F, 0.7654028744F,
  0.7657880459F, 0.7661729100F, 0.7665574664F, 0.7669417150F,
  0.7673256553F, 0.7677092871F, 0.7680926100F, 0.7684756239F,
  0.7688583284F, 0.7692407232F, 0.7696228080F, 0.7700045826F,
  0.7703860467F, 0.7707671999F, 0.7711480420F, 0.7715285728F,
  0.7719087918F, 0.7722886989F, 0.7726682938F, 0.7730475762F,
  0.7734265458F, 0.7738052023F, 0.7741835454F, 0.7745615750F,
  0.7749392906F, 0.7753166921F, 0.7756937791F, 0.7760705514F,
  0.7764470087F, 0.7768231508F, 0.7771989773F, 0.7775744880F,
  0.7779496827F, 0.7783245610F, 0.7786991227F, 0.7790733676F,
  0.7794472953F, 0.7798209056F, 0.7801941982F, 0.7805671729F,
  0.7809398294F, 0.7813121675F, 0.7816841869F, 0.7820558873F,
  0.7824272684F, 0.7827983301F, 0.7831690720F, 0.7835394940F,
  0.7839095957F, 0.7842793768F, 0.7846488373F, 0.7850179767F,
  0.7853867948F, 0.7857552914F, 0.7861234663F, 0.7864913191F,
  0.7868588497F, 0.7872260578F, 0.7875929431F, 0.7879595055F,
  0.7883257445F, 0.7886916601F, 0.7890572520F, 0.7894225198F,
  0.7897874635F, 0.7901520827F, 0.7905163772F, 0.7908803468F,
  0.7912439912F, 0.7916073102F, 0.7919703035F, 0.7923329710F,
  0.7926953124F, 0.7930573274F, 0.7934190158F, 0.7937803774F,
  0.7941414120F, 0.7945021193F, 0.7948624991F, 0.7952225511F,
  0.7955822752F, 0.7959416711F, 0.7963007387F, 0.7966594775F,
  0.7970178875F, 0.7973759685F, 0.7977337201F, 0.7980911422F,
  0.7984482346F, 0.7988049970F, 0.7991614292F, 0.7995175310F,
  0.7998733022F, 0.8002287426F, 0.8005838519F, 0.8009386299F,
  0.8012930765F, 0.8016471914F, 0.8020009744F, 0.8023544253F,
  0.8027075438F, 0.8030603298F, 0.8034127831F, 0.8037649035F,
  0.8041166906F, 0.8044681445F, 0.8048192647F, 0.8051700512F,
  0.8055205038F, 0.8058706222F, 0.8062204062F, 0.8065698556F,
  0.8069189702F, 0.8072677499F, 0.8076161944F, 0.8079643036F,
  0.8083120772F, 0.8086595151F, 0.8090066170F, 0.8093533827F,
  0.8096998122F, 0.8100459051F, 0.8103916613F, 0.8107370806F,
  0.8110821628F, 0.8114269077F, 0.8117713151F, 0.8121153849F,
  0.8124591169F, 0.8128025108F, 0.8131455666F, 0.8134882839F,
  0.8138306627F, 0.8141727027F, 0.8145144038F, 0.8148557658F,
  0.8151967886F, 0.8155374718F, 0.8158778154F, 0.8162178192F,
  0.8165574830F, 0.8168968067F, 0.8172357900F, 0.8175744328F,
  0.8179127349F, 0.8182506962F, 0.8185883164F, 0.8189255955F,
  0.8192625332F, 0.8195991295F, 0.8199353840F, 0.8202712967F,
  0.8206068673F, 0.8209420958F, 0.8212769820F, 0.8216115256F,
  0.8219457266F, 0.8222795848F, 0.8226131000F, 0.8229462721F,
  0.8232791009F, 0.8236115863F, 0.8239437280F, 0.8242755260F,
  0.8246069801F, 0.8249380901F, 0.8252688559F, 0.8255992774F,
  0.8259293544F, 0.8262590867F, 0.8265884741F, 0.8269175167F,
  0.8272462141F, 0.8275745663F, 0.8279025732F, 0.8282302344F,
  0.8285575501F, 0.8288845199F, 0.8292111437F, 0.8295374215F,
  0.8298633530F, 0.8301889382F, 0.8305141768F, 0.8308390688F,
  0.8311636141F, 0.8314878124F, 0.8318116637F, 0.8321351678F,
  0.8324583246F, 0.8327811340F, 0.8331035957F, 0.8334257098F,
  0.8337474761F, 0.8340688944F, 0.8343899647F, 0.8347106867F,
  0.8350310605F, 0.8353510857F, 0.8356707624F, 0.8359900904F,
  0.8363090696F, 0.8366276999F, 0.8369459811F, 0.8372639131F,
  0.8375814958F, 0.8378987292F, 0.8382156130F, 0.8385321472F,
  0.8388483316F, 0.8391641662F, 0.8394796508F, 0.8397947853F,
  0.8401095697F, 0.8404240037F, 0.8407380873F, 0.8410518204F,
  0.8413652029F, 0.8416782347F, 0.8419909156F, 0.8423032456F,
  0.8426152245F, 0.8429268523F, 0.8432381289F, 0.8435490541F,
  0.8438596279F, 0.8441698502F, 0.8444797208F, 0.8447892396F,
  0.8450984067F, 0.8454072218F, 0.8457156849F, 0.8460237959F,
  0.8463315547F, 0.8466389612F, 0.8469460154F, 0.8472527170F,
  0.8475590661F, 0.8478650625F, 0.8481707063F, 0.8484759971F,
  0.8487809351F, 0.8490855201F, 0.8493897521F, 0.8496936308F,
  0.8499971564F, 0.8503003286F, 0.8506031474F, 0.8509056128F,
  0.8512077246F, 0.8515094828F, 0.8518108872F, 0.8521119379F,
  0.8524126348F, 0.8527129777F, 0.8530129666F, 0.8533126015F,
  0.8536118822F, 0.8539108087F, 0.8542093809F, 0.8545075988F,
  0.8548054623F, 0.8551029712F, 0.8554001257F, 0.8556969255F,
  0.8559933707F, 0.8562894611F, 0.8565851968F, 0.8568805775F,
  0.8571756034F, 0.8574702743F, 0.8577645902F, 0.8580585509F,
  0.8583521566F, 0.8586454070F, 0.8589383021F, 0.8592308420F,
  0.8595230265F, 0.8598148556F, 0.8601063292F, 0.8603974473F,
  0.8606882098F, 0.8609786167F, 0.8612686680F, 0.8615583636F,
  0.8618477034F, 0.8621366874F, 0.8624253156F, 0.8627135878F,
  0.8630015042F, 0.8632890646F, 0.8635762690F, 0.8638631173F,
  0.8641496096F, 0.8644357457F, 0.8647215257F, 0.8650069495F,
  0.8652920171F, 0.8655767283F, 0.8658610833F, 0.8661450820F,
  0.8664287243F, 0.8667120102F, 0.8669949397F, 0.8672775127F,
  0.8675597293F, 0.8678415894F, 0.8681230929F, 0.8684042398F,
  0.8686850302F, 0.8689654640F, 0.8692455412F, 0.8695252617F,
  0.8698046255F, 0.8700836327F, 0.8703622831F, 0.8706405768F,
  0.8709185138F, 0.8711960940F, 0.8714733174F, 0.8717501840F,
  0.8720266939F, 0.8723028469F, 0.8725786430F, 0.8728540824F,
  0.8731291648F, 0.8734038905F, 0.8736782592F, 0.8739522711F,
  0.8742259261F, 0.8744992242F, 0.8747721653F, 0.8750447496F,
  0.8753169770F, 0.8755888475F, 0.8758603611F, 0.8761315177F,
  0.8764023175F, 0.8766727603F, 0.8769428462F, 0.8772125752F,
  0.8774819474F, 0.8777509626F, 0.8780196209F, 0.8782879224F,
  0.8785558669F, 0.8788234546F, 0.8790906854F, 0.8793575594F,
  0.8796240765F, 0.8798902368F, 0.8801560403F, 0.8804214870F,
  0.8806865768F, 0.8809513099F, 0.8812156863F, 0.8814797059F,
  0.8817433687F, 0.8820066749F, 0.8822696243F, 0.8825322171F,
  0.8827944532F, 0.8830563327F, 0.8833178556F, 0.8835790219F,
  0.8838398316F, 0.8841002848F, 0.8843603815F, 0.8846201217F,
  0.8848795054F, 0.8851385327F, 0.8853972036F, 0.8856555182F,
  0.8859134764F, 0.8861710783F, 0.8864283239F, 0.8866852133F,
  0.8869417464F, 0.8871979234F, 0.8874537443F, 0.8877092090F,
  0.8879643177F, 0.8882190704F, 0.8884734671F, 0.8887275078F,
  0.8889811927F, 0.8892345216F, 0.8894874948F, 0.8897401122F,
  0.8899923738F, 0.8902442798F, 0.8904958301F, 0.8907470248F,
  0.8909978640F, 0.8912483477F, 0.8914984759F, 0.8917482487F,
  0.8919976662F, 0.8922467284F, 0.8924954353F, 0.8927437871F,
  0.8929917837F, 0.8932394252F, 0.8934867118F, 0.8937336433F,
  0.8939802199F, 0.8942264417F, 0.8944723087F, 0.8947178210F,
  0.8949629785F, 0.8952077815F, 0.8954522299F, 0.8956963239F,
  0.8959400634F, 0.8961834486F, 0.8964264795F, 0.8966691561F,
  0.8969114786F, 0.8971534470F, 0.8973950614F, 0.8976363219F,
  0.8978772284F, 0.8981177812F, 0.8983579802F, 0.8985978256F,
  0.8988373174F, 0.8990764556F, 0.8993152405F, 0.8995536720F,
  0.8997917502F, 0.9000294751F, 0.9002668470F, 0.9005038658F,
  0.9007405317F, 0.9009768446F, 0.9012128048F, 0.9014484123F,
  0.9016836671F, 0.9019185693F, 0.9021531191F, 0.9023873165F,
  0.9026211616F, 0.9028546546F, 0.9030877954F, 0.9033205841F,
  0.9035530210F, 0.9037851059F, 0.9040168392F, 0.9042482207F,
  0.9044792507F, 0.9047099293F, 0.9049402564F, 0.9051702323F,
  0.9053998569F, 0.9056291305F, 0.9058580531F, 0.9060866248F,
  0.9063148457F, 0.9065427159F, 0.9067702355F, 0.9069974046F,
  0.9072242233F, 0.9074506917F, 0.9076768100F, 0.9079025782F,
  0.9081279964F, 0.9083530647F, 0.9085777833F, 0.9088021523F,
  0.9090261717F, 0.9092498417F, 0.9094731623F, 0.9096961338F,
  0.9099187561F, 0.9101410295F, 0.9103629540F, 0.9105845297F,
  0.9108057568F, 0.9110266354F, 0.9112471656F, 0.9114673475F,
  0.9116871812F, 0.9119066668F, 0.9121258046F, 0.9123445945F,
  0.9125630367F, 0.9127811314F, 0.9129988786F, 0.9132162785F,
  0.9134333312F, 0.9136500368F, 0.9138663954F, 0.9140824073F,
  0.9142980724F, 0.9145133910F, 0.9147283632F, 0.9149429890F,
  0.9151572687F, 0.9153712023F, 0.9155847900F, 0.9157980319F,
  0.9160109282F, 0.9162234790F, 0.9164356844F, 0.9166475445F,
  0.9168590595F, 0.9170702296F, 0.9172810548F, 0.9174915354F,
  0.9177016714F, 0.9179114629F, 0.9181209102F, 0.9183300134F,
  0.9185387726F, 0.9187471879F, 0.9189552595F, 0.9191629876F,
  0.9193703723F, 0.9195774136F, 0.9197841119F, 0.9199904672F,
  0.9201964797F, 0.9204021495F, 0.9206074767F, 0.9208124616F,
  0.9210171043F, 0.9212214049F, 0.9214253636F, 0.9216289805F,
  0.9218322558F, 0.9220351896F, 0.9222377821F, 0.9224400335F,
  0.9226419439F, 0.9228435134F, 0.9230447423F, 0.9232456307F,
  0.9234461787F, 0.9236463865F, 0.9238462543F, 0.9240457822F,
  0.9242449704F, 0.9244438190F, 0.9246423282F, 0.9248404983F,
  0.9250383293F, 0.9252358214F, 0.9254329747F, 0.9256297896F,
  0.9258262660F, 0.9260224042F, 0.9262182044F, 0.9264136667F,
  0.9266087913F, 0.9268035783F, 0.9269980280F, 0.9271921405F,
  0.9273859160F, 0.9275793546F, 0.9277724566F, 0.9279652221F,
  0.9281576513F, 0.9283497443F, 0.9285415014F, 0.9287329227F,
  0.9289240084F, 0.9291147586F, 0.9293051737F, 0.9294952536F,
  0.9296849987F, 0.9298744091F, 0.9300634850F, 0.9302522266F,
  0.9304406340F, 0.9306287074F, 0.9308164471F, 0.9310038532F,
  0.9311909259F, 0.9313776654F, 0.9315640719F, 0.9317501455F,
  0.9319358865F, 0.9321212951F, 0.9323063713F, 0.9324911155F,
  0.9326755279F, 0.9328596085F, 0.9330433577F, 0.9332267756F,
  0.9334098623F, 0.9335926182F, 0.9337750434F, 0.9339571380F,
  0.9341389023F, 0.9343203366F, 0.9345014409F, 0.9346822155F,
  0.9348626606F, 0.9350427763F, 0.9352225630F, 0.9354020207F,
  0.9355811498F, 0.9357599503F, 0.9359384226F, 0.9361165667F,
  0.9362943830F, 0.9364718716F, 0.9366490327F, 0.9368258666F,
  0.9370023733F, 0.9371785533F, 0.9373544066F, 0.9375299335F,
  0.9377051341F, 0.9378800087F, 0.9380545576F, 0.9382287809F,
  0.9384026787F, 0.9385762515F, 0.9387494993F, 0.9389224223F,
  0.9390950209F, 0.9392672951F, 0.9394392453F, 0.9396108716F,
  0.9397821743F, 0.9399531536F, 0.9401238096F, 0.9402941427F,
  0.9404641530F, 0.9406338407F, 0.9408032061F, 0.9409722495F,
  0.9411409709F, 0.9413093707F, 0.9414774491F, 0.9416452062F,
  0.9418126424F, 0.9419797579F, 0.9421465528F, 0.9423130274F,
  0.9424791819F, 0.9426450166F, 0.9428105317F, 0.9429757274F,
  0.9431406039F, 0.9433051616F, 0.9434694005F, 0.9436333209F,
  0.9437969232F, 0.9439602074F, 0.9441231739F, 0.9442858229F,
  0.9444481545F, 0.9446101691F, 0.9447718669F, 0.9449332481F,
  0.9450943129F, 0.9452550617F, 0.9454154945F, 0.9455756118F,
  0.9457354136F, 0.9458949003F, 0.9460540721F, 0.9462129292F,
  0.9463714719F, 0.9465297003F, 0.9466876149F, 0.9468452157F,
  0.9470025031F, 0.9471594772F, 0.9473161384F, 0.9474724869F,
  0.9476285229F, 0.9477842466F, 0.9479396584F, 0.9480947585F,
  0.9482495470F, 0.9484040243F, 0.9485581906F, 0.9487120462F,
  0.9488655913F, 0.9490188262F, 0.9491717511F, 0.9493243662F,
  0.9494766718F, 0.9496286683F, 0.9497803557F, 0.9499317345F,
  0.9500828047F, 0.9502335668F, 0.9503840209F, 0.9505341673F,
  0.9506840062F, 0.9508335380F, 0.9509827629F, 0.9511316810F,
  0.9512802928F, 0.9514285984F, 0.9515765982F, 0.9517242923F,
  0.9518716810F, 0.9520187646F, 0.9521655434F, 0.9523120176F,
  0.9524581875F, 0.9526040534F, 0.9527496154F, 0.9528948739F,
  0.9530398292F, 0.9531844814F, 0.9533288310F, 0.9534728780F,
  0.9536166229F, 0.9537600659F, 0.9539032071F, 0.9540460470F,
  0.9541885858F, 0.9543308237F, 0.9544727611F, 0.9546143981F,
  0.9547557351F, 0.9548967723F, 0.9550375100F, 0.9551779485F,
  0.9553180881F, 0.9554579290F, 0.9555974714F, 0.9557367158F,
  0.9558756623F, 0.9560143112F, 0.9561526628F, 0.9562907174F,
  0.9564284752F, 0.9565659366F, 0.9567031017F, 0.9568399710F,
  0.9569765446F, 0.9571128229F, 0.9572488061F, 0.9573844944F,
  0.9575198883F, 0.9576549879F, 0.9577897936F, 0.9579243056F,
  0.9580585242F, 0.9581924497F, 0.9583260824F, 0.9584594226F,
  0.9585924705F, 0.9587252264F, 0.9588576906F, 0.9589898634F,
  0.9591217452F, 0.9592533360F, 0.9593846364F, 0.9595156465F,
  0.9596463666F, 0.9597767971F, 0.9599069382F, 0.9600367901F,
  0.9601663533F, 0.9602956279F, 0.9604246143F, 0.9605533128F,
  0.9606817236F, 0.9608098471F, 0.9609376835F, 0.9610652332F,
  0.9611924963F, 0.9613194733F, 0.9614461644F, 0.9615725699F,
  0.9616986901F, 0.9618245253F, 0.9619500757F, 0.9620753418F,
  0.9622003238F, 0.9623250219F, 0.9624494365F, 0.9625735679F,
  0.9626974163F, 0.9628209821F, 0.9629442656F, 0.9630672671F,
  0.9631899868F, 0.9633124251F, 0.9634345822F, 0.9635564585F,
  0.9636780543F, 0.9637993699F, 0.9639204056F, 0.9640411616F,
  0.9641616383F, 0.9642818359F, 0.9644017549F, 0.9645213955F,
  0.9646407579F, 0.9647598426F, 0.9648786497F, 0.9649971797F,
  0.9651154328F, 0.9652334092F, 0.9653511095F, 0.9654685337F,
  0.9655856823F, 0.9657025556F, 0.9658191538F, 0.9659354773F,
  0.9660515263F, 0.9661673013F, 0.9662828024F, 0.9663980300F,
  0.9665129845F, 0.9666276660F, 0.9667420750F, 0.9668562118F,
  0.9669700766F, 0.9670836698F, 0.9671969917F, 0.9673100425F,
  0.9674228227F, 0.9675353325F, 0.9676475722F, 0.9677595422F,
  0.9678712428F, 0.9679826742F, 0.9680938368F, 0.9682047309F,
  0.9683153569F, 0.9684257150F, 0.9685358056F, 0.9686456289F,
  0.9687551853F, 0.9688644752F, 0.9689734987F, 0.9690822564F,
  0.9691907483F, 0.9692989750F, 0.9694069367F, 0.9695146337F,
  0.9696220663F, 0.9697292349F, 0.9698361398F, 0.9699427813F,
  0.9700491597F, 0.9701552754F, 0.9702611286F, 0.9703667197F,
  0.9704720490F, 0.9705771169F, 0.9706819236F, 0.9707864695F,
  0.9708907549F, 0.9709947802F, 0.9710985456F, 0.9712020514F,
  0.9713052981F, 0.9714082859F, 0.9715110151F, 0.9716134862F,
  0.9717156993F, 0.9718176549F, 0.9719193532F, 0.9720207946F,
  0.9721219794F, 0.9722229080F, 0.9723235806F, 0.9724239976F,
  0.9725241593F, 0.9726240661F, 0.9727237183F, 0.9728231161F,
  0.9729222601F, 0.9730211503F, 0.9731197873F, 0.9732181713F,
  0.9733163027F, 0.9734141817F, 0.9735118088F, 0.9736091842F,
  0.9737063083F, 0.9738031814F, 0.9738998039F, 0.9739961760F,
  0.9740922981F, 0.9741881706F, 0.9742837938F, 0.9743791680F,
  0.9744742935F, 0.9745691707F, 0.9746637999F, 0.9747581814F,
  0.9748523157F, 0.9749462029F, 0.9750398435F, 0.9751332378F,
  0.9752263861F, 0.9753192887F, 0.9754119461F, 0.9755043585F,
  0.9755965262F, 0.9756884496F, 0.9757801291F, 0.9758715650F,
  0.9759627575F, 0.9760537071F, 0.9761444141F, 0.9762348789F,
  0.9763251016F, 0.9764150828F, 0.9765048228F, 0.9765943218F,
  0.9766835802F, 0.9767725984F, 0.9768613767F, 0.9769499154F,
  0.9770382149F, 0.9771262755F, 0.9772140976F, 0.9773016815F,
  0.9773890275F, 0.9774761360F, 0.9775630073F, 0.9776496418F,
  0.9777360398F, 0.9778222016F, 0.9779081277F, 0.9779938182F,
  0.9780792736F, 0.9781644943F, 0.9782494805F, 0.9783342326F,
  0.9784187509F, 0.9785030359F, 0.9785870877F, 0.9786709069F,
  0.9787544936F, 0.9788378484F, 0.9789209714F, 0.9790038631F,
  0.9790865238F, 0.9791689538F, 0.9792511535F, 0.9793331232F,
  0.9794148633F, 0.9794963742F, 0.9795776561F, 0.9796587094F,
  0.9797395345F, 0.9798201316F, 0.9799005013F, 0.9799806437F,
  0.9800605593F, 0.9801402483F, 0.9802197112F, 0.9802989483F,
  0.9803779600F, 0.9804567465F, 0.9805353082F, 0.9806136455F,
  0.9806917587F, 0.9807696482F, 0.9808473143F, 0.9809247574F,
  0.9810019778F, 0.9810789759F, 0.9811557519F, 0.9812323064F,
  0.9813086395F, 0.9813847517F, 0.9814606433F, 0.9815363147F,
  0.9816117662F, 0.9816869981F, 0.9817620108F, 0.9818368047F,
  0.9819113801F, 0.9819857374F, 0.9820598769F, 0.9821337989F,
  0.9822075038F, 0.9822809920F, 0.9823542638F, 0.9824273195F,
  0.9825001596F, 0.9825727843F, 0.9826451940F, 0.9827173891F,
  0.9827893700F, 0.9828611368F, 0.9829326901F, 0.9830040302F,
  0.9830751574F, 0.9831460720F, 0.9832167745F, 0.9832872652F,
  0.9833575444F, 0.9834276124F, 0.9834974697F, 0.9835671166F,
  0.9836365535F, 0.9837057806F, 0.9837747983F, 0.9838436071F,
  0.9839122072F, 0.9839805990F, 0.9840487829F, 0.9841167591F,
  0.9841845282F, 0.9842520903F, 0.9843194459F, 0.9843865953F,
  0.9844535389F, 0.9845202771F, 0.9845868101F, 0.9846531383F,
  0.9847192622F, 0.9847851820F, 0.9848508980F, 0.9849164108F,
  0.9849817205F, 0.9850468276F, 0.9851117324F, 0.9851764352F,
  0.9852409365F, 0.9853052366F, 0.9853693358F, 0.9854332344F,
  0.9854969330F, 0.9855604317F, 0.9856237309F, 0.9856868310F,
  0.9857497325F, 0.9858124355F, 0.9858749404F, 0.9859372477F,
  0.9859993577F, 0.9860612707F, 0.9861229871F, 0.9861845072F,
  0.9862458315F, 0.9863069601F, 0.9863678936F, 0.9864286322F,
  0.9864891764F, 0.9865495264F, 0.9866096826F, 0.9866696454F,
  0.9867294152F, 0.9867889922F, 0.9868483769F, 0.9869075695F,
  0.9869665706F, 0.9870253803F, 0.9870839991F, 0.9871424273F,
  0.9872006653F, 0.9872587135F, 0.9873165721F, 0.9873742415F,
  0.9874317222F, 0.9874890144F, 0.9875461185F, 0.9876030348F,
  0.9876597638F, 0.9877163057F, 0.9877726610F, 0.9878288300F,
  0.9878848130F, 0.9879406104F, 0.9879962225F, 0.9880516497F,
  0.9881068924F, 0.9881619509F, 0.9882168256F, 0.9882715168F,
  0.9883260249F, 0.9883803502F, 0.9884344931F, 0.9884884539F,
  0.9885422331F, 0.9885958309F, 0.9886492477F, 0.9887024838F,
  0.9887555397F, 0.9888084157F, 0.9888611120F, 0.9889136292F,
  0.9889659675F, 0.9890181273F, 0.9890701089F, 0.9891219128F,
  0.9891735392F, 0.9892249885F, 0.9892762610F, 0.9893273572F,
  0.9893782774F, 0.9894290219F, 0.9894795911F, 0.9895299853F,
  0.9895802049F, 0.9896302502F, 0.9896801217F, 0.9897298196F,
  0.9897793443F, 0.9898286961F, 0.9898778755F, 0.9899268828F,
  0.9899757183F, 0.9900243823F, 0.9900728753F, 0.9901211976F,
  0.9901693495F, 0.9902173314F, 0.9902651436F, 0.9903127865F,
  0.9903602605F, 0.9904075659F, 0.9904547031F, 0.9905016723F,
  0.9905484740F, 0.9905951086F, 0.9906415763F, 0.9906878775F,
  0.9907340126F, 0.9907799819F, 0.9908257858F, 0.9908714247F,
  0.9909168988F, 0.9909622086F, 0.9910073543F, 0.9910523364F,
  0.9910971552F, 0.9911418110F, 0.9911863042F, 0.9912306351F,
  0.9912748042F, 0.9913188117F, 0.9913626580F, 0.9914063435F,
  0.9914498684F, 0.9914932333F, 0.9915364383F, 0.9915794839F,
  0.9916223703F, 0.9916650981F, 0.9917076674F, 0.9917500787F,
  0.9917923323F, 0.9918344286F, 0.9918763679F, 0.9919181505F,
  0.9919597769F, 0.9920012473F, 0.9920425621F, 0.9920837217F,
  0.9921247263F, 0.9921655765F, 0.9922062724F, 0.9922468145F,
  0.9922872030F, 0.9923274385F, 0.9923675211F, 0.9924074513F,
  0.9924472294F, 0.9924868557F, 0.9925263306F, 0.9925656544F,
  0.9926048275F, 0.9926438503F, 0.9926827230F, 0.9927214461F,
  0.9927600199F, 0.9927984446F, 0.9928367208F, 0.9928748486F,
  0.9929128285F, 0.9929506608F, 0.9929883459F, 0.9930258841F,
  0.9930632757F, 0.9931005211F, 0.9931376207F, 0.9931745747F,
  0.9932113836F, 0.9932480476F, 0.9932845671F, 0.9933209425F,
  0.9933571742F, 0.9933932623F, 0.9934292074F, 0.9934650097F,
  0.9935006696F, 0.9935361874F, 0.9935715635F, 0.9936067982F,
  0.9936418919F, 0.9936768448F, 0.9937116574F, 0.9937463300F,
  0.9937808629F, 0.9938152565F, 0.9938495111F, 0.9938836271F,
  0.9939176047F, 0.9939514444F, 0.9939851465F, 0.9940187112F,
  0.9940521391F, 0.9940854303F, 0.9941185853F, 0.9941516044F,
  0.9941844879F, 0.9942172361F, 0.9942498495F, 0.9942823283F,
  0.9943146729F, 0.9943468836F, 0.9943789608F, 0.9944109047F,
  0.9944427158F, 0.9944743944F, 0.9945059408F, 0.9945373553F,
  0.9945686384F, 0.9945997902F, 0.9946308112F, 0.9946617017F,
  0.9946924621F, 0.9947230926F, 0.9947535937F, 0.9947839656F,
  0.9948142086F, 0.9948443232F, 0.9948743097F, 0.9949041683F,
  0.9949338995F, 0.9949635035F, 0.9949929807F, 0.9950223315F,
  0.9950515561F, 0.9950806549F, 0.9951096282F, 0.9951384764F,
  0.9951671998F, 0.9951957987F, 0.9952242735F, 0.9952526245F,
  0.9952808520F, 0.9953089564F, 0.9953369380F, 0.9953647971F,
  0.9953925340F, 0.9954201491F, 0.9954476428F, 0.9954750153F,
  0.9955022670F, 0.9955293981F, 0.9955564092F, 0.9955833003F,
  0.9956100720F, 0.9956367245F, 0.9956632582F, 0.9956896733F,
  0.9957159703F, 0.9957421494F, 0.9957682110F, 0.9957941553F,
  0.9958199828F, 0.9958456937F, 0.9958712884F, 0.9958967672F,
  0.9959221305F, 0.9959473784F, 0.9959725115F, 0.9959975300F,
  0.9960224342F, 0.9960472244F, 0.9960719011F, 0.9960964644F,
  0.9961209148F, 0.9961452525F, 0.9961694779F, 0.9961935913F,
  0.9962175930F, 0.9962414834F, 0.9962652627F, 0.9962889313F,
  0.9963124895F, 0.9963359377F, 0.9963592761F, 0.9963825051F,
  0.9964056250F, 0.9964286361F, 0.9964515387F, 0.9964743332F,
  0.9964970198F, 0.9965195990F, 0.9965420709F, 0.9965644360F,
  0.9965866946F, 0.9966088469F, 0.9966308932F, 0.9966528340F,
  0.9966746695F, 0.9966964001F, 0.9967180260F, 0.9967395475F,
  0.9967609651F, 0.9967822789F, 0.9968034894F, 0.9968245968F,
  0.9968456014F, 0.9968665036F, 0.9968873037F, 0.9969080019F,
  0.9969285987F, 0.9969490942F, 0.9969694889F, 0.9969897830F,
  0.9970099769F, 0.9970300708F, 0.9970500651F, 0.9970699601F,
  0.9970897561F, 0.9971094533F, 0.9971290522F, 0.9971485531F,
  0.9971679561F, 0.9971872617F, 0.9972064702F, 0.9972255818F,
  0.9972445968F, 0.9972635157F, 0.9972823386F, 0.9973010659F,
  0.9973196980F, 0.9973382350F, 0.9973566773F, 0.9973750253F,
  0.9973932791F, 0.9974114392F, 0.9974295059F, 0.9974474793F,
  0.9974653599F, 0.9974831480F, 0.9975008438F, 0.9975184476F,
  0.9975359598F, 0.9975533806F, 0.9975707104F, 0.9975879495F,
  0.9976050981F, 0.9976221566F, 0.9976391252F, 0.9976560043F,
  0.9976727941F, 0.9976894950F, 0.9977061073F, 0.9977226312F,
  0.9977390671F, 0.9977554152F, 0.9977716759F, 0.9977878495F,
  0.9978039361F, 0.9978199363F, 0.9978358501F, 0.9978516780F,
  0.9978674202F, 0.9978830771F, 0.9978986488F, 0.9979141358F,
  0.9979295383F, 0.9979448566F, 0.9979600909F, 0.9979752417F,
  0.9979903091F, 0.9980052936F, 0.9980201952F, 0.9980350145F,
  0.9980497515F, 0.9980644067F, 0.9980789804F, 0.9980934727F,
  0.9981078841F, 0.9981222147F, 0.9981364649F, 0.9981506350F,
  0.9981647253F, 0.9981787360F, 0.9981926674F, 0.9982065199F,
  0.9982202936F, 0.9982339890F, 0.9982476062F, 0.9982611456F,
  0.9982746074F, 0.9982879920F, 0.9983012996F, 0.9983145304F,
  0.9983276849F, 0.9983407632F, 0.9983537657F, 0.9983666926F,
  0.9983795442F, 0.9983923208F, 0.9984050226F, 0.9984176501F,
  0.9984302033F, 0.9984426827F, 0.9984550884F, 0.9984674208F,
  0.9984796802F, 0.9984918667F, 0.9985039808F, 0.9985160227F,
  0.9985279926F, 0.9985398909F, 0.9985517177F, 0.9985634734F,
  0.9985751583F, 0.9985867727F, 0.9985983167F, 0.9986097907F,
  0.9986211949F, 0.9986325297F, 0.9986437953F, 0.9986549919F,
  0.9986661199F, 0.9986771795F, 0.9986881710F, 0.9986990946F,
  0.9987099507F, 0.9987207394F, 0.9987314611F, 0.9987421161F,
  0.9987527045F, 0.9987632267F, 0.9987736829F, 0.9987840734F,
  0.9987943985F, 0.9988046584F, 0.9988148534F, 0.9988249838F,
  0.9988350498F, 0.9988450516F, 0.9988549897F, 0.9988648641F,
  0.9988746753F, 0.9988844233F, 0.9988941086F, 0.9989037313F,
  0.9989132918F, 0.9989227902F, 0.9989322269F, 0.9989416021F,
  0.9989509160F, 0.9989601690F, 0.9989693613F, 0.9989784931F,
  0.9989875647F, 0.9989965763F, 0.9990055283F, 0.9990144208F,
  0.9990232541F, 0.9990320286F, 0.9990407443F, 0.9990494016F,
  0.9990580008F, 0.9990665421F, 0.9990750257F, 0.9990834519F,
  0.9990918209F, 0.9991001331F, 0.9991083886F, 0.9991165877F,
  0.9991247307F, 0.9991328177F, 0.9991408491F, 0.9991488251F,
  0.9991567460F, 0.9991646119F, 0.9991724232F, 0.9991801801F,
  0.9991878828F, 0.9991955316F, 0.9992031267F, 0.9992106684F,
  0.9992181569F, 0.9992255925F, 0.9992329753F, 0.9992403057F,
  0.9992475839F, 0.9992548101F, 0.9992619846F, 0.9992691076F,
  0.9992761793F, 0.9992832001F, 0.9992901701F, 0.9992970895F,
  0.9993039587F, 0.9993107777F, 0.9993175470F, 0.9993242667F,
  0.9993309371F, 0.9993375583F, 0.9993441307F, 0.9993506545F,
  0.9993571298F, 0.9993635570F, 0.9993699362F, 0.9993762678F,
  0.9993825519F, 0.9993887887F, 0.9993949785F, 0.9994011216F,
  0.9994072181F, 0.9994132683F, 0.9994192725F, 0.9994252307F,
  0.9994311434F, 0.9994370107F, 0.9994428327F, 0.9994486099F,
  0.9994543423F, 0.9994600303F, 0.9994656739F, 0.9994712736F,
  0.9994768294F, 0.9994823417F, 0.9994878105F, 0.9994932363F,
  0.9994986191F, 0.9995039592F, 0.9995092568F, 0.9995145122F,
  0.9995197256F, 0.9995248971F, 0.9995300270F, 0.9995351156F,
  0.9995401630F, 0.9995451695F, 0.9995501352F, 0.9995550604F,
  0.9995599454F, 0.9995647903F, 0.9995695953F, 0.9995743607F,
  0.9995790866F, 0.9995837734F, 0.9995884211F, 0.9995930300F,
  0.9995976004F, 0.9996021324F, 0.9996066263F, 0.9996110822F,
  0.9996155004F, 0.9996198810F, 0.9996242244F, 0.9996285306F,
  0.9996327999F, 0.9996370326F, 0.9996412287F, 0.9996453886F,
  0.9996495125F, 0.9996536004F, 0.9996576527F, 0.9996616696F,
  0.9996656512F, 0.9996695977F, 0.9996735094F, 0.9996773865F,
  0.9996812291F, 0.9996850374F, 0.9996888118F, 0.9996925523F,
  0.9996962591F, 0.9996999325F, 0.9997035727F, 0.9997071798F,
  0.9997107541F, 0.9997142957F, 0.9997178049F, 0.9997212818F,
  0.9997247266F, 0.9997281396F, 0.9997315209F, 0.9997348708F,
  0.9997381893F, 0.9997414767F, 0.9997447333F, 0.9997479591F,
  0.9997511544F, 0.9997543194F, 0.9997574542F, 0.9997605591F,
  0.9997636342F, 0.9997666797F, 0.9997696958F, 0.9997726828F,
  0.9997756407F, 0.9997785698F, 0.9997814703F, 0.9997843423F,
  0.9997871860F, 0.9997900016F, 0.9997927894F, 0.9997955494F,
  0.9997982818F, 0.9998009869F, 0.9998036648F, 0.9998063157F,
  0.9998089398F, 0.9998115373F, 0.9998141082F, 0.9998166529F,
  0.9998191715F, 0.9998216642F, 0.9998241311F, 0.9998265724F,
  0.9998289884F, 0.9998313790F, 0.9998337447F, 0.9998360854F,
  0.9998384015F, 0.9998406930F, 0.9998429602F, 0.9998452031F,
  0.9998474221F, 0.9998496171F, 0.9998517885F, 0.9998539364F,
  0.9998560610F, 0.9998581624F, 0.9998602407F, 0.9998622962F,
  0.9998643291F, 0.9998663394F, 0.9998683274F, 0.9998702932F,
  0.9998722370F, 0.9998741589F, 0.9998760591F, 0.9998779378F,
  0.9998797952F, 0.9998816313F, 0.9998834464F, 0.9998852406F,
  0.9998870141F, 0.9998887670F, 0.9998904995F, 0.9998922117F,
  0.9998939039F, 0.9998955761F, 0.9998972285F, 0.9998988613F,
  0.9999004746F, 0.9999020686F, 0.9999036434F, 0.9999051992F,
  0.9999067362F, 0.9999082544F, 0.9999097541F, 0.9999112354F,
  0.9999126984F, 0.9999141433F, 0.9999155703F, 0.9999169794F,
  0.9999183709F, 0.9999197449F, 0.9999211014F, 0.9999224408F,
  0.9999237631F, 0.9999250684F, 0.9999263570F, 0.9999276289F,
  0.9999288843F, 0.9999301233F, 0.9999313461F, 0.9999325529F,
  0.9999337437F, 0.9999349187F, 0.9999360780F, 0.9999372218F,
  0.9999383503F, 0.9999394635F, 0.9999405616F, 0.9999416447F,
  0.9999427129F, 0.9999437665F, 0.9999448055F, 0.9999458301F,
  0.9999468404F, 0.9999478365F, 0.9999488185F, 0.9999497867F,
  0.9999507411F, 0.9999516819F, 0.9999526091F, 0.9999535230F,
  0.9999544236F, 0.9999553111F, 0.9999561856F, 0.9999570472F,
  0.9999578960F, 0.9999587323F, 0.9999595560F, 0.9999603674F,
  0.9999611666F, 0.9999619536F, 0.9999627286F, 0.9999634917F,
  0.9999642431F, 0.9999649828F, 0.9999657110F, 0.9999664278F,
  0.9999671334F, 0.9999678278F, 0.9999685111F, 0.9999691835F,
  0.9999698451F, 0.9999704960F, 0.9999711364F, 0.9999717662F,
  0.9999723858F, 0.9999729950F, 0.9999735942F, 0.9999741834F,
  0.9999747626F, 0.9999753321F, 0.9999758919F, 0.9999764421F,
  0.9999769828F, 0.9999775143F, 0.9999780364F, 0.9999785495F,
  0.9999790535F, 0.9999795485F, 0.9999800348F, 0.9999805124F,
  0.9999809813F, 0.9999814417F, 0.9999818938F, 0.9999823375F,
  0.9999827731F, 0.9999832005F, 0.9999836200F, 0.9999840316F,
  0.9999844353F, 0.9999848314F, 0.9999852199F, 0.9999856008F,
  0.9999859744F, 0.9999863407F, 0.9999866997F, 0.9999870516F,
  0.9999873965F, 0.9999877345F, 0.9999880656F, 0.9999883900F,
  0.9999887078F, 0.9999890190F, 0.9999893237F, 0.9999896220F,
  0.9999899140F, 0.9999901999F, 0.9999904796F, 0.9999907533F,
  0.9999910211F, 0.9999912830F, 0.9999915391F, 0.9999917896F,
  0.9999920345F, 0.9999922738F, 0.9999925077F, 0.9999927363F,
  0.9999929596F, 0.9999931777F, 0.9999933907F, 0.9999935987F,
  0.9999938018F, 0.9999940000F, 0.9999941934F, 0.9999943820F,
  0.9999945661F, 0.9999947456F, 0.9999949206F, 0.9999950912F,
  0.9999952575F, 0.9999954195F, 0.9999955773F, 0.9999957311F,
  0.9999958807F, 0.9999960265F, 0.9999961683F, 0.9999963063F,
  0.9999964405F, 0.9999965710F, 0.9999966979F, 0.9999968213F,
  0.9999969412F, 0.9999970576F, 0.9999971707F, 0.9999972805F,
  0.9999973871F, 0.9999974905F, 0.9999975909F, 0.9999976881F,
  0.9999977824F, 0.9999978738F, 0.9999979624F, 0.9999980481F,
  0.9999981311F, 0.9999982115F, 0.9999982892F, 0.9999983644F,
  0.9999984370F, 0.9999985072F, 0.9999985750F, 0.9999986405F,
  0.9999987037F, 0.9999987647F, 0.9999988235F, 0.9999988802F,
  0.9999989348F, 0.9999989873F, 0.9999990379F, 0.9999990866F,
  0.9999991334F, 0.9999991784F, 0.9999992217F, 0.9999992632F,
  0.9999993030F, 0.9999993411F, 0.9999993777F, 0.9999994128F,
  0.9999994463F, 0.9999994784F, 0.9999995091F, 0.9999995384F,
  0.9999995663F, 0.9999995930F, 0.9999996184F, 0.9999996426F,
  0.9999996657F, 0.9999996876F, 0.9999997084F, 0.9999997282F,
  0.9999997469F, 0.9999997647F, 0.9999997815F, 0.9999997973F,
  0.9999998123F, 0.9999998265F, 0.9999998398F, 0.9999998524F,
  0.9999998642F, 0.9999998753F, 0.9999998857F, 0.9999998954F,
  0.9999999045F, 0.9999999130F, 0.9999999209F, 0.9999999282F,
  0.9999999351F, 0.9999999414F, 0.9999999472F, 0.9999999526F,
  0.9999999576F, 0.9999999622F, 0.9999999664F, 0.9999999702F,
  0.9999999737F, 0.9999999769F, 0.9999999798F, 0.9999999824F,
  0.9999999847F, 0.9999999868F, 0.9999999887F, 0.9999999904F,
  0.9999999919F, 0.9999999932F, 0.9999999943F, 0.9999999953F,
  0.9999999961F, 0.9999999969F, 0.9999999975F, 0.9999999980F,
  0.9999999985F, 0.9999999988F, 0.9999999991F, 0.9999999993F,
  0.9999999995F, 0.9999999997F, 0.9999999998F, 0.9999999999F,
  0.9999999999F, 1.0000000000F, 1.0000000000F, 1.0000000000F,
  1.0000000000F, 1.0000000000F, 1.0000000000F, 1.0000000000F,
};

static const float floor1_inverse_db_table[256]={
  1.0649863e-07F, 1.1341951e-07F, 1.2079015e-07F, 1.2863978e-07F,
  1.3699951e-07F, 1.4590251e-07F, 1.5538408e-07F, 1.6548181e-07F,
  1.7623575e-07F, 1.8768855e-07F, 1.9988561e-07F, 2.128753e-07F,
  2.2670913e-07F, 2.4144197e-07F, 2.5713223e-07F, 2.7384213e-07F,
  2.9163793e-07F, 3.1059021e-07F, 3.3077411e-07F, 3.5226968e-07F,
  3.7516214e-07F, 3.9954229e-07F, 4.2550680e-07F, 4.5315863e-07F,
  4.8260743e-07F, 5.1396998e-07F, 5.4737065e-07F, 5.8294187e-07F,
  6.2082472e-07F, 6.6116941e-07F, 7.0413592e-07F, 7.4989464e-07F,
  7.9862701e-07F, 8.5052630e-07F, 9.0579828e-07F, 9.6466216e-07F,
  1.0273513e-06F, 1.0941144e-06F, 1.1652161e-06F, 1.2409384e-06F,
  1.3215816e-06F, 1.4074654e-06F, 1.4989305e-06F, 1.5963394e-06F,
  1.7000785e-06F, 1.8105592e-06F, 1.9282195e-06F, 2.0535261e-06F,
  2.1869758e-06F, 2.3290978e-06F, 2.4804557e-06F, 2.6416497e-06F,
  2.8133190e-06F, 2.9961443e-06F, 3.1908506e-06F, 3.3982101e-06F,
  3.6190449e-06F, 3.8542308e-06F, 4.1047004e-06F, 4.3714470e-06F,
  4.6555282e-06F, 4.9580707e-06F, 5.2802740e-06F, 5.6234160e-06F,
  5.9888572e-06F, 6.3780469e-06F, 6.7925283e-06F, 7.2339451e-06F,
  7.7040476e-06F, 8.2047000e-06F, 8.7378876e-06F, 9.3057248e-06F,
  9.9104632e-06F, 1.0554501e-05F, 1.1240392e-05F, 1.1970856e-05F,
  1.2748789e-05F, 1.3577278e-05F, 1.4459606e-05F, 1.5399272e-05F,
  1.6400004e-05F, 1.7465768e-05F, 1.8600792e-05F, 1.9809576e-05F,
  2.1096914e-05F, 2.2467911e-05F, 2.3928002e-05F, 2.5482978e-05F,
  2.7139006e-05F, 2.8902651e-05F, 3.0780908e-05F, 3.2781225e-05F,
  3.4911534e-05F, 3.7180282e-05F, 3.9596466e-05F, 4.2169667e-05F,
  4.4910090e-05F, 4.7828601e-05F, 5.0936773e-05F, 5.4246931e-05F,
  5.7772202e-05F, 6.1526565e-05F, 6.5524908e-05F, 6.9783085e-05F,
  7.4317983e-05F, 7.9147585e-05F, 8.4291040e-05F, 8.9768747e-05F,
  9.5602426e-05F, 0.00010181521F, 0.00010843174F, 0.00011547824F,
  0.00012298267F, 0.00013097477F, 0.00013948625F, 0.00014855085F,
  0.00015820453F, 0.00016848555F, 0.00017943469F, 0.00019109536F,
  0.00020351382F, 0.00021673929F, 0.00023082423F, 0.00024582449F,
  0.00026179955F, 0.00027881276F, 0.00029693158F, 0.00031622787F,
  0.00033677814F, 0.00035866388F, 0.00038197188F, 0.00040679456F,
  0.00043323036F, 0.00046138411F, 0.00049136745F, 0.00052329927F,
  0.00055730621F, 0.00059352311F, 0.00063209358F, 0.00067317058F,
  0.00071691700F, 0.00076350630F, 0.00081312324F, 0.00086596457F,
  0.00092223983F, 0.00098217216F, 0.0010459992F, 0.0011139742F,
  0.0011863665F, 0.0012634633F, 0.0013455702F, 0.0014330129F,
  0.0015261382F, 0.0016253153F, 0.0017309374F, 0.0018434235F,
  0.0019632195F, 0.0020908006F, 0.0022266726F, 0.0023713743F,
  0.0025254795F, 0.0026895994F, 0.0028643847F, 0.0030505286F,
  0.0032487691F, 0.0034598925F, 0.0036847358F, 0.0039241906F,
  0.0041792066F, 0.0044507950F, 0.0047400328F, 0.0050480668F,
  0.0053761186F, 0.0057254891F, 0.0060975636F, 0.0064938176F,
  0.0069158225F, 0.0073652516F, 0.0078438871F, 0.0083536271F,
  0.0088964928F, 0.009474637F, 0.010090352F, 0.010746080F,
  0.011444421F, 0.012188144F, 0.012980198F, 0.013823725F,
  0.014722068F, 0.015678791F, 0.016697687F, 0.017782797F,
  0.018938423F, 0.020169149F, 0.021479854F, 0.022875735F,
  0.024362330F, 0.025945531F, 0.027631618F, 0.029427276F,
  0.031339626F, 0.033376252F, 0.035545228F, 0.037855157F,
  0.040315199F, 0.042935108F, 0.045725273F, 0.048696758F,
  0.051861348F, 0.055231591F, 0.058820850F, 0.062643361F,
  0.066714279F, 0.071049749F, 0.075666962F, 0.080584227F,
  0.085821044F, 0.091398179F, 0.097337747F, 0.10366330F,
  0.11039993F, 0.11757434F, 0.12521498F, 0.13335215F,
  0.14201813F, 0.15124727F, 0.16107617F, 0.17154380F,
  0.18269168F, 0.19456402F, 0.20720788F, 0.22067342F,
  0.23501402F, 0.25028656F, 0.26655159F, 0.28387361F,
  0.30232132F, 0.32196786F, 0.34289114F, 0.36517414F,
  0.38890521F, 0.41417847F, 0.44109412F, 0.46975890F,
  0.50028648F, 0.53279791F, 0.56742212F, 0.60429640F,
  0.64356699F, 0.68538959F, 0.72993007F, 0.77736504F,
  0.82788260F, 0.88168307F, 0.9389798F, 1.F,
};

