<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head>
<meta content="text/html; charset=ISO-8859-1" http-equiv="Content-Type" />
<!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Utiliser mod_rewrite pour le contrle d'accs - Serveur Apache HTTP Version 2.4</title>
<link href="../style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="../style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="../style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" /><link rel="stylesheet" type="text/css" href="../style/css/prettify.css" />
<script src="../style/scripts/prettify.min.js" type="text/javascript">
</script>

<link href="../images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.4</p>
<img alt="" src="../images/feather.png" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="../images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="../">Version 2.4</a> &gt; <a href="./">Rewrite</a></div><div id="page-content"><div id="preamble"><h1>Utiliser mod_rewrite pour le contrle d'accs</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/access.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/access.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div>


<p>Ce document est un complment  la <a href="../mod/mod_rewrite.html">documentation de rfrence</a> de
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code>. Il explique comment utiliser
<code class="module"><a href="../mod/mod_rewrite.html">mod_rewrite</a></code> pour contrler l'accs  diverses
ressources, ainsi que d'autres techniques en rapport. Il contient de
nombreux exemples d'utilisation courante de mod_rewrite avec une
description dtaille de leur fonctionnement.</p>

<div class="warning">Vous devez vous attacher  comprendre le
fonctionnement des exemples, car la plupart d'entre eux ne
fonctionneront pas sur votre systme si vous vous contentez de les
copier/coller dans vos fichiers de configuration.</div>

</div>
<div id="quickview"><ul id="toc"><li><img alt="" src="../images/down.gif" /> <a href="#blocked-inline-images">Blocage du rfrencement  chaud (Hotlinking) d'images</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#blocking-of-robots">Blocage des robots</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#host-deny">Rejet des clients contenus dans une liste noire</a></li>
<li><img alt="" src="../images/down.gif" /> <a href="#referer-deflector">Aiguillage bas sur l'en-tte Referer</a></li>
</ul><h3>Voir aussi</h3><ul class="seealso"><li><a href="../mod/mod_rewrite.html">Documentation du module mod_rewrite</a></li><li><a href="intro.html">Introduction  mod_rewrite</a></li><li><a href="remapping.html">Redirection et remise en
correspondance</a></li><li><a href="vhosts.html">Serveurs virtuels</a></li><li><a href="proxy.html">Serveurs mandataires</a></li><li><a href="rewritemap.html">Utilisation de RewriteMap</a></li><li><a href="advanced.html">Techniques avances</a></li><li><a href="avoid.html">Quand ne pas utiliser mod_rewrite</a></li><li><a href="#comments_section">Commentaires</a></li></ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="blocked-inline-images" id="blocked-inline-images">Blocage du rfrencement  chaud (Hotlinking) d'images</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
          <p>Cette technique vous permet d'interdire  d'autres sites
	  d'inclure directement vos images dans leurs pages. On fait
	  souvent rfrence  cette pratique sous le nom de
	  rfrencement  chaud (Hotlinking) qui entrane l'utilisation
	  de votre bande passante pour servir des contenus faisant
	  partie du site de quelqu'un d'autre.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
	<p>Cette technique repose sur la valeur de la variable
	optionnelle <code>HTTP_REFERER</code>. Certaines personnes
	pourront donc contourner cette limitation. Pour la plupart des
	utilisateurs cependant, la requte chouera, en ce sens que
	l'image ne sera pas affiche depuis le site tiers.</p>
	<p>Il y a plusieurs manires de grer cette situation.</p>

	<p>Dans le premier exemple, nous rejetons tout simplement la
	requte si elle ne provenait pas d'une page appartenant  notre
	site. Pour les besoins de cet exemple, nous supposons que le nom
	de votre site est <code>www.example.com</code>.</p>



<pre class="prettyprint lang-config">RewriteCond "%{HTTP_REFERER}" "!^$"
RewriteCond "%{HTTP_REFERER}" "!www.example.com" [NC]
RewriteRule "\.(gif|jpg|png)$"    "-"   [F,NC]</pre>


	<p>Dans le second exemple, plutt que de rejeter la requte,
	nous affichons une autre image  la place.</p>

<pre class="prettyprint lang-config">RewriteCond "%{HTTP_REFERER}" "!^$"
RewriteCond "%{HTTP_REFERER}" "!www.example.com" [NC]
RewriteRule "\.(gif|jpg|png)$"    "/images/go-away.png"   [R,NC]</pre>


	<p>Dans le troisime exemple, nous redirigeons la requte vers
	une image appartenant  un autre site.</p>

<pre class="prettyprint lang-config">RewriteCond "%{HTTP_REFERER}" "!^$"
RewriteCond "%{HTTP_REFERER}" "!www.example.com" [NC]
RewriteRule "\.(gif|jpg|png)$" "http://other.example.com/image.gif"   [R,NC]</pre>


	<p>De tous ces exemples, les deux derniers semblent les plus
	efficaces pour faire en sorte que les gens arrtent de
	rfrencer vos images  chaud, car il ne verront pas les images
	qu'ils s'attendent  voir.</p>

        </dd>

        <dt>Discussion :</dt>

        <dd>
        <p>Si vous ne voulez pas rediriger la requte, mais
	simplement interdire l'accs  la ressource, vous pouvez y
	parvenir sans utiliser mod_rewrite :</p>

        <pre class="prettyprint lang-config">SetEnvIf Referer "example\.com" localreferer
&lt;FilesMatch "\.(jpg|png|gif)$"&gt;
    Require env localreferer
&lt;/FilesMatch&gt;</pre>

        </dd>
      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="blocking-of-robots" id="blocking-of-robots">Blocage des robots</a></h2>

      

      <dl>
        <dt>Description :</dt>

        <dd>
        <p>
        Dans cet exemple, nous allons discuter d'une mthode permettant
	de bloquer les requtes persistentes en provenance d'un robot
	particulier, ou d'un navigateur.</p>

        <p>La mthode classique pour exclure un robot consiste  dfinir
	un fichier, <code>/robots.txt</code> qui spcifie les parties de
	votre site web pour lesquelles vous voulez exclure les robots.
	Malheureusement, certains robots ne tiennent pas compte de ces
	fichiers.
        </p>

        <p>Notez qu'il existe des mthodes d'exclusion qui n'utilisent
	pas mod_rewrite. Notez aussi que toute technique qui repose sur
	le contenu de la chane client <code>USER_AGENT</code> peut tre
	contourne trs facilement car cette chane peut tre modifie.</p>
        </dd>

        <dt>Solution :</dt>

        <dd>
        <p>On utilise un jeu de rgles qui spcifie le rpertoire 
	protger, ainsi que la chane client <code>USER_AGENT</code> qui
	identifie le robot malin ou envahissant.</p>

        <p>Dans cet exemple, nous bloquons un robot nomm
	<code>Vilain_Robot</code> pour le rpertoire
	<code>/secret/fichiers</code>. Si vous voulez bloquer ce client
	seulement depuis une source particulire, vous pouvez aussi
	spcifier un intervalle d'adresses IP.</p>

<pre class="prettyprint lang-config">RewriteCond "%{HTTP_USER_AGENT}"   "^NameOfBadRobot"
RewriteCond "%{REMOTE_ADDR}"       "=123\.45\.67\.[8-9]"
RewriteRule "^/secret/files/"   "-"   [F]</pre>

        </dd>

      <dt>Discussion :</dt>

      <dd>
      <p>
        Vous pouvez cependant parvenir au mme rsultat sans utiliser
	mod_rewrite via la mthode alternative suivante :
      </p>
      <pre class="prettyprint lang-config">SetEnvIfNoCase User-Agent "^NameOfBadRobot" goaway
&lt;Location "/secret/files"&gt;
    &lt;RequireAll&gt;
        Require all granted
        Require not env goaway
    &lt;/RequireAll&gt;
&lt;/Location&gt;</pre>

      <p>
      Comme indiqu plus haut, il est ais de contourner cette
      technique, simplement en modifiant le contenu de l'en-tte
      <code>USER_AGENT</code>. Si vous subissez une attaque en rgle,
      vous allez devoir rflchir  un blocage  un niveau suprieur,
      par exemple une rgle de filtrage de votre pare-feu.
      </p>

      </dd>

      </dl>

    </div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="host-deny" id="host-deny">Rejet des clients contenus dans une liste noire</a></h2>

  

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Nous voulons interdire l'accs  notre serveur aux clients
      contenus dans une liste noire similaire 
      <code>hosts.deny</code>.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
<pre class="prettyprint lang-config">RewriteEngine on
RewriteMap    hosts-deny  "txt:/path/to/hosts.deny"
RewriteCond   "${hosts-deny:%{REMOTE_ADDR}|NOT-FOUND}" "!=NOT-FOUND" [OR]
RewriteCond   "${hosts-deny:%{REMOTE_HOST}|NOT-FOUND}" "!=NOT-FOUND"
RewriteRule   "^"  "-"  [F]</pre>


<div class="example"><p><code>
##<br />
##  hosts.deny<br />
##<br />
##  ATTENTION! Ceci est une table de correspondances, non une liste,<br />
##		mme si elle est traite comme telle. mod_rewrite<br />
##		l'interprte comme une liste de paires cl/valeur, et<br />
##		chaque entre doit au moins possder une valeur par<br />
##		dfaut "-".<br />
<br />
193.102.180.41 -<br />
bsdti1.sdm.de  -<br />
192.76.162.40  -<br />
</code></p></div>
    </dd>

    <dt>Discussion :</dt>
    <dd>
    <p>
    La seconde condition RewriteCond prsuppose que HostNameLookups est
    dfini  On, de faon  ce que les adresses IP des clients puissent
    tre rsolues. Dans le cas contraire, vous devez supprimer la
    seconde condition, ainsi que le drapeau <code>[OR]</code> de la
    premire.
    </p>
    </dd>
  </dl>

</div><div class="top"><a href="#page-header"><img alt="top" src="../images/up.gif" /></a></div>
<div class="section">
<h2><a name="referer-deflector" id="referer-deflector">Aiguillage bas sur l'en-tte Referer</a></h2>

  

  <dl>
    <dt>Description :</dt>

    <dd>
      <p>Redirige les requtes en fonction du Referer de provenance de
      la requte, avec des cibles diffrentes pour chaque Referer.</p>
    </dd>

    <dt>Solution :</dt>

    <dd>
  <p>Le jeu de rgles suivant utilise un fichier de correspondances pour
  associer chaque Referer  une cible de redirection.</p>

<pre class="prettyprint lang-config">RewriteMap  deflector "txt:/path/to/deflector.map"

RewriteCond "%{HTTP_REFERER}" !=""
RewriteCond "${deflector:%{HTTP_REFERER}}" "=-"
RewriteRule "^" "%{HTTP_REFERER}" [R,L]

RewriteCond "%{HTTP_REFERER}" !=""
RewriteCond "${deflector:%{HTTP_REFERER}|NOT-FOUND}" "!=NOT-FOUND"
RewriteRule "^" "${deflector:%{HTTP_REFERER}}" [R,L]</pre>


      <p>Le fichier de correspondances contient les cibles de
      redirection associes  chaque Referer, ou, si nous voulons
      simplement rediriger les requtes vers leur Referer, un "-" est
      inscrit dans le fichier de correspondances :</p>

<pre class="prettyprint lang-config">##
##  deflector.map
##

http://badguys.example.com/bad/index.html    -
http://badguys.example.com/bad/index2.html   -
http://badguys.example.com/bad/index3.html   http://somewhere.example.com/</pre>


    </dd>
  </dl>

</div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="../en/rewrite/access.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="../fr/rewrite/access.html" title="Franais">&nbsp;fr&nbsp;</a></p>
</div><div class="top"><a href="#page-header"><img src="../images/up.gif" alt="top" /></a></div><div class="section"><h2><a id="comments_section" name="comments_section">Commentaires</a></h2><div class="warning"><strong>Notice:</strong><br />This is not a Q&amp;A section. Comments placed here should be pointed towards suggestions on improving the documentation or server, and may be removed again by our moderators if they are either implemented or considered invalid/off-topic. Questions on how to manage the Apache HTTP Server should be directed at either our IRC channel, #httpd, on Freenode, or sent to our <a href="http://httpd.apache.org/lists.html">mailing lists</a>.</div>
<script type="text/javascript"><!--//--><![CDATA[//><!--
var comments_shortname = 'httpd';
var comments_identifier = 'http://httpd.apache.org/docs/2.4/rewrite/access.html';
(function(w, d) {
    if (w.location.hostname.toLowerCase() == "httpd.apache.org") {
        d.write('<div id="comments_thread"><\/div>');
        var s = d.createElement('script');
        s.type = 'text/javascript';
        s.async = true;
        s.src = 'https://comments.apache.org/show_comments.lua?site=' + comments_shortname + '&page=' + comments_identifier;
        (d.getElementsByTagName('head')[0] || d.getElementsByTagName('body')[0]).appendChild(s);
    }
    else { 
        d.write('<div id="comments_thread">Comments are disabled for this page at the moment.<\/div>');
    }
})(window, document);
//--><!]]></script></div><div id="footer">
<p class="apache">Copyright 2016 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="../mod/">Modules</a> | <a href="../mod/directives.html">Directives</a> | <a href="http://wiki.apache.org/httpd/FAQ">FAQ</a> | <a href="../glossary.html">Glossaire</a> | <a href="../sitemap.html">Plan du site</a></p></div><script type="text/javascript"><!--//--><![CDATA[//><!--
if (typeof(prettyPrint) !== 'undefined') {
    prettyPrint();
}
//--><!]]></script>
</body></html>