/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "core/dom/DocumentEncodingData.h"

#include "core/html/parser/TextResourceDecoder.h"

namespace blink {

DocumentEncodingData::DocumentEncodingData()
    : m_encoding(UTF8Encoding())
    , m_wasDetectedHeuristically(false)
    , m_attemptedToDetermineEncodingFromContentSniffing(false)
    , m_encodingWasDetectedFromContentSniffing(false)
    , m_sawDecodingError(false)
{
}

DocumentEncodingData::DocumentEncodingData(const TextResourceDecoder& decoder)
{
    m_encoding = decoder.encoding();
    m_wasDetectedHeuristically = decoder.encodingWasDetectedHeuristically();
    m_attemptedToDetermineEncodingFromContentSniffing = decoder.attemptedToDetermineEncodingFromContentSniffing();
    m_encodingWasDetectedFromContentSniffing = decoder.encodingWasDetectedFromContentSniffing();
    m_sawDecodingError = decoder.sawError();
}

void DocumentEncodingData::setEncoding(const WTF::TextEncoding& encoding)
{
    m_encoding = encoding;
}

} // namespace blink
