// HyperRogue Russian translation, by green orange <khadaev98@gmail.com>
// Copyright (C) 2011-2016 Zeno Rogue, see 'hyper.cpp' for details

// This translation file is encoded with UTF-8

// Nouns.

// For each noun in English, provide:

// 1) the type (usually gender) of the noun. For example, in Polish each noun can be:

// masculine living (GEN_M),
// masculine object (GEN_O), 
// feminine (GEN_F), or 
// neuter (GEN_N).

// 2) all the forms required by HyperRogue. For example, in Polish the following are
// given:
// The following forms are given:
// nominative (referred to as %1), 
// nominative plural (%P1), 
// accusative (%a1),
// ablative (%abl1) (for land names, locative "in/on..." is given instead of ablative). 

// Feel free to add more or less forms or types if needed. Note that you don't
// have to provide all the forms in your language, only those used by HyperRogue
// (in Polish just 4 of 14 forms are used, and this is probably similar in other
// languages).

// monsters
N("Yeti", GEN_M, "Йети", "Йети", "Йети", "Йети")
N("Icewolf", GEN_M, "Ледяной волк", "Ледяные волки", "Ледяного волка", "Ледяным волком")
N("Ranger",  GEN_M, "Странник", "Странники", "Странника", "Странником")
N("Rock Troll", GEN_M, "Горный тролль", "Горные тролли", "Горного Тролля", "Горным троллем")
N("Goblin", GEN_M, "Гоблин", "Гоблины", "Гоблина", "Гоблином")
N("Sand Worm", GEN_M, "Пустынный червь", "Пустынные черви", "Пустынного червя", "Пустынным червём")
N("Sand Worm Tail", GEN_M, "Хвост червя", "Хвосты червя", "Хвоста червя", "Хвостом червя")
N("Sand Worm W", GEN_M, "Пустынный червь W", "Пустынные черви W", "Пустынного червя W", "Пустынным червём W")
N("Desert Man", GEN_M, "Человек пустыни", "Люди пустыни", "Человека пустыни", "Человеком пустыни")
N("Ivy Root", GEN_O, "Корень плюща", "Корни плюща", "Корень плюща", "Корнем плюща")
N("Active Ivy", GEN_O, "Активный плющ", "Активные плющи", "Активный плющ", "Активным плющом")
N("Ivy Branch", GEN_F, "Ветвь плюща", "Ветви плюща", "Ветвь плюща", "Ветвью плюща")
N("Dormant Ivy", GEN_O, "Спящий плющ", "Спящие плющи", "Спящий плющ", "Спящим плющом")
N("Ivy N", GEN_O, "Плющ N", "Плющи N", "Плющ N", "Плющом N")
N("Ivy D", GEN_O, "Плющ D", "Плющи D", "Плющ D", "Плющом D")
N("Giant Ape", GEN_F, "Огромная обезьяна", "Огромные обезьяны", "Огромную обезьяну", "Огромной обезьяной")
N("Slime Beast", GEN_F, "Живая слизь", "Живая слизь", "Живую слизь", "Живой слизью")
N("Mirror Image", GEN_N, "Зеркальное отражение", "Зеркальные отражения", "Зеркальное отражение", "Зеркальным отражением")
N("Mirage", GEN_O, "Мираж", "Миражи", "Мираж", "Миражом")
N("Golem", GEN_M, "Голем", "Големы", "Голема", "Големом")
N("Eagle", GEN_M, "Орёл", "Орлы", "Орла", "Орлом")
N("Seep", GEN_M, "Горный призрак", "Горные призраки", "Горного призрака", "Горным призраком")
N("Zombie", GEN_M, "Зомби", "Зомби", "Зомби", "Зомби")
N("Ghost", GEN_M, "Дух", "Духи", "Духа", "Духом")
N("Necromancer", GEN_M, "Некромант", "Некроманты", "Некроманта", "Некромантом")
N("Shadow", GEN_F, "Тень", "Тени", "Тень", "Тенью")
N("Tentacle", GEN_N, "Щупальце", "Щупальца", "Щупальце", "Щупальцем")
N("Tentacle Tail", GEN_O, "Хвост щупальца", "Хвосты щупальца", "Хвост щупальца", "Хвостом щупальца")
N("Tentacle W", GEN_N, "Щупальце W", "Щупальца W", "Щупальце W", "Щупальцем W")
N("Tentacle (withdrawing)", GEN_N, "Щупальце (исчезает)", "Щупальца(исчезает)", "Щупальце(исчезает)", "Щупальцем(исчезает)")
N("Cultist", GEN_M, "Культист", "Культисты", "Культиста", "Культистом")
N("Fire Cultist", GEN_M, "Огненный культист", "Огненные культисты", "Огненного культиста", "Огненным культистом")
N("Greater Demon", GEN_M, "Старший демон", "Старшие демоны", "Старшего демона", "Старшим демоном")
N("Lesser Demon", GEN_M, "Младший демон", "Младшие демоны", "Младшего демона", "Младшим демоном")
N("Ice Shark", GEN_F, "Ледяная акула", "Ледяные акулы", "Ледяную акулу", "Ледяной акулой")
N("Running Dog", GEN_F, "Бегущая собака", "Бегущие собаки", "Бегущую собаку", "Бегущей собакой")
N("Demon Shark", GEN_F, "Акула-демон", "Акулы-демоны", "Акулу-демона", "Акулой-демоном")
N("Fire Fairy", GEN_F, "Огненная фея", "Огненный феи", "Огненную фею", "Огненной феей")
N("Crystal Sage", GEN_M, "Кристальный мудрец", "Кристальные мудрецы", "Кристального мудреца", "Кристальным мудрецом")
N("Hedgehog Warrior", GEN_M, "Ёж-воин", "Ежи-воины", "Ежа-воина", "Ежом-воином")
// items
N("Ice Diamond", GEN_O, "Ледяной алмаз", "Ледяные алмазы", "Ледяной алмаз", "Ледяным алмазом")
N("Gold", GEN_N, "Золото", "Золото", "Золото", "Золотом")
N("Spice", GEN_F, "Пряность", "Пряности", "Пряность", "Пряностью")
N("Ruby", GEN_O, "Рубин", "Рубины", "Рубин", "Рубином")
N("Elixir of Life", GEN_O, "Эликсир жизни", "Эликсиры жизни", "Эликсир жизни", "Эликсиром жизни")
N("Shard", GEN_O, "Осколок", "Осколки", "Осколок", "Осколком")
N("Necromancer's Totem", GEN_O, "Тотем некроманта", "Тотемы некроманта", "Тотем некроманта", "Тотемом некроманта")
N("Demon Daisy", GEN_F, "Адская ромашка", "Адские ромашки", "Адскую ромашку", "Адской ромашкой")
N("Statue of Cthulhu", GEN_F, "Статуя Ктулху", "Статуи Ктулху", "Статую Ктулху", "Статуей Ктулху")
N("Phoenix Feather", GEN_N, "Перо феникса", "Перья феникса", "Перо феникса", "Пером феникса")
N("Ice Sapphire", GEN_O, "Ледяной сапфир", "Ледяные сапфиры", "Ледяной сапфир", "Ледяным сапфиром")
N("Hyperstone", GEN_O, "Гиперкамень", "Гиперкамни", "Гиперкамень", "Гиперкамнем")
N("Key", GEN_O, "Ключ", "Ключи", "Ключ", "Ключом")
N("Dead Orb", GEN_F, "Мёртвая сфера", "Мёртвые сферы", "Мёртвую сферу", "Мёртвой сферой")
N("Fern Flower", GEN_O, "Цветок папоротника", "Цветы папоротника", "Цветок папоротника", "Цветком папоротника")
// orbs: we are using a macro here
#define Orb(E, P) N("Orb of " E, GEN_F, "Сфера " P, "Сферы " P, "Сферу " P, "Сферой " P)
Orb("Yendor", "Йендора")
Orb("Storms", "Бури")
Orb("Flash", "Вспышки")
Orb("Winter", "Зимы")
Orb("Speed", "Скорости")
Orb("Life", "Жизни")
Orb("Shielding", "Щита")
Orb("Teleport", "Телепорта")
Orb("Safety", "Безопасности")
Orb("Thorns", "Шипов")
// terrain features
N("none", GEN_N, "ничто", "ничто", "ничего", "ничем")
N("ice wall", GEN_F, "ледяная стена", "ледяные стены", "ледяную стену", "ледяной стеной")
N("great wall", GEN_F, "великая стена", "великие стены", "великую стену", "великой стеной")
N("red slime", GEN_F, "красная слизь", "красная слизь", "красную слизь", "красной слизью")
N("blue slime", GEN_F, "синяя слизь", "синяя слизь", "синюю слизь", "синей слизью")
N("living wall", GEN_F, "живая стена", "живые стены", "живую стену", "живой стеной")
N("living floor", GEN_O, "живой пол", "живые полы", "живой пол", "живым полом")
N("dead troll", GEN_M, "мёртвый тролль" ,"мёртвые тролли", "мёртвого тролля", "мёртвым троллем")
N("sand dune", GEN_F, "дюна", "дюны", "дюну", "дюной")
N("Magic Mirror", GEN_N, "Волшебное зеркало", "Волшебные зеркала", "Волшебное зеркало", "Волшебным зеркалом")
N("Cloud of Mirage", GEN_N, "Облако миражей", "Облака миражей", "Облако миражей", "Облаком миражей")
N("Thumper", GEN_O, "Тампер", "Тамперы", "Тампер", "Тампером")
N("Bonfire", GEN_O, "Костёр", "Костры", "Костёр", "Костром")
N("ancient grave", GEN_F, "древняя могила", "древние могилы", "древнюю могилу", "древней могилой")
N("fresh grave", GEN_F, "свежая могила", "свежие могилы", "свежую могилу", "свежей могилой")
N("column", GEN_F, "колонна", "колонны", "колонну", "колонной")
N("lake of sulphur", GEN_N, "озеро серы", "озёра серы", "озеро серы", "озером серы")
N("lake", GEN_N, "озеро", "озёра", "озеро", "озером")
N("frozen lake", GEN_N, "замёрзшее озеро", "замёрзшие озёра", "замёрзшее озеро", "замёрзшим озером")
N("chasm", GEN_F, "пропасть", "пропасти", "пропасть", "пропастью")
N("big tree", GEN_N, "большое дерево", "большие деревья", "большое дерево", "большим деревом")
N("tree", GEN_N, "дерево", "деревья", "дерево", "деревом")
// lands
N("Great Wall", GEN_F, "Великая стена", "Великие стены", "Великую стену", "на Великой стене")
N("Crossroads", GEN_O, "Перекрёсток", "Перекрёстки", "Перекрёсток", "на Перекрёстке")
N("Desert", GEN_F, "Пустыня", "Пустыни", "Пустыню", "в Пустыне")
N("Icy Land", GEN_F, "Ледяная земля", "Ледяные земли", "Ледяную землю", "в Ледяной земле")
N("Living Cave", GEN_F, "Живая Пещера", "Живые Пещеры", "Живую Пещеру", "в Живой Пещере")
N("Jungle", GEN_N, "Джунгли", "Джунгли", "Джунгли", "в Джунглях")
N("Alchemist Lab", GEN_F, "Лаборатория", "Лаборатории", "Лабораторию", "в Лаборатории")
N("Mirror Land", GEN_F, "Зеркальная земля", "Зеркальные земли", "Зеркальную землю", "в Зеркальной земле")
N("Graveyard", GEN_N, "Кладбище", "Кладбища", "Кладбище", "на Кладбище")
N("R'Lyeh", GEN_O, "Р'Льех", "Р'Льех", "Р'Льех", "в Р'Льехе")
N("Hell", GEN_O, "Ад", "Ад", "Ад", "в Аду")
N("Cocytus", GEN_O, "Коцит", "Коцит", "Коцит", "в Коците")
N("Land of Eternal Motion", GEN_F, "Земля Вечного Движения", "Земли Вечного Движения", "Землю Вечного Движения", "в Земле Вечного Движения")
N("Dry Forest", GEN_O, "Сухой Лес", "Сухие Леса", "Сухой Лес", "в Сухом Лесу")
N("Game Board", GEN_F, "Игровая Доска", "Игровые Доски", "Игровую Доску", "на Игровой Доске")

// Game messages

// fighting messages

// For each English form, provide a Polish form. Player is referred to via %...0, 
// and objects are referred to via %...1 and %...2. For example, in Polish:

// %a1 refers to the accusative form of the first object (as explained above in 'Nouns')
// likewise, %a2 refers to the accusative form of the second object
// %E1 is replaced by "Е‚", "Е‚o" or "Е‚a", depending on the gender of %1
// %EeЕ›0 adds "Е‚eЕ›" or "Е‚aЕ›" depending on the gender of the player

// Use whatever %xxx# codes you need for your language. Of course, 
// tell me how your codes should be expanded.

S("You kill %the1.", "Вы убили %a1.")
S("You would be killed by %the1!", "Вас убьёт %1!")
S("%The1 would get you!", "%1 уничтожит вас здесь!")
S("%The1 destroys %the2!", "%1 уничтожил%E1 %a2!")
S("%The1 eats %the2!", "%1 съел%E1 %a2!")
S("The ivy destroys %the1!", "Плющ уничтожил %a1!")
S("%The1 claws %the2!", "%1 атаковал%E1 %a2!")
S("%The1 scares %the2!", "%1 пугает %a2!")
S("%The1 melts away!", "%1 тает!")
S("%The1 stabs %the2.", "%1 заколол%E1 %a2.")
S("You stab %the1.", "Вы закололи %a1.")

S("You cannot attack %the1 directly!", "Вы не можете напасть на %a1!")
S("Stab them by walking around them.", "Нападите на него сбоку.")

S("You feel more experienced in demon fighting!", "Теперь Вы более опытны в борьбе с демонами!")
S("Cthulhu withdraws his tentacle!", "Ктулху забирает свой щупальце!")
S("The sandworm explodes in a cloud of Spice!", "Червь взорвался и стал облаком специй")
S("%The1 is confused!", "%1 в замешательстве")
S("%The1 raises some undead!", "%1 восстал из мёртвых!")
S("%The1 throws fire at you!", "%1 бросил в Вас огнём!")
S("%The1 shows you two fingers.", "%1 показал%E1 Вам два пальца.")
S("You wonder what does it mean?", "Вы спросите, а что это значит?")
S("%The1 shows you a finger.", "%1 показал%E1 Вам палец.")
S("You think about possible meanings.", "Вы думаете о возможном значении.")
S("%The1 moves his finger downwards.", "%1 опустил%E1 свои пальцы.")
S("Your brain is steaming.", "Ваш мозг дымится.")
S("%The1 destroys %the2!", "%1 уничтожил%E1 %a2!")
S("You join %the1.", "Вы встретились с %abl1.")
S("Two of your images crash and disappear!", "Два Ваших двойника столкнулись и уничтожились!")
S("%The1 breaks the mirror!", "%1 разбил%E1 зеркало!")
S("%The1 disperses the cloud!", "%1 рассеял%E1 облако!")
S("You activate the Flash spell!", "Вы активировали заклинание вспышки!")
S("You activate the Lightning spell!", "Вы активировали заклинание молнии!")
S("Ice below you is melting! RUN!", "Лёд под Вами тает! БЕГИТЕ!")
S("This spot will be burning soon! RUN!", "Земля под Вами загорается! БЕГИТЕ!")
S("The floor has collapsed! RUN!", "Пол рухнул! БЕГИТЕ!")
S("You need to find the right Key to unlock this Orb of Yendor!", 
  "Вам нужен ключ, чтобы открыть сферу Йендора!")
S("You fall into a wormhole!", "Вы упали в червоточину!")
S("You activate %the1.", "Вы активировали %a1.")
S("No room to push %the1.", "Нет места, чтобы толкать %a1.")
S("You push %the1.", "Вы толкнули %a1.")
S("You start cutting down the tree.", "Вы начали рубить дерево.")
S("You cut down the tree.", "Вы срубили дерево.")
S("You cannot attack Sandworms directly!", "Вы не можете атаковать песчаных червей!")
S("You cannot attack Tentacles directly!", "Вы не можете атаковать щупальца Ктулху!")
S("You cannot defeat the Shadow!", "Вы не можете убить свою тень!")
S("You cannot defeat the Greater Demon yet!", "Вы пока не можете победить Старшего демона!")
S("That was easy, but groups could be dangerous.", "Они слабы, но в стае могут быть опасны.")
S("Good to know that your fighting skills serve you well in this strange world.", "Полезно знать, что Ваши боевые навыки неплохо работают в этом странном мире.")
S("You wonder where all these monsters go, after their death...", "Вы задаётесь вопросом, куда же деваются эти монстры после смерти?")
S("You feel that the souls of slain enemies pull you to the Graveyard...", "Вы чувствуете, как души убитых врагов тянут Вас на Кладбище.")
S("Wrong color!", "Не тот цвет!")
S("You cannot move through %the1!", "Вы не можете пройти через %a1!")
S("%The1 would kill you there!", "%1 убьёт Вас здесь!")
S("Wow! %1! This trip should be worth it!", "%1! А это путешествие стоит того!")
S("For now, collect as much treasure as possible...", "Соберите столько сокровищ, сколько сможете...")
S("Prove yourself here, then find new lands, with new quests...", "Проверь себя здесь, а потом ищи новые земли с новыми миссиями")
S("You collect your first %1!", "Вы нашли перв%A1 %a1!")
S("You have found the Key! Now unlock this Orb of Yendor!", "Вы нашли ключ! Откройте им сферу Йендора!")
S("This orb is dead...", "Эта сфера мертва...")
S("Another Dead Orb.", "Ещё одна мёртвая сфера.")
S("You have found %the1!", "Вы нашли %a1!")
S("You feel that %the2 become%s2 more dangerous.", "Вы чувствуете, что находиться %abl2 всё опаснее.")
S("With each %1 you collect...", "С каждым собранным %abl1...")
S("Are there any magical orbs in %the1?...", "Есть ли какие-нибудь сферы %abl1?")
S("You feel that %the1 slowly become%s1 dangerous...", "Вы чувствуете, что %1 становится всё опаснее...")
S("Better find some other place.", "Лучше отправьтесь в другое место.")
S("You have a vision of the future, fighting demons in Hell...", "Вы видите себя в будущем, убивающего демонов в Аду...")
S("With this Elixir, your life should be long and prosperous...", "С этим эликсиром Ваша жизнь будет долгой и процветающей...")
S("The Necromancer's Totem contains hellish incantations...", "Тотем некроманта содержит адские заклинания...")
S("The inscriptions on the Statue of Cthulhu point you toward your destiny...", "Надписи на статуе Ктулху показывают Вам Вашу судьбу...")
S("Still, even greater treasures lie ahead...", "Большая часть сокровищ ещё впереди...")
S("You collect %the1.", "Вы нашли %a1.")
S("CONGRATULATIONS!", "ПОЗДРАВЛЯЕМ!")
S("Collect treasure to access more different lands...", "Собирайте сокровища, чтобы найти новые земли...")
S("You feel that you have enough treasure to access new lands!", "Вы чувствуете, что у Вас достаточно сокровищ, чтобы открыть новые земли!")
S("Collect more treasures, there are still more lands waiting...", "Собирайте больше сокровищ, ещё много земель Вас ждут...")
S("You feel that the stars are right, and you can access R'Lyeh!", "Вы чувствуете, что звёзды правы, Вы можете открыть Р'Льех!")
S("Kill monsters and collect treasures, and you may get access to Hell...", "Убивайте монстров и собирайте сокровища, и Вы сможете открыть Ад...")
S("To access Hell, collect 10 treasures each of 9 kinds...", "Чтобы открыть Ад, соберите по 10 сокровищ из 9 различных мест...")
S("Abandon all hope, the gates of Hell are opened!", "Оставь надежду, врата Ада открылись!")
S("And the Orbs of Yendor await!", "Шары Йендора ждут!")
S("You switch places with %the1.", "Вы поменялись местами с %abl1.")
S("You rejoin %the1.", "Вы воссоединились с %abl1.")
S("The mirror shatters!", "Зеркало разбилось!")
S("The cloud turns into a bunch of images!", "Облако превратилось в группу изображений!")
S("The slime reacts with %the1!", "Слизь реагирует с %abl1!")
S("You drop %the1.", "Вы выкинули %a1.")
S("You feel great, like a true treasure hunter.", "Вы чувствуете себя как прекрасный охотник за сокровищами.")
S("Your eyes shine like gems.", "Ваши глаза сияют, как драгоценные камни.")
S("Your eyes shine as you glance at your precious treasures.", "Ваши глаза сверкают, когда Вы смотрите на свои драгоценности.")
S("You glance at your great treasures.", "Вы смотрите на ваши громадные сокровища.")
S("You glance at your precious treasures.", "Вы смотрите на ваши драгоценные сокровища.")
S("You glance at your precious treasure.", "Вы смотрите на ваше драгоценное сокровище.")
S("Your inventory is empty.", "Ваш инвентарь пуст.")
S("You teleport to a new location!", "Вы телепортировались в новое место!")
S("Could not open the score file: ", "Невозможно открыть файл с результатами: ")
S("Game statistics saved to %1", "Статистика игры записана в %1")
S("Game loaded.", "Игра сохранена.")
S("You summon some Mimics!", "Вы призвали миражи!")
S("You summon a golem!", "Вы призвали голема!")
S("You will now start your games in %1", "Теперь вы начинаете игру %abl1")
S("Activated the Hyperstone Quest!", "Активирована миссия Гиперкамней!")
S("Orb power depleted!", "Сила сферы исчерпана!")
S("Orbs summoned!", "Сферы призваны!")
S("Orb power gained!", "Сила сферы получена!")
S("Dead orbs gained!", "Мёртвые сферы получены!")
S("Orb of Yendor gained!", "Сферы Йендора получены!")
S("Treasure gained!", "Сокровища получены!")
S("Lots of treasure gained!", "Много сокровищ получено!")
S("You summon a sandworm!", "Вы призвали червя!")
S("You summon an Ivy!", "Вы призвали плющ!")
S("You summon a monster!", "Вы призвали монстра!")
S("You summon some Thumpers!", "Вы призвали тамперы!")
S("You summon a bonfire!", "Вы призвали костры!")
S("Treasure lost!", "Сокровища потеряны!")
S("Kills gained!", "Убийства получены!")
S("Activated Orb of Safety!", "Активирована сфера безопасности!")
S("Teleported to %1!", "Вы телепортированы %abl1")

S("Welcome to HyperRogue", "Добро пожаловать в HyperRogue")
S(" for Android", " на Android")
S(" for iOS", " на iOS")
S("! (version %1)\n\n", "! (версия %1)\n\n")
S(" (press ESC for some hints about it).", " (нажмите ESC, чтобы получить подсказки).")
S("Press 'c' for credits.", "Нажмите 'c', чтобы узнать авторов.")
S("game design, programming, texts and graphics by Zeno Rogue <zeno@attnam.com>\n\n",
  "проект, программирование, тексты и графика: Zeno Rogue <zeno@attnam.com>\n\n")
S("add credits for your translation here", "Перевод: green orange <khadaev98@gmail.com>\n\n")
S(" (touch to activate)", " (коснитесь, чтобы активировать)")
S(" (expired)", " (кончился)")
S(" [%1 turns]", " [ходов: %1]")
S(", you", ", Вы")
S("0 = Klein model, 1 = Poincaré model", "0 = модель Клейна, 1 = модель Пуанкаре")
S("you are looking through it!", "взгляните на гиперболоид!")
S("simply resize the window to change resolution", "просто поменяйте размер окна чтобы сменить разрешение")
S("[+] keep the window size, [-] use the screen resolution", "[+] фиксирует размер окна, [-] использует разрешение экрана")
S("+5 = center instantly, -5 = do not center the map", "+5 = центрировать сразу, -5 = не центрировать")
S("press Space or Home to center on the PC", "Нажмите Пробел или Home, чтобы отцентрировать экран на персонаже.")
S("You need special glasses to view the game in 3D", "Вам нужны специальные очки, чтобы видеть игру в 3D")
S("You can choose one of the several modes", "Вы можете выбрать один из нескольких режимов")
S("ASCII", "ASCII")
S("black", "чёрный")
S("plain", "простой")
S("Escher", "Эшер")
S("items only", "только предметы")
S("items and monsters", "предметы и монстры")
S("no axes", "без осей")
S("auto", "авто")
S("light", "легкий")
S("heavy", "тяжёлый")
S("The axes help with keyboard movement", "Оси помогают перемещаться с помощью клавиатуры")
S("Config file: %1", "Файл конфигурации: %1")
S("joystick mode: automatic (release the joystick to move)", "Режим джойстика: авто (опустите джойстик для перемещения)")
S("joystick mode: manual (press a button to move)", "Режим джойстика: ручной (нажмите на клавишу для перемещения)")
S("Reduce the framerate limit to conserve CPU energy", "Ограничить fps, чтобы сохранить энергию ЦП")
S("Press F1 or right click for help", "Нажмите F1 или ПКМ для помощи")
//"Нажмите F1 или правую кнопку мыши для получения помощи")
S("No info about this...", "Нет информации об этом...")
S("Press Enter or F10 to save", "Нажмите Enter или F10, чтобы сохраниться")
S("Press Enter or F10 to quit", "Нажмите Enter или F10, чтобы выйти")
S("or 'r' or F5 to restart", "либо 'r' или F5, чтобы начать заново")
S("or 't' to see the top scores", "либо 't', чтобы посмотреть результаты")
S("or another key to continue", "либо другую клавишу, чтобы продолжить")
S("It is a shame to cheat!", "Как Вам не стыдно!")
S("Showoff mode", "Режим показа")
S("Quest status", "Статус миссии")
S("GAME OVER", "КОНЕЦ ИГРЫ")
S("Your score: %1", "Ваш счёт: %1")
S("Enemies killed: %1", "Врагов убито: %1")
S("Orbs of Yendor found: %1", "Собрано сфер Йендора: %1")
S("Collect 30 $$$ to access more worlds", "Соберите 30 $$$, чтобы открыть новые земли")
S("Collect at least 10 treasures in each of 9 types to access Hell", "Соберите хотя бы по 10 сокровищ 9 разных типов, чтобы попасть в Ад")
S("Collect at least 10 Demon Daisies to find the Orbs of Yendor", "Соберите 10 адских ромашек, чтобы найти сферу Йендора")
S("Hyperstone Quest: collect at least 10 %1 in %the2", "Миссия Гиперкамня: соберите 10 драгоценностей в %abl2")
S("Hyperstone Quest completed!", "Миссия Гиперкамня закончена!")
S("Look for the Orbs of Yendor in Hell or in the Crossroads!", "Ищите сферы Йендора в Аду и на Перекрёстке!")
S("Unlock the Orb of Yendor!", "Откройте сферу Йендора!")
S("Defeat 100 enemies to access the Graveyard", "Убейте 100 врагов, чтобы открыть Кладбище")
S("(press ESC during the game to review your quest)", "(нажмите ESC во время игры, чтобы посмотреть ваши миссии)")
S("you have cheated %1 times", "количество читов: %1")
S("%1 turns (%2)", "ходов: %1 (%2)")
S("last messages:", "последние сообщения: ")
S("time elapsed", "время")
S("date", "дата")
S("treasure collected", "собрано сокровищ")
S("total kills", "всего убийств")
S("turn count", "ходов потрачено")
S("cells generated", "клеток сгенерировано")
S("t/left/right - change display, up/down - scroll, s - sort by", "t/левая/правая стрелки - изменить, вверх/вниз - листать, s - сортировать")
S("kills", "убийств")
S("time", "время")
S("ver", "версия")
S("SORT", "СОРТИРОВКА")
S("PLAY", "ИГРА")
S("Your total wealth", "Ваше богатство")
S("treasure collected: %1", "собрано сокровищ: %1")
S("objects found: %1", "найдено предметов: %1")
S("orb power: %1", "сила сферы: %1")
S(" (click to drop)", " (нажмите, чтобы бросить)")
S("You can also scroll to the desired location and then press 't'.", "Вы также можете пролистать в нужное месть и нажать 't'.")
S("Thus, it is potentially useful for extremely long games, which would eat all the memory on your system otherwise.\n", 
  "Это может быть полезно для крайне долгих игр, если у Вас заканчивается память.")
S("You can touch the Dead Orb in your inventory to drop it.", "Коснитесь мёртвой сферы, чтобы собрать её.")
S("This might be useful for Android devices with limited memory.", "Это может быть полезно для Android-устройств с ограниченной памятью.")
S("You can press 'g' or click them in the list to drop a Dead Orb.", "Вы можете нажать 'g' либо кликнуть на сферу в списке, чтобы бросить её.")
S("frames per second", "кадров в секунду")
S("monsters killed: %1", "монстров убито: %1")
S("Drawing %1 (layer %2), F1 for help", "Рисуем %1 (слой %2), F1 - помощь")
S("hepta floor", "семиугольный пол")
S("hexa floor", "шестиугольный пол")
S("character", "персонаж")
S("ESC for menu/quest", "ESC - меню/миссия")
S("vector graphics editor", "векторный графический редактор")
S("cheat mode", "режим обманщика")
S("heptagonal game board", "семиугольная игровая доска")
S("triangular game board", "треугольная игровая доска")
S("HyperRogue game board", "игровая доска HyperRogue")
S("first page [Space]", "первая страница [пробел]")
S("exit configuration", "выйти из настроек")
S("Configuration:", "Настройки:")
S("video resolution", "видео разрешение")
S("fullscreen mode", "полноэкранный режим")
S("animation speed", "скорость анимации")
S("dist from hyperboloid ctr", "расстояние от центра гиперболоида")
S("scale factor", "масштаб")
S("wall display mode", "режим показа стен")
S("monster display mode", "режим показа монстров")
S("cross display mode", "режим показа осей")
S("background music volume", "громкость фоновой музыки")
S("OFF", "ВЫКЛ")
S("ON", "ВКЛ")
S("distance between eyes", "расстояние между глазами")
S("framerate limit", "ограничение на fps")
S("joystick mode", "режим джойстика")
S("automatic", "авто")
S("manual", "ручной")
S("language", "язык")
S("EN", "RU")
S("player character", "Ваш персонаж")
S("male", "мужской")
S("female", "женский")
S("use Shift to decrease and Ctrl to fine tune ", "используйте Shift для уменьшения,")
S("(e.g. Shift+Ctrl+Z)", "Ctrl для тонкой настройки") // (например, Shift+Ctrl+Z)")
S("the second page [Space]", "вторая страница [Пробел]")
S("special features [Space]", "специальные опции [Пробел]")
S("exit configuration", "выйти из настроек")
S("see the help screen", "смотри экран помощи")
S("save the current config", "сохранить текущие настройки")
S("(v) config", "(v) настр.")
S("Screenshot saved to %1", "Скриншот сохранён в %1")
S("You need an Orb of Teleport to teleport.", "Вам нужна сфера телепорта для телепортации.")
S("Use arrow keys to choose the teleport location.", "С помощью стрелок выберите место для телепортации.")
S("openGL mode enabled", "режим OpenGL включен")
S("openGL mode disabled", "режим OpenGL выключен")
S("openGL & antialiasing mode", "openGL и режим сглаживания")
S("anti-aliasing enabled", "сглаживание включено")
S("anti-aliasing disabled", "сглаживание выключено")
S("You activate your demonic powers!", "Вы активировали свои демонические силы!")

// Steam achievement messages

S("New Achievement:", "Новое достижение:")
S("Your total treasure has been recorded in the Steam Leaderboards.", "Ваш общий результат занесён в таблицу Steam.")
S("Congratulations!", "Поздравляем!")
S("You have improved your total high score and %1 specific high scores!", "Вы подняли свой общий результат и %1 отдельных результатов!")
S("You have improved your total and '%1' high score!", "Вы подняли свой общий результат и '%1'!")
S("You have improved your total high score on Steam. Congratulations!", "Вы увеличили свой общий счёт в Steam. Поздравляем!")
S("You have improved %1 of your specific high scores!", "Вы увеличили %1 отдельных результатов!!")
S("You have improved your '%1' high score on Steam!", "Вы подняли свой счёт в категории '%1' в Steam!")
S("You have collected 10 treasures of each type.", "Вы собрали по 10 сокровищ каждого типа.")
S("This is your first victory!", "Это ваша первая победа!")
S("This has been recorded in the Steam Leaderboards.", "Это записано в таблицу рекордов Steam.")
S("The faster you get here, the better you are!", "Чем быстрее, тем лучше!")
S("You have improved both your real time and turn count. Congratulations!", "Вы улучшили результаты по реальному времени и по числу ходов! Поздравляем")
S("You have used less real time than ever before. Congratulations!", "Вы потратили меньше реального времени, чем раньше. Поздравляем!")
S("You have used less turns than ever before. Congratulations!", "Вы потратили меньше ходов, чем раньше. Поздравляем!")

// help texts. These are separated into multiple lines just for convenience,
// you don't have to follow.

S(
 "You have been trapped in a strange, non-Euclidean world. Collect as much treasure as possible "
 "before being caught by monsters. The more treasure you collect, the more "
 "monsters come to hunt you, as long as you are in the same land type. The "
 "Orbs of Yendor are the ultimate treasure; get at least one of them to win the game!",

 "Вы оказались заперты в странном неевклидовом мире. Соберите как можно больше сокровищ "
 "перед тем как Вас поймают монстры. Чем больше сокровищ Вы собираете, тем больше монстров "
 "на Вас охотится, пока Вы находитесь на одной территории. Сферы Йендора - уникальные "
 "сокровища; соберите хотя бы одну, чтобы выиграть!"
 )

S(
 "You can fight most monsters by moving into their location. "
 "The monster could also kill you by moving into your location, but the game "
 "automatically cancels all moves which result in that.\n\n",
 
 "Вы можете атаковать большинство монстров, просто передвигаясь на клетку с ними. "
 "Монстры могут атаковать Вас тем же способом, но игра сама блокирует ходы, "
 "приводящие к этому.\n\n")

S(
 "Usually, you move by touching somewhere on the map; you can also touch one "
 "of the four buttons on the map corners to change this (to scroll the map "
 "or get information about map objects). You can also touch the "
 "numbers displayed to get their meanings.\n",
 "Обычно Вы перемещаетесь просто кликая мышкой в нужном направлении; на можно "
 "использовать 4 кнопки по углам карты чтобы листать карту или получать"
 "информацию про объекты. Кликая по изображаемым числам, можно смотреть, "
 "что они означают.\n")

S("Move with mouse, num pad, qweadzxc, or hjklyubn. Wait by pressing 's' or '.'. Spin the world with arrows, PageUp/Down, and Home/Space. "
 "To save the game you need an Orb of Safety. Press 'v' for config, ESC for the quest status and menu.\n\n",
 "Двигайтесь с помощью мышки, нумпада, qweadzxc или hjklyubn. Ждите, нажимая 's' или '.'. "
 "Поворачивайте карту стрелками, PageUp/Down или Home/Space. "
 "Чтобы сохраниться, Вам нужна сфера безопасности. Нажмите 'v' для настроек, Esc для статуса квеста или меню.")
 
S("See more on the website: ", "Смотрите далее на сайте: ")

S("special thanks to the following people for their bug reports, feature requests, porting, and other help:\n\n%1\n\n",
  "отдельное спасибо следующим людям за багрепорты, предложения и другую помощь:\n\n%1\n\n")

S(
 "The total value of the treasure you have collected.\n\n"
 "Every world type contains a specific type of treasure, worth 1 $$$; "
 "your goal is to collect as much treasure as possible, but every treasure you find "
 "causes more enemies to hunt you in its native land.\n\n"
 "Orbs of Yendor are worth 50 $$$ each.\n\n",

  "Общая стоимость найденных Вами сокровищ.\n\n"
  "Каждая земля содержит свой тип ценности, стоящей 1 $$$; "
  "Ваша цель - собрать как можно больше ценностей, но каждая найденная ценность "
  "увеличивает количество врагов в этой земле.\n\n"
  "Сфера Йендора стоит 50 $$$.\n\n")

S(
 "The higher the number, the smoother the animations in the game. "
 "If you find that animations are not smooth enough, you can try "
 "to change the options ",
 "Чем выше это число, тем более гладкой будет анимация в игре. "
 "Если она недостаточно гладкая, поменяйте настройки. ")

S("(Menu button) and select the ASCII mode, which runs much faster. "
 "Depending on your device, turning the OpenGL mode on or off might "
 "make it faster, slower, or cause glitches.",
 "(Меню), выберите ASCII режим, который работает быстрее. В зависимости "
 "от Вашего устройства включите или выключите OpenGL. Он может быть "
 "как быстрее, так и медленнее. "
 )

S("(in the MENU). You can reduce the sight range, this should make "
 "the animations smoother.",
 "(в MENU). Вы можете уменьшить радиус обзора, что сделает анимацию более гладкой. ")

S("(press v) and change the wall/monster mode to ASCII, or change "
 "the resolution.",
 "(нажмите 'v') и поменяйте режим отображения стен/монстров на ASCII, или измените разрешение. ")

S(
 "In this mode you can draw your own player character and floors. "
 "Mostly for the development purposes, but you can have fun too.\n\n"
 "f - floor, p - player (repeat 'p' for layers)\n\n"
 "n - new shape, u - copy the 'player body' shape\n\n"
 "1-9 - rotational symmetries, 0 - toggle axial symmetry\n\n"
 "point with mouse and: a - add point, m - move nearest point, d - delete nearest point, c - nearest point again, b - add after nearest\n\n"
 "s - save in C++ format (but cannot be loaded yet without editing source)\n\n"
 "z - zoom, o - Poincaré model\n",
 
 "В этом режиме Вы можете рисовать персонажа и всё окружение. "
 "В основном для нужд разработчиков, но и просто для веселья тоже.\n\n"
 "f - пол, p - игрок (повторите для смены слоя)\n\n"
 "n - новая форма, u - копировать форму игрока\n\n"
 "1-9 - повороты, 0 - осевая симметрия\n\n"
 "Расставьте точки мышкой и: a - добавить точку, m - двигать ближайшую точку, d - удалить ближайшую точку, c - снова ближайшая точка, b - после ближайшей\n\n"
 "s - запись в формате C++ (пока не может быть загружено без редактирования исходников)\n\n"
 "z - увеличение, o - модель Пуанкаре\n")

S(
 "These huge monsters normally live below the sand, but your movements have "
 "disturbed them. They are too big to be slain with your "
 "weapons, but you can defeat them by making them unable to move. "
 "This also produces some Spice. They move two times slower than you.",

 "Эти огромные монстры обычно живут под огромным слоем песка, но Вы их потревожили. "
 "Они слишком велики, чтобы их можно было убить Вашим оружием, но они "
 "умирают, если не могут двигаться. Также они производят пряности. Они движутся в 2 раза медленнее Вас.")

S("The tentacles of Cthulhu are like sandworms, but longer. "
 "They also withdraw one cell at a time, instead of exploding instantly.",

 "Щупальца Ктулху походи на песчаных червей, но длиннее. "
 "Они втягиваются по одной клетке, а не взрываются мгновенно.")

S(
 "A huge plant growing in the Jungle. Each Ivy has many branches, "
 "and one branch grows per each of your moves. Branches grow in a clockwise "
 "order. The root itself is vulnerable.",
 "Огромное растение, растущее в Джунглях. Каждый плющ имеет много побегов, "
 "и один из них растёт каждый ход. Побеги растут по часовой стрелке. Корень "
 "плюща - самое уязвимое место.\n")

S("The Alchemists produce magical potions from pools of blue and red slime. You "
 "can go through these pools, but you cannot move from a blue pool to a red "
 "pool, or vice versa. Pools containing items count as colorless, and "
 "they change color to the PC's previous color when the item is picked up. "
 "Slime beasts also have to keep to their own color, "
 "but when they are killed, they explode, destroying items and changing "
 "the color of the slime and slime beasts around them.",
 "Алхимики создают магические зелья из красной и синей слизи. Вы "
 "можете перемещаться по этой слизи, но не можете перейти с красной на синюю "
 "и наоборот. Слизь, содержащая предметы, бесцветна и меняет свой цвет на Ваш, "
 "когда Вы собираете предмет. Живая слизь тоже двигается лишь по своему цвету, "
 "но при гибели меняет цвет всей слизи в радиусе 2 клеток на свой.\n")

S(
 "These creatures are slow, but very powerful... more powerful than you. "
 "You need some more experience in demon fighting before you will be able to defeat them. "
 "Even then, you will be able to slay this one, but more powerful demons will come...\n\n"
 "Each 10 lesser demons you kill, you become powerful enough to kill all the greater "
 "demons on the screen, effectively turning them into lesser demons.",
 
 "Эти существа медленны, но очень сильны... гораздо сильнее Вас. "
 "Вам нужно набраться опыта в битве с демонами.\n\n"
 "Когда Вы убьёте 10 младших демонов, Вы станете достаточно сильны, чтобы побеждать старших, "
 "которые тут же сами станут младшими, но потом придут новые старшие демоны...")

S("These creatures are slow, but they often appear in large numbers.",
  "Эти существа медленны, но они берут количеством.")

S("A big monster from the Living Caves. A dead Troll will be reunited "
 "with the rocks, causing some walls to grow around its body.",
 "Огромный монстр из Живых пещер. Мёртвый тролль окружается "
 "камнями, вызывая рост скал вокруг себя.")

S("Huge, impassable walls which separate various lands.",
  "Огромные непроходимые стены, разделяющие разные земли.")

S(
 "This cave contains walls which are somehow living. After each turn, each cell "
 "counts the number of living wall and living floor cells around it, and if it is "
 "currently of a different type than the majority of cells around it, it switches. "
 "Items count as three floor cells, and dead Trolls count as five wall cells. "
 "Some foreign monsters also count as floor or wall cells.\n",
 "В этой пещере даже стены живые. Каждый ход каждая клетка считает количество "
 "клеток живого пола и живых стен среди соседних, и если клеток другого типа больше, "
 "она меняет тип. Предметы считаются за 3 клетки пола, "
 "мёртвые тролли - за 5 клеток стен.Некоторые монстры из других земель "
 "тоже могут считаться за пол или стены.\n")

// "клеток живого пола и живых стен среди соседних‚ и если клеток другого типа больше, "

S(
 "This forest is quite dry. Beware the bushfires!\n"
 "Trees catch fire on the next turn. The temperature of the grass cells "
 "rises once per turn for each fire nearby, and becomes fire itself "
 "when its temperature has risen 10 times.\n"
 "You can also cut down the trees. Big trees take two turns to cut down.",
 "Этот лес довольно сухой. Берегитесь лесных пожаров!\n"
 "Деревья загораются от огня на следующем шагу. Температура травы растёт "
 "на каждом шаге, после 10 шагов трава загорается.\n"
 "Также Вы можете рубить деревья. Большие деревья требуют двух ударов."
 )
 
S("A big and quite intelligent monster living in the Icy Land.",
  "Большой и довольно умный монстр из Ледяной земли.")

S(
 "A nasty predator from the Icy Land. Contrary to other monsters, "
 "it tracks its prey by their heat.",
 "Мерзкий хищник из Ледяной земли. В отличие от остальных монстров "
 "он ищет свою жертву по её теплу.")

S("Rangers take care of the magic mirrors in the Land of Mirrors. "
 "They know that rogues like to break these mirrors... so "
 "they will attack you!",
 "Странники охраняют магические зеркала. Они знают, что эти "
 "разбойники хотят разбить их зеркала и тут же нападают на Вас!")

S("A nasty creature native to the Living Caves. They don't like you "
 "for some reason.",
 "Противное существо из Живых пещер. По каким-то причинам не любит людей.")

S("A tribe of men native to the Desert. They have even tamed the huge Sandworms, who won't attack them.",
  "Племя людей, живущих в пустыне. Они приручили песчаных червей, и те их не трогают.")

S("This giant ape thinks that you are an enemy.", "Эта огромная обезьяна считает Вас своим врагом.")

S("A magical being which copies your movements.", "Это магическое создание копирует Ваши движения.")

S("A magical being which copies your movements. "
 "You feel that it would be much more useful in an Euclidean space.",
 "Это магическое создание повторяет Ваши движения. Вы понимаете, что в евклидовом мире это куда полезнее.")

S("You can summon these friendly constructs with a magical process.",
  "Магия позволяет призывать этих дружелюбных созданий.")

S("A majestic bird, who is able to fly very fast.",
  "Величественная птица, летающая очень быстро.")
 
S("A monster who is able to live inside the living cave wall.",
  "Этот монстр может жить внутри стен пещеры.")

S("A typical Graveyard monster.", "Типичный для Кладбища монстр.")

S("A typical monster from the Graveyard, who moves through walls.\n\n"
  "There are also wandering Ghosts. They will appear "
  "if you do not explore any new places for a long time (about 100 turns). "
  "They can appear anywhere in the game.",
  "Типичный для Кладбища монстр, умеющий проходить сквозь стены.\n\n"
  "Также существуют блуждающие призраки. Они появляются, если Вы не исследуете новые места в течение большого времени (примерно 100 ходов). Они могут появиться в любом месте в игре"
  )

S("Necromancers can raise ghosts and zombies from fresh graves.",
  "Некромант может призывать призраков и зомби из свежих могил.")

S("A creepy monster who follows you everywhere in the Graveyard.",
  "Пугающий монстр, вечно преследующий Вас на Кладбище.")

S("People worshipping Cthulhu. They are very dangerous.",
  "Люди, поклоняющиеся Ктулху. Они довольно опасны.")

S("People worshipping Cthulhu. This one is especially dangerous, "
 "as he is armed with a weapon which launches fire from afar.",
 "Люди, поклоняющиеся Ктулху. Этот особо опасен, так как " 
 "он может кинуть в Вас огонь.")

S("This dangerous predator has killed many people, and has been sent to Cocytus.",
  "Этот опасный хищник убил немало людей и был отправлен в Коцит.")
 
S("This white dog is able to run all the time. It is the only creature "
 "able to survive and breed in the Land of Eternal Motion.",
 "Эта белая собака способна всё время бежать. Это единственное "
 "существо, способное жить и размножаться в Земле вечного движения.")

S("Demons of Hell do not drown when they fall into the lake in Cocytus. "
 "They turn into demonic sharks, enveloped in a cloud of steam.",
 "Демоны из Ада не тонут в озёрах Коцита. Они превращаются в "
 "демонических акул, окутанных облаками пара.")

S("These fairies would rather burn the forest, than let you get some Fern Flowers. "
 "The forest is infinite, after all...\n\n"
 "Fire Fairies transform into fires when they die.",
 "Эти феи скорее сожгут лес, чем позволят Вам собрать цветок папоротника. "
 "В конце концов, лес бесконечный...\n\n"
 "Они превращаются в огонь, когда умирают.")

S("These warriors of the Forest wield exotic weapons called hedgehog blades. "
 "These blades protect them from a frontal attack, but they still can be 'stabbed' "
 "easily by moving from one place next to them to another.",
 "Эти лесные воители вооружены экзотическим оружием, называемым ежиным клинком. "
 "Клинки защищают их от прямых атак, но они могут быть 'заколоты', "
 "достаточно перейти с одной клетки рядом с нм на другую.")

S("This being radiates an aura of wisdom. "
 "It is made of a beautiful crystal, you would love to take it home. "
 "But how is it going to defend itself? Better not to think of it, "
 "thinking causes your brain to go hot...\n\n"
 "Crystal Sages melt at -30 °C, and they can rise the temperature around you from afar.",
 "Они излучают ауру мудрости. Они сделаны из красивых кристаллов, и Вы хотели бы "
 "забрать их домой. Но как он собирается защищать себя? Лучше не думайте об этом, "
 "мышление нагревает Ваш мозг...\n\n"
 "Кристальные мудрецы тают при -30 °C, и они могут повысить температуру вокруг Вас издалека.")
 
S("Cold white gems, found in the Icy Land.", "Холодные белые камни, найденные в Ледяной земле.")

S("An expensive metal from the Living Caves. For some reason "
 "gold prevents the living walls from growing close to it.",
 "Драгоценный металл из Живых пещер. Он препятствует росту живых стен в клетку с ним.")

S("A rare and expensive substance found in the Desert. "
 "It is believed to extend life and raise special psychic powers.",
 "Редкое и дорогое вещество из Пустыни. Говорят, продлевает срок жизни и даёт сверхспособности.")

S("A beautiful gem from the Jungle.", "Прекрасный камень из Джунглей.")

S(
 "A wonderful beverage, apparently obtained by mixing red and blue slime. You definitely feel more "
 "healthy after drinking it, but you still feel that one hit of a monster is enough to kill you.",
 "Чудесный напиток, полученный из синей и красной слизи. Вы чувствуете себя лучше, выпив его, "
 "но одного удара Вам всё ещё хватит, чтобы погибнуть.")

S("A piece of a magic mirror, or a mirage cloud, that can be used for magical purposes. Only mirrors and clouds "
 "in the Land of Mirrors leave these.",
 "Часть магического зеркала или облака миражей. Может быть использовано в магических целях. "
 "Может быть получено только в Зеркальной земле.")

S("These sinister totems contain valuable gems.",
  "Этот зловещий тотем содержит ценные камни.")

S("These star-shaped flowers native to Hell are a valuable alchemical component.",
  "Эти звездовидные цветы их Ада - важный алхимический компонент.")

S("This statue is made of materials which cannot be found in your world.",
  "Эти статуи сделаны из материала, который не найдёшь в Вашем мире.")

S("One of few things that does not cause the floor in the Land of Eternal Motion to collapse. Obviously they are quite valuable.",
  "Единственная вещь, которую выдерживает пол в Земле вечного движения. "
  "Очевидно, довольно ценно.")
 
S("Cold blue gems, found in the Cocytus.", "Холодные голубые камни, найденные в Коците.")

S("These bright yellow gems can be found only by those who have mastered the Crossroads.",
  "Эти ярко-жёлтые камни может найти лишь тот, кто стал мастером Перекрёстка.")
 
S("That's all you need to unlock the Orb of Yendor! Well... as long as you are able to return to the Orb that this key unlocks...\n\n"
 "Each key unlocks only the Orb of Yendor which led you to it.",
 "Это всё, что Вам нужно, чтобы открыть Сферу Йендора! Ну, если Вы сможете к ней вернуться...\n"
 "Каждый ключ открывает лишь ту сферу, которая на него указывает.")

S("These orbs can be found in the Graveyard. You think that they were once powerful magical orbs, but by now, their "
 "power is long gone. No way to use them, you could as well simply drop them...\n\n",
 "Эту сферу можно найти на Кладбище. Когда-то она обладала могущественной магией, но теперь её сила иссякла. "
 "Нет способа её использовать. Разве что просто бросить её...\n\n")

S(
 "This wonderful Orb can only be collected by those who have truly mastered this hyperbolic universe, "
 "as you need the right key to unlock it. Luckily, your psychic abilities will let you know "
 "where the key is after you touch the Orb.",
 "Эта прекрасная сфера может быть собрана лишь тем, кто по настоящему освоил гиперболическую вселенную, "
 "но Вам нужно найти ключ от неё. К счастью, Вы узнаете, где он лежит, как только дотронетесь до сферы.")
 
S(
  "This orb can be used to invoke the lightning spell, which causes lightning bolts to shoot from you in all directions.",
  "Эта сфера может использоваться для заклинания Молнии, которое бьёт молниями во всех направлениях.")

S("This orb can be used to invoke a flash spell, which destroys almost everything in radius of 2.",
  "Эта сфера вызывает заклинание вспышки, уничтожающее почти всё в радиусе 2.")

S("This orb can be used to invoke a wall of ice. It also protects you from fires.",
  "Эта сфера создаёт за Вами стену льда. Также защищает Вас от огня.")
 
S("This orb can be used to move faster for some time.",
  "Эта сфера ускорит Вас на некоторое время.")

S("This orb can be used to summon friendly golems. It is used instantly when you pick it up.",
  "Эта сфера призывает дружественных големов. Она срабатывает, как только Вы её поднимаете.")

S("This orb can protect you from damage.", "Эта сфера защитит Вас от всех атак.")

S("This orb lets you instantly move to another location on the map. Just click a location which "
  "is not next to you to teleport there. ",
  "Эта сфера позволяет перемещаться в произвольное место. Просто кликните по не соседней с Вами клетке, "
  "чтобы телепортироваться туда.")
 
S("This orb lets you instantly move to a safe faraway location. Knowing the nature of this strange world, you doubt "
 "that you will ever find the way back...\n\n"
 "Your game will be saved if you quit the game while the Orb of Safety is still powered.\n\n"
 "Technical note: as it is virtually impossible to return, this Orb recycles memory used for the world so far (even if you do not use it to save the game). ",
 "Эта сфера перемещает Вас в далёкое безопасное место, откуда Вы не вернётесь назад...\n\n"
 "Пока сфера активна, при выходе из игры Ваша игра будет сохранена.\n\n"
 "Технически, старый мир просто удаляется. ")

S("This orb allows attacking Hedgehog Warriors directly, as well as stabbing other monsters.\n",
  "Эта сфера позволит прямо атаковать Ежей-Воинов и закалывать тех врагов, которых Вы могли убить обычным путём.\n")
 
S("This flower brings fortune to the person who finds it.\n",
  "Этот цветок приносит удачу тому, кто найдёт его.\n")

S("Ice Walls melt after some time has passed.", "Ледяные стены со временем могут таять.")

S("A natural terrain feature of the Desert.", "Натуральный ландшафт пустыни.")

S("You can go inside the Magic Mirror, and produce some mirror images to help you.",
  "Вы можете пройти в Магическое зеркало и создать отражения, которые будут Вам помогать.")

S(
 "Tiny droplets of magical water. You see images of yourself inside them. "
 "Go inside the cloud, to make these images help you.",
 "Крошечные капли магической жидкости. Вы видите в них свои отражения. "
 "Войдите в облако, чтобы создать двойников, помогающих Вам.")
 
S("A device that attracts sandworms and other enemies. You need to activate it.",
  "Этот аппарат привлекает песчаных червей и других врагов. Вам нужно активировать его.")

S("A heap of wood that can be used to start a fire. Everything is already here, you just need to touch it to fire it.",
  "Куча брёвен. Всё готово для костра, Вам нужно лишь поджечь его.")

S("An ancient grave.", "Старая могила.")

S("A fresh grave. Necromancers like those.", "Свежая могила. Некроманты их любят.")

S("A piece of architecture typical to R'Lyeh.", "Типичная архитектура Р'Льеха.")

S("An impassable lake in Cocytus.", "Непроходимое озеро в Коците.")

S("You can walk on it... but beware.", "Вы можете пойти сюда, но будьте осторожны!")

S("It was a floor... until something walked on it.", "Здесь был пол... пока кто-то не наступил не него.")

S(
 "This land is a quick gateway to other lands. It is very easy to find other lands "
 "from the Crossroads. Which means that you find monsters from most other lands here!\n\n"
 "As long as you have found enough treasure in their native lands, you can "
 "find magical items in the Crossroads. Mirror Land brings mirrors and clouds, "
 "and other land types bring magical orbs.\n\n"
 "A special treasure, Hyperstone, can be found on the Crossroads, but only "
 "after you have found 10 of every other treasure.",
 "Эта земля - кратчайший путь в любую другую. Здесь очень легко найти любую "
 "другую землю, и здесь можно встретить монстров изо всех земель!\n\n"
 "Как только Вы набираете достаточно сокровищ в некоторой земле, её магические "
 "предметы становятся доступны здесь. В Зеркальной земле это зеркала и миражи, в остальных - сферы.\n\n"
 "Свой сокровище, Гиперкамень, появится лишь после того, как Вы соберёте по 10 сокровищ каждого типа.")
 
S("A hot land, full of sand dunes, mysterious Spice, and huge and dangerous sand worms.",
  "Жаркая земля, полная песчаных дюн, загадочных специй и огромных опасных червей.")
 
S(
 "A very cold land, full of ice walls. Your mere presence will cause these ice walls to "
 "melt, even if you don't want it.",
 "Очень холодная земля, полная ледяных стен. Они будут таять от Вашего присутствия, даже если Вы этого не хотите.")

S("A land filled with huge ivy plants and dangerous animals.",
  "Земля, полная огромными плющами и опасными животными.")

S("A strange land which contains mirrors and mirages, protected by Mirror Rangers.",
  "Странная земля с зеркалами и миражами, защищёнными Странниками.")

S("All the monsters you kill are carried to this strange land, and buried. "
 "Careless Rogues are also carried here...",
 "Все убитые Вами монстры похоронены здесь. И неосторожные охотники за сокровищами тоже...")

S("An ancient sunken city which can be reached only when the stars are right.\n\n"
  "You can find Temples of Cthulhu in R'Lyeh once you collect five Statues of Cthulhu.",
  "Этот древний затопленный город можно найти лишь тогда, когда на него укажут звёзды.\n\n"
  "Вы сможете найти храмы Ктулху, как только соберёте 5 статуй Ктулху.")
 
S("A land filled with demons and molten sulphur. Abandon all hope ye who enter here!",
  "Земля, полная демонов и расплавленной серы. Оставь надежду всяк сюда входящий!")

S("This frozen lake is a hellish version of the Icy Land. Now, your body heat melts the floor, not the walls.",
  "Замёрзшее озеро - адский вариант Ледяной земли. Но сейчас тепло плавит пол, а не стены.")

S("A land where you cannot stop, because every piece of floor is extremely unstable. Only monsters who "
 "can run forever are able to survive there, and only phoenix feathers are so light that they do not disturb "
 "the floor.\n",
 "Земля, в которой нельзя остановиться, потому что пол крайне неустойчив. Лишь монстры, способные всегда бежать, "
 "могут здесь выжить, и лишь перья феникса столь легки, что не тревожат землю.\n")

S("Affects looks and grammar", "Влияет на внешний вид и грамматику")

S("first joystick: movement threshold", "джойстик 1: порог движения")
S("first joystick: execute movement threshold", "джойстик 1: порог выполнения движения")
S("second joystick: pan threshold", "джойстик 2: порог панорамы")
S("second joystick: panning speed", "джойстик 2: скорость панорамы")
S("%The1 is frozen!", "%1 замерзает!")
S("%The1 burns!", "%1 горит!")
S("message flash time", "время показа сообщений")

S("skin color", "цвет кожи")
S("weapon color", "цвет оружия")
S("hair color", "цвет волос")
S("dress color", "цвет одежды")
S("Shift=random, Ctrl=mix", "Shift=случайный, Ctrl=смешать")

S("Euclidean mode", "режим евклидовой плоскости")
S("Return to the hyperbolic world", "вернуться на гиперболоид")
S("Choose from the lands visited this game.", "Выберите одну из уже посещённых земель.")
S("Scores and achievements are not", "Очки и достижения не");
S("saved in the Euclidean mode!", "сохраняются в евклидовом режиме!");

// Android buttons (some are not translated because there are no good short words in Polish)
S("MOVE", "ХОД")
S("BACK", "BACK")
S("DRAG", "DRAG")
S("INFO", "ИНФО")
S("MENU", "МЕНЮ")
S("QUEST", "МИССИЯ")
S("HELP", "ПОМОШЬ")
S("NEW", "NEW")
S("PLAY", "ИГРА")
S("SHARE", "SHARE")
S("HyperRogue for Android", "HyperRogue для Android")
S("Date: %1 time: %2 s ", "Дата: %1 время: %2 s ")
S("distance: %1\n", "расстояние: %1\n")
S("Cheats: ", "Читы: ")
S("Score: ", "Очки: ")
S("Kills: ", "Убийства: ")
S("Retrieving scores from Google Leaderboards...", "Получение результатов из таблиц Google...")
S("Scores retrieved.", "Результаты получены.")

S("Your total treasure has been recorded in the Google Leaderboards.", "Ваш результат записан в рейтинг Google.")
S("You have improved your total high score on Google. Congratulations!", "Вы поставили рекорд по общему счёту в таблицах Google. Поздравляем!")
S("You have improved your '%1' high score on Google!", "Вы повысили свой результат '%1' в таблицах Google")
S("This has been recorded in the Google Leaderboards.", "Это было записано в рейтинг Google.")

// this text changed a bit:

S("Ever wondered how some boardgame would look on the hyperbolic plane? "
 "I wondered about Go, so I have created this feature. Now you can try yourself!\n"
 "Enter = pick up an item (and score), space = clear an item\n"
 "Other keys place orbs and terrain features of various kinds\n"
 "In the periodic editor, press 0-4 to switch walls in different ways\n",
 "Вы когда-нибудь думали о том, как выглядит настольная игра на гиперболической плоскости? "
 "Я думал про Го и создал этот режим. Теперь и Вы можете попробовать!\n"
 "Enter = поднять предмет, space = удалить предмет\n"
 "Остальные клавиши добавляют разные предметы или элементы ландшафта.\n"
 "В периодическом редакторе клавиши 0-4 меняют местоположение стен разными способами.\n")
 
S("Periodic Editor", "Периодический редактор")
// also translate this line:
// "In the periodic editor, press 0-4 to switch walls in different ways\n",

S("Collect 60 $$$ to access even more lands", "Соберите 60 $$$, чтобы открыть новые земли")

// Emerald Mine

N("Emerald Mine", GEN_F, "Изумрудная шахта", "Изумрудные шахты", "Изумрудную шахту", "в Изумрудной шахте")
N("Pikeman", GEN_M, "Копейщик", "Копейщики", "Копейщика", "Копейщиком")
N("Flail Guard", GEN_M, "Воин с цепом", "Воины с цепом", "Воина с цепом", "Воином с цепом")
N("Miner", GEN_M, "Шахтёр", "Шахтёры", "Шахтёра", "Шахтёром")
N("Emerald", GEN_O, "Изумруд", "Изумруды", "Изумруд", "Изумрудом")

Orb("the Mind", "Разума")

S(
     "Evil people are mining for emeralds in this living cave. "
     "It does not grow naturally, but it is dug out in a regular "
     "pattern, which is optimal according to the evil engineers.",
     "Злые люди искали изумруды в Живой пещере. "
     "Она не растёт сама, но выкопана периодически "
     "оптимально для нужд злых инженеров. ")

S(
    "Miners have special tools for dealing with the Living Cave. "
    "When they die, these tools activate, destroying the living cave "
    "around them.",
    "Шахтёры имеют специальные инструменты для копания Живой пещеры. "
    "При гибели они автоматически используются, уничтожая пещеру вокруг них.")

S(
    "When Pikemen move, they attack all cells which are now adjacent to them. "
    "Luckily, they can be killed in the same way.\n\n"
    "They never move if this would attack their friends.",
    "Когда Копейщик ходит, он атакует все клетки рядом с ним. К счастью, и его можно убить подобным образом.\n\n"
    "Копейщик никогда не будет атаковать дружественной ему существо.")

S(
    "This guard of the Emerald Mine is wielding a huge flail. "
    "You cannot attack him directly, as the flail would still hit you then. "
    "Luckily, you have learned a trick: if you step away from him, "
    "he will hit himself with the flail!",
    
    "Этот страж изумрудных шахт вооружён огромным цепом. "
    "Вы не можете атаковать его обычным путём, потому что тогда цеп убьёт Вас. "
    "К счастью, Вы знаете трюк: достаточно отойти от него, когда он замахивается, "
    "и он убьёт сам себя!")

S("A precious green gem from the Emerald Mines.", "Ценный зелёный камень из изумрудных шахт.")

S("%The1 pierces %the2!", "%1 проколол%E1 %a2!")

S("Make him hit himself by walking away from him.",
  "Заставьте его ударить самого себя, просто подойдя к нему.")

S("This orb allows you to instantly kill a non-adjacent enemy by clicking it. "
    "Each use drains 30 charges.",
  "Эта сфера позволит Вам убить любого врага, не стоящего рядом с Вами, просто кликнув по нему. "
  "Это действие тратит 30 зарядов.")

S("%The1 is immune to mental blasts!", "%1 защищён%E1 от психических атак!")
S("You kill %the1 with a mental blast!", "Вы убили %a1 психическим взрывом!")

// Vineyard

N("Vineyard", GEN_O, "Виноградник", "Виноградники", "Виноградник", "в Винограднике")
N("Vine Beast", GEN_M, "Винный зверь", "Винные звери", "Винного зверя", "Винным зверем")
N("Vine Spirit", GEN_M, "Винный дух", "Винные духи", "Винного духа", "Винным духом")
N("vine", GEN_F, "лоза", "лозы", "лозы", "лозой")
N("partial fire", GEN_O, "частичный огонь", "частичные огни", "частичный огонь", "частичным огнём")
N("Wine", GEN_N, "Вино", "Вина", "Вино", "Вином")

S(  "This cell is partially on fire.", "Эта клетка частично в огне.")

S(
  "The Vineyard is filled with vines. A very dense pattern of straight lines here...\n\n" 
  "Vine Beasts and Vine Spirits change vine cells to grass, and vice versa.",
  "Виноградник полон виноградными лозами. Они образуют очень плотный узор из прямых...\n\n"
  "Винные звери и духи превращают траву в вино и наоборот.")

S("A vine is growing here... but only on a half of the cell. How is that even possible?!"
  "Most monsters cannot move from this cell to the cell containing the other half. "
  "Vine spirits can move only to the adjacent cells which are also adjacent to the "
  "other half.",
  "Здесь растёт лоза... но только на половине клетки. Как это возможно?! "
  "Большинство монстров не могут перейти с этой клетки на соседнюю с ней по стороне, содержащей лозу; "
  "винный дух, напротив, на может перейти с этой клетки на лозу, соседнюю с ней по свободной половине.")

S(
    "A beast made of vines!\n\n"
    "Vine Beasts turn into vines when they die.",
    "Зверь, свитый из виноградных лоз!\n\n"
    "Винный зверь превращается в лозу при гибели.")

S(  "A spirit living in the vines!\n\n"
    "Vine Spirits destroy the vines when they die.",
    "Дух, живущий в лозе\n\n"
    "Винный дух уничтожает лозу при гибели.")

S("Wine grown under hyperbolic sun would be extremely prized in your home location.",
  "Вино, созревшее под гиперболическим солнцем, очень ценится на Вашей родине.")

S("This orb allows one to pass through all kinds of walls and chasms.",
  "Эта сфера позволяет ходить через все стены и пропасти.")

S("You cannot attack through the Vine!",
  "Вы не можете атаковать сквозь лозу!")

Orb("Aether", "Эфира")

// Dead Caves

N("Dead Cave", GEN_F, "Мёртвая пещера", "Мёртвые пещеры", "Мёртвую пещеру", "в Мёртвой пещере")
N("Dark Troll", GEN_M, "Тёмный тролль", "Тёмные тролли", "Тёмного тролля", "Тёмным троллем")
N("Earth Elemental", GEN_M, "Земной элементаль", "Земные элементали", "Земного элементаля", "Земным элементалем")
N("dead wall", GEN_F, "мёртвая стена", "мёртвые стены", "мёртвую стену", "мёртвой стеной")
N("dead floor", GEN_O, "мёртвый пол", "мёртвые полы", "мёртвый пол", "мёртвым полом")
N("rubble", GEN_O, "щебень", "щебни", "щебень", "щебнем")
N("Silver", GEN_N, "Серебро", "Серебро", "Серебро", "Серебром")

S("A precious metal from the Dead Caves.", "Драгоценный металл из Мёртвых пещер.")

S(  "A Troll without the power of Life.", "Тролль без жизненной силы.")

S(
    "A rare unliving construct from the Dead Caves. "
    "It instantly destroys cave walls next to its path, and also leaves "
    "an impassable wall behind it. You suppose that this impassable wall helps it to "
    "escape from some threats. You hope you won't meet these threats...",
    
    "Редкое неживое создание из Мёртвых пещер. "
    "Мгновенно разрушает стены на своём пути и оставляет стены за собой.")

S("%The1 punches %the2!", "%1 ударил%E1 %a2!")
S("%The1 is destroyed by the forces of Life!", "Сила Жизни уничтожила %a1!")
S(  "Somehow, this cave has not received the spark of Life yet.",
    "Так или иначе, в эту пещеру ещё не пришла жизнь.")

// Hive
N("Hive", GEN_O, "Улей", "Ульи", "Улей", "в Улье")
N("Red Hyperbug", GEN_M, "Красный гипержук", "Красные гипержуки", "Красного гипержука", "Красным гипержуком")
N("Green Hyperbug", GEN_M, "Зелёный гипержук", "Зелёные гипержуки", "Зелёного гипержука", "Зелёным гипержуком")
N("Blue Hyperbug", GEN_M, "Синий гипержук", "Синие гипержуки", "Синего гипержука", "Синим гипержуком")
N("Royal Jelly", GEN_N, "маточное молочко", "маточное молочко", "маточное молочко", "маточным молочком")
N("weird rock", GEN_O, "странный камень", "странные камни", "странный камень", "странным камнем")

Orb("Invisibility", "Невидимости")

S("A weirdly colored rock. Hyperentomologists claim that the "
  "Hyperbug armies use these rocks to navigate back home after a victorious battle.",
  "Странно окрашенный камень. Гиперэнтомологи считают, что армии "
  "гипержуков используют их, чтобы вернуться после победоносной битвы домой.")
 
S("%The1 fights with %the2!", "%1 атаковал%E1 %a2!")

S("The Hive is filled with Hyperbugs. They are huge insects which look a bit like "
  "ants, a bit like bees, and a bit like roaches. "
  "They live in circular nests, and an army of Hyperbugs will attack any intruder, "
  "including you and enemy Hyperbugs. Will you manage to get to the "
  "heart of such a nest, and get the precious Royal Jelly?",
  "Улей населён гипержуками. Эти огромные насекомые выглядят немного как муравьи, "
  "немного как пчёлы и немного как тараканы. Они живут в круглых гнёздах, "
  "и их армия готова напасть на любого нарушителя, включая Вас и жуков другого цвета. "
  "Хотите ли Вы добраться до центра такого гнезда и забрать ценное маточное молочко?")
 
S("This is what Hyperbug Queens eat. Very tasty and healthy.",
  "Это - еда королевы гипержуков. Очень вкусно и полезно.")

S("When you have this Orb, most monsters won't see you, unless "
    "you are standing still, attacking, or picking up items.",
  "Пока у Вас есть эта сфера, большинство монстров не видят Вас, "
  "если Вы не стоите рядом, не атакуете и не поднимаете предметы.")

Orb("Earth", "Земли")

S("This orb lets you go through living walls. It also has powers in some of the other lands.",
  "Эта сфера позволяет проходить сквозь живые стены. Она имеет силу и в некоторых других землях.")

// Land of Power

N("Land of Power", GEN_F, "Земля силы", "Земли силы", "Землю силы", "в Земле силы")
N("Witch Apprentice", GEN_F, "Ведьма-ученица", "Ведьмы-ученицы", "Ведьму-ученицу", "Ведьмой-ученицей")
N("Speed Witch", GEN_F, "Ведьма скорости", "Ведьмы скорости", "Ведьму скорости", "Ведьмой скорости")
N("Flash Witch", GEN_F, "Ведьма вспышки", "Ведьмы вспышки", "Ведьму вспышки", "Ведьмой вспышки")
N("Fire Witch", GEN_F, "Ведьма огня", "Ведьмы огня", "Ведьму огня", "Ведьмой огня")
N("Aether Witch", GEN_F, "Ведьма эфира", "Ведьмы эфира", "Ведьму эфира", "Ведьмой эфира")
N("Winter Witch", GEN_F, "Ведьма зимы", "Ведьмы зимы", "Ведьму зимы", "Ведьмой зимы")
N("Evil Golem", GEN_M, "Злой голем", "Злые големы", "Злого голема", "Злым големом")
N("Powerstone", GEN_O, "Камень силы", "Камни силы", "Камень силы", "Камнем силы")
N("crystal cabinet", GEN_O, "кристальный кабинет", "кристальные кабинеты", "кристальный кабинет", "кристальным кабинетом")

S("When you have this Orb, you will leave a trail of fire behind you.",
  "Пока у Вас есть эта сфера, Вы оставляете огненный след за собой.")

S(
    "A Witch without any special powers. But watch out! She will "
    "pick up any basic Orbs on her path, and use their powers.",
    "Ведьма без особых сил. Но будьте осторожны! Она может поднять "
    "сферу на своём пути и забрать её силу.")
       
S(  "A Witch with a Speed spell. She moves twice as fast as you. Unless you "
    "have an Orb of Speed too, of course!",
    "Ведьма с заклинанием скорость. Она движется в 2 раза быстрее Вас. "
    "Если у Вас нет того же заклинания, конечно!")

S(  "A Witch with a Fire spell. She will leave a trail of fire behind her.",
    "Ведьма с заклинанием огня. Оставляет огненный след за собой.")

S(  "A Witch with a Winter spell. She is able to move through fire.",
    "Ведьма с заклинанием зимы. Может проходить сквозь огонь.")

S(  "A Witch with an Aether spell. She is able to move through fire and walls.",
    "Ведьма с заклинанием эфира. Может проходить сквозь огонь и стены.")

S(  "Somebody has summoned these evil constructs with a magical process.",
    "Враждебная конструкция, созданная в результате магического процесса.")
    
S(  "The Land of Power is filled with everburning fire, magical Orbs, and guarded by "
    "witches and golems. There are basic orbs lying everywhere, and more prized ones "
    "are kept in crystal cabinets.\n\n"
    "Witches are allowed to use all the powers of the "
    "basic orbs against intruders. These powers never expire, but a Witch "
    "can use only one power at a time (not counting Orbs of Life).\n\n"
    "Witches and Golems don't pursue you into other Lands. Also, most Orb powers "
    "are drained when you leave the Land of Power.",
    "Земля силы полна вечно горящими огнями и магическими сферами и защищена "
    "ведьмами и големами. Все обычные сферы есть здесь, "
    "и наиболее ценные из них защищены кристальными кабинетами.\n\n"
    "Ведьмы способны использовать силы сфер против нарушителей. "
    "Эти силы действуют бесконечно, но каждая ведьма может использовать лишь "
    "Одну (не считая сферы жизни).\n\n"
    "Ведьмы и големы не покидают эту землю. Когда вы уходите из неё, силы некоторых "
    "Ваших сфер покидают Вас.")

S(
    "Witches use these crystal cabinets to protect Powerstones, as well as the more "
    "expensive Orbs. They are partially protected from thieves: they are too strong "
    "to be smashed by conventional attacks, and if you try to steal the item "
    "using an Orb of Aether, your Aether power will be completely drained.",
  "Ведьмы используют эти кристальные кабинеты для защиты Камней силы, как и самые "
  "ценные сферы. Они частично защищают их от воров: они достаточно прочны, чтобы "
  "выдерживать прямые атаки, и если Вы попробуете использовать сферу Эфира для "
  "проникновения в него, то сила сферы сразу иссякнет.")

S(
    "A Stone from the Land of Power. You are not sure what it is exactly, but "
    "as the Powerstones are kept in crystal cabinets, they are surely valuable.",
    "Камень из Земли силы. Вы точно не знаете, что это такое, но раз они спрятаны "
    "в кристальных кабинетах, они довольно ценны.")

Orb("Fire", "Огня")

// achievements:

// x "Head Witch", "Have 10 Orbs active at the same time."
// "Enemy Number One", "Have an army of 1000 hyperbugs pursue you."
// x "Lifebringer", "Brought Life into the Dead Caves."
// "Wall Gardener", "Make a living wall grow outside of a cavernous region."
// x "Master Swordsman", "Defeat a Hedgehog Warrior, a Pikeman, and a Flail Guard at the same time."
// x "Master of Melee", "Defeat five monsters in melee at the same time."

// for collection achievements: 
// provide the required cases for descriptions:
// Spice, Royal Jelly, Silver, Powerstone, and Wine
// achievement names:
// Master of the Hive, Master of Power, Master of Vineyard, Master of Dead Caves, Master of the Mine
// "Hyperbug", "Hyperbug Warrior", "Hyperbug Queen",

// for the store description:

// (currently, five more lands are included!)

// lines forgotten previously

S("Your Aether power has expired! RUN!", "Ваша эфирная сила иссякает! БЕГИТЕ!")

S("%The1 tricks %the2.", "%1 победил%E1 %a2.")
S("You trick %the1.", "Вы победили %a1.")

S(  "A Witch with a Flash spell. Very dangerous!\n\nLuckily, she never uses the spell if it "
    "would kill her friends. She could destroy an Evil Golem, though.",
    "Ведьма с заклинанием вспышки. Очень опасна!\n\nК счастью, она никогда не использует "
    "заклинание, ели оно убьёт других ведьм. Но големов она может и уничтожить.")
       
S("Your Aether powers are drained by %the1!", "Твоя эфирная сила была уменьшена %abl1!")
S("As you leave, your powers are drained!", "Покидая землю силы, Вы теряете магию сфер!")
S("%The1 picks up %the2!", "%1 поднял%E1 %a2!") // currently only Witches, so only female form

S("You can right click any element to get more information about it.\n\n",
  "Кликните правой кнопкой мыши, чтобы узнать больше.\n\n")

S("The Hyperbugs are fighting!", "Гипержуки сражаются!")

S("","") N("",GEN_N,"","","","")

S("Cheat-changed the display.", "Отображение использованных читов.")
S("Dead floor, with some rubble.", "Мёртвая земля с щебнем.")

// Camelot

N("Camelot", GEN_O, "Камелот", "Камелот", "Камелот", "в Камелоте")
N("wall of Camelot", GEN_F, "стена Камелота", "стены Камелота", "стену Камелота", "стеной Камелота")
N("moat of Camelot", GEN_O, "ров Камелота", "рвы Камелота", "ров Камелота", "рвом Камелота")
N("Round Table", GEN_O, "Круглый Стол", "Круглые Столы", "Круглый Стол", "Круглому Столу")
N("Knight", GEN_M, "Рыцарь", "Рыцари", "Рыцаря", "Рыцарем")
N("Holy Grail", GEN_O, "Святой Грааль", "Святые Граали", "Святой Грааль", "Святым Граалем")

S(
  "The Knights of the Round Table are the greatest warriors of these lands. "
  "They are not very inventive with names though, as they call each of their "
  "castles Camelot. "
  "You are probably worthy of joining them, but they will surely give you "
  "some quest to prove yourself...\n\n"
  "Each castle contains a single treasure, the Holy Grail, in the center. "
  "The radius of the Round Table is usually 28, but after you find a Holy Grail "
  "successfully, each new castle (and each Round Table) you find will be bigger.",
 
  "Рыцари Круглого стола - величайшие воины этой земли. "
  "Они не очень изобретательны и называют каждый свой замок Камелот. "
  "Возможно, Вам стоит встретиться с ними, и они дадут Вам задание.\n\n"
  "Каждый замок содержит одно сокровище (Святой Грааль) в центре. Обычно радиус "
  "круглого стола равен 28, но с каждым новым Граалем радиус становится всё больше.")
 
S("It would be impolite to land on the table!",
  "Было бы невежливо приземляться на стол!")
S("You jump over the table!", "Вы запрыгнули на стол!")
S("That was not a challenge. Find a larger castle!",
  "Это было несложно. Найдите больший замок!")
S("The Knights congratulate you on your success!",
  "Рыцари поздравляют Вас с успехом!")
S("The Knights laugh at your failure!",
  "Рыцари смеются над Вашей неудачей!")
S("The Knights stare at you!", "Рыцари смотрят на Вас!")
S("Come on, this is too easy... find a bigger castle!",
  "Ну давай, это слишком просто... Найди больший замок!")
S("The Knights wish you luck!", "Рыцари желают Вам удачи!")

S("Congratulations! You have found the Holy Grail!",
  "Поздравляем! Вы нашли святой Грааль!")

S("\"I would like to congratulate you again!\"", "\"Я хотел бы ещё раз Вас поздравить!\"")
S("\"Find the Holy Grail to become one of us!\"", "\"Найди Святой Грааль, и станешь одним из нас!\"")
S("\"The Holy Grail is in the center of the Round Table.\"", "\"Святой Грааль в центре круглого стола.\"")
S("\"I enjoy watching the hyperbug battles.\"", "\"Мне нравится наблюдать за боями гипержуков.\"")
S("\"Have you visited a temple in R'Lyeh?\"", "\"Вы уже были в храме в Р'Льехе?\"")
S("\"Nice castle, eh?\"", "\"Хороший замок, да?\"")

// Temple

N("Temple of Cthulhu", GEN_O, "Храм Ктулху", "Храмы Ктулху", "Храм Ктулху", "в Храме Ктулху")
N("big statue of Cthulhu", GEN_O, "памятник Ктулху", "памятники Ктулху", "памятник Ктулху", "памятником Ктулху")
N("Grimoire", GEN_O, "Гримуар", "Гримуары", "Гримуар", "Гримуаром")
N("Cult Leader", GEN_M, "Лидер культа", "Лидеры культа", "Лидера культа", "Лидером культа")

S("The temple of Cthulhu consists of many concentric circles of columns. "
  "You will surely encounter many Cultists there, who believe that a pilgrimage "
  "to the inner circles will bring them closer to Cthulhu himself, and Grimoires "
  "which surely contain many interesting secrets.\n\n"
  "The circles in the temple of Cthulhu are actually horocycles. They are "
  "infinite, and there is an infinite number of them.",
 
  "Храм Ктулху содержит много концентрических кругов колонн. "
  "Здесь Вы встретите культистов, верящих, что путешествие во внутренние круги "
  "храма приблизит их ко Ктулху, и найдёте Гримуары, содержащие весьма интересные секреты.\n\n"
  "Круги в храме на самом деле орициклы. Они бесконечны, и их число бесконечно."
  )
 
S("The Grimoires contain many secrets of the Great Old Ones. "
  "Each new inner circle in the Temple of Cthulhu contains new Grimoires, with new secrets. "
  "You hope to read them when you return home, and to learn many things. "
  "The knowledge is valuable to you, but it is rather pointless to try to get "
  "several copies of the same Grimoire...",
  "Гримуары содержат много секретов Великих предков Каждый новый круг Храма Ктулху содержит "
  "новые тома с новыми секретами. Вы можете принести их домой, прочитать и узнать много вещей."
  "Знание ценно для Вас, но Вам не нужны копии одного Гримуара... "
  )

S("These statues of Cthulhu are too large to carry, and they don't look too "
  "valuable anyway. Most monsters will never go through them... they probably have "
  "their reasons. But you can go! When you move into the cell containing "
  "a statue, you push the statue to the cell you left.\n",
  
  "Эти статуи Ктулху слишком велики, чтобы их забрать, да и не выглядят особо ценными.  "
  "Большинство монстров не может ходить через них, у них есть на то свои причины. "
  "Но Вы можете! Когда Вы ходите на клетку с памятником, "
  "он сдвигается на клетку, которую Вы покинули."
  )

S("These Cultists can push the statues, just like you.",
  "Эти культисты могут двигать статуи,как и Вы.")

S("You already have this Grimoire! Seek new tomes in the inner circles.",
  "У Вас уже есть этот Гримуар! Ищите новые тома в более глубоких кругах.")
  
S("You push %the1 behind you!", "Вы передвинули %a1 за себя.")

// More texts

S("Your total kills", "Всего убийств")

S(
  "In most lands, more treasures are generated with each enemy native to this land you kill. "
  "Moreover, 100 kills is a requirement to enter the Graveyard and the Hive.\n\n"
  "Friendly creatures and parts of monsters (such as the Ivy) do appear in the list, "
  "but are not counted in the total kill count.",

  "В большинстве земель чем больше Вы убиваете местных жителей, тем больше сокровищ "
  "создаётся. Кроме того, Вам нужно убить 100 врагов, чтобы попасть на Кладбище и в Улей.\n\n"
  "Дружественные существа и части монстров (например, части плюща) при этом на считаются.")
  
S("There must be some temples of Cthulhu in R'Lyeh...",
  "В Р'Льехе должны быть храмы Ктулху...")

S("You overheard Hedgehog Warriors talking about emeralds...",
  "Вы слышите ежей-воинов, говорящих об изумрудах...")

S("You overhear miners talking about a castle...",
  "Вы слышите шахтёров, говорящих о замке...")
  
S("A castle in the Crossroads...", "О замке на перекрёстке...")

/*
S("You can find Temples of Cthulhu in R'Lyeh once you collect five Statues of Cthulhu.",
  "Вы можете найти храмы Ктулху в Р'Льехе, как только найдёте 5 статуй Ктулху.")
*/

S("You have to escape first!", "Вы должны бежать первым!");
S("There is not enough space!", "Нет места!");

S("Customize character", "Настройка персонажа")
S("gender", "пол")

S("Cannot teleport on a monster!", "Нельзя телепортироваться на монстра!")
S("Cannot teleport on an item!", "Нельзя телепортироваться на предмет!")
S("Cannot teleport here!", "Нельзя телепортироваться сюда!")
//S("You cannot teleport that far away!", "Вы не можететелепортироваться так далеко!")
S("You cannot target that far away!", "Nie możesz celować tak daleko!")
S("You cannot target that close!", "Nie możesz celować tak blisko!")
S("Cannot cast illusion on an item!", "Nie możesz rzucić iluzji na przedmiot!")
S("Cannot cast illusion here!", "Nie możesz rzucić ilzuji tutaj!")
S("Cannot cast illusion on a monster!", "Nie możesz rzucić ilzuji na potwora!")
S("Cannot throw fire there!", "Nie możesz tego podpalić!")

Orb("the Dragon", "Дракона")
 
S("This Orb allows you to throw fire, just like the Fire Cultists.\n\n"
  "Each fire drains 5 charges. You are not allowed to throw fire into adjacent cells.",
  "Эта сфера позволит Вам кидать огонь, прямо как огненные культисты.\n\n"
  "Каждое использование тратит 5 зарядов. Вы не можете кинуть огонь на соседнюю клетку."
  )
 
S("You throw fire!", "Вы бросили огонь!")
 
Orb("Trickery", "Хитрости")
 
N("Illusion", GEN_F, "Иллюзия", "Иллюзии", "Иллюзию", "Иллюзией")

S("Illusions are targetted "
  "by most monsters, just like yourself, Thumpers, and your friends.",
  "Их будут атаковать почти все монстры, "
  "так же как Вас, Тамперы и ваших союзников.")
 
S("This Orb allows you to create illusions of yourself. Illusions are targetted "
  "by most monsters, just like yourself, Thumpers, and your friends.\n\n"
  "Each illusion takes 5 charges to create, and one extra charge "
  "per turn. You can also click your illusion to take it away, restoring 4 charges.\n\n"
  "If you have both Orb of Teleport and Orb of Trickery, Illusion is cast "
  "first -- you can then teleport on your Illusion to switch places with it.",
  "Эта сфера позволяет Вам создавать иллюзии. Их будут атаковать почти все монстры, "
  "так же как Вас, Тамперы и ваших союзников.\n\n"
  "Каждая иллюзия требует 5 зарядов для создания и по одному в каждый ход. "
  "Также Вы можете кликнуть на иллюзию, чтобы забрать её, потратив 3 заряда.\n\n"
  "Если у Вас есть сферы Хитрости и Телепорта, Иллюзия работает первой -- Вы можете"
  "потом телепортироваться на неё, чтобы поменяться с ней местами.")
                      // Иллюзии "Хитрости"
S("Illusions are targetted by most monsters, just like yourself, Thumpers, and your friends.",
  "Их будут атаковать почти все монстры, "
  "так же как Вас, Тамперы и ваших союзников.")
  
S("You create an Illusion!", "Вы создали иллюзию!")
S("You take the Illusion away.", "Вы забрали иллюзию!")

S("You cannot target that far away!", "Вы не можете выбрать цель так далеко!")
S("You cannot target that close!", "Вы не можете выбрать цель так близко!")
S("Cannot cast illusion on an item!", "Нельзя создать иллюзию на предмете!")
S("Cannot cast illusion here!", "Нельзя создать иллюзию здесь!")
S("Cannot cast illusion on a monster!", "Нельзя создать иллюзию на монстре!")
S("Cannot throw fire there!", "Вы не можете кинуть огонь сюда!")

S("or ESC to see how it ended", "либо ESC, чтобы посмотреть, как всё закончилось")

S("high contrast", "высокий контраст")

S("draw the heptagons darker", "семиугольники темнее");

S("targetting ranged Orbs Shift+click only",
  "выбирать цель сфер только через Shift+клик")

S("Shift+F, Shift+O, Shift+T, Shift+L, Shift+U, etc.",
  "Shift+F, Shift+O, Shift+T, Shift+L, Shift+U, и т. д..")

S("also hold Alt during the game to toggle high contrast",
  "также Alt во время игры переключает высокий контраст")

// Crossroads II
 
N("Crossroads II", GEN_N, "Перекрёсток II", "Перекрёстки II", "Перекрёсток II", "на Перекрёстке II")
 
S(
  "An alternate layout of the Crossroads. It is more dense and more regular, "
  "although you won't find the castle of Camelot here.",
 
  "Другая схема перекрёстка. Она плотнее и регулярнее обычной, "
  "но замок Камелот Вы здесь не найдёте."
)
 
// Caribbean
 
// 'Karaiby' is plural in Polish, should probably fix the grammar for this
 
N("Caribbean", GEN_M, "Карибы", "Карибы", "Карибы", "на Карибах")
 
N("Pirate", GEN_M, "Пират", "Пираты", "Пирата", "Пиратом")
N("Shark", GEN_F, "Акула", "Акулы", "Акулу", "Акулой")
N("Parrot", GEN_M, "Попугай", "Попугаи", "Попугая", "Попугаем")
N("Pirate Treasure", GEN_N, "Сокровище пиратов", "Сокровища пиратов", "Сокровище пиратов", "Сокровищем пиратов")
N("Compass", GEN_O, "Компас", "Компасы", "Компас", "Компасом")
 
N("sea", GEN_O, "море", "моря", "море", "морем")
N("boat", GEN_F, "лодка", "лодки", "лодку", "лодкой")
N("island", GEN_O, "остров", "острова", "остров", "островом")
N("tree", GEN_N, "дерево", "деревья", "дерево", "деревом")
 
Orb("Time", "Времени")
 
S("This dangerous sea contains nasty sharks and pirates. ",
  "Опасное море, полное акул и пиратов.")
 
S("The islands of Caribbean are infinite and circular, and "
  "the pirates probably have hidden their treasures somewhere far from the coast.",
  "Карибские острова бесконечные и круглые. Возможно, пираты "
  "прячут свои сокровища где-то вдали от берега.")
 
S(
    "Hyperbolic pirates do not need huge ships, since so many lands to conquest "
    "are so close. These small boats are enough for them.\n\n"
    "Boats allow you to go through water. If you are in a boat, you can move into "
    "a water cell (and the boat will come with you).",
   
    "Гиперболическим пиратам не нужны большие корабли, ведь много земель "
    "для завоевания так близки. Достаточно этих маленьких лодок.\n\n"
    "Лодки позволяют двигаться по воде. Если Вы в лодке, Вы можете "
    "перейти на клетку с водой (и лодка переместится туда же).")
 
S(
    "The forests of Caribbean are too dense to be traversed by humans, "
    "and they are hard to burn. Many colorful parrots can be found there.",
    "Карибские леса слишком плотны, чтобы сквозь них мог пройти человек, "
    "и их трудно поджечь. Много разноуветных попугаев живёт здесь.")
 
S("Ye wonder where did th' Pirates find all these riches...",
    "Интересно, где Пираты нашли эти богатства...")
 
S(
  "The hyperbolic pirates have no use for treasure maps. However, they have found "
  "out that a compass points to the center of the island. So they just go as "
  "far towards the center as they can, and hide their treasure there.",
 
  "Карты бесполезны для гиперболических пиратов, но они знают, что "
  "компас всегда показывает в центр острова. Так что они просто идут "
  "как можно дальше к центру острова и прячут там сокровища.")
 
S("Just a nasty shark.", "Просто противная акула.")
 
S("Parrots feel safe in the forests of Caribbean, so they "
    "never leave them. But they will help the Pirates by attacking the intruders.",
 
  "Попугаи чувствуют себя в безопасности в Карибских лесах и "
  "никогда их не покидают. Но они помогают пиратам, нападая на чужаков.")
 
S("Just a typical hyperbolic pirate.", "Обычный гиперболический пират.")
 
S(
    "Normally, the power of most Orbs slowly fades away, even when "
    "you are not actively using them. This Orb prevents this.\n\n"
   
    "When you have the Orb of Time, Orbs which are not active won't lose their power. "
    "Orbs are considered active if they have a continuous power which has actually "
    "affected something in the last turn.\n\n"
   
    "Orbs of Shielding remain active after being activated (even if you are no longer "
    "attacked), and Orbs of Time have a bigger cap inside their native Caribbean than "
    "outside.",
   
    "Обычно сила сфер угасает, даже если Вы не используете их. Сфера Времени "
    "препятствует этому.\n\n"
   
    "Если у Вас есть сфера Времени, неактивные сферы не теряют свою силу. Сфера "
    "считается активной, если она имеет постоянный эффект, проявившийся на "
    "последнем ходе.\n\n"
   
    "Сфера Щита считается активной всегда (даже если Вы никого не атаковали). "
    "Сфера Времени имеет на Карибах больший эффект, чем в других местах.")
 
// Achievements:
 
// Parrot : Find and collect Pirate Treasure.
// Caribbean Shark : Collect 10 Pirate Treasures.
// Pirate : Collect 25 Pirate Treasures.
// Master of Caribbean : Collect 50 Pirate Treasures.
 
// Red Rock Valley
 
N("Red Rock Valley", GEN_F, "Долина Красных Скал", "Долины Красных Скал", "Далину Красных Скал", "в Долине Красных Скал")
 
N("Rock Snake", GEN_F, "Каменная змея", "Каменные змеи", "Каменную змею", "Каменной змеёй")
N("Rock Snake Tail", GEN_O, "Хвост змеи", "Хвосты змей", "Хвост змеи", "Хвостом змеи")
N("Red Troll", GEN_M, "Красный тролль", "Красные тролли", "Красного тролля", "Красным троллем")
N("Red Gem", GEN_O, "Красный камень", "Красные камни", "Красный камень", "Красным камнем")
 
N("rock I", GEN_F, "скалы I", "скалы I", "скалу I", "скалой I")
N("rock II", GEN_F, "скалы II", "скалы II", "скалу II", "скалой II")
N("rock III", GEN_F, "скалы III", "скалы III", "скалу III", "скалой III")
 
Orb("Space", "Пространства")
 
S("Not enough power for telekinesis!", "Мало силы для телекинеза!")
 
S("This land contains high rock formations. Most of the valley is at level 0, "
  "while items are found at level 3. It is impossible to gain two or more levels, "
  "or to lose three levels, in a single move, (attacks are possible at any "
  "difference, though). Kill Red Trolls and Rock Snakes to make a cell higher.",
 
  "Эта земля содержт участки высоких скал. Большая часть долины находится на уровне 0, "
  "а все предметы лежат на уровне 3. Невозможно подняться на 2 или больше уровня "
  "или опуститься на 3 уровня за один ход, хотя атаковать можно всегда. "
  "Убейте Красного тролля или Каменную змею, чтобы сделать клетку выше.")
 
S("A kind of Troll native to the Red Rock Valley.",
  "Этот вид троллей обитает в Долине Красных Скал.")
 
S(
  "Rock snakes are similar to Sandworms, but they move each turn. However, they "
  "only move on the hexagonal cells. They are also somewhat longer than the Sandworms.",
 
  "Каменные змеи похожи на Пустынных червей, но движутся каждый ход. Однако они "
  "могут перемещаться только по шестиугольникам. Также они несколько длиннее червей.")
 
S("A gem from the Red Rock Valley.", "Камень из Долины Красных Скал.")
 
S(
    "This Orb is able to bring faraway items to your location, even if there are "
    "monsters or barriers on the way. The cost of "
    "bringing an item (in charges) equals the square of its distance to you. Contrary "
    "to some other Orbs, usage is not allowed if you have not enough power left.",
   
  "Эта сфера может принести Вам предметы издалека, даже если на пути есть монстры "
  "или препятствия. Стоимость использования равна квадрату расстояния "
  "до предмета. В отличие от некоторых других сфер, она не может быть использована, "
  "если ей силы не хватает.")
 
// Climber : Find and collect a Red Gem.
// Red Troll : Collect 10 Red Gems.
// Rock Snake : Collect 25 Red Gems.
// Master of Red Rock : Collect 50 Red Gems.
 
// missing sentences
 
S("%The1 drowns!", "%1 утонул%E1!");
S("%The1 falls!", "%1 упал%E1!");
 
// these were missing from the translation for some reason
 
S("Hell has these lakes everywhere... They are shaped like evil stars, and filled with burning sulphur.",
  "В Аду эти озёра повсюду. Они похожи на звёзды и наполнны кипящей серой.")
 
// Hardcore Mode
 
S("hardcore mode", "режим hardcore");
 
S("One wrong move and it is game over!", "Один неверный шаг, и игра закончится!");
S("Not so hardcore?", "не так хардкорно?");
 
// Shoot'em up Mode
 
S("shoot'em up mode", "режим стрельбы");
S("Welcome to the Shoot'em Up mode!", "Добро пожаловать в режим стрельбы!");
S("F/;/Space/Enter/KP5 = fire, WASD/IJKL/Numpad = move", "F/;/Space/Enter/KP5 = стрелять, WASD/IJKL/Numpad = ходить");
 
N("Rogue", GEN_M, "Разбойник", "Разбойники", "Разбойника", "Разбойником")
N("Knife", GEN_O, "Нож", "Ножи", "Нож", "Ножом")
N("Flail", GEN_O, "Цеп", "Цепы", "Цеп", "Цепом")
N("Fireball", GEN_O, "Огненный Шар", "Огненные Шары", "Огненный Шар", "Огненным Шаром")
N("Tongue", GEN_O, "Язык", "Языки", "Язык", "Языком")
 
S("In the Shoot'em Up mode, you are armed with thrown Knives.",
  "В режиме стрельбы Вы вооружены метательными ножами.")
S("A simple, but effective, missile, used by rogues.",
  "Простой, но эффективный снаряд, используемый разбойниками.")
S("This attack is likely to hit the attacker.",
  "Эта атака, вероятно, попадёт в атакующего.")
S("This magical missile burns whatever it hits.", "Этот магический снаряд поджигает всё, во что попадает.")
S("Some monsters have long tongues, which allow them to attack enemies in nearby cells.",
  "Некоторые существа имеют длинные языки, которые позволяют им атаковать врагов на соседних клетках.")
 
// modes for the local highscores
 
S(", m - mode: normal", ", m - нормальный режим")
S(", m - mode: hardcore only", ", m - режим hardcore")
S(", m - mode: shoot'em up", "m - режим стрельбы")
 
// update description for Steam:

S("You are killed by %the1!", "Вас убил %1!")
 
// (Shoot'em Up mode and two more lands than in the free version, and more are planned!)

S("You would get hurt!", "Это было больно!")
S("PARTIAL", "ЧАСТИЧНО")
S("Cannot drop %the1 here!", "Сюда нельзя положить мёртвую сферу!")
S("You cannot attack Rock Snakes directly!", "Вы не можете атаковать Каменную змею!");
S(" (E:%1)", " (E:%1)");

S("\"I am lost...\"", "\"Я потерялся...\"");

// achievements from Version 7.0 which have not yet been translated
 
// Hardcore : Get the Orb of Yendor in the Hardcore mode.
// Хардкор: Соберите сферу Йендора в режиме Хардкор
// Knife Master : Get the Orb of Yendor in the Shoot'em Up mode.
// Мастер ножей: Соберите сферу Йендора в режиме стрельбы.
 
// new menu for Version 7.1
 
S("(v) menu", "(v) меню")
S("return to the game", "вернуться в игру")
S("or 'v' to see the main menu", "или 'v', чтобы открыть главное меню")
 
S("HyperRogue %1", "HyperRogue %1")
S("basic configuration", "базовые настройки")
S("advanced configuration", "продвинутые настройки")
S("local highscores", "локальные рекорды")
S("help", "помощь")
S("restart game", "играть заново")
S("special game modes", "специальные режимы")
S("save the game", "сохранить игру")
S("quit the game", "выйти из игры")
S("review your quest", "смотреть квест")
S("review the scene", "смотреть сцену")
S("game over screen", "экран конца игры")
S("continue game", "продолжить игру")
S("play the game!", "играть!")
 
// fixed descriptions for Shmup achievements
 
S("You have used less knives than ever before. Congratulations!",
  "Вы использовали меньше ножей, чем раньше. Поздравляем!")
 
S("You have improved both your real time and knife count. Congratulations!",
  "Вы улучшили результаты по реальному времени и количеству ножей. Поздравляем!")
 
S("%1 knives (%2)", "ножи: %1 (%2)")
 
// temporary
S("No description yet." ,"Нет описания.")
 
// special case when no Spice is visible
S("The sandworm explodes!", "Червь взорвался!")
 
// Ocean
 
// achievements:
// Reached Ocean: Find and collect an Amber.
// Открыть Океан: Найдите а соберите Янтарь.
// Albatross: Collect 10 Ambers.
// Альбатрос: Соберите 10 янтарей.
// Amber Albatross: Collect 25 Ambers.
// Янтарный альбатрос: соберите 25 янтарей.
// Master of the Tides: Collect 50 Ambers.
// Мастер приливов: Соберите 50 янтарей.
 
N("Ocean", GEN_O, "Океан", "Океаны", "Океан", "в Океане")
 
S(
    "You can collect some valuable Ambers on the coast, but beware the tides!\n\n"
    "You can also take one of the boats and venture into the Ocean, "
    "to find other coasts, dangerous whirlpools, and islands inhabited by Pirates.",
 
  "Вы модете найти ценный Янтарь не берегу, но остерегайтесь приливов!\n\n"
  "Вы модете найти лодку и отправиться в Океан, чтобы найти другие берега, "
  "опасные Водовороты и острова, полные пиратов.")
 
N("Albatross", GEN_M, "Альбатрос", "Альбатросы", "Альбатроса", "Альбатросом")
 
S(
  "Those large seabirds attack you for some reason. At least they are not "
  "as fast as Eagles...",
  "Эти большие морские птицв почему-то атакуют Вас. Они хотя бы не такие "
  "быстрые, как Орлы...")
 
N("stranded boat", GEN_F, "лодка на мели", "лодки на мели", "лодку на мели", "в лодке на мели")
 
 
S(
  "This boat cannot go through the sand. But if you sit inside and "
  "wait for the tide, you will be able to use it to travel through the Ocean.",
 
  "Эта лодка не может пройти сквозь песок. Но если вы сядете внутрь "
  "и дождётесь прилива, Вы сможете ей воспользоваться."
  )    
 
N("Ocean", GEN_O, "Океан", "Океаны", "Океан", "в Океане")
 
N("Amber", GEN_O, "Янтарь", "Янтари", "Янтарь", "Янтарём")
 
S(
  "When the tide is away, beautiful ambers can be found on the hyperbolic beaches. "
  "Perhaps there used to be a forest here?",
 
  "Во время отлива на гиперболических берегах можно найти прекрасный Янтарь. "
  "Може, здесь когда-то был лес?"
  )

Orb("Air", "Воздуха")
 
S("This Orb allows you to blow your enemies away.\n\n"
  "Click a monster to blow it one cell away. It cannot be used against mimics, ghosts, sharks and other monsters restricted to a specific terrain, and multi-tile monsters.",
  "Эта сфера позволяет Вам сдуват врагов вдаль.\n\n"
  "Нажми на монстра, чтобы сдуть его на 1 клетку. Невозможно сдуть мимиков, духов, акул и других монстров, живущих на определённой территории, и монстров из нескольких частей."  
  )

N("Sea Border", GEN_O, "Граница моря", "Границы моря", "Границу моря", "на Границе моря")
 
S("Border between seas.", "Граница между морями.")
 
// Whirlpool
 
// achievements:
// Escaped Whirlpool: Collect a Pearl, and escape the Whirlpool.
// Покинуть Водоворот: Соберите Жемчужину и выберитесь из Водоворота.
// Vortex Shark: Collect 10 Pearls.
// Акула вихря: Соберите 10 жемчужин.
// Vortex Pirate: Collect 25 Pearls.
// Пират Вихря: Соберите 25 жемчужин.
// Master of the Whirlpool: Collect 50 Pearls.
// Мастер Водоворота: Соберите 50 жемчужин.
 
N("Whirlpool", GEN_O, "Водоворот", "Водовороты", "Водоворот", "в Водовороте")
 
S(
  "Many lost boats are spinning in this whirlpool. Some of them contain treasures "
  "and Pirates.\n\n"
  "Unmanned boats will go one cell clockwise in each turn. Sharks and manned boats "
  "are only allowed to go with the current, that is, towards the center, or clockwise.",
 
  "Много лодок погибло в этом водовороте. В некоторых из них были ценности и Пираты.\n\n"
  "Пустые лодки движутся на одну клетку по часовой стрелке каждые ход. Акулы и лодки с людьми "
  "движутся по течению, то есть к центру или по часовой стрелке."
  )
 
N("Pearl", GEN_F, "Жемчужина", "Жемчужины", "Жемчужину", "Жемчужиной")
 
S(
  "You do not know exactly why, but there are valuable pearls on many boats "
  "in the whirlpool.",
  "Неизвестно, почему, но этих жемчужин довольно много в лодках в этом водовороте."
  )
 
Orb("Water", "Воды")
 
S( "This Orb allows your boat to go against the current, "
   "and also to go into the land, creating water on the way.",
   "Эта сфера позволяет тебе плыть против течения, "
   "а также двигаться по суше, создавая воду по пути.")
 
S("You cannot go against the current!", "Нельзя плыть против течения!")
 
// Minefield
 
// achievements:
// Reached Minefield: Collect a Bomberbird Egg.
// Открыть Минное поле: Соберите Яйцо бомбардира.
// Minesweeper: Collect 10 Bomberbird Eggs.
// Сапёр: Соберите 10 Яиц бомбардира.
// Bomberbird: Collect 25 Bomberbird Eggs.
// Бомбардир: Соберите 25 Яиц бомбадира.
// Master of the Minefield: Collect 50 Bomberbird Eggs.
// Мастер Минного поля: Соберите 50 Яиц бомбардира.
 
N("Minefield", GEN_N, "Минное поле", "Минные поля", "Минное поле", "на Минном поле")
N("minefield", GEN_N, "минное поле", "минные поля", "минное поле", "на минном поле")
N("cell without mine", GEN_N, "поле без мин", "поля без мин", "поле без мин", "полем без мин")
 
S(
  "This minefield has been created by the Bomberbirds to protect their valuable eggs. "
  "Mines explode when they are stepped on, creating fire all around them "
  "(this fire never expires in the Minefield). If you don't step on a mine, you "
  "know the number of mines in cells around you. These numbers are marked with "
  "color codes on the cells you have visited.",
  "Минное поле было создано птицами Бомбардирами, чтобы охранять их ценные яйца. "
  "Мина взрывается, когда Вы наступаете на неё, и создаёт огонь вокруг Вас (огонь "
  "здесь горит вечно). Если Вы не наступили на мину, то Вы знаете, сеолько мин рядом с Вами. "
  "Эти числа кодируются цветами клеток, на которых Вы были."
  )
 
N("Bomberbird", GEN_M, "Бомбардир", "Бомбардиры", "Бомбардира", "Бомбардиром")
 
S(
    "Dark red birds who have created the minefield.\n\n"
    "They create a mine on the spot where they are killed, provided "
    "that the terrain is suitable. Also note that mines are triggered "
    "by dead birds falling on them.",
 
    "Тёмно-чёрные птицы, создавшие Минное поле.\n\n"
    "Когда птица умирает, на клетке, где она была, остаётся мина. "
    "Помни, что мёртвые птицы могут активировать мины.")
 
N("Tame Bomberbird", GEN_M, "Ручной бомбардир", "Ручные бомбардиры", "Ручного бомбардира", "Ручным бомбардиром")
   
S(
  "This bomberbird will follow you at some distance, and attack your enemies. "
  "You can kill it to place a mine.",
 
  "Этот бомбардир будет следовать за Вами и атаковать Ваших врагов. "
  "Можете его убить, чтобы оставить мину.")
 
N("Bomberbird Egg", GEN_N, "Яйцо бомбардира", "Яйца бомбардира", "Яйцо бомбардира", "Яйцом бомбардира")
 
S(
  "Bomberbird eggs are big and tasty, and thus valuable. "
  "They can hatch when left alone for some time (but this will never happen "
  "if you are watching).",
 
  "Яйца бомбардиров большие и вкусные, и потому ценные. "
  "Если оставть их в покое, может вылупиться бомбардир (но этого "
  "не случится, пока Вы на них смотрите)."
  )
 
Orb("Friendship", "Дружбы")
 
S("This Orb summons a friendly Bomberbird.",
  "Эта сфера вызывает ручного Бомбардира.")
 
S("Nowhere to blow %the1!", "Некуда сдуть %a1!")
S("%The1 is immune to wind!", "%1 защищён от ветра!")
S("You blow %the1 away!", "Вы сдули %a1!")
  
S("WARNING: you are entering a minefield!", "ВНИМАНИЕ: вы вошли на минное поле!")
S("No mines next to you.", "Нет мин рядом с Вами.")
S("A mine is next to you!", "Одна мина рядом с Вами!")
S("Two mines next to you!", "Две мины рядом с Вами!")
S("Three mines next to you!", "Три мины рядом с Вами!")
S("Four mines next to you!", "Четыре мины рядом с Вами!")
S("Five mines next to you!", "Пяти мин рядом с Вами!")
S("Six mines next to you!", "Шесть мин рядом с Вами!")
S("Seven mines next to you!", "Семь мин рядом с Вами!")
 
S("Still confused? Read the FAQ on the HyperRogue website!\n\n",
  "Что-т неясно? Прочитайте FAQ на сайте HyperRogue! (по-английски)\n\n")

S("You have to run away from the water!", "Убегайте из воды!")

 
N("Palace", GEN_O, "Дворец", "Дворцы", "Дворец", "в Дворце")
N("palace wall", GEN_F, "стена дворца", "стены дворца", "стену дворца", "стеной дворца")
 
S("Apparently a princess is kept locked somewhere, but you won't ever find her in this hyperbolic palace. ",
  "Видимо, принцесса где-то заперта, но в гиперболическом дворце Вы её не найдёте. ")
 
S("Apparently a prince is kept locked somewhere, but you won't ever find him in this hyperbolic palace. ",
  "Видимо, принц где-то заперт, но в гиперболическом дворце Вы его не найдёте. ")
 
S("So better just to concentrate on collecting treasure. "
  "Beware the traps, and the guards, who are hard to kill!",
 
  "Лучше сконцентрироваться на сборе сокровищ. "
  "Остерегайтесь ловушек и стражников, которых сложно убить!"
  )
 
N("trapdoor", GEN_F, "ловушка", "ловушки", "ловушку", "ловушкой")
S("This floor will fall after someone goes there. Go quickly!",
  "Пол провалится, как только на него наступят. Бегите!")
 
N("closed gate", GEN_O, "закрытый проход", "закрытые проходы", "закрытый проход", "закрытым проходом")
N("open gate", GEN_O, "открытый проход", "открытые проходы", "открытый проход", "открытым проходом")
N("closing plate", GEN_F, "закрывающая плита", "закрывающие плиты", "закрывающую плиту", "закрывающей плитой")
N("opening plate", GEN_F, "открывающая плита", "открывающие плиты", "открывающую плиту", "открывающей плитой")
 
S("Green pressure plates open all gates in radius 3 around them. "
  "Similarly, red pressure plates close all gates in this radius.",
 
  "Зелёная плита открывает все проходы в радиусе 3 клеток. "
  "Аналогично, красная плита закрывает проходы в том же радиусе.")
 
N("Hypersian Rug", GEN_O, "Гиперсидский ковёр", "Гиперсидские ковры", "Гиперсидский ковёр", "Гиперсидским ковром")
S("Nice, a hyperbolic rug! It will not fit very well on your flat Euclidean floor, but who cares?",
  "Прекрасный гиперболический ковёр! На плоский пол его не положишь, ну и пусть.")
 
Orb("the Frog", "Жабы")
S("This Orb lets you jump to a place which is two cell away from you, in a single turn. "
  "You can jump over water, chasms and fire, but not over walls.",
  "Эта сфера позволяет прыгать на 2 клетки за один ход. "
  "Вы можете прыгать через воду, огонь или пропасть, но не через стены.")
S("Cannot jump through %the1!", "Нельзя прыгать через %a1!")
S("You jump!", "Вы прыгнули!")
 
S("\n\nNote: when pushing %the1 off a heptagonal cell, you can control the pushing direction "
  "by clicking left or right half of the heptagon.",
  "\n\nВажно: когда Вы толкаете %a1 с семиугольника, Вы можете выбирать направление движения, "
  "нажимая на соответствующую половину семиугольника."
  )
 
S(" With the keyboard, you can rotate the view for a similar effect (Page Up/Down).",
  " На клавиатуре пользуйтесь поворотом поля для того же эффекта (Page Up/Down).")
 
N("Palace Guard", GEN_M, "Дворцовый стражник", "Дворцовые стражники", "Дворцового стражника", "Дворцовым стражником")
 
S("You have to hit Palace Guards several times to kill them. After each hit, they "
  "are pushed away and stunned for some time.",
  "Чтобы убить Дворцового стражника, его нужно ударить несколько раз. После каждого удара "
  "он отлетает на одну клетку назад и застывает на некоторое время.")
 
N("Fat Guard", GEN_M, "Тучный стражник", "Тучные стражники", "Тучного стражника", "Тучным стражником")
 
S("Fat guards are too heavy to be pushed away by your hits.",
  "Тучный стражник слишком тяжёл, чтобы отлетать от Ваших ударов.")
 
N("Skeleton", GEN_M, "Скелет", "Скелеты", "Скелета", "Скелетом")
S("Skeletons work similar to Palace Guards, but they won't die no matter how many "
  "times you hit them. Well, you have to be more creative...\n\n"
  "Skeletons attacked outside of their native land, Palace, are stunned for a longer time.",
  "Скелет реагирует на удары как Дворцовый стражник, но сколько раз бы Вы его не ударили, "
  "он не умрёт. Хитрее надо быть...\n\n"
  "Если скелет атакован вне его родной земли, Дворца, он застывает на более долгое время."
  )
 
N("Vizier", GEN_M, "Визирь", "Визири", "Визиря", "Визирем")
S("Viziers are neither pushed away nor stunned. However, you attack them automatically when "
  "escaping from them.",
  "Визиря нельзя ни оглушить, ни оттолкнуть. Вы атакуете его каждый раз, когда "
  "убегаете от него.")
 
S("You stun %the1.", "Вы оглушили %a1.")
S("The gate is closing right on you! RUN!", "Проход закрывается! БЕГИТЕ!")
S("%The1 is crushed!", "%1 разрушается")
S("You hit %the1.", "Вы ударили %a1.")
S("Hit him by walking away from him.", "Ударьте его, убежав от него.")
S("Hmm, he has been training in the Emerald Mine. Interesting...", "Он тренировался в Изумрудной шахте. Хм, интересно...")
 
// Reached the Palace: Find and collect a Hypersian Rug.
// Открыть Дворец: Найдите и соберите Гиперсидский ковёр.
// Palace Guard: Collect 10 Hypersian Rugs.
// Дворцовый страж: Соберите 10 Гиперсидских ковров.
// Vizier: Collect 25 Hypersian Rugs.
// Визирь: Соберите 25 Гиперсидских ковров
// Prince: Collect 50 Hypersian Rugs.
// Принц: Соберите 50 Гиперсидских ковров.
 
// Living Fjord
 
N("Living Fjord", GEN_O, "Живой фьорд", "Живые фьорды", "Живой фьорд", "в Живом фьорде")
 
S("A coastal area, from where you can get both to the inland worlds and to the Ocean. "
  "Each turn, each cell will become water or earth, based on the majority of cells around it. "
  "Contrary to the Living Caves, this process is not affected by most items and monsters, "
  "but elementals, dead Trolls, and cells outside of the Living Fjord have "
  "a very powerful effect.",
  "Прибрежный регион, из которого можно попасть как в наземные области, так и в Океан. "
  "Каждый ход каждая клетка становится сушей или водой, основываясь на том, каких соседей больше. "
  "В отличие от Живой пещеры этот процесс не зависит от объектов и монстров, за "
  "исключением Элементалей, мёртвых Троллей и клеток вне Живого фьорда - "
  "все они имеют очень сильный эффект."
  )
 
N("Fjord Troll", GEN_M, "Тролль фьорда", "Тролли фьорда", "Тролля фьорда", "Троллем фьорда")
S("Fjord Trolls leave a wall when they die, causing the living fjord to rise around it. "
  "Contrary to Rock Trolls, items around are not destroyed.",
  "Тролли фьорда превращаются в стену при смерти, вызывая рост живых фьордов вокруг. "
  "В отличие от горных троллей они не уничтожают предметы."
  )
 
N("Viking", GEN_M, "Викинг", "Викинги", "Викинга", "Викингом")
S("Mighty warriors from the Fjord, who can use boats.",
  "Могучие воины из Фьорда, способные использовать лодки.")
 
N("Water Elemental", GEN_M, "Водный элементаль", "Водные элементали", "Водного элементаля", "Водным элементалем")
S("Wherever this powerful being goes, the living fjord "
  "sinks below water, non-magical boats are destroyed, and fires are extinguished.\n\n"
  "As a special case, you can attack the Water Elemental from the water, without drowning immediately.",
  "Где бы ни шло это могущественное существо, фьорды расступаются перед ним, "
  "обычные лодки уничтожаются, огонь гаснет.\n\n"
  "Однако, если Вы атакуете его, находяст в воде, Вас не затянет сразу в воду.")
 
 
N("Garnet", GEN_O, "Гранат", "Гранаты", "Гранат", "Гранатом")
S("Vikings believe that garnets improve their strength.",
  "Викинги верятЮ что гранаты дают им силу.")
 
Orb("the Fish", "Рыбы")
S("This Orb lets you dive into the water. While diving, you are able to see and collect underwater treasures, "
  "while being invisible to monsters yourself. You are afraid of jumping into the water straight from a boat, so usually you won't do it.",
  "Эта сфера позволяет нырять. Когда Вы ныряете, Вы видите и можете собирать подводные ценности, "
  "а враги Вас не видят. Но Вы боитесь прягать из лодки прямо в воду.")
 
S("%The1 is washed away!", "%a1 смыло водой!")
S("%The1 is extinguished!", "%1 гаснет!")
 
// Reached the Living Fjord: Find and collect a Garnet.
// Открыть Живой фьорд: Найдите и соберите Гранат.
// Viking: Collect 10 Garnets.
// Викинг: Соберите 10 гранатов.
// Water Elemental: Collect 25 Garnets.
// Водный элементаль: Соберите 25 гранатов.
// Master of the Fjord: Collect 50 Garnets.
// Мастер фьорда: Соберите 50 гранатов.
 
// implemented, not appears in the game yet
 
Orb("Discord", "Раздора")
 
S("Causes most monsters to attack other monsters, not only you and your friends.",
  "Монстры начинают атаковать других монстров, а не только Вас и ваших союзников.")
 
// Shmup Configuration
 
S("forward", "вперёд")
S("backward", "назад")
S("turn left", "повернуть налево")
S("turn right", "повернуть направо")
S("move up", "идти наверх")
S("move right", "идти направо")
S("move down", "идти вниз")
S("move left", "идти налево")
S("throw a knife", "кинуть нож")
S("face the pointer", "лицом к цели")
S("throw at the pointer", "кинуть нож в цель")
S("drop Dead Orb", "бросить мёртвую сферу")
S("center the map on me", "центрировать карту по мне")
S("activate Orb power", "активировать сферу")
 
S("pan up", "крутить вверх")
S("pan right", "крутить вправо")
S("pan down", "крутить вниз")
S("pan left", "крутить влево")
S("rotate left", "повернуть влево")
S("rotate right", "повернуть вправо")
S("home", "центр на игроках")
 
S("do nothing", "ничего")
S("rotate view", "повернуть вид")
S("panning X", "крутить X")
S("panning Y", "крутить Y")
S("player 1 X", "игрок 1 X")
S("player 1 Y", "игрок 1 Y")
S("player 1 go", "игрок 1 идёт")
S("player 1 spin", "игрок 1 вертит")
S("player 2 X", "игрок 2 X")
S("player 2 Y", "игрок 2 Y")
S("player 2 go", "игрок 2 идёт")
S("player 2 spin", "игрок 2 вертит")
S("player 3 X", "игрок 3 X")
S("player 3 Y", "игрок 3 Y")
S("player 3 go", "игрок 3 идёт")
S("player 3 spin", "игрок 3 вертит")
S("player 4 X", "игрок 4 X")
S("player 4 Y", "игрок 4 Y")
S("player 4 go", "игрок 4 идёт")
S("player 4 spin", "игрок 4 вертит")
 
S("Joystick %1, axis %2", "Джойстик %1, ось %2")
S("one player", "один игрок")
S("two players", "два игрока")
S("configure player 1", "настройки игрока 1")
S("configure player 2", "настройки игрока 2")
S("configure player 3", "настройки игрока 3")
S("configure player 4", "настройки игрока 4")
S("configure panning", "настройки прокрутки")
S("configure joystick axes", "настройка джойстика")
S("continue playing", "продолжить игру")
S("start playing in the shmup mode", "начать игру в режиме стрельбы")
S("return to the turn-based mode", "вернуться в пошаговый режим")
S("save the configuration", "сохранить настройки")
S("press a key to unassign", "нажмите, чтобы отменить назначение")
S("press a key for '%1'", "нажмите клавишу для '%1'")
S("unassign a key", "отменить")
 
// extra pattern modes
 
S("explore the Emerald Pattern", "Изучить Изумрудный узор")
// S("explore the Fifty Pattern (4 colors)", "Изучить узор 50 (4 цвета)")
// S("explore the Fifty Pattern (8 colors)", "Изучить узор 50 (8 цветов)")
 
// extra flavor/Knight lines
 
S("Kill a Vizier in the Palace to access Emerald Mine", "Убей Визиря во дворце, чтобы открыть Изумрудную шахту.")
S("Collect 5 Emeralds to access Camelot", "Собери 5 изумрудов, чтобы открыть Камелот.")
S("Some lands unlock at specific treasures or kills", "Для открытия некоторых земель нужно определённые сокровища или убитые враги.")
 
S("You will be fighting red rock snakes, too...", "Вы тоже будете биться с красными змеями...")
 
S("\"The Red Rock Valley is dangerous, but beautiful.\"",
  "\"Долина красных камней опасна, но прекрасна.\"")
S("\"Train in the Desert first!\"", "\"Потренируйтесь сначала в Пустыне!\"")
S("\"I like collecting ambers at the beach.\"", "\"Люблю собирать янтарь на берегу.\"")
S("\"Our Table seats %1 Knights!\"", "\"За нашим столом сидит %1 рыцарей!\"")
S("\"There are %1 floor tiles inside our Table!\"", "\"Внутри стола %1 клеток!\"")
S("\"By now, you should have your own formula, you know?\"", "\"Сейчас у Вас должна быть своя формула!\"")
S("\"Have you tried to take a boat and go into the Ocean? Try it!\"", "\"Вы пробовали взять лодку и уплыть в Океан?\"")

//====================//
// NEW IN VERSION 7.3 //
//====================//
 
// new name for 'Ivy D'
 
N("Dead Ivy", GEN_O, "Мёртвый плющ", "Мёртвые плющи", "Мёртвый плющ", "Мёртвым плющом")
 
// new messages for living/nonliving monsters
 
S("%The1 bites %the2!", "%1 ударил%E1 %a2!")
S("%The1 attacks %the2!", "%1 атаковал%E1 %a2!")
S("You destroy %the1 with a mental blast!", "Вы уничтожили %a1 силой мысли!")
S("The ivy kills %the1!", "Плющ убил %a1!")
S("You destroy %the1.", "Вы уничтожили %a1.")
S("%The1 kills %the2!", "%1 убил%E1 %a2!")
S("%The1 sinks!", "%1 утонул%E1!");
 
S("Cannot jump on %the1!", "Нельзя прыгнуть на %1!")
 
// renamed Fifty to Palace
S("explore the Palace Pattern (4 colors)", "Изучить узор Дворца (4 цветов)")
S("explore the Palace Pattern (8 colors)", "Изучить узор Дворца (8 цветов)")
 
// Map Editor
//============
 
S("map editor", "редактор карт")
S("You activate your terraforming powers!", "Вы активировали силу редактирования!")
S("Press F5 to clear the board.", "Нажмите F5, чтобы очистить доску.")
S("Press F5 to restart the game normally.", "Нажмите F5, чтобы начать нормальную игру.")
S("High quality shots not available on this platform", "Скрины высокого качества недоступны на этой платформе")
S("Saved the high quality shot to %1", "Скрин высокого качества сохранён в %1")
S("Map saved to %1", "Карта сохранена в %1")
S("Map loaded from %1", "Карта загружена из %1")
S("copying", "копирование")
S("boundary", "граница")
S("clear monster", "удалить монстра")
S("use at your own risk!", "используйте это на свой риск!")
 
// Note: in English, these have been arranged from longest to shortest.
// This gives a somewhat nice effect on the top left corner of the screen.
// You may want to aim for the same effect when translating
 
S("0-9 = radius (%1)", "0-9 = радиус (%1)")
S("b = boundary", "i = предметы")
S("m = monsters", "b = граница")
S("w = walls",    "m = монстры")
S("i = items",    "l = земли")
S("l = lands",    "c = копия")
S("c = copy",     "w = стены")
 
// And this is from shortest to longest (bottom left corner)
S("F1 = help",                "F1 = помощь")
S("F2 = save",                "F2 = записать")
S("F3 = load",                "F3 = загрузить")
S("F5 = restart",             "F5 = перезапуск")
S("F6 = HQ shot",             "F6 = скриншот HQ")
S("F7 = player on/off",       "F7 = игрок вкл/выкл")
S("ESC = return to the game", "ESC = вернуться в игру")
 
S(
  "This mode allows you to edit the map.\n\n"
  "NOTE: Use at your own risk. Combinations which never "
  "appear in the real game may work in an undefined way "
  "(do not work, look strangely, give strange messages, or crash the game).\n\n"
  "To get the most of this editor, "
  "some knowledge of inner workings of HyperRogue is required. "
  "Each cell has four main fields: land type, wall type, monster type, item type. "
  "The same wall type (especially \"none\", \"sea\", or \"bonfire\") may look or "
  "work a bit differently, based on the land it is in. Sometimes an object may "
  "appear twice on the list due to subtle differences (for example, Demons could "
  "move next turn or not).\n\n"
  "Press w, i, l, or m to choose which aspect of cells to change, "
  "then just click on the cells and they will change. Press 'c' while "
  "hovering over a cell to copy that cell, this copies all information about it. "
  "When copying large areas or placing multi-tile monsters, it might be important where "
  "on the cell you are clicking.\n\n"
  "You can also press 0-9 to apply your changes to a greater radius. "
  "This also affects the copy/paste feature, allowing to copy a larger area.\n\n"
  "Press F2 to save the current map (and F3 to load it). If you try this after "
  "a long game of HyperRogue (without using Orbs of Safety), the filesize will "
  "be very large! "
  "Note however that large structures, such as "
  "Great Walls, large circles and horocycles, are destroyed by this.\n\n"
  "Press 'b' to mark cells as boundaries. Such cells, and cells beyond "
  "them, are not copied by the copy/paste feature, nor saved by the "
  "save feature.\n\n",
 
  "В этом режиме можно редактировать карту.\n\n"
  "ВНИМАНИЕ: используйте его на свой риск! Комбинации, которые не могут возникнуть "
  "в настоящей игре, могут иметь неопределённое поведение (не работать, выглядеть "
  "странно, выдавать странные сообщения, вызывать вылет игры).\n\n"
  "Чтобы пользоваться редактором, нужно немного представлять, как устроена игра "
  "HyperRogue. Каждая клетка содержит четыре основных элемента: тип земли, тип стены, тип монстра"
  "тип предмета. некоторые типы стен (особенно \"ничего\", \"море\" и \"костёр\")"
  " могут выглядеть или работать немного по-разному в зависимости от земли, в которой они "
  "находятся. Иногда объект может находиться в списке в двух экземплярах в зависимости от разных вещей "
  "(например, будет ли Демон двигаться на следующий ход).\n\n"
  "Нажмите w, i, l, m чтобы выбрать, какой атрибут клетки будете менять, нажмите на клетку, "
  "и она изменится. Нажмите 'c', когда мышка находится над клетко       , чтобы копировать "
  "клетку -- копируется вся информация о ней. Если Вы копируете или размещаете "
  "монстров из нескольких клеток, может иметь значение часть клетки, на которую Вы нажмёте.\n\n"
  "Нажмите 0-9, чтобы применить изменения с большим радиусом. "
  "Это также влияет на копирование/вставку, копируя большую область.\n\n"
  "Нажмите F2, чтобы сохранить текущую карту (и F3, чтобы загрузить). Если вы попробуете "
  "сделат это после долгой игры в HyperRogue (без сфер Безопасности), "
  "размер файла может быть очень велик! Большие структуры, такие как Великие стены "
  "и ороциклы, будут уничтожены.\n\n"
  "Нажмите 'b', чтобы обозначить клетку как границу. Такие клетки, как и клетки за ними, "
  "не будут копироваться, вставляться и сохраняться.\n\n"
  )
 
// Princess Quest
//================
 
// Saved the Princess - "Wybawca" - "Uratuj Księżniczkę."
// Princess Challenge - "Misja Księżniczka" - "Zwycięstwo w misji Księżniczka."
// Martial Artist - "Sztuki walki" - "Pozwól nieuzbrojonej Księżniczce wygrać walkę"
 
S(
  "A mouse squeaks at you. It seems that it wants you to go somewhere. "
  "That's interesting, what could you find here?\n\n"
  "Note: in the part of the Palace that you are exploring during this "
  "quest, the distribution of monsters, pressure plates, and items has been "
  "changed somewhat, to make it a bit more suitable for less "
  "experienced players. The number of monsters does not depend on the "
  "number of Hypersian Rugs you have collected, and there are more "
  "opening plates.\n\n"
  "However, even with the normal distribution, it appears that it should be "
  "always possible to reach your goal. If you want this challenge, "
  "select it from the special game modes menu.",
 
  "Мышка пищит на Вас. Как будто она хочет, чтобы Вы пошли куда-то. "
  "Интересно, что же там может быть?\n\n"
  "В той части Дворца, которая будет доступна в Квесте, "
  "распределение монстров, плит и предметов немного изменено, "
  "чтобы подходить для не очень опытных игроков. "
  "Количество монстров не зависит от количества собранных сокровищ, "
  "и открывающих плит здесь больше.\n\n"
  "Но и при нормальном распределении Квест можно пройти. "
  "Если Вы хотите это сделать, выберите специальный режим в меню."
)
 
S("\"When I visited the Palace, a mouse wanted me to go somewhere.\"",
  "\"Когда я был во Дворце, мышь пыталась меня позвать куда-то.\"")
  
S("\"I wonder what was there...\"", "\"Интересно, что там было...\"")
 
N("Mouse", GEN_F, "Мышка", "Мышки", "Мышку", "Мышкой")
 
S("You hear a distant squeak!", "Вы слышите писк!")
S("%The1 squeaks in a confused way.", "%1 пищит, запутавшись.")
S("%The1 squeaks gratefully!", "%1 пищит с благодарностью!");
S("%The1 squeaks hopelessly.", "%1 пищит без надежды.");
S("%The1 squeaks in despair.", "%1 пищит в отчаянии.");
S("%The1 squeaks sadly.", "%1 пищит грустно.");
S("%The1 squeaks with hope!", "%1 пищит с надеждой!");
S("%The1 squeaks happily!", "%1 пищит радостно!");
S("%The1 squeaks excitedly!", "%1 пищит азартно!");
 
N("giant rug", GEN_O, "огромный ковёр", "огромные ковры", "огромный ковёр", "огромным ковром")
 
S("This is the biggest Hypersian Rug you have ever seen! "
  "Unfortunately, it is too large to take it as a trophy.",
  "Это самый большой гиперсидский ковёр, который Вы когда-либо видели! "
  "К сожалению, он слишком большой, чтобы забрать его.")
 
N("Prince", GEN_M, "Принц", "Принцы", "Принца", "Принцем")
N("Princess", GEN_F, "Принцесса", "Принцессы", "Принцессу", "Принцессой")
 
S("%1 takes %his1 revenge on %the2!", "%1 будет мстить!")
S("\"That should teach you to take me seriously!\"",
  "\"Относись ко мне серьёзно! Будет тебе наука!\"")
 
S("%The1 kisses you, and begs you to bring %him1 away from here.",
  "%1 поцеловал%E1 тебя, и попросил%E1 увести отсюда.")
 
S("\"I want my revenge. Stun a guard and leave him for me!\"",
  "Я хочу мстить! Оглуши стража и оставь его мне!\"")
 
S("\"That felt great. Thanks!\"", "\"Это было прекрасно. Спасибо!\"")
 
S("\"Bring me out of here please!\"", "Прошу, уведи меня отсюда!\"")
 
S("%The1 kisses you, and thanks you for saving %him1.",
  "%1 поцеловал%E1 тебя и поблагодарил%E1 за спасение.")
 
S("\"I have been trained to fight with a Hypersian scimitar, you know?\"",
  "Я тренировал%c1 с гиперсидским ятаганом, ты в курсе?\"")
 
S("\"I would love to come to your world with you!\"",
  "Я хотел%E1 бы отправиться в Ваш мир вместе с Вами!\"")
 
S("\"Straight lines stay close to each other forever, this is so romantic!\"",
  "\"Прямые линии остаются близко друг к другу... Как романтично!\"")
 
S("\"Maps... Just like the world, but smaller... how is that even possible?!\"",
  "\"Карты... как мир, только меньше... как это возможно?!\"")
 
Orb("Love", "Любви")
S("Love takes time, but it heals all wounds, and transcends time and space.\n\n"
  "The Orb of Love is worth 30$$$, if you end the game with it.\n",
 
  "Любовь требует времени, но лечит все раны, и проходит сквозь "
  "время и пространство.\n\n"
  "Сфера любви стоит 30$$$, если закончить игру с ней.\n")
 
// Princess Challenge:
 
S("%1 Challenge", "Миссия %1")
S("Save %the1 first to unlock this challenge!", "Спаси %a1, прежде чем разблокировать миссию!")
S("Welcome to %the1 Challenge!", "Спаси %a1!")
S("The more Hypersian Rugs you collect, the harder it is.", "Чем больше Вы нашли гиперсидских ковров, тем это сложнее.")
S("Follow the Mouse and escape with %the1!", "Следуq за Мышкой и выйди с %abl1!")
S("Hardness frozen at %1.", "Сложность заморожена на %1.");
S("Congratulations! Your score is %1.", "Поздравляем! Ваш результат: %1.")

S("u = undo",     "u = отмена")
S("f = flip %1",     "f = перевернуть %1")
S("Failed to save map to %1", "Не удалось созранить карту в %1")
S("Failed to load map from %1", "Не удалось загрузить карту из %1")
S("save whom", "кого спасти")
S("other", "другое") // other keys in the main menu

// VERSION 7.4
 
// missing texts, refactored things, and rule changes
//====================================================
 
S("%The1 activates her Flash spell!", "%1 активировал%E1 заклинание вспышки!")
 
N("Fire", GEN_O, "Огонь", "Огни", "Огонь", "Огнём")
S("This cell is on fire. Most beings and items cannot survive.",
  "Эта клетка в огне. Большинство существ и предметов не могут выжить.")
 
N("Eternal Fire", GEN_O, "Вечный огонь", "Вечные огни", "Вечный огонь", "Вечным огнём")
S("This fire never burns out.", "Этот огонь никогда не гаснет.")
 
S("Some rubble.", "Щебень.")
 
S("The Orb loses its power as it leaves the Land of Power!",
  "Сфера потеряла свою силу, когда покинула Землю силы!")
 
S("%The1 fills the hole!", "%1 упал%E1 в дыру!")
 
N("Tentacle+Ghost", GEN_N, "Щупальце+Дух", "Щупальца+Духи", "Щупальце+Духа", "Щупальцем+Духом")
 
// Land Overview
//===============
 
S("world overview", "обзор мира")
S("or 'o' to see the world overview", "или 'o', чтобы посмотреть обзор")
 
S("forbidden to find in %the1", "запрещена %abl1")
S("too dangerous to use in %the1", "слишком опасна %abl1")
S("useless in %the1", "бесполезна %abl1")
S("only native Orbs allowed in %the1", "только родные сферы доступны %abl1")
S("this Orb is never unlocked globally (only hubs)", "эта сфера открывается только ы Центрах")
S("collect 25 %2 to unlock it in %the1", "collect 25x %2, чтобы открыть её %abl1")
S("collect 3 %2 to unlock it in %the1","collect 3x %2, чтобы открыть её %abl1")
S("native in %the1 (collect 10 %2)", "родная %abl1 (10x %2)")
S("native in %the1 (collect 1 %2)", "родная %abl1 (1x %2)")
S("secondary in %the1 (collect 10 %3, or 25 %2)", "дополнительная %abl1 (10x %3, или 25x %2)")
S("the native Orb of %the1", "родная сфера %abl1")
S("this Orb appears on floors and is used by witches", "эта сфера появляется на земле и используется ведьмами")
S("a prized Orb, it appears only in cabinets", "ценная сфера, только в кабинетах")
S("this Orb never appears in %the1", "эта сфера никогда не появляется %abl1")
S("Hub Land: orbs appear here if unlocked in their native land", "Центр: сфера появвляется здесь, когда она разблокировна в своей родной земле")
S("kill a monster, or collect 25 %2", "убей монстра, или собери 25x %2")
 
S("Always available.\n", "Земля всегда доступна.\n")
S("Treasure required: %1 $$$.\n", "Сокровищ нужно: %1 $$$.\n")
S("Accessible only from %the1.\n", "Доступно только из %a1.\n")
S("Accessible only from %the1 (until finished).\n", "Доступно только из %a1 (пока не окончена).\n")
 
S("Accessible only from %the1 or %the2.\n", "Доступно только из %a1 и %a2.\n")
 
S("Kills required: %1.\n", "УБийств нужно: %1 $$$.\n")
S("Finished lands required: %1 (collect 10 treasure)\n",
  "Земель окончено: %1 (собрано 10 сокровищ)\n")
 
S("Treasure required: %1 x %2.\n", "Сокровищ собрано: %1 x %2.\n")
 
S("Alternatively: kill a %1.\n", "Альтернатива: убить %a1.\n")
 
S("Kills required: any Elemental (Living Fjord/Dead Caves).\n",
  "Требуется убить любого элементаля (Живой фьорд/Мёртвая пещера).")
 
S("Variants of %the1 are always available in the Random Pattern Mode.",
  "Варианты земли %1 всегда доступны в режиме случайного узора.")
 
S("Variants of %the1 are available in the Random Pattern Mode after "
  "getting a highscore of at least 10 %2.",
  "Варианты земли %1 доступны в редиме случайного узора при рекорде не менее 10x "
  "%2.")
 
S(" kills: %1", " убийств: %1")
S(" $$$: %1", " $$$: %1")
S(" Hyperstone: %1/%2", " Гиперкамней: %1/%2")
S(" Hell: %1/9", " Ад: %1/9")
 
// improved editor
 
S("vector graphics editor -- press F1 for help", "графический редактор -- нажмите F1, чтобы получить помощь")
S("pics to save/load:", "картинки для загрузки/сохранения:")
S("level to save/load:", "карты для загрузки/сохранения:")
 
S("F4 = extension", "F4 = расширение")
S("Enter = back", "Enter = назад")
S("SPACE = map/graphics", "SPACE = карта/графика")
 
S("Emerald Pattern", "Изумрудный узор")
S("Palace Pattern", "Дворцовый узор")
S("Zebra Pattern", "узор Зебра")
S("rotational symmetry", "вращательная симметрия")
S("symmetry 0-1", "симметрия 0-1")
S("symmetry 0-2", "симметрия 0-2")
S("symmetry 0-3", "симметрия 0-3")
 
S("display pattern codes (full)", "показать коды узоров (полные)")
S("display pattern codes (simplified)", "показать коды узоров (упрощённые)")
S("display only hexagons", "показать только шестиугольники")
S("display only heptagons", "показать только семиугольники")
S("predesigned patterns", "спроектированные узоры")
 
S("Gameboard", "Игровая доска")
S("random colors", "случайные цвета")
S("emerald pattern", "изумрудный узор")
S("four elements", "четыре элемента")
S("eight domains", "восемь областей")
S("zebra pattern", "ущор зебры")
S("three stripes", "три полосы")
S("random black-and-white", "случайный чёрно-белый")
S("p = paint", "p = раскраска")
S("r = regular", "r = узор")
 
S(
   "In this mode you can draw your own player characters, "
   "floors, monsters, and items. Press 'e' while hovering over "
   "an object to edit it. Start drawing shapes with 'n', and "
   "add extra vertices with 'a'. Press 0-9 to draw symmetric "
   "pictures easily. More complex pictures can "
   "be created by using several layers ('l'). See the edges of "
   "the screen for more keys.",
   
   "В этом режиме можно нарисовать своего персонажа, пол, монстров, "
   "предметы. Нажмите 'e', держа мышь над объектом, "
   "чтобы его изменить. Добавляйте формы с 'n', вершины с 'a'. "
   "Нажмите 0-9 чтобы сделать симметричный узор. Более "
   "сложные фигуры могут состоять из нескольких слоёв ('l'). "
   "Остальные клавиши смотри в углах экрана.")
 
S(
   "Press 'r' to choose a regular pattern. When a pattern is on, "
   "editing a cell automatically edits all cells which are "
   "equivalent according to this pattern. You can choose from "
   "several patterns, and choose which symmetries matter "
   "for equivalence. Also, you can press Space to switch between "
   "the map and graphics editor quickly -- note that editing floors "
   "with the graphics editor also adheres to the pattern.",
   
   "Нажмите 'r', чтобы выбрать регулярный узор. Когда узор выбран, "
   "изменение клетки автоматически изменяет все эквивалентные, "
   "ей в этом узоре. Вы можете выбрать один из нескольких узоров "
   "и определить, какие симметрии важны для эквивалентности. "
   "Нажмите пробел, чтобы переключиться между картой и графическим "
   "редактором -- изменение пола влияет на узор.")
 
S("monster" ,"монстр")
S("item", "предмет")
S("floor", "пол")
S("hexagonal", "шестиугольник")
S("heptagonal", "семиугольник")
S("floor/pattern", "пол/узор")
 
S("l = layers: %1", "l = слой: %1")
S("1-9 = rotations: %1", "1-9 = поворот: %1")
S("0 = symmetry", "0 = симметрия")
S("0 = asymmetry", "0 = асимметрия")
S("%1 vertices", "вершины: %1")
S("a = add v", "a = добавить v")
S("m = move v", "m = передвинуть v")
S("d = delete v", "d = удалить v")
S("c = readd v", "c = обновить v")
S("b = reorder", "b = порядок")
S("t = shift", "t = сдвиг")
S("y = spin", "y = поворот")
 
S("'n' to start", "n = начать")
S("z = zoom in", "z = приблизить")
S("o = zoom out", "o = отдалить")
S("g = grid", "g = сетка")
S("e = edit this", "e = изменить")
 
S("x: %1", "x: %1")
S("y: %1", "y: %1")
S("z: %1", "z: %1")
S("r: %1", "r: %1")
S("ϕ: %1°", "ϕ: %1°")
 
S("A fake Land with colored floors.",
  "Фиктивная земля с разноцветным полом.")
 
S("random pattern mode", "режим случайных узоров")
 
// Ivory Tower
//=============
 
N("Ivory Tower", GEN_F, "Башня из слоновой кости", "Башни из слоновой кости", "Башню из слоновой кости", "в Башне из слоновой кости")
 
S(
  "Powerful wizards claimed this part of the world, to perform their magical "
  "experiments in peace and solitude. They have changed the direction of gravity, "
  "to make it even harder for intruders to reach them.\n\n"
  "Gravity works as follows: cells are unstable if they are empty, and there is "
  "no cell immediately below them which contains a wall. It is impossible to move "
  "from one unstable cell to another, except if moving down.",
 
  "Мощные колдуны создавали эту землю, чтобы проводить магические "
  "эксперименты в покое и уединении. Они изменили направление силы тяжести, "
  "чтобы сделать попадание сюда труднее.\n\n"
  "Гравитация работает так: клетка нестабильна, если она пуста, и "
  "поле под ним не содердит стены. Нельзя перейти с одного нестабильного поля "
  "на другое, иначе как вниз."
  )
 
N("Servant", GEN_M, "Слуга", "Слуги", "Слугу", "Слугой")
S("A simple servant of the master of the Ivory Tower.",
  "Обычный слуга Хозяина башни из слоновой кости.")
 
N("Gargoyle", GEN_F, "Горгулья", "Горгульи", "Горгулью", "Горгульей")
N("stone gargoyle", GEN_F, "каменная горгулья", "каменные горгульи", "каменную горгулью", "каменной горгульей")
N("stone gargoyle floor", GEN_O, "пол с горгульей", "полы с горгульями", "пол с горгульей", "полом с горгульей")
N("stone gargoyle bridge", GEN_O, "мост с горгульей", "мосты с горгульями", "мост с горгульей", "мостом с горгульями")
 
S(
  "A being made of stone, who likes high buildings. It becomes normal stone when "
  "killed, but only if next to something stable -- otherwise it falls.",
  "Существо из камня, выглядящее как высокое здание. Становится камнем, когда "
  "умирает, если рядом есть что-то стабильное -- "
  "иначе падает.")
 
N("Ivory Figurine", GEN_F, "Фигурка", "Фигурки", "Фигурку", "Фигуркой")
 
S("A beautiful figurine, made of ivory. Figurines close to the base of the Tower "
  "tend do disappear after you have collected many of them.",
  "Чудесная фигурка из слоновой кости. Фигурки рядом с основанием "
  "башни пропадают, когда Вы соберёте много их.")
 
N("Platform", GEN_F, "Платформа", "Платформы", "Платформу", "Платформой")
N("platform", GEN_F, "платформа", "платформы", "платформу", "платформой")

S("You can stand here.", "Можно встать сюда.")
 
N("ladder", GEN_F, "лестница", "лестницы", "лестницу", "лестницей")
S("You can use this ladder to climb the Tower.",
  "Используйти лестницу, чтобы забраться на Башню.")
 
Orb("Matter", "Вещества")
 
S("This Orb allows to temporarily create impassable matter, either to block paths or "
  "to build bridges across chasms and waters.",
  "Эта сфера позволяет временно создавать непроходимое вещество, чтобы блокировать "
  "пути или строить мосты через пропасть или воду.")
 
N("temporary wall", GEN_F, "временная стена", "временные стены", "временную стену", "временной стеной")
N("temporary floor", GEN_O, "временный пол", "временные полы", "временный пол", "временным полом")
N("temporary bridge", GEN_O, "временный мост", "временные мосты", "временный мост", "временным мостом")
 
S("This structure will disappear after some time.", "Эта конструкция пропадёт через некоторое время.")
 
S("Nothing to stand on here!", "Не на чем стоять!")
S("Gravity does not allow this!", "Гравитация не позволяет!")
 
// Elemental Planes
//==================
 
N("Elemental Planes", GEN_F, "Плоскость Стихий", "Плоскости Стихий", "Плоскость Стихий", "в Плоскости Стихий")
N("Plane of Fire", GEN_F, "Плоскость Огня", "Плоскости Огня", "Плоскость Огня", "в Плоскости Огня")
N("Plane of Earth", GEN_F, "Плоскость Земли", "Плоскости Земли", "Плоскость Земли", "в Плоскости Земли")
N("Plane of Air", GEN_F, "Плоскость Воздуха", "Плоскости Воздуха", "Плоскость Воздуха", "в Плоскости Воздуха")
N("Plane of Water", GEN_F, "Плоскость Воды", "Плоскости Воды", "Плоскость Воды", "в Плоскости Воды")
 
S("The Elemental Planes are divided into four subzones: Planes of Fire, Water, Air, and Earth. "
  "You need to collect a Shard from each Plane to construct an Elemental Gem. "
  "It is dangerous to collect too many Shards of the same type without constructing a Gem.",
 
  "Есть четыре Плоскости Стихий: Плоскость Огня, Воды, Воздуха и Земли. "
  "Вам нужно собрать по Осколку из каждой, чтобы собрать камень стихий. "
  "Собирать много осколков, не собирая Камень, довольно опасно."
  )
 
N("Fire Elemental", GEN_M, "Огненный Элементаль", "Огненные Элементали", "Огненного Элементаля", "Огненным Элементалем")
 
S("This monster leaves a trail of fire behind.",
  "Этот Элементаль оставляет за собой след Огня.")
 
N("Air Elemental", GEN_M, "Воздушный Элементаль", "Воздушные Элементали", "Воздушного Элементаля", "Воздушным Элементалем")
 
S("An Air Elemental looks like a live tornado. Once you are three (or less) cells from it, "
  "it is impossible to move closer, due to strong winds. You can stand and wait, though. "
  "This also affects most monsters.",
 
  "Воздушные элементаль похож на живое торнадо. Если Вы находитесь от него на расстоянии 3 или менее "
  "Вы не можете подойти ближе из-за сильного ветра. Но можно стоять и ждать. Это действует на всех монстров.")
 
N("Fire Shard", GEN_O, "Осколок Огня", "Осколки Огня", "Осколок Огня", "Осколком Огня")
N("Air Shard", GEN_O, "Осколок Воздуха", "Осколки Воздуха", "Осколок Воздуха", "Осколком Воздуха")
N("Water Shard", GEN_O, "Осколок Воды", "Осколки Воды", "Осколок Воды", "Осколком Воды")
N("Earth Shard", GEN_O, "Осколок Земли", "Осколки Земли", "Осколок Земли", "Осколком Земли")
N("Elemental Gem", GEN_O, "Камень стихий", "Камни стихий", "Камень стихий", "Камнем стихий")
 
Orb("Summoning", "Призыва")
 
S(
    "This orb allows you to summon monsters. Usually, they are either Elementals or "
    "native creatures. While the monsters do not like being summoned, and will "
    "attack you once they recover from summoning sickness, such summoning "
    "often has its uses.",
  "Эта сфера позволяет призывать монстров. Обычно это Элементали или родные "
  "для земли существа. Существа не нравится быть вызванным, и как только "
  "оно оправится от вызова, будет Вас атаковать."
  )
 
N("limestone wall", GEN_F, "известняковая стена", "известняковые стены", "известняковую стену", "известняковой стеной")
 
S("Simply a wall. Mostly.", "Обычная стена. В основном.")
 
// Zebra
//=======
 
N("Zebra", GEN_F, "Зебра", "Зебры", "Зебру", "в Зебре")
S("Everything in this Land has black and white stripes.",
  "Всё в этой Земли имеет белые и чёрные полосы.")
 
N("Striped Dog", GEN_M, "Полосатый пёс", "Полосатые псы", "Полосатого пса", "Полосатым псом")
S("A predator native to the Zebra.", "Типичный хищник этой земли.")
 
N("Onyx", GEN_O, "Оникс", "Ониксы", "Оникс", "Ониксом")
S("A black gem with white stripes. It is beautiful.", "Драгоценный чёрный камень с белыми полосками.")
 
// Crossroads III
//================
 
N("Crossroads III", GEN_O, "Перекрёсток III", "Перекрёстки III", "Перекрёсток III", "на Перекрёстке III")
 
S("An alternate layout of the Crossroads. Great Walls cross here at right angles.",
  "Альтернативный вариант Перекрёстка. Великие стены пересекаются под прямым углом.")
 
// Steam achievements:
 
/*
                "NEW_ACHIEVEMENT_5_12_NAME"     "Открыть Башню слоновой кости"
                "NEW_ACHIEVEMENT_5_12_DESC"     "Найдите и соберите Фигурку из слоновой кости."
                "NEW_ACHIEVEMENT_5_13_NAME"     "Слуга"
                "NEW_ACHIEVEMENT_5_13_DESC"     "Соберите 10 Фигурок."
                "NEW_ACHIEVEMENT_5_14_NAME"     "Горгулья"
                "NEW_ACHIEVEMENT_5_14_DESC"     "Соберите 25 Фигурок."
                "NEW_ACHIEVEMENT_5_15_NAME"     "Мастер Башни"
                "NEW_ACHIEVEMENT_5_15_DESC"     "Соберите 50 Фигурок."
                "NEW_ACHIEVEMENT_5_16_NAME"     "Открыть Зебру"
                "NEW_ACHIEVEMENT_5_16_DESC"     "Найдите и соберите Оникс."
                "NEW_ACHIEVEMENT_5_17_NAME"     "Полосатый пёс"
                "NEW_ACHIEVEMENT_5_17_DESC"     "Соберите 10 Ониксов."
                "NEW_ACHIEVEMENT_5_18_NAME"     "Пятнистый пёс"
                "NEW_ACHIEVEMENT_5_18_DESC"     "Соберите 25 Ониксов."
                "NEW_ACHIEVEMENT_5_19_NAME"     "Клетчатый пёс"
                "NEW_ACHIEVEMENT_5_19_DESC"     "Соберите 50 Ониксов."
                "NEW_ACHIEVEMENT_5_20_NAME"     "Элементалист"
                "NEW_ACHIEVEMENT_5_20_DESC"     "Создайте Камень стихий."
                "NEW_ACHIEVEMENT_5_21_NAME"     "Младший элементаль"
                "NEW_ACHIEVEMENT_5_21_DESC"     "Создайте 10 Камней стихий."
                "NEW_ACHIEVEMENT_5_22_NAME"     "Старший элементаль"
                "NEW_ACHIEVEMENT_5_22_DESC"     "Создайте 25 Камней стихий."
                "NEW_ACHIEVEMENT_5_23_NAME"     "Мастер Стихий"
                "NEW_ACHIEVEMENT_5_23_DESC"     "Создайте 50 Камней стихий."
*/

S("Cannot create temporary matter on a monster!", "Нельзя создать временную материю на монстре!")
S("Cannot create temporary matter on an item!", "Нельзя создать временную материю на предмете!")
S("Cannot create temporary matter here!", "Нельзя создать временную материю здесь!")
S("Cannot summon on a monster!", "Нельзя призвать монстра на занятую клетку!")
S("No summoning possible here!", "Призыв невозможен!")
S("You summon %the1!", "Вы призвали %a1!")

S("F4 = file", "F4 = файл")

 
// VERSION 8.0
//=============
 
S("The Air Elemental blows you away!", "Воздушный элементаль сдул Вас!")
 
// appended to cave troll description
S(" Additionally, all items around the killed Troll will be destroyed.",
  " Все предметы рядом с умершим троллем также уничтожаются.")
 
// 'dead cave troll' and 'dead troll' are separated now
 
N("dead rock troll", GEN_M, "мёртвый пещерный тролль" ,"мёртвые пещерные тролли", "мёртвого пещерного тролля", "мёртвым пещерным троллем")
 
S("There are several species of trolls living in the hyperbolic world. "
  "Some of them leave this wall behind them when they die.",
 
  "В гиперболическом мире есть несколько видов троллей. "
  "Некоторые из них при смерти превращаются в такую стену.")
 
// paper model creator
//---------------------
 
S("paper model creator", "создатель бумажных моделей")
S("synchronize net and map", "синхронизовать сеть и карту")
S("display the scope", "показать охват")
S("create the model", "создать модель")
S("back to HyperRogue", "вернуться в игру")
S("design the net", "разработать сеть")
 
S("The paper model created as papermodel-*.bmp", "Модель сохранена как papermodel-*.bmp")
S("Failed to load the file 'papermodeldata.txt'", "Невозможно загрузить файл papermodeldata.txt")
S("Could not save the paper model data", "Не удалось сохранить модель")
 
// pure tactics mode
//-------------------
 
S("pure tactics mode", "режим тактики")
S("Not available in the pure tactics mode!", "Недоступно в тактическом режиме!")
S("\"The Knights of the Horocyclic Table salute you!\"", "\"Рыцари Орициклического Стола поздравляют Вас!\"")
S("press 0 to leave this mode", "Нажмите 0, чтобы выйти из режима")
S("Collect %1x %2 to unlock", "Соберите %1x %2, чтобы разблокировать")
 
S(
        "In the pure tactics mode, you concentrate on a specific land. "
        "Your goal to obtain as high score as possible, without using "
        "features of the other lands. You can then compare your score "
        "with your friends!\n\n"
       
        "You need to be somewhat proficient in the normal game to "
        "unlock the given land in this challenge "
        "(collect 20 treasure in the given land, or 2 in case of Camelot).\n\n"
       
        "Since getting high scores in some lands is somewhat luck dependent, "
        "you play each land N times, and your score is based on N consecutive "
        "plays. The value of N depends on how 'fast' the land is to play, and "
        "how random it is.\n\n"
       
        "In the Caribbean, you can access Orbs of Thorns, Aether, and "
        "Space if you have ever collected 25 treasure in their native lands.\n\n"
       
        "The rate of treasure spawn is static in this mode. It is not "
        "increased by killing monsters.\n\n"
       
        "Good luck, and have fun!",
       
        "В тактическом режиме Вы концентрируетесь на одной земле. Цель - "
        "максимизировать счёт,не используя особенности других земель. "
        "Вы можете сравнить свои результаты с результатами друзей!\n\n"
       
        "Вы должны быть достаточно опытным в обычной игре, чтобы открыть "
        "землю здесь (соберите в ней 20 сокровищ, или 2 в случае Камелота).\n\n"
       
        "Так как результаты в некоторых землях могут зависеть от случая, "
        "Вам нужно сыграть N раз, и счёт зависит от "
        "N последовательных игр. Значение N зависит от того, насколько быстро "
        "проходит игра, и насколько она зависит от случая.\n\n"
       
        "На Карибах Вам доступны сферы Шипов, Эфира и Пространства, если "
        "Вы собрали 25 сокровищ в их родных землях.\n\n"
       
        "Частота появления сокровищ здесь постоянна, она не зависит от количества "
        "убитых монстров.\n\n"
       
        "Удачи и приятного времяпровождения!")
 
// Yendor Challenge
//------------------
 
S("Yendor Challenge", "Миссия Йендора")
S("Collect 10 treasures in various lands to unlock the challenges there",
  "Собирайте 10 сокровищ в разных землях, чтобы разблокировать миссии здесь")
 
S("easy", "легко")
S("challenge", "испытание")
 
S("Challenges do not get harder", "Сложность не меняется")
S("Each challenge gets harder after each victory", "Миссия становится сложнее с каждой победой")
 
S(" (won!)", " (победа!)")
S(" (won at level %1!)", " (победа на уровне %1!)")
S("(locked)", "(закрыто)")
 
S(
    "There are many possible solutions to the Yendor Quest. In the Yendor "
    "Challenge, you will try many of them!\n\n"    
    "Each challenge takes part in a specific land, and you have to use what "
    "you have available.\n\n"
   
    "You need to obtain an Orb of Yendor in the normal game to activate "
    "this challenge, and (ever) collect 10 treasures in one or two lands "
    "to activate a specific level.\n\n"
   
    "After you complete each challenge, you can try it again, on a harder "
    "difficulty level.\n\n"
   
    "All the solutions showcased in the Yendor Challenge work in the normal "
    "play too. However, passages to other lands, and (sometimes) some land features "
    "are disabled in the Yendor "
    "Challenge, so that you have to use the expected method. Also, "
    "the generation rules are changed slightly for the Palace "
    "and Minefield while you are looking for the Orb of Yendor, "
    "to make the challenge more balanced "
    "(but these changes are also active during the normal Yendor Quest).\n\n"
   
    "You get 1000 points for each challenge won, and 1 extra point for "
    "each extra difficulty level.",
   
    "Есть много способов достать сферу Йендора. В этой миссии "
    "Вы можете попробовать все варианты!\n\n"
    "Каждая миссия проходит в конкретных землях, и можно использовать лишь то, "
    "что там есть.\n\n"
    "Вы должны достать сферу Йендора в обычной игре, чтобы открыть этот режим, "
    "и собрать 10 сокровищ в одной или двух землях, чтобы открыть конкретные уровни.\n\n"
   
    "Закончив определённую миссию, Вы можете попробовать её заново на большей сложности.\n\n"
   
    "Все решения, продемонстрированные в миссии Йендора, работают и в нормальной игре. "
    "Выходы в другие земли и некоторые внутренние особенности здесь отключены, "
    "что заставляет использовать предусмотренный способ. Правила генерации "
    "во Дворце и на Минном поле немного изменены, пока Вы ищете Сферу, "
    "но в нормальной игре эти изменения во время квеста тоже действуют.\n\n"
    )
 
S("Unlock this challenge by getting the Orb of Yendor!",
  "Откройте этот режим, собрав сферу Йендора!")
 
S("Collect 10 treasures in various lands to unlock the challenges there",
  "Собирайте 10 сокровищ в разных землях, чтобы открыть миссии здесь")
 
// Wild West
//-----------
 
N("Wild West", GEN_O, "Дикий Запад", "Дикие Запады", "Дикий Запад", "на Диком Западе")
N("Outlaw", GEN_M, "Бандит" ,"Бандиты", "Бандита", "Бандитом")
N("Bounty", GEN_F, "Награда", "Награды", "Награду", "Наградой")
N("saloon wall", GEN_F, "стена салуна", "стены салунов", "стену салуна", "стеной салуна")
N("Revolver", GEN_O, "Револьвер", "Револьверы", "Револьвер", "Револьвером")
 
S("%The1 shoots you!", "%1 застрелит тебя!")
S("You shoot %the1!", "Вы застрелили %a1!")
 
S(
  "Take a revolver, kill outlaws, collect bounties.\n\n"
  "Note: since this land is anachronistic, it is not available in normal game. "
  "It is only available in special modes.",
 
  "Хватай револьвер, убивай бандитов, получай награды!\n\n"
  "Замечание: Так как эта земля анахронистична, она не доступна в "
  "нормальной игре. Только в специальных режимах.")
 
// Land of Storms
//----------------
 
S(
  "Whenever after your move there is a connection between a charged and a "
  "grounded cell, there is a short circuit. All cells on any "
  "path connecting a charged and a grounded cell (without repeated cells, "
  "or two consecutive grounded/charged cells) become damaged.\n\n"
 
  "Sandstone walls and most creatures are conductive. Great Walls are "
  "isolators, but lands beyond them count as grounded.\n\n"
 
  "Fulgurite, the treasure, is created when you manage to short circuit "
  "a sandstone wall, or a Rich Metal Beast.\n\n"
 
  "Trolls leave conductive rocks when killed, and Metal Beasts can only "
  "be killed by electricity -- your attacks only stun them, or push "
  "them away if already stunned.",
 
  "После каждого Вашего хода, если есть соединение между заряженной и "
  "заземлённой клеткой, возникает короткое замыкание. По всем клеткам на пути "
  "между заряженной и заземлённой (без повторов, и без двух соседних "
  "заряженных/заземлённых) проходит ток.\n\n"
 
  "Стены из песчаника и большинство существ проводят ток. Великие стены -- "
  "изоляторы, а все клетки между ними считаются заземлёнными.\n\n"
 
  "Фульгурит, местное сокровище, появляется, если разрушить песчаник или "
  "убить Богатого железного зверя.\n\n"
 
  "Тролль при гибели превращается в проводящую стену. Железных зверей "
  "можно убить только электричеством -- атаки только оглушают их, или толкают, "
  "если уже оглушены.")
 
N("Land of Storms", GEN_F, "Земля Бури", "Земли Бури", "Землю Бури", "в Земле Бури")
N("charged wall", GEN_F, "заряженная стена", "заряженные стены", "заряженную стену", "заряженной стеной")
N("grounded wall", GEN_F, "заземлённая стена", "заземлённые стены", "заземлённую стену", "заземлённой стеной")
N("metal wall", GEN_F, "металлическая стена", "металлические стены", "металлическую стену", "металлической стеной")
N("sandstone wall", GEN_F, "песчаниковая стена", "песчаниковые стены", "песчаниковую стену", "песчаниковой стеной")
N("Storm Troll", GEN_M, "Тролль бури", "Тролли бури", "Тролля бури", "Троллем бури")
N("Metal Beast", GEN_M, "Железный зверь", "Железные звери", "Железного зверя", "Железным зверем")
N("Rich Metal Beast", GEN_M, "Богатый железный зверь", "Богатые железные звери", "Богатого железного зверя", "Богатым железным зверем")
N("electric discharge", GEN_O, "разряд", "разряды", "разряд", "разрядом")

 
S("There is a flash of thunder!", "Молния!")
 
Orb("Stunning", "Оглушения")
 
S("This Orb allows you to target monsters to stun them. "
  "10 charges are used to stun for 5 turns. Does not "
  "work against multi-tile monsters.",
 
  "Эта сфера позволяет оглушать монстров. "
  "10 зарядов = оглушения на 5 ходов. Не действует на "
  "\"многоклеточных\" монстров."
  )
 
S("You stun %the1!", "Вы оглушили %a1!")
 
// Overgrown Woods
//-----------------
 
Orb("Luck", "Удачи")
 
S("This Orb allows you to find new lands more easily. "
  "Lands where you have already collected less treasure, "
  "and especially the Crossroads, are more likely to "
  "spawn while you have this. Additionally, Orbs of Safety "
  "are more likely to spawn in the Whirlpool.",
 
  "Эта сфера позволяет с лёгкостью находить новые земли. "
  "Земли, в которых Вы собрали мало сокровищ, и особенно "
  "Перекрёстки, появляются чаще, пока у Вас есть "
  "эта сфера. Кроме того, сферы Безопасности чаще находятся "
  "в Водовороте."
  )    
 
N("Overgrown Woods", GEN_F, "Заросли", "Заросли", "Заросли", "в Зарослях")
N("Mutant Ivy", GEN_O, "Плющ-мутант", "Плющи-мутанты", "Плюш-мутант", "Плющом-мутантом")
N("Mutant Sapling", GEN_O, "Саженец-мутант", "Саженцы-мутанты", "Саженец-мутант", "Саженцем-мутантом")
N("Forest Troll", GEN_M, "Лесной тролль", "Лесные тролли", "Лесного тролля", "Лесным троллем")
 
S("Forest Trolls create an impassable wall when they die.",
  "Лесные тролли превращаются в непроходимые стены, когда умирают.")
 
S(
  "The Overgrown Woods are filled with mutant ivies! These plants "
  "grow very fast. Each leaf, after being grown, can grow itself "
  "on the next turn. However, each part is only able to grow "
  "once in 16 turns. Outside of the Overgrown Woods, the Mutant Ivy "
  "may grow only on hexagonal cells.\n\n"
  "Maybe such fast growing plants could help you solve the problem "
  "of hunger in your world? Kill the Mutant Ivies to collect Mutant Saplings.",
 
  "Заросли полны плющами-мутантами! Они растут очень быстро. "
  "Каждый выросший побег может расти на следующем же ходу. "
  "Но расти в следующий раз он сможет лишь через 16 ходов. "
  "Вне Зарослей плющи-мутанты могут расти только на шестиугольниках.\n\n"
  "Возможно, столь быстрый рост решит проблему голода в Вашем мире? "
  "Убейте плющ, чтобы собрать саженец."
  )
 
S("Trees in this forest can be cut down. Big trees take two turns to cut down.",
  "Вы можете рубить деревья в лесу. Большие деревья рубятся за два хода."
  )
 
/* ACHIEVEMENTS
 
                "NEW_ACHIEVEMENT_5_24_NAME"     "Саженец-мутант"
                "NEW_ACHIEVEMENT_5_24_DESC"     "Найдите и соберите саженец-мутант."
                "NEW_ACHIEVEMENT_5_25_NAME"     "Лесной тролль"
                "NEW_ACHIEVEMENT_5_25_DESC"     "Соберите 10 саженцев-мутантов."
                "NEW_ACHIEVEMENT_5_26_NAME"     "Плющ-мутант"
                "NEW_ACHIEVEMENT_5_26_DESC"     "Соберите 25 саженцев-мутантов."
                "NEW_ACHIEVEMENT_5_27_NAME"     "Мастер Плюща"
                "NEW_ACHIEVEMENT_5_27_DESC"     "Соберите 50 саженцев-мутантов."
                "NEW_ACHIEVEMENT_5_28_NAME"     "Молния"
                "NEW_ACHIEVEMENT_5_28_DESC"     "Найдите и соберите фульгурит."
                "NEW_ACHIEVEMENT_5_29_NAME"     "Тролль бури"
                "NEW_ACHIEVEMENT_5_29_DESC"     "Соберите 10 фульгуритов."
                "NEW_ACHIEVEMENT_5_30_NAME"     "Железный зверь"
                "NEW_ACHIEVEMENT_5_30_DESC"     "Соберите 25 фульгуритов."
                "NEW_ACHIEVEMENT_5_31_NAME"     "Богатый железный зверь"
                "NEW_ACHIEVEMENT_5_31_DESC"     "Соберите 50 фульгуритов."
 
*/

// N("Fulgurite", GEN_O, "Фульгурит", "Фульгурити", "Фульгурит", "Фульгуритем") // verify!

S("Alternatively: kill a %1 in %the2.\n", "Альтернатива: убить %a1 %abl2.\n")

S("Your power is drained by %the1!", "%1 уменьшил Вашу мощь!")
 
S("Wow! That was close.", "Ох! Это было близко.");
 
S("Collect four different Elemental Shards!", "Собери Осколки всех стихий!")
S("Unbalanced shards in your inventory are dangerous.",
  "Несбалансированность осколков в Вашем инвентаре опасна.")
S("You construct some Elemental Gems!", "Вы создали Элементальный камень!")
 
N("Fulgurite", GEN_O, "Фульгурит", "Фульгуриты", "Фульгурит", "Фульгуритом")
 
S("Alternatively: kill a %1 in %the2.\n", "Альтернатива: убить %a1 %abl2.\n")
 
// VERSION 8.1
//=============
 
// extra config
S("Prince", "Принц")
S("Princess", "Принцесса")
S("cat" ,"кот")
S("dog", "пёс")
S("dress color II", "цвет одежды II")
S("character", "персонаж")
 
//missing texts
S("%The1 hits %the2.", "%1 ударил%E1 %a2.")
S("%The1 is destroyed by the Flash.", "Вспышка уничтожила %1.")
 
// improved kill descriptions
S("parts destroyed: %1", "уничтожено частей: %1")
S("friends killed: %1", "убито союзников: %1")
S("monsters destroyed: %1", "монстров уничтожено: %1")
S("friends destroyed: %1", "союзников уничтожено: %1")
S("\n\nThis is a part of a monster. It does not count for your total kills.",
  "\n\nЭто лишь часть монстра. Не учитывается в количестве убийств.")
S("\n\nThis is a friendly being. It does not count for your total kills.",
  "\n\nЭто Ваш союзник. Не учитывается в количестве убийств.")
 
// Overgrown Clearing
//--------------------
 
S("A clearing in the Overgrown Woods. Obviously, this gives "
  "the Mutant Ivies an infinite space to grow...\n\n"
  "Mutant Fruits rot if they are not adjacent to a Mutant Ivy.",
 
  "Поляна в Зарослях. Представляет собой неограниченное пространство "
  "для роста плющей-мутантов...\n\n"
  "Мутировавшие фрукты гниют, если они не находятся рядом с плющом.")
 
N("Clearing", GEN_F, "Поляна", "Поляны", "Поляну", "на Поляне")
 
N("Mutant Fruit", GEN_O, "Фрукт-мутант", "Фрукты-мутанты",
"Фрукт-мутант", "Фруктом-мутантом")
 
N("Giant Fox", GEN_M, "Огромный лис", "Огромные лисы", "Огромного лиса", "Огромным лисом")
 
S(
    "What is freedom for you? A situation when you can walk wherever you want? "
    "Or a situation when you do not have to work, since you have as much tasty food "
    "as you want?\n\n"
    "Well, this creature has chosen the second option. It won't be happy "
    "if you destroy its prison.\n",
   
    "Что для Вас есть свобода? Когда можно идти, куда хочешь? "
    "Или когда не надо работать, так как есть столько вкусной еды, "
    "сколько хочешь?\n\n"
    "Это существо выбрало второй вариант. Лис не будет рад, если Вы "
    "разрушите его тюрьму.\n"
    )
 
Orb("Freedom", "Свободы")
 
S(
    "This orb is activated if you are unable to escape (radius 4) "
    "without making illegal moves or "
    "going through cells which are currently adjacent to enemy monsters. "
    "Most game over situations are covered by this, but generally, "
    "this orb is oversensitive...\n\n"
    "When activated, it creates a Flash effect of radius 5.",
   
    "Эта сфера активируется, если Вам некуда идти (в радиусе 4), "
    "не делая запрещённых ходов и не ходя на клетки, рядом с которыми "
    "стоит монстр. Обычно игра кончается именно в такой ситуации, "
    "хотя обратное верно далеко не всегда...\n\n"
    "При активации создаёт Вспышку радиуса 5."
  )
 
S("Your %1 activates!", "Ваша %1 сработала!")
 
// Haunted Woods
//---------------
 
S("You become a bit nervous...", "Вы начали нервничать...")
S("Better not to let your greed make you stray from your path.",
  "Лучше не идти на поводу у своей жадности!")
 
N("Haunted Woods", GEN_O, "Лес с привидениями", "Леса с привидениями",
"Лес с привидениями", "в Лесу с привидениями")
 
S(
  "A dark forest filled with ghosts and graves. But there is also treasure hidden "
  "deep within... But don't let greed make you stray from your path, as "
  "you can get lost!\n\n"
  "The Haunted Woods are bounded by a single equidistant curve. It is not a circle or horocycle.\n\n",
 
  "Мрачный лес, полный духов и надгробий. Но в глубине спрятаныi "
  "сокровища... Но не будьте слишком жадными, а то потеряетесь!\n\n"
  "Лес с привидениями ограничен одной эквидистантой.\n\n")
 
 
N("Black Lotus", GEN_O, "Чёрный лотос", "Чёрные лотосы", "Чёрный лотос", "Чёрным лотосом")
 
S(
    "This beautiful flower is greatly prized by wizards, as it allows them to cast powerful magical spells "
    "without preparation.\n",
 
    "Этот прекрасный цветок очень ценится колдунами, так как позволяет "
    "создавать мощные чары без подготовки.\n"
    )
 
Orb("Undeath", "Нежити")
 
S(
    "Monsters slain by you in melee are turned into friendly ghosts. "
    "Does not affect plants and friends.",
 
    "Убитые Вашими руками монстры превращаются в мирных призраков. "
    "Не действует на растения и союзников."
    )
 
N("Friendly Ghost", GEN_M, "Дружественный дух", "Дружественные духи",
"Дружественного духа", "Дружественным духом")
 
S("Friendly ghosts are friendly beings who can go through any obstacles. However, "
  "unlike most friends, they tend to fly away from you.",
 
  "Дружественные духи могут проходить сквозь любые препятствия. "
  "В отличие от других союзников, склонны улетать от Вас."
   )
 
// Windy Plains
//--------------
 
N("Windy Plains", GEN_F, "Ветреная равнина", "Ветреные равнины",
"Ветреную равнину", "на Ветреной равнине")
 
N("fan", GEN_O, "Вентилятор", "Вентиляторы", "Вентилятор", "Вентилятором")
 
S(
  "Someone has put air fans in these plains, causing strong winds everywhere. "
  "You think that the purpose is to harness the magical power of Air Elementals, but "
  "you are not sure.\n\n"
  "All cells except fans are grouped into three colors according to a pattern. "
  "Wind blows counterclockwise around each group of cells of a single color. "
  "Cells which are blocked by walls, or at distance at most 2 from an Air Elemental, "
  "do not count for this.\n\n"
  "It is illegal to move in a direction which is closer to incoming wind than to "
  "outcoming wind. However, you can move two cells with the wind in a single turn, "
  "and so can the birds.",
 
  "Кто-то расставил вентиляторы на этой равнине и вызвал сильные ветры. "
  "Вам кажется, что кто-то хотел использовать силу Воздушных "
  "Элементалей, но не уверены.\n\n"
 
  "Все клетки, кроме вентиляторов, раскрашены в 3 цвета регулярным "
  "образом. Ветер дует против часовой стрелки вокруг каждой группы "
  "одноцветных клеток. Клетки, занятые стенами, или находящиеся на  "
  "расстоянии не более 2 от Воздушного Элементаля, не учитываются.\n\n"
  "Невозможно пойти в направлении, которое ближе ко входящему ветру, "
  "чем к выходящему. Зато Вы можете пройти сразу 2 клетки в  "
  "направлении ветра, и птицы тоже могут."
  )
 
N("White Dove Feather", GEN_N, "Голубиное перо", "Голубиные перья",
  "Голубиное перо", "Голубиным пером")
S("This feather is truly beautiful and strong.",
  "Красивое и сильное голубиное перо.")

N("Wind Crow", GEN_F, "Ветряная ворона", "Ветряные вороны", "Ветряную ворону", "Ветряной вороной")
S("A large bird who likes strong winds. Just as you, it can fly quickly in the wind.",
  "Большая птица, которая любит сильный ветер. Как и Вы, движется "
  "быстрее с ветром."
  )
 
// Orb of Empathy replaces Orb of Air on the Beach
Orb("Empathy", "Сочувствия")
S(" %1", " %1")
S(", %1", ", %1")
 
S(  "This Orb lets your allies to share your Orb powers.\n\n"
    "The following Orbs are affected:",
   
    "Эта сфера позволяет Вашим союзникам использовать силы Ваших сфер.\n\n"
    "Действует на следующие сферы:")
 
N("strong wind", GEN_O, "сильный ветер", "сильные ветры", "сильный ветер", "сильным ветром")
 
S(
    "In the Windy Plains, you can let the wind carry you, "
    "causing you to move two cells with the wind in a single turn. "
    "This cannot be done if you are standing at distance at most 2 "
    "from the Air Elemental, or if any of the three cells on the way "
    "has two wind directions.\n\n"
    "Press 't' or click the destination to activate.",
   
    "На Ветреной равнине Вы можете позволить ветру унести Вас, "
    "подвинувшись сразу на 2 клетки за 1 ход. Это невозможно, если Вы "
    "стоите на расстоянии не более 2 от Воздушного элементаля, "
    "или на одной из проходимых клеток более одного направления "
    "ветра.\n\n"
    "Нажмите 't' или кликните на клетку, чтобы это использовать."
  )
 
/*
        "NEW_ACHIEVEMENT_6_3_NAME"  "Открыть Леса с привидениями"
        "NEW_ACHIEVEMENT_6_3_DESC"  "Соберите Чёрный лотос и убегите."
        "NEW_ACHIEVEMENT_6_4_NAME"  "Тёмный призрак"
        "NEW_ACHIEVEMENT_6_4_DESC"  "Соберите 10 Чёрных лотосов и
        убегите."
        "NEW_ACHIEVEMENT_6_5_NAME"  "Выживальщик"
        "NEW_ACHIEVEMENT_6_5_DESC"  "Соберите 25 Чёрных лотосов и
        убегите."
        "NEW_ACHIEVEMENT_6_6_NAME"  "Мастер привидений"
        "NEW_ACHIEVEMENT_6_6_DESC"  "Соберите 50 Чёрных лотосов и
        убегите."
        "NEW_ACHIEVEMENT_6_7_NAME"  "Мастер выживания"
        "NEW_ACHIEVEMENT_6_7_DESC"  "Получите достижение
        'Выживальщик', не рубя деревьев, не используя сфер и не
        привлекая монстров из других земель."
        "NEW_ACHIEVEMENT_6_8_NAME"  "Открыть Ветреную равнину"
        "NEW_ACHIEVEMENT_6_8_DESC"  "Соберите Голубиное перо."
        "NEW_ACHIEVEMENT_6_9_NAME"  "Ветряная ворона"
        "NEW_ACHIEVEMENT_6_9_DESC"  "Соберите 10 Голубиных перьев."
        "NEW_ACHIEVEMENT_6_10_NAME" "Белый голубь"
        "NEW_ACHIEVEMENT_6_10_DESC" "Соберите 25 Голубиных перьев."
        "NEW_ACHIEVEMENT_6_11_NAME" "Мастер Ветреной равнины"
        "NEW_ACHIEVEMENT_6_11_DESC" "Соберите 50 Голубиных перьев."
        "NEW_ACHIEVEMENT_6_12_NAME" "Открыть Поляну"
        "NEW_ACHIEVEMENT_6_12_DESC" "Соберите Фрукт-мутант."
        "NEW_ACHIEVEMENT_6_13_NAME" "Красный лис"
        "NEW_ACHIEVEMENT_6_13_DESC" "Соберите 10 Фруктов-мутантов."
        "NEW_ACHIEVEMENT_6_14_NAME" "Огромный лис"
        "NEW_ACHIEVEMENT_6_14_DESC" "Соберите 25 Фруктов-мутантов."
        "NEW_ACHIEVEMENT_6_15_NAME" "Мастер Поляны"
        "NEW_ACHIEVEMENT_6_15_DESC" "Соберите 50 Фруктов-мутантов."
*/

// VERSION 8.2
//=============
 
S("The ivy attacks %the1!", "Плющ атаковал %a1!")
 
// heptagonal mode
//-----------------
 
S("heptagonal mode", "режим семиугольников")
 
S("\n\n(For the heptagonal mode, the radius has been reduced to 2 for closing plates.)",
  "\n\n(В режиме семиугольников радиус действия закрывающих плит уменьшен до 2.)")
 
// Hypersian Rug mode
//--------------------
 
S("hypersian rug mode", "режим гиперсидского ковра")
 
S(
  "In this mode, HyperRogue is played on a 3D model of a part of the hyperbolic plane, "
  "similar to one you get from the 'paper model creator' or by hyperbolic crocheting.\n\n"
  "This requires some OpenGL extensions and may crash or not work correctly -- enabling "
  "the 'render texture without OpenGL' options may be helpful in this case. Also the 'render once' option "
  "will make the rendering faster, but the surface will be rendered only once, so "
  "you won't be able to play a game on it.\n\n"
  "Use arrow keys to rotate, Page Up/Down to zoom.",
 
  "В этом режиме Вы играете в HyperRogue на трёхмерной модели гиперболической "
  "плоскости, похожей на те, что можно получить в 'создателе бумажных моделей'\n\n"
  "Это требует некоторых расширений OpenGL, может работать некорректно или вызывать "
  "падение игры -- включение опции 'не использовать OpenGL' может помочь. "
  "Опция 'отрисовать один раз' ускоряет отрисовку, "
  "но играть в таком режиме невозможно.\n\n"
  "Используйте стрелки для вращения, Page Up/Down для изменения масштаба.")
 
S("what's this?", "что это?")
S("take me back", "вернуться в меню")
S("enable the Hypersian Rug mode", "включить режим гиперсидского ковра")
S("render the texture only once", "отрисовать один раз")
S("render texture without OpenGL", "не использовать OpenGL")
S("texture size", "размер текстур")
 
// Crossroads IV & Chaos Mode
//----------------------------
 
N("Crossroads IV", GEN_O, "Перекрёсток IV", "Перекрёстки IV", "Перекрёсток IV", "на Перекрёстке IV")
 
S("Chaos mode", "режим Хаоса")
 
S("In the Chaos mode, lands change very often, and there are no walls between them. "
  "Some lands are incompatible with this."
  "\n\nYou need to reach Crossroads IV to unlock the Chaos mode."
  ,
 
  "В режиме Хаоса земли меняются очень часто, и между ними нет стен. "
  "Некоторые земли несовместимы с этим режимом."
  "\n\nВы должны достичь Перекрёстка IV, чтобы открыть режим Хаоса."
)
 
// Rose Garden
//-------------
 
N("Rose Garden", GEN_O, "Розарий", "Розарии", "Розарий", "в Розарии")
N("False Princess", GEN_F, "Ложная принцесса", "Ложные принцессы", "Ложную принцессу", "Ложной принцессой")
N("False Prince", GEN_M, "Ложный принц", "Ложные принцы", "Ложного принца", "Ложным принцем")
N("Rose Lady", GEN_F, "Розовая дама", "Розовые дамы", "Розовую даму", "Розовой дамой")
N("Rose Lord", GEN_M, "Розовый лорд", "Розовые лорды", "Розового лорда", "Розовым лордом")
N("Rose Beauty", GEN_F, "Розовая красотка", "Розовые красотки", "Розовую красотку", "Розовой красоткой")
N("Handsome Gardener", GEN_M, "Красивый садовод", "Красивые садоводы", "Красивого садовника", "Красивым садовником")
N("rosebush", GEN_O, "куст розы", "кусты розы", "куст розы", "кустом розы")
 
Orb("Beauty", "красоты")
N("Thornless Rose", GEN_F, "роза без шипов", "розы без шипов", "розу без шипов", "розой без шипов")
 
S("Don't be fooled by this red-haired girl, or you will be stabbed if you come too close!",
  "Не будьте обмануты этой рыжеволосой девушкой, у неё есть острый нож!")
S("Don't be fooled by this red-haired boy, or you will be stabbed if you come too close!",
  "Не будьте обмануты этим рыжеволосым парнем, у него есть острый нож!")
S("This false princess is immune to the alluring scent of roses.",
  "Эта ложная принцесса невосприимчива к ароматам роз.")
S("This false prince is immune to the alluring scent of roses.",
  "Этот ложный принц невосприимчив к ароматам роз.")
S("She has flowers in her long fair hair. You could not bring yourself to attack such a beautiful woman.",
  "В её длинные светлые локоны вплетены прекрасные цветы. Вы не можете ударить столь красивую девушку.")
S("Tall, strong, and holding a flower in his hand. You could not bring yourself to attack such a handsome man.",
  "Высокий, сильный, с прекрасным цветком в руках. Вы не можете ударить этого красавца.")
 
S(  "This Orb makes you stunningly beautiful. "
    "Monsters which come next to you will be stunned for one turn. "
    "Multi-tile monsters are not affected. Additionally, it makes you immune to "
    "beauty.",
 
    "С этой сферой Вы становитесь ошеломляюще прекрасны. "
    "Монстр, подошедший к Вам, застывает на один ход. "
    "Не действует на монстров из нескольких клеток. Также Вы теперь можете "
    "игнорировать красоту других.")
 
S(  "A big, beautiful, magical flower.", "Большой прекрасный магический цветок.")
 
S("Don't be fooled by beauty, or you will be stabbed if you come too close!",
  "Не будьте обмануты красотой, если не хотите получить удар в спину!")
 
 
S(
  "Each eight turns, each rosebush at distance at most 5 from you will "
  "release a wave of alluring scent. Creatures on the frontwave "
  "will move towards where the scent came from. Even if it causes them "
  "to attack their friends or beautiful creatures, or move into water, fire, chasm, or thorns of the rosebush. "
  "Ivies, Ghosts, Rock Snakes, Rose Ladies and Lords, and monsters restricted to a specific "
  "terrain are immune to scents.",
 
  "Каждые 8 ходов каждый розовый куст на расстоянии не более 5 от Вас выпускает "
  "волну манящего аромата. Все монстры на пути двигаются к кусту, даже если "
  "им приходится атаковать союзника или прекрасное существо, пойти в воду, огонь, пропасть "
  "или в шипы куста. Это не действует на призраков, плющи, каменных змей и "
  "и монстров, ограниченных своей землёй.")
 
S(
  "This land is filled with beautiful, but dangerous, creatures and plants.",
 
  "Эта земля полна прекрасными, но опасными существами и растениями.")
 
S("%The1 is killed by thorns!", "%1 убит%E1 шипами!");
 
S("You just cannot stand in place, those roses smell too nicely.", "Вы не можете устоять на месте, эти розы пахнут слишком прекрасно.")
S("Those roses smell too nicely. You have to come towards them.", "Эти розы пахнут слишком прекрасно. Вы можете пойти лишь в сторону них.")
 
// Warped Sea/Coast
//------------------
 
N("Warped Coast", GEN_O, "Искривлённый берег", "Искривлённые берега", "Искривлённый берег", "на Искривлённом берегу")
N("Warped Sea", GEN_N, "Искривлённое море", "Искривлённые моря", "Искривлённое море", "в Искривлённом море")
N("Ratling", GEN_M, "Крысолюд", "Крысолюди", "Крысолюда", "Крысолюдом")
N("Coral", GEN_O, "Коралл", "Кораллы", "Коралл", "Кораллом")
Orb("the Warp", "Искривления")
 
S(
  "This land is warped. Ironically, the coast is completely straight...",
  "Эта земля искривлена. Зато берег абсолютно прямой...")
 
S(
  "This part of the world is warped, restricting the movement somewhat. "
  "\"Diagonal\" movement and attacking between triangular cells is not allowed. "
  "Flash, Storms, and Freedom spells ignore this, and Ghosts can move, attack, and "
  "be attacked diagonally.",
  "Это земля искривлена, и движения немного ограничены. "
  "Ходы и атаки \"по-диагонали\" между треугольниками невозможны. "
  "Заклинания Вспышки, Бури и Свободы игнорируют это. Духи также могут ходить, "
  "атаковать и быть атакованными по-диагонали.")
 
S( "This Orb creates a warped zone of radius 5 around you, "
  "and also allows you to move diagonally in warped zones.",
 
  "Эта сфера создаёт искривление в радиусе 5 клеток вокруг Вас, "
  "и позволяет Вам ходить по-диагонали в искривлённых зонах.")
 
S(  "Corals have a somewhat hyperbolic structure even in your home world, "
    "but natural corals from the Warped Sea have truly beautiful shapes. "
    "Ratlings know the value of corals, and thus keep them in boats for safety.",
   
    "Кораллы имеют структуру, похожую на гиперболическую, даже в Вашем обычном мире, "
    "но настоящие кораллы из Искривлённого моря имеют действительно красивые формы. "
    "Крысолюды знают цену кораллам и на всякий случай хранят из в лодках.")
 
S(
    "These warped humanoids are skilled warriors and sailors, and they "
    "feel at home at the Warped Coast. Their battle experience has taught them "
    "that enemies who wait without moving or attacking anything are the most deadly. "
    "If they see such an enemy, they become extremely suspicious, and they also wait.",
   
    "Эти искривлённые гуманоиды -- опытные воины и мореходы, и чувствуют себя "
    "как дома на Искривлённом берегу. Их боевой опыт говорит, что враги, которые "
    "стоят на месте и никого не атакуют, наиболее опасны. Когда они видят такого врага, "
    "Они становятся подозрительными и тоже стоят на месте.")
   
 
S("hexagonal #1", "шестиугольник #1")
S("You cannot move between the triangular cells here!", "Вы не можете ходить между треугольниками!")
S("display the triheptagonal grid", "показать трёх-семи-угольную сетку")
 
N("no wall", GEN_O, "нет стены", "нет стены", "нет стены", "нет стены")
N("no monster", GEN_O, "нет монстра", "нет монстра", "нет монстра", "нет монстра")
N("no item", GEN_O, "нет предмета", "нет предмета", "нет предмета", "нет предмета")
 
S("\n\nA Ghost never moves to a cell which is adjacent to another Ghost of the same kind.",
  "\n\nПризрак не может ходить на клетку рядом с другим таким же призраком.")
 
S("You cannot attack diagonally!", "Вы не можете атаковать по-диагонали!")
 
// for later...
//--------------
 
Orb("Energy", "Energii")
 
S(  "This Orb halves the power usage of orbs which cost some "
    "charges with each activation. It even affects the "
    "one-shot orbs such as Flash or Teleport. If such an activation "
    "normally costs x charges, it costs only x/2 (rounded up) "
    "if you have an Orb of Energy.",
   
    "Эта сфера уменьшает энергию, используемую другими сферами "
    "при активации. Это работает даже для одноразовых сфер, например, "
    "Вспышки или Телепорта. Если обычно использование стоило "
    "x единиц энергии, то с этой сферой оно будет стоить "
    "x/2 единиц (округлённое вверх).")
 
/*
 
        "NEW_ACHIEVEMENT_6_17_NAME" "Открыть Искривлённый берег"
        "NEW_ACHIEVEMENT_6_17_DESC" "Соберите Коралл."
        "NEW_ACHIEVEMENT_6_18_NAME" "Крысолюд"
        "NEW_ACHIEVEMENT_6_18_DESC" "Соберите 10 Кораллов."
        "NEW_ACHIEVEMENT_6_19_NAME" "Искривлённый крысолюд"
        "NEW_ACHIEVEMENT_6_19_DESC" "Соберите 25 Кораллов."
        "NEW_ACHIEVEMENT_6_20_NAME" "Мастер Кривизны"
        "NEW_ACHIEVEMENT_6_20_DESC" "Соберите 50 Кораллов."
        "NEW_ACHIEVEMENT_6_21_NAME" "Открыть Розарий"
        "NEW_ACHIEVEMENT_6_21_DESC" "Соберите Розу без шипов."
        "NEW_ACHIEVEMENT_6_22_NAME" "Ложная принцесса"
        "NEW_ACHIEVEMENT_6_22_DESC" "Соберите 10 Роз без шипов."
        "NEW_ACHIEVEMENT_6_23_NAME" "Розовая красотка"
        "NEW_ACHIEVEMENT_6_23_DESC" "Соберите 25 Роз без шипов."
        "NEW_ACHIEVEMENT_6_24_NAME" "Розовая дама"
        "NEW_ACHIEVEMENT_6_24_DESC" "Соберите 50 Роз без шипов."
        "NEW_ACHIEVEMENT_6_25_NAME" "Путешественник"
        "NEW_ACHIEVEMENT_6_25_DESC" "Откройте Перекрёсток IV."
        "NEW_ACHIEVEMENT_6_26_NAME" "Мастер хаоса"
        "NEW_ACHIEVEMENT_6_26_DESC" "Соберите 300 $$$ в режиме Хаоса."
 
*/

//   "Skeletons attacked outside of their native land, Palace, are stunned for a longer time.",

S("TRANSLATIONWARNING2", "")
S("TRANSLATIONWARNING", "") // Warning: new features from 8.1 are not yet translated to Russian")

S("Return to the normal game", "Вернуться в обычную игру")
S("three players", "три игрока")
S("four players", "четыре игрока")
S("key Orb power", "клавиша для силы сферы")

S("Orb power (target: mouse)", "активировать сферу")
S("Orb power (target: facing)", "клавиша для силы сферы")
S("You cannot go against the wind!", "Nie możesz iść pod wiatr!")

N("warp gate", GEN_F, "врата искривления", "врата искривления", "врата искривления", "вратами искривления")

S("This gate separates the warped area from the normal land.", 

  "Эти врата отделяют искривлённые земли от обычных.")

S("You cannot move between the cells without dots here!", 

  "Вы не можете ходить между полями без точек!")

S("Those roses smell too nicely. You can only target cells closer to them!",

  "Эти розы так прекрасно пахнут. Вы можете выбирать цель только ближе к ним!")

S("You need to move to give space to %the1!",

  "Вам нужно освободить место для %a1!")

// in Russian it works too

  

N("Ratling Avenger", GEN_M, "Крысолюд-мститель", "Крысолюди-мстители", "Крысолюда-мстителя", "Крысолюдом-мстителем")



S(

  "So, you have killed a Ratling on the unwarped sea? You will be punished for this! "

  "Luckily, if you run away from the Warped Sea quickly, the Ratling Avengers will lose track of you.",

  

  "Вы убили Крысолюда в неискривлённом море? Мститель до Вас доберётся!"

  "К счастью, если достаточно далеко уйти от Искривлённого моря, он потеряет Ваш след.")


 
// VERSION 8.3
//=============
 
S("Kills required: %1 (%2).\n", "Убить монстров необходимо: %1 (%2).\n")
 
S("\"Be careful in the Rose Garden! It is beautiful, but very dangerous!\"",
  "\"Будьте осторожны в Розарии! Там красиво, но очень опасно!\"")
 
S("\"Thank you very much for talking, and have a great rest of your day!\"",
  "\"Большое спасибо за беседу, удачного дня!\"")
 
// Conformal/history mode
 
S("conformal/history mode", "режим конформный/истории")
S("Preparing the line (%1/1000)...", "Приготовление линии (%1/1000)...")
S("Could not create an image of that size.", "Невозможно создать изображение такого размера.")
S("Saved the band image as: ", "Изображение сохранено как: ")
S("right", "право")
S("left", "лево")
S("up", "вверх")
S("down", "вниз")
S("counterclockwise", "против часовой стрелки")
S("clockwise", "по часовой стрелке")
S("zoom out", "отдалить")
S("zoom in", "приблизить")
S("left to right", "вправо")
S("right to left", "влево")
S("spin down", "вращать вниз")
S("spin up", "вращать вверх")
S("disk", "диск")
S("half-plane", "полуплоскость")
S("band", "лента")
S("polygonal", "многоугольник")
S("polynomial", "многочлен")
S("include history", "включить историю")
S("model used", "используемая модель")
S("rotation", "поворот")
 
S("coefficient", "коэффициент")
S("which coefficient", "какой коэффициент")
S("polygon sides", "стороны многоугольника")
S("star factor", "коэффициент звезды")
S("degree of the approximation", "степень приближения")
S("prepare the line animation", "приготовить анимацию линии")
S("animation speed", "скорость анимации")
S("render bands automatically", "рисовать ленту автоматически")
S("band width", "ширина ленты")
S("length of a segment", "длина отрезка")
S("spiral on rendering", "спираль отрисовки")
S("render now (length: %1)", "рисуется сейчас (длина: %1)")
S("exit this menu", "выход")
S("Enable cheat mode or GAME OVER to use this", "Доступно только в конце игры и в режиме обманщика")
 
// remember to note it's in English
S("see http://www.roguetemple.com/z/hyper/conformal.php", "смотри http://www.roguetemple.com/z/hyper/conformal.php (по-английски))")
 
// Yendorian Forest
 
N("Yendorian Forest", GEN_O, "Йендорский Лес", "Йендорские Леса", "Йендорский Лес", "в Йендорском Лесу")
 
S(
  "This forest was planted by one of the wizards from the Ivory Tower "
  "to conduct experiments with gravity.",
 
  "Этот лес был создан одним из магов Башни из Слоновой Кости "
  "для продолжения экспериментов с гравитацией.")
 
N("Yendorian Researcher", GEN_M, "Йендорский исследователь", "Йендорские исследователи", "Йендорского исследователя", "Йендорским исследователем")
 
S(
    "These people study gravity and infinite trees. "
    "They have no special features, other than wearing a strange hat.",
   
  "Эти люди изучают гравитацию и бесконечные деревья. Они ничем не "
  "отличаются от обычных людей, кроме этих странных шляп.")
 
N("Sparrowhawk", GEN_M, "Ястреб", "Ястребы", "Ястреба", "Ястребом")
 
S("A bird who hunts in the treetops of the Yendorian Forest.",
  "Эта птица охотится в Йендорском лесу.")
 
N("Apple", GEN_N, "Яблоко", "Яблоки", "Яблоко", "Яблоком")
 
S("A fruit from the Yendorian Forest.", "Фрукт из Йендорского леса.")
 
N("trunk", GEN_O, "пень", "пни", "пень", "пнём")
 
S("The skeleton of a tree.", "Скелет дерева.")

N("solid branch", GEN_F, "толстая ветка", "толстые ветки", "толстую ветку", "толстой веткой")
 
S("Branches here could bear your weight easily.",
  "Эти ветви легко выдержат ваш вес.")

N("weak branch", GEN_F, "тонкая ветка", "тонкие ветки", "тонкую ветку", "тонкой веткой")
 
S("Branches here will bear you weight, but if you use them to move (not fall) to an unstable place, they will break.",
  "Эти ветви выдерживают ваш вес, но если из использовать, чтобы пойти (не упасть) на что-то неустойчивое, они сломаются.")

N("canopy", GEN_F, "листва", "листва", "листву", "листвой")
 
S(
  "Only thin twigs and leaves here. They may bear fruits, but for you, these cells count as unstable.",
  "Здесь лишь тонкие веточки и листья. Они могут выдержать фрукт, но не ваш вес.")
 
 
// Dragon Chasm
 
N("Dragon Chasms", GEN_F, "Драконья бездна", "Драконьи бездны", "Драконью бездну", "в Драконьей бездне")
 
N("Dragon", GEN_M, "Дракон", "Драконы", "Дракона", "Драконом")
 
N("Dragon Scale", GEN_F, "чешуя дракона", "чешуи дракона", "чешую дракона", "чешуёй дракона")
 
S(
    "Dragon Scales are a prized material for armors. "
    "They are also prized by collectors, who would like to boast "
    "about how they have killed a Dragon."
    "\n\nDragon Scales disappear after 500 turns."
    ,
 
    "Чешуя дракона -- ценный материал для брони. "
    "Также они ценятся коллекционерами, которые хотели бы похвастаться, "
    "как они убили дракона."
    "\n\nЧешуя дракона исчезнет через 500 ходов."
    )
 
S(
    "Dragons are powerful monsters. They are slow, but evil, "
    "and love to pick on creatures who are even slower than "
    "them. They must be stopped!\n\n"
 
    "A Dragon moves each two turns. It may attack with all its segments, "
    "or move its whole body forwards or "
    "backwards, it may also move a frontal part backwards. To kill a Dragon, "
    "you need to hit each of its segments. "
    "The head will regenerate on the "
    "turns the Dragon is not moving, so you will usually have to hit it with "
    "your last attack; otherwise, if the head is healthy, it may breathe "
    "fire (at range 3), losing the hitpoint. Killing the Dragon "
    "while still in the Dragon Chasms gives you treasure.",
   
    "Драконы -- очень сильные существа. Они медленные, но злые, и любят "
    "издеваться над существами, которые ещё медленнее. "
    "Остановите их!\n\n"
 
    "Дракон движется каждый второй ход. Он может атаковать любой своей частью, "
    "либо передвинуться вперёд или назад, либо передвинуть переднюю "
    "часть назад. Чтобы убить дракона, нужно ударить каждую его часть. "
    "Голова регенерирует каждый ход, когда дракон не движется, "
    "так что обычно её придётся бить последней; если голова здорова, "
    "дракон может дышать огнём (дальность 3), тратя одну жизнь. За убийство дракона "
    "в Драконьей бездне вы получите награду."
   )
 
S("%The1 breathes fire at you!", "%1 дышит огнём на вас!")
S("%The1 breathes fire!", "%1 дышит огнём!")
 
Orb("Domination", "Доминации")
 
S(
    "This Orb lets you ride Dragons and other worm-like creatures. "
   "Simply move onto such a creature to ride them; while riding, you are protected from dangerous terrains "
   "and partially from attacks (they cause you to lose half of your Domination power), "
   "but you cannot collect items. When only one charge is left, "
   "you have to dismount this turn -- be very careful to make this possible, "
   "as your mount could attack you immediately!\n\n" "While riding, "
   "click on a location to order your mount to move or attack there.",
   
   "Эта сфера позволяет вас ездить на драконах и других червеобразных существах. "
   "Просто пойди на клетку с таким монстром, чтобы оседлать его. "
   "Пока ты едешь на существе, на тебя не действуют никакие опасные объекты "
   "и, частично, атаки (от которых вы теряете половину силы "
   "этой сферы), но вы не можете собирать предметы. Когда остаётся "
   "только один заряд, вы должны слезть с существа -- будьте осторожны, "
   "ведь оно может сразу же атаковать вас!\n\n"
   "Нажимайте на клетки, чтобы заставить существо туда пойти или атаковать."
   )
 
S("You command %the1!", "Вы оседлали %a1!.")
S("You need to dismount %the1!", "Вы должны слезть с %a1!")
S("%The1 tries to dismount you!", "%1 пробует сбросить вас!")
 
S("Enemies killed: %1 (%2 types)", "Существ убито: %1 (%2 типов)")
S(" kills: %1/%2", " убийств: %1/%2")
S("Different kills required: %1.\n", "Необходимо убить различных существ: %1.\n")
 
// Galapagos
 
N("Galápagos", GEN_M, "Галапагосы", "Галапагосы", "Галапагосы", "на Галапагосах")
 
N("Baby Tortoise", GEN_F, "Черепашка", "Черепашки", "Черепашку", "Черепашкой")
 
Orb("the Shell", "Панциря")
 
S(
    "This Orb protects you from physical attacks. "
    "It lasts for more turns than the Orb of Shielding, but "
    "10 charges are lost whenever you are attacked. "
    "It also does not protect you from fires, scents, and being eaten.",
   
    "Эта сфера защищает вас от физических атак. "
    "Она действует дольше, чем сфера Щита, но теряет"
    "10 зарядов при каждой атаке. "
    "Не защищает от огня, запаха и съедения.")
 
S(
  "Galápagos is the land of Tortoises. "
  "They are very slow, which allows the Dragons to pick on them by "
  "stealing and eating their young. Bring the Baby Tortoises back, "
  "but, there is a catch: the Tortoises come in many varieties, depending "
  "on the part of Galápagos they live in -- there are 21 binary environmental "
  "factors, and thus "
  "2097152 varieties. You'll have to find a "
  "Tortoise which matches the baby exactly!\n\n"
  "Tortoises move each 3 turns, and attacks only stun them.\n\n"
  "Bringing back a Baby Tortoise counts as 5 $$$. The more factors agree in "
  "the given location of Galápagos, the brighter it is shown on your screen.",
 
  "Галапагосы -- край черепах. Черепахи очень медленны, что позволяет драконам издеваться над ними -- "
  "красть и поедать их детей. Отведи черепашку на родину! Но есть "
  "проблема: здесь есть много разновидностей черепах, зависящих от места проживания -- "
  "есть 21 различных параметров, что даёт 2097152 вариантов. "
  "Найдите черепаху, точно соответствующую этому малышу!\n\n"
  "Черепахи движутся каждый третий ход. Атаки только оглушают их.\n\n"
  "Каждый приведённый черепашонок считается за 5 $$$. Чем больше параметров "
  "совпадают в данной местности, тем светлее она показывается.")
 
S("%The1 scares %the2 a bit!", "%1 немного пугает %a2!")
S("%The1 attacks your shell!", "%1 атакует вашу раковину!")
 
S("Hyperstone Quest: collect at least 10 points in %the2",
  "Миссия Гиперкамней: собери не меньше 10 очков %abl2")
 
S("animals killed: %1", "животных убито: %1")
S("\n\nTortoises are not monsters! They are just annoyed. They do not count for your total kills.",
  "\n\nЧерепашки -- не монстры! Хоть и раздражают. Они не считаются в количестве убийств.")
 
S("Aww, poor %1... where is your family?", "Ох, бедный %1... Где его семья?")
S("You are now a tortoise hero!", "Теперь вы -- черепаший герой!")
S("Find a %1 in %the2.", "Найди %a1 %abl2.")
 
/*
        "NEW_ACHIEVEMENT_6_27_NAME" "Убийца драконов"
        "NEW_ACHIEVEMENT_6_27_DESC" "Соберите Чешую дракона."
        "NEW_ACHIEVEMENT_6_28_NAME" "Лорд Драконов"
        "NEW_ACHIEVEMENT_6_28_DESC" "Соберите 10 Чешуй драконов."
        "NEW_ACHIEVEMENT_6_29_NAME" "Принц Драконов"
        "NEW_ACHIEVEMENT_6_29_DESC" "Соберите 25 Чешую драконов."
        "NEW_ACHIEVEMENT_6_30_NAME" "Король Драконов"
        "NEW_ACHIEVEMENT_6_30_DESC" "Соберите 50 Чешуй драконов."
        "NEW_ACHIEVEMENT_6_31_NAME" "Черепаший герой"
        "NEW_ACHIEVEMENT_6_31_DESC" "Спасите двух Черепашек."
        "NEW_ACHIEVEMENT_7_0_NAME"  "Черепаший чемпион"
        "NEW_ACHIEVEMENT_7_0_DESC"  "Спасите пять Черепашек."
        "NEW_ACHIEVEMENT_7_1_NAME"  "Черепаший ниндзя"
        "NEW_ACHIEVEMENT_7_1_DESC"  "Спасите 10 Черепашек."
        "NEW_ACHIEVEMENT_7_2_NAME"  "Открыть Йендорский лес"
        "NEW_ACHIEVEMENT_7_2_DESC"  "Найдите и соберите Яблоко."
        "NEW_ACHIEVEMENT_7_3_NAME"  "Исследователь Йендора"
        "NEW_ACHIEVEMENT_7_3_DESC"  "Соберите 10 яблок."
        "NEW_ACHIEVEMENT_7_4_NAME"  "Ястреб"
        "NEW_ACHIEVEMENT_7_4_DESC"  "Соберите 25 яблок."
        "NEW_ACHIEVEMENT_7_5_NAME"  "Мастер Йендора"
        "NEW_ACHIEVEMENT_7_5_DESC"  "Соберите 50 яблок."
*/

S("(includes co-op)", "(включая совместный режим)")
S("Revived!", "Воскрешено!")
S("turn count = %1 last exploration = %2 ghost timer = %3", "количество ходов = %1, последнее исследование = %2, отсчёт времени призраков = %3")
S("You hear a distant roar!", "Вы слышите далёкий рёв!")

S("summon Bonfire", "призвать Костры")
S("Hyperstone Quest", "Миссия Гиперкамней")
S("summon dead orbs", "призвать мёртвые сферы")
S("summon a Monster", "призвать монстра")
S("gain orb powers", "получить силу сфер")
S("summon a Golem", "призвать Голема")
S("summon Thumpers", "призвать Тамперы")
S("summon Ivy", "призвать Плющ")
S("lose all treasure", "потерять все сокровища")
S("gain kills", "получить убийства")
S("Select the land ---", "Выбрать землю ---")
S("summon Mimics", "призвать двойников")
S("summon orbs", "призвать сферы")
S("deplete orb powers", "потерять силы сфер")
S("Safety (quick save)", "Сохраниться")
S("summon treasure", "призвать сокровища")
S("summon lots of treasure", "призвать много сокровищ")
S("--- and teleport there", "--- и телепортироваться туда")
S("summon Sand Worm", "призвать Песчаного червя")
S("summon Orb of Yendor", "призвать сферы Йендора")
S("rotate the character", "повернуться")

S("gain Orb of Yendor", "получить сферу Йендора")
S("switch ghost timer", "переключить таймер призраков")
S("switch web display", "переключить отображение сетки")
S("You damage %the1 with a mental blast!", "Вы атаковали %a1 энергией мысли!")
S("You are now a tortoise heroine!", "Теперь вы -- черепашья героиня!")
S("Note: currently scores are saved only in the normal mode on Android",
  "Важно: на Андроиде счёт записывается только в обычном режиме")
S("Note: you can play, but scores won't be saved on Android",
  "Важно: вы можете играть, но счёт не будет сохранён")
S("settings set here won't be saved", "установленные настройки не будут сохранены")
S("-- use the Android menu instead", "используйте меню Андроида")


#undef Orb