;;;; -*- Mode: lisp -*-

(defpackage #:cmucl-tests-system
  (:use #:cl #:asdf))

(require :lisp-unit)

(in-package #:cmucl-tests-system)

(asdf:defsystem cmucl-tests
  :depends-on (:cmucl-pcl-tests)
  :components
  ((:file "dd")
   (:file "extended-loop")
   (:file "fd-streams")
   (:file "fdlibm")
   (:file "filesys")
   (:file "float-tran")
   (:file "float")
   (:file "gray-streams")
   (:file "irrat")
   (:file "issues")
   (:file "printer")
   (:file "run-tests")
   (:file "simple-streams")
   (:file "srctran")
   (:file "trac")
   (:file "trig")
   (:file "unicode")))

(asdf:defsystem cmucl-pcl-tests
  :components
  ((:module "pcl"
    :components
    ((:file "pcl")
     (:file "pkg" :depends-on ("pcl"))
     #+gerds-pcl
     (:file "ctor"
      :depends-on ("pkg"))
     (:file "defclass"
      :depends-on ("pkg"))
     (:file "make-instance"
      :depends-on ("pkg" #+gerds-pcl "ctor"))
     (:file "reinitialize-instance"
      :depends-on ("pkg" "make-instance"))
     (:file "slot-value"
      :depends-on ("pkg" "make-instance"))
     (:file "slot-boundp"
      :depends-on ("pkg" "make-instance"))
     (:file "slot-missing"
      :depends-on ("pkg" "make-instance"))
     (:file "slot-accessors"
      :depends-on ("pkg" "make-instance"))
     (:file "slot-type"
      :depends-on ("pkg" "slot-value"))
     (:file "inline-access"
      :depends-on ("pkg" "slot-type"))
     (:file "method-combination"
      :depends-on ("pkg"))
     (:file "pv"
      :depends-on ("pkg"))
     (:file "defgeneric"
      :depends-on ("pkg"))
     (:file "defmethod"
      :depends-on ("pkg"))
     (:file "find-method"
      :depends-on ("pkg"))
     (:file "methods"
      :depends-on ("pkg"))))))
	    

(defmethod perform ((op test-op) (c (eql (asdf:find-system :cmucl-tests))))
  (or (funcall (intern "RUN-ALL-TESTS" (find-package "CMUCL-TEST-RUNNER")))
      (error "TEST-OP failed for CMUCL-TESTS")))



