;; Test all the f64 operators on major boundary values and all special
;; values (except comparison operators, which are tested in f64_cmp.wast).

(module
  (func (export "add") (param $x f64) (param $y f64) (result f64) (f64.add (local.get $x) (local.get $y)))
  (func (export "sub") (param $x f64) (param $y f64) (result f64) (f64.sub (local.get $x) (local.get $y)))
  (func (export "mul") (param $x f64) (param $y f64) (result f64) (f64.mul (local.get $x) (local.get $y)))
  (func (export "div") (param $x f64) (param $y f64) (result f64) (f64.div (local.get $x) (local.get $y)))
  (func (export "sqrt") (param $x f64) (result f64) (f64.sqrt (local.get $x)))
  (func (export "min") (param $x f64) (param $y f64) (result f64) (f64.min (local.get $x) (local.get $y)))
  (func (export "max") (param $x f64) (param $y f64) (result f64) (f64.max (local.get $x) (local.get $y)))
  (func (export "ceil") (param $x f64) (result f64) (f64.ceil (local.get $x)))
  (func (export "floor") (param $x f64) (result f64) (f64.floor (local.get $x)))
  (func (export "trunc") (param $x f64) (result f64) (f64.trunc (local.get $x)))
  (func (export "nearest") (param $x f64) (result f64) (f64.nearest (local.get $x)))
  (func (export "abs") (param $x f64) (result f64) (f64.abs (local.get $x)))
  (func (export "neg") (param $x f64) (result f64) (f64.neg (local.get $x)))
  (func (export "copysign") (param $x f64) (param $y f64) (result f64) (f64.copysign (local.get $x) (local.get $y)))
)

(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const 0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000002p-1022))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000002p-1022))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x1.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x0.fffffffffffffp-1022))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x0.fffffffffffffp-1022))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x1.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.fffffffffffffp-1022))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.fffffffffffffp-1022))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.0000000000001p-1022))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1021))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1021))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const 0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const 0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const 0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1.8p+0))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1.8p+0))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.b21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.721fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.721fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.b21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const 0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const 0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const 0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1.8p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1.8p+0))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+1))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const 0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+1))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.d21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.521fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.521fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.d21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const 0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1.b21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const -0x1.721fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const 0x1.721fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1.b21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1.d21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const -0x1.521fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const 0x1.521fb54442d18p+2))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1.d21fb54442d18p+2))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+3))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+3))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const 0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const -0x1p-1022)) (f64.const infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const 0x1p-1)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const -0x1p-1)) (f64.const infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -0x1p+0)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const 0x1p+0)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const -0x1p+0)) (f64.const infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const 0x1p+0)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "add" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -infinity)) (f64.const -infinity))
(assert_return_nan (invoke "add" (f64.const -infinity) (f64.const infinity)))
(assert_return_nan (invoke "add" (f64.const infinity) (f64.const -infinity)))
(assert_return (invoke "add" (f64.const infinity) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "add" (f64.const -infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "add" (f64.const infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -0x0p+0)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const 0x0p+0)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -0x0p+0)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const 0x0p+0)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -0x1p-1022)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const 0x1p-1022)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -0x1p-1022)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const 0x1p-1022)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -0x1p-1)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const 0x1p-1)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -0x1p-1)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const 0x1p-1)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -0x1p+0)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const 0x1p+0)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -0x1p+0)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const 0x1p+0)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -infinity)) (f64.const -nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const infinity)) (f64.const -nan))
(assert_return (invoke "add" (f64.const nan) (f64.const -infinity)) (f64.const nan))
(assert_return (invoke "add" (f64.const nan) (f64.const infinity)) (f64.const nan))
(assert_return (invoke "add" (f64.const -nan) (f64.const -nan)) (f64.const -nan))
(assert_return_nan (invoke "add" (f64.const -nan) (f64.const nan)))
(assert_return_nan (invoke "add" (f64.const nan) (f64.const -nan)))
(assert_return (invoke "add" (f64.const nan) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const 0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.0000000000002p-1022))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000002p-1022))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const 0x0.fffffffffffffp-1022))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const -0x1.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const 0x1.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const -0x0.fffffffffffffp-1022))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.fffffffffffffp-1022))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.0000000000001p-1022))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.fffffffffffffp-1022))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (f64.const -0x1p-1021))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (f64.const 0x1p-1021))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const 0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const 0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const 0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const 0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const 0x1p+0)) (f64.const -0x1.8p+0))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -0x1p+0)) (f64.const 0x1.8p+0))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const 0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.721fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.b21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.b21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.721fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const 0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const 0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const 0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const 0x1p-1)) (f64.const -0x1.8p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -0x1p-1)) (f64.const 0x1.8p+0))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const 0x1p+0)) (f64.const -0x1p+1))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -0x1p+0)) (f64.const 0x1p+1))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const 0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.521fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.d21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.d21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.521fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const 0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1.721fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const -0x1.b21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const 0x1.b21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1.721fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1.521fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const -0x1.d21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const 0x1.d21fb54442d18p+2))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1.521fb54442d18p+2))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+3))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+3))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const 0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -0x1p-1022)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const 0x1p-1)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -0x1p-1)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -0x1p+0)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const 0x1p+0)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -0x1p+0)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const 0x1p+0)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return_nan (invoke "sub" (f64.const -infinity) (f64.const -infinity)))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -infinity)) (f64.const infinity))
(assert_return_nan (invoke "sub" (f64.const infinity) (f64.const infinity)))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -0x0p+0)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const 0x0p+0)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -0x0p+0)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const 0x0p+0)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -0x1p-1022)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const 0x1p-1022)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -0x1p-1022)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const 0x1p-1022)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -0x1p-1)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const 0x1p-1)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -0x1p-1)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const 0x1p-1)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -0x1p+0)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const 0x1p+0)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -0x1p+0)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const 0x1p+0)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -infinity)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const infinity)) (f64.const -nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const -infinity)) (f64.const nan))
(assert_return (invoke "sub" (f64.const nan) (f64.const infinity)) (f64.const nan))
(assert_return (invoke "sub" (f64.const -nan) (f64.const -nan)) (f64.const -nan))
(assert_return_nan (invoke "sub" (f64.const -nan) (f64.const nan)))
(assert_return_nan (invoke "sub" (f64.const nan) (f64.const -nan)))
(assert_return (invoke "sub" (f64.const nan) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const 0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const 0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const 0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return_nan (invoke "mul" (f64.const -0x0p+0) (f64.const -infinity)))
(assert_return_nan (invoke "mul" (f64.const -0x0p+0) (f64.const infinity)))
(assert_return_nan (invoke "mul" (f64.const 0x0p+0) (f64.const -infinity)))
(assert_return_nan (invoke "mul" (f64.const 0x0p+0) (f64.const infinity)))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const 0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (f64.const 0x0.8p-1022))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (f64.const -0x0.8p-1022))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x0.8p-1022))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x0.8p-1022))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const 0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (f64.const 0x0.8p-1022))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (f64.const -0x0.8p-1022))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x0.8p-1022))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x0.8p-1022))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -0x1p-1)) (f64.const 0x1p-2))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const 0x1p-1)) (f64.const -0x1p-2))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p-2))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p-2))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const 0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const 0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const 0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000006p-1022))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const 0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const -0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1.921fb54442d18p-1020))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const 0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const -0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1.921fb54442d18p+1))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.3bd3cc9be45dep+5))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.3bd3cc9be45dep+5))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.3bd3cc9be45dep+5))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.3bd3cc9be45dep+5))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp-51))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const 0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const -0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1.fffffffffffffp+1))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const 0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const -0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1.fffffffffffffp+1022))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return_nan (invoke "mul" (f64.const -infinity) (f64.const -0x0p+0)))
(assert_return_nan (invoke "mul" (f64.const -infinity) (f64.const 0x0p+0)))
(assert_return_nan (invoke "mul" (f64.const infinity) (f64.const -0x0p+0)))
(assert_return_nan (invoke "mul" (f64.const infinity) (f64.const 0x0p+0)))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -0x1p-1022)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const 0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -0x1p-1)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const 0x1p-1)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -0x1p+0)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const 0x1p+0)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -0x1p+0)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const 0x1p+0)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "mul" (f64.const infinity) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -0x0p+0)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const 0x0p+0)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -0x0p+0)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const 0x0p+0)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -0x1p-1022)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const 0x1p-1022)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -0x1p-1022)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const 0x1p-1022)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -0x1p-1)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const 0x1p-1)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -0x1p-1)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const 0x1p-1)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -0x1p+0)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const 0x1p+0)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -0x1p+0)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const 0x1p+0)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -infinity)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const infinity)) (f64.const -nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const -infinity)) (f64.const nan))
(assert_return (invoke "mul" (f64.const nan) (f64.const infinity)) (f64.const nan))
(assert_return (invoke "mul" (f64.const -nan) (f64.const -nan)) (f64.const -nan))
(assert_return_nan (invoke "mul" (f64.const -nan) (f64.const nan)))
(assert_return_nan (invoke "mul" (f64.const nan) (f64.const -nan)))
(assert_return (invoke "mul" (f64.const nan) (f64.const nan)) (f64.const nan))
(assert_return_nan (invoke "div" (f64.const -0x0p+0) (f64.const -0x0p+0)))
(assert_return_nan (invoke "div" (f64.const -0x0p+0) (f64.const 0x0p+0)))
(assert_return_nan (invoke "div" (f64.const 0x0p+0) (f64.const -0x0p+0)))
(assert_return_nan (invoke "div" (f64.const 0x0p+0) (f64.const 0x0p+0)))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const 0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const 0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const 0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const 0x0p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const 0x1p-52))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const -0x1p-52))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-52))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-52))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const 0x0.0000000000002p-1022))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const -0x0.0000000000002p-1022))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x0.0000000000002p-1022))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x0.0000000000002p-1022))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p+52))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p+52))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+52))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+52))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (f64.const 0x1p-1021))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (f64.const -0x1p-1021))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1021))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1021))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0.28be60db9391p-1022))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x0.28be60db9391p-1022))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0.28be60db9391p-1022))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0.28be60db9391p-1022))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const 0x1p-1022) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (f64.const 0x1p+1021))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (f64.const -0x1p+1021))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p+1021))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p+1021))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const 0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const 0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.45f306dc9c883p-4))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.45f306dc9c883p-4))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.45f306dc9c883p-4))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.45f306dc9c883p-4))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0.2p-1022))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0.2p-1022))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0.2p-1022))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0.2p-1022))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const 0x1p-1) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (f64.const 0x1p+1022))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (f64.const -0x1p+1022))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p+1022))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p+1022))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -0x1p-1)) (f64.const 0x1p+1))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const 0x1p-1)) (f64.const -0x1p+1))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p+1))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p+1))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.45f306dc9c883p-3))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.45f306dc9c883p-3))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.45f306dc9c883p-3))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.45f306dc9c883p-3))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0.4p-1022))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0.4p-1022))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0.4p-1022))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0.4p-1022))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const 0x1p+0) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const 0x1.921fb54442d18p+3))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const -0x1.921fb54442d18p+3))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1.921fb54442d18p+3))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1.921fb54442d18p+3))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.921fb54442d19p-1022))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.921fb54442d19p-1022))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.921fb54442d19p-1022))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.921fb54442d19p-1022))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.45f306dc9c882p+1021))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.45f306dc9c882p+1021))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.45f306dc9c882p+1021))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.45f306dc9c882p+1021))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p+0))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p+0))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -0x1p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const 0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -0x1p-1)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const 0x1p-1)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -0x1p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const 0x1p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const -0x1p+0)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const 0x1p+0)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "div" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "div" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return_nan (invoke "div" (f64.const -infinity) (f64.const -infinity)))
(assert_return_nan (invoke "div" (f64.const -infinity) (f64.const infinity)))
(assert_return_nan (invoke "div" (f64.const infinity) (f64.const -infinity)))
(assert_return_nan (invoke "div" (f64.const infinity) (f64.const infinity)))
(assert_return (invoke "div" (f64.const -infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const infinity) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "div" (f64.const infinity) (f64.const nan)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -0x0p+0)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const 0x0p+0)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -0x0p+0)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const 0x0p+0)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -0x1p-1022)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const 0x1p-1022)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -0x1p-1022)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const 0x1p-1022)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -0x1p-1)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const 0x1p-1)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -0x1p-1)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const 0x1p-1)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -0x1p+0)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const 0x1p+0)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -0x1p+0)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const 0x1p+0)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -infinity)) (f64.const -nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const infinity)) (f64.const -nan))
(assert_return (invoke "div" (f64.const nan) (f64.const -infinity)) (f64.const nan))
(assert_return (invoke "div" (f64.const nan) (f64.const infinity)) (f64.const nan))
(assert_return (invoke "div" (f64.const -nan) (f64.const -nan)) (f64.const -nan))
(assert_return_nan (invoke "div" (f64.const -nan) (f64.const nan)))
(assert_return_nan (invoke "div" (f64.const nan) (f64.const -nan)))
(assert_return (invoke "div" (f64.const nan) (f64.const nan)) (f64.const nan))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const 0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const 0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const 0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -0x0p+0) (f64.const infinity)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const 0x0p+0) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return_nan (invoke "min" (f64.const -0x0p+0) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -0x0p+0) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const 0x0p+0) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const 0x0p+0) (f64.const nan)))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (f64.const 0x0.0000000000001p-1022))
(assert_return_nan (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -0x0.0000000000001p-1022) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const 0x0.0000000000001p-1022) (f64.const nan)))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -0x1p-1022) (f64.const infinity)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const 0x1p-1022) (f64.const infinity)) (f64.const 0x1p-1022))
(assert_return_nan (invoke "min" (f64.const -0x1p-1022) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -0x1p-1022) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const 0x1p-1022) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const 0x1p-1022) (f64.const nan)))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const 0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const 0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -0x1p-1) (f64.const infinity)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const 0x1p-1) (f64.const infinity)) (f64.const 0x1p-1))
(assert_return_nan (invoke "min" (f64.const -0x1p-1) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -0x1p-1) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const 0x1p-1) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const 0x1p-1) (f64.const nan)))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const 0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const 0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p+0))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -0x1p+0) (f64.const infinity)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const 0x1p+0) (f64.const infinity)) (f64.const 0x1p+0))
(assert_return_nan (invoke "min" (f64.const -0x1p+0) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -0x1p+0) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const 0x1p+0) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const 0x1p+0) (f64.const nan)))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const 0x1.921fb54442d18p+2))
(assert_return_nan (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return_nan (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const 0x0p+0)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "min" (f64.const infinity) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const 0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "min" (f64.const infinity) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const 0x1p-1)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "min" (f64.const infinity) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -0x1p+0)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const 0x1p+0)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "min" (f64.const infinity) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "min" (f64.const -infinity) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const -infinity) (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "min" (f64.const infinity) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "min" (f64.const -infinity) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -infinity) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const infinity) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const infinity) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -0x0p+0)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const 0x0p+0)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -0x0p+0)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const 0x0p+0)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -0x0.0000000000001p-1022)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const 0x0.0000000000001p-1022)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -0x1p-1022)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const 0x1p-1022)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -0x1p-1022)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const 0x1p-1022)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -0x1p-1)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const 0x1p-1)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -0x1p-1)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const 0x1p-1)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -0x1p+0)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const 0x1p+0)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -0x1p+0)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const 0x1p+0)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -infinity)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const infinity)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -infinity)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const infinity)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const -nan) (f64.const nan)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const -nan)))
(assert_return_nan (invoke "min" (f64.const nan) (f64.const nan)))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0p+0) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const -infinity)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0p+0) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -0x0p+0) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -0x0p+0) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const 0x0p+0) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const 0x0p+0) (f64.const nan)))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -0x0.0000000000001p-1022) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const 0x0.0000000000001p-1022) (f64.const nan)))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const -infinity)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const -infinity)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1022) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -0x1p-1022) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -0x1p-1022) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const 0x1p-1022) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const 0x1p-1022) (f64.const nan)))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const 0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const -infinity)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p-1) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const -infinity)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p-1) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -0x1p-1) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -0x1p-1) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const 0x1p-1) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const 0x1p-1) (f64.const nan)))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const 0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const -infinity)) (f64.const -0x1p+0))
(assert_return (invoke "max" (f64.const -0x1p+0) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const -infinity)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1p+0) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -0x1p+0) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -0x1p+0) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const 0x1p+0) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const 0x1p+0) (f64.const nan)))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "max" (f64.const -infinity) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "max" (f64.const infinity) (f64.const -0x0p+0)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "max" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "max" (f64.const -infinity) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "max" (f64.const infinity) (f64.const -0x1p-1022)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "max" (f64.const -infinity) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "max" (f64.const infinity) (f64.const -0x1p-1)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "max" (f64.const -infinity) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "max" (f64.const infinity) (f64.const -0x1p+0)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const 0x1p+0)) (f64.const infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "max" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "max" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "max" (f64.const -infinity) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "max" (f64.const infinity) (f64.const infinity)) (f64.const infinity))
(assert_return_nan (invoke "max" (f64.const -infinity) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -infinity) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const infinity) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const infinity) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -0x0p+0)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const 0x0p+0)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -0x0p+0)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const 0x0p+0)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -0x0.0000000000001p-1022)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const 0x0.0000000000001p-1022)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -0x1p-1022)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const 0x1p-1022)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -0x1p-1022)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const 0x1p-1022)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -0x1p-1)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const 0x1p-1)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -0x1p-1)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const 0x1p-1)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -0x1p+0)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const 0x1p+0)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -0x1p+0)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const 0x1p+0)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -infinity)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const infinity)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -infinity)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const infinity)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const -nan) (f64.const nan)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const -nan)))
(assert_return_nan (invoke "max" (f64.const nan) (f64.const nan)))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const 0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -0x1p+0)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const 0x1p+0)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -infinity)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const infinity)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const -nan)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0p+0) (f64.const nan)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const -nan)) (f64.const -0x0p+0))
(assert_return (invoke "copysign" (f64.const 0x0p+0) (f64.const nan)) (f64.const 0x0p+0))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p-1)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p-1)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1p+0)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1p+0)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const infinity)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -infinity)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const infinity)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x0.0000000000001p-1022) (f64.const nan)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const -nan)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const 0x0.0000000000001p-1022) (f64.const nan)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -0x0p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const 0x0p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -0x1p-1)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const 0x1p-1)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -0x1p+0)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const 0x1p+0)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -infinity)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const infinity)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -infinity)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const infinity)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const -nan)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1022) (f64.const nan)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const -nan)) (f64.const -0x1p-1022))
(assert_return (invoke "copysign" (f64.const 0x1p-1022) (f64.const nan)) (f64.const 0x1p-1022))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const 0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -0x0p+0)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const 0x0p+0)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -0x1p-1022)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const 0x1p-1022)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -0x1p+0)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const 0x1p+0)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -infinity)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const infinity)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -infinity)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const infinity)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const -nan)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p-1) (f64.const nan)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const -nan)) (f64.const -0x1p-1))
(assert_return (invoke "copysign" (f64.const 0x1p-1) (f64.const nan)) (f64.const 0x1p-1))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const 0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -0x0p+0)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const 0x0p+0)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const 0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const 0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -infinity)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const infinity)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -infinity)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const infinity)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const -nan)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1p+0) (f64.const nan)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const -nan)) (f64.const -0x1p+0))
(assert_return (invoke "copysign" (f64.const 0x1p+0) (f64.const nan)) (f64.const 0x1p+0))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1022)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1022)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p-1)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p-1)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1p+0)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1p+0)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -infinity)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const infinity)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.921fb54442d18p+2) (f64.const nan)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const -nan)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const 0x1.921fb54442d18p+2) (f64.const nan)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1022)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1022)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p-1)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p-1)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1p+0)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1p+0)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -infinity)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const infinity)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const -nan)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const 0x1.fffffffffffffp+1023) (f64.const nan)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -0x0p+0)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const 0x0p+0)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -0x0.0000000000001p-1022)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const 0x0.0000000000001p-1022)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -0x1p-1022)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const 0x1p-1022)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -0x1p-1)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const 0x1p-1)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -0x1p+0)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const 0x1p+0)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -0x1p+0)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const 0x1p+0)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -0x1.921fb54442d18p+2)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const 0x1.921fb54442d18p+2)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const 0x1.fffffffffffffp+1023)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const -nan)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const -infinity) (f64.const nan)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const -nan)) (f64.const -infinity))
(assert_return (invoke "copysign" (f64.const infinity) (f64.const nan)) (f64.const infinity))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -0x0p+0)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const 0x0p+0)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -0x0p+0)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const 0x0p+0)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const 0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -0x0.0000000000001p-1022)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const 0x0.0000000000001p-1022)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -0x1p-1022)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const 0x1p-1022)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -0x1p-1022)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const 0x1p-1022)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -0x1p-1)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const 0x1p-1)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -0x1p-1)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const 0x1p-1)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -0x1p+0)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const 0x1p+0)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -0x1p+0)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const 0x1p+0)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -0x1.921fb54442d18p+2)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const 0x1.921fb54442d18p+2)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -0x1.fffffffffffffp+1023)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const 0x1.fffffffffffffp+1023)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -infinity)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const infinity)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -infinity)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const infinity)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const -nan) (f64.const nan)) (f64.const nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "copysign" (f64.const nan) (f64.const nan)) (f64.const nan))
(assert_return (invoke "sqrt" (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "sqrt" (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return_nan (invoke "sqrt" (f64.const -0x0.0000000000001p-1022)))
(assert_return (invoke "sqrt" (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p-537))
(assert_return_nan (invoke "sqrt" (f64.const -0x1p-1022)))
(assert_return (invoke "sqrt" (f64.const 0x1p-1022)) (f64.const 0x1p-511))
(assert_return_nan (invoke "sqrt" (f64.const -0x1p-1)))
(assert_return (invoke "sqrt" (f64.const 0x1p-1)) (f64.const 0x1.6a09e667f3bcdp-1))
(assert_return_nan (invoke "sqrt" (f64.const -0x1p+0)))
(assert_return (invoke "sqrt" (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return_nan (invoke "sqrt" (f64.const -0x1.921fb54442d18p+2)))
(assert_return (invoke "sqrt" (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.40d931ff62705p+1))
(assert_return_nan (invoke "sqrt" (f64.const -0x1.fffffffffffffp+1023)))
(assert_return (invoke "sqrt" (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+511))
(assert_return_nan (invoke "sqrt" (f64.const -infinity)))
(assert_return (invoke "sqrt" (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "sqrt" (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "sqrt" (f64.const nan)) (f64.const nan))
(assert_return (invoke "floor" (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "floor" (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "floor" (f64.const -0x0.0000000000001p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "floor" (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "floor" (f64.const -0x1p-1022)) (f64.const -0x1p+0))
(assert_return (invoke "floor" (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "floor" (f64.const -0x1p-1)) (f64.const -0x1p+0))
(assert_return (invoke "floor" (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "floor" (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "floor" (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "floor" (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.cp+2))
(assert_return (invoke "floor" (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.8p+2))
(assert_return (invoke "floor" (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "floor" (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "floor" (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "floor" (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "floor" (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "floor" (f64.const nan)) (f64.const nan))
(assert_return (invoke "ceil" (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "ceil" (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "ceil" (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "ceil" (f64.const 0x0.0000000000001p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "ceil" (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "ceil" (f64.const 0x1p-1022)) (f64.const 0x1p+0))
(assert_return (invoke "ceil" (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "ceil" (f64.const 0x1p-1)) (f64.const 0x1p+0))
(assert_return (invoke "ceil" (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "ceil" (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "ceil" (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.8p+2))
(assert_return (invoke "ceil" (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.cp+2))
(assert_return (invoke "ceil" (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "ceil" (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "ceil" (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "ceil" (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "ceil" (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "ceil" (f64.const nan)) (f64.const nan))
(assert_return (invoke "trunc" (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "trunc" (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "trunc" (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "trunc" (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "trunc" (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "trunc" (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "trunc" (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "trunc" (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "trunc" (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "trunc" (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "trunc" (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.8p+2))
(assert_return (invoke "trunc" (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.8p+2))
(assert_return (invoke "trunc" (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "trunc" (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "trunc" (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "trunc" (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "trunc" (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "trunc" (f64.const nan)) (f64.const nan))
(assert_return (invoke "nearest" (f64.const -0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "nearest" (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "nearest" (f64.const -0x0.0000000000001p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "nearest" (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "nearest" (f64.const -0x1p-1022)) (f64.const -0x0p+0))
(assert_return (invoke "nearest" (f64.const 0x1p-1022)) (f64.const 0x0p+0))
(assert_return (invoke "nearest" (f64.const -0x1p-1)) (f64.const -0x0p+0))
(assert_return (invoke "nearest" (f64.const 0x1p-1)) (f64.const 0x0p+0))
(assert_return (invoke "nearest" (f64.const -0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "nearest" (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "nearest" (f64.const -0x1.921fb54442d18p+2)) (f64.const -0x1.8p+2))
(assert_return (invoke "nearest" (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.8p+2))
(assert_return (invoke "nearest" (f64.const -0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "nearest" (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "nearest" (f64.const -infinity)) (f64.const -infinity))
(assert_return (invoke "nearest" (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "nearest" (f64.const -nan)) (f64.const -nan))
(assert_return (invoke "nearest" (f64.const nan)) (f64.const nan))
(assert_return (invoke "abs" (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "abs" (f64.const 0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "abs" (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "abs" (f64.const 0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "abs" (f64.const -0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "abs" (f64.const 0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "abs" (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "abs" (f64.const 0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "abs" (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "abs" (f64.const 0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "abs" (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "abs" (f64.const 0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "abs" (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "abs" (f64.const 0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "abs" (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "abs" (f64.const infinity)) (f64.const infinity))
(assert_return (invoke "abs" (f64.const -nan)) (f64.const nan))
(assert_return (invoke "abs" (f64.const nan)) (f64.const nan))
(assert_return (invoke "neg" (f64.const -0x0p+0)) (f64.const 0x0p+0))
(assert_return (invoke "neg" (f64.const 0x0p+0)) (f64.const -0x0p+0))
(assert_return (invoke "neg" (f64.const -0x0.0000000000001p-1022)) (f64.const 0x0.0000000000001p-1022))
(assert_return (invoke "neg" (f64.const 0x0.0000000000001p-1022)) (f64.const -0x0.0000000000001p-1022))
(assert_return (invoke "neg" (f64.const -0x1p-1022)) (f64.const 0x1p-1022))
(assert_return (invoke "neg" (f64.const 0x1p-1022)) (f64.const -0x1p-1022))
(assert_return (invoke "neg" (f64.const -0x1p-1)) (f64.const 0x1p-1))
(assert_return (invoke "neg" (f64.const 0x1p-1)) (f64.const -0x1p-1))
(assert_return (invoke "neg" (f64.const -0x1p+0)) (f64.const 0x1p+0))
(assert_return (invoke "neg" (f64.const 0x1p+0)) (f64.const -0x1p+0))
(assert_return (invoke "neg" (f64.const -0x1.921fb54442d18p+2)) (f64.const 0x1.921fb54442d18p+2))
(assert_return (invoke "neg" (f64.const 0x1.921fb54442d18p+2)) (f64.const -0x1.921fb54442d18p+2))
(assert_return (invoke "neg" (f64.const -0x1.fffffffffffffp+1023)) (f64.const 0x1.fffffffffffffp+1023))
(assert_return (invoke "neg" (f64.const 0x1.fffffffffffffp+1023)) (f64.const -0x1.fffffffffffffp+1023))
(assert_return (invoke "neg" (f64.const -infinity)) (f64.const infinity))
(assert_return (invoke "neg" (f64.const infinity)) (f64.const -infinity))
(assert_return (invoke "neg" (f64.const -nan)) (f64.const nan))
(assert_return (invoke "neg" (f64.const nan)) (f64.const -nan))
