#ifndef __ClangIntroSema_h__
#define __ClangIntroSema_h__

#include "clang/Sema/Sema.h"

class ClangIntroducer;

class ClangIntroSema : public clang::Sema {
  ClangIntroducer *_introducer;
  int _nested_tu_end;
  int _nested_base_specifiers;
  clang::SmallVector<clang::CXXBaseSpecifier *, 16> _BaseInfo;

public:
  ClangIntroSema(ClangIntroducer &introducer,
      clang::Preprocessor &pp, clang::ASTContext &ctxt,
      clang::ASTConsumer &consumer,
      clang::TranslationUnitKind TUKind = clang::TU_Complete,
      clang::CodeCompleteConsumer *CompletionConsumer = 0);
  ~ClangIntroSema ();

  clang::Scope *setCurScope(clang::Scope *new_scope);

  void ActOnStartCXXMemberDeclarations(clang::Scope *S, clang::Decl *TagDecl,
      clang::SourceLocation FinalLoc, bool IsFinalSpelledSealed,
      clang::SourceLocation LBraceLoc);

#if FRONTEND_CLANG < 38
  void ActOnBaseSpecifiers (clang::Decl *ClassDecl,
      clang::CXXBaseSpecifier **Bases, unsigned NumBases);
#else
  void ActOnBaseSpecifiers (clang::Decl *ClassDecl,
      clang::MutableArrayRef<clang::CXXBaseSpecifier *> Bases);
#endif

  void ActOnFinishCXXMemberSpecification (clang::Scope* S,
      clang::SourceLocation RLoc, clang::Decl *TagDecl, clang::SourceLocation LBrac,
      clang::SourceLocation RBrac, clang::AttributeList *AttrList);

  void ActOnEndOfTranslationUnit ();

  bool canSkipFunctionBody(clang::Decl *FctDecl);
};

#endif // __ClangIntroSema_h__
