/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "domain_settings_type_combo_changed.h"



void domain_settings_type_combo_changed(struct w *widgets)
{
    gint active_index = 0;

    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->domain_settings_combo[0]));

    /* Domain type master selected */
    if( active_index <= 0 )
    {
	/* Allow-update widget is visible */
	gtk_widget_show(widgets->domain_settings_entry[4]);

	/* Allow-notify widget is not visible */
	gtk_widget_hide(widgets->domain_settings_entry[8]);

	/* Master servers widget is not visible */
	gtk_widget_hide(widgets->domain_settings_entry[9]);
    }

    /* Domain type slave selected */
    if( active_index == 1 )
    {
	/* Allow-update widget is not visible */
	gtk_widget_hide(widgets->domain_settings_entry[4]);

	/* Allow-notify widget is visible */
	gtk_widget_show(widgets->domain_settings_entry[8]);

	/* Master servers widget is visible */
	gtk_widget_show(widgets->domain_settings_entry[9]);
    }
}
