/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.NameTest;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.PrefixTest;
import com.icl.saxon.om.AttributeInfo;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ElementImpl
extends ParentNodeImpl
implements ElementInfo,
Element,
NamedNodeMap {
    private static AttributeCollection emptyAtts = new AttributeCollection();
    protected Name fullName;

    public void initialise(Name name, AttributeCollection attributeCollection, NodeInfo nodeInfo, String string, int n, int n2) throws SAXException {
        this.fullName = name;
        this.parent = (ParentNodeImpl)nodeInfo;
        this.sequence = n2;
        DocumentImpl documentImpl = (DocumentImpl)this.getDocumentRoot();
        documentImpl.setLineNumber(n2, n);
        documentImpl.setBaseURI(n2, string);
    }

    public final String getSystemId() {
        return ((DocumentImpl)this.getDocumentRoot()).getBaseURI(this.sequence);
    }

    public void setLineNumber(int n) {
        ((DocumentImpl)this.getDocumentRoot()).setLineNumber(this.sequence, n);
    }

    public int getLineNumber() {
        return ((DocumentImpl)this.getDocumentRoot()).getLineNumber(this.sequence);
    }

    public final Name getExpandedName() {
        return this.fullName;
    }

    public final String getPrefix() {
        return this.fullName.getPrefix();
    }

    public final String getURI() {
        return this.fullName.getURI();
    }

    public String getURIforPrefix(String string) throws SAXException {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (this.parent instanceof DocumentInfo) {
            if (string.equals("")) {
                return "";
            }
            throw new SAXException("Namespace for prefix \"" + string + "\" has not been declared");
        }
        return ((ElementInfo)((Object)this.parent)).getURIforPrefix(string);
    }

    public String getPrefixForURI(String string) {
        if (this.parent instanceof DocumentInfo) {
            return null;
        }
        return ((ElementInfo)((Object)this.parent)).getPrefixForURI(string);
    }

    public void addNamespaceNodes(ElementInfo elementInfo, Vector vector, NodeInfo nodeInfo) throws SAXException {
        if (!(this.parent instanceof DocumentInfo) && this.parent != nodeInfo) {
            ((ElementInfo)((Object)this.parent)).addNamespaceNodes(elementInfo, vector, nodeInfo);
        }
    }

    public void outputNamespaceNodes(Outputter outputter) throws SAXException {
        if (!(this.parent instanceof DocumentInfo)) {
            ((ElementInfo)((Object)this.parent)).outputNamespaceNodes(outputter);
        }
    }

    public final Name makeName(String string, boolean bl) throws SAXException {
        return new Name(string, this, bl);
    }

    public final NameTest makePrefixTest(String string) throws SAXException {
        String string2 = this.getURIforPrefix(string);
        return new PrefixTest(string2);
    }

    public final short getNodeType() {
        return 1;
    }

    public AttributeCollection getAttributeList() {
        return emptyAtts;
    }

    public String getAttributeValue(Name name) {
        return null;
    }

    public String getAttributeValue(String string) {
        return null;
    }

    public AttributeInfo makeAttributeNode(Name name) {
        return null;
    }

    public String getInheritedAttribute(Name name) throws SAXException {
        NodeInfo nodeInfo = this;
        while (nodeInfo instanceof ElementInfo) {
            String string = nodeInfo.getAttributeValue(name);
            if (string != null) {
                return string;
            }
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        return null;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public boolean isFirstInGroup() {
        NodeInfo nodeInfo = (NodeInfo)this.getPreviousSibling();
        while (nodeInfo != null && !(nodeInfo instanceof ElementInfo)) {
            nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
        }
        if (nodeInfo == null) {
            return true;
        }
        return !nodeInfo.hasName(this.getExpandedName());
    }

    public boolean isLastInGroup() {
        NodeInfo nodeInfo = (NodeInfo)this.getNextSibling();
        while (nodeInfo != null && !(nodeInfo instanceof ElementInfo)) {
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
        if (nodeInfo == null) {
            return true;
        }
        return !nodeInfo.hasName(this.getExpandedName());
    }

    public boolean isFirstChild() {
        NodeInfo nodeInfo = (NodeInfo)this.getPreviousSibling();
        while (nodeInfo != null && !(nodeInfo instanceof ElementInfo)) {
            nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
        }
        return nodeInfo == null;
    }

    public boolean isLastChild() {
        NodeInfo nodeInfo = (NodeInfo)this.getNextSibling();
        while (nodeInfo != null && !(nodeInfo instanceof ElementInfo)) {
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
        return nodeInfo == null;
    }

    public void copy(Outputter outputter) throws SAXException {
        outputter.writeStartTag(this.fullName);
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            nodeInfo.copy(outputter);
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
        outputter.writeEndTag(this.fullName);
    }

    public String getPath() {
        String string = ((NodeInfo)this.getParentNode()).getPath();
        return (string.equals("/") ? "" : string) + "/" + this.getDisplayName() + "[" + this.getNumberSimple() + "]";
    }

    public String getTagName() {
        return this.getDisplayName();
    }

    public String getNodeValue() {
        return null;
    }

    public String getAttribute(String string) {
        return "";
    }

    public NamedNodeMap getAttributes() {
        return this;
    }

    public void removeAttribute(String string) {
        this.setAttribute(string, null);
    }

    public Attr getAttributeNode(String string) {
        return null;
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagName(String string) {
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        NodeInfo nodeInfo = this;
        while (nodeInfo != null) {
            if (nodeInfo instanceof ElementInfo && (string.equals("*") || string.equals(nodeInfo.getDisplayName()))) {
                vector.addElement(nodeInfo);
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        return new NodeSetExtent(vector);
    }

    public String getAttributeNS(String string, String string2) {
        return "";
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.disallowUpdate();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return null;
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        Vector<NodeInfo> vector = new Vector<NodeInfo>();
        NodeInfo nodeInfo = this;
        while (nodeInfo != null) {
            if (nodeInfo instanceof ElementInfo && (string.equals("*") || string.equals(nodeInfo.getURI()) && (string2.equals("*") || string2.equals(nodeInfo.getLocalName())))) {
                vector.addElement(nodeInfo);
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        return new NodeSetExtent(vector);
    }

    public boolean hasAttribute(String string) {
        return false;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return false;
    }

    public Node getNamedItem(String string) {
        return null;
    }

    public Node setNamedItem(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node item(int n) {
        return null;
    }

    public int getLength() {
        return 0;
    }

    public Node getNamedItemNS(String string, String string2) {
        return null;
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }
}

