#!/bin/sh

TOOLPATH=`pwd`
TOOLVER=`grep toolchain-source debian/changelog | head -1 | sed -e 's/^.*(//' -e 's/).*$//'`
TEMPPATH=/tmp/toolchain-update.sh-temp/
rm -rf $TEMPPATH
mkdir $TEMPPATH
cd $TEMPPATH


su -c 'apt-get update'

apt-get source gcc-3.4
NEW=`grep gcc gcc-*/debian/changelog | head -1 | sed -e 's/^.*(//' -e 's/).*$//'`
OLD=`grep 'Updated gcc to' $TOOLPATH/debian/changelog | head -1| sed -e 's/^.* to //' -e 's/ .*$//'`
if dpkg --compare-versions $NEW gt $OLD; then
    rm $TOOLPATH/gcc-*.tar.bz2
    cp gcc-*/gcc-*.tar.bz2 $TOOLPATH
    rm $TOOLPATH/debian/patches/gcc/*
    cp gcc-*/debian/rules.patch $TOOLPATH/debian/patches/gcc/
    cp gcc-*/debian/patches/* $TOOLPATH/debian/patches/gcc/
    VER=`echo $NEW | perl -pe 's/^.*?:(\d+\.\d+).*$/$1/'`-1
    if dpkg --compare-versions $VER \> $TOOLVER; then
	V="-v "$VER;
    else
	V=""
    fi
    cd $TOOLPATH; dch $V "Updated gcc to "$NEW; cd $TEMPPATH
fi

apt-get source binutils
NEW=`grep binutils binutils-*/debian/changelog | head -1 | sed -e 's/^.*(//' -e 's/).*$//'`
OLD=`grep 'Updated binutils to' $TOOLPATH/debian/changelog | head -1| sed -e 's/^.* to //' -e 's/ .*$//'`
if dpkg --compare-versions $NEW gt $OLD; then
    rm $TOOLPATH/binutils-*.tar.bz2
    gunzip binutils*.orig.tar.gz
    bzip2 -9 binutils*.orig.tar
    N=`echo binutils*.orig.tar.bz2| sed -e s/.orig// -e s/_/-/`
    cp binutils*.orig.tar.bz2 $TOOLPATH/$N
    rm $TOOLPATH/debian/patches/binutils/*
    cp binutils-*/debian/patches/* $TOOLPATH/debian/patches/binutils/
    cd $TOOLPATH; dch "Updated binutils to "$NEW; cd $TEMPPATH
fi

apt-get source gdb
NEW=`grep gdb gdb-*/debian/changelog | head -1 | sed -e 's/^.*(//' -e 's/).*$//'`
OLD=`grep 'Updated gdb to' $TOOLPATH/debian/changelog | head -1| sed -e 's/^.* to //' -e 's/ .*$//'`
if dpkg --compare-versions $NEW gt $OLD; then
    rm $TOOLPATH/gdb-*.tar.bz2
    gunzip gdb*.orig.tar.gz
    bzip2 -9 gdb*.orig.tar
    N=`echo gdb*.orig.tar.bz2| sed -e s/.orig// -e s/_/-/`
    cp gdb*.orig.tar.bz2 $TOOLPATH/$N
    mv $TOOLPATH/debian/patches/gdb/rules.patch .
    rm $TOOLPATH/debian/patches/gdb/*
    mv rules.patch $TOOLPATH/debian/patches/gdb/
    cp gdb-*/debian/patches/* $TOOLPATH/debian/patches/gdb/
    cd $TOOLPATH; dch "Updated gdb to "$NEW; cd $TEMPPATH
fi

cd $TOOLPATH
#rm -fr $TEMPPATH