// Copyright (c) 1999-2001  David Muse
// See the file COPYING for more information

#include <sqlrelay/sqlrclient.h>
#include <string.h>

bool sqlrconnection::resumeSession(int port, const char *socket) {

	// if already connected, end the session
	if (connected) {
		endSession();
	}

	// set the connectionunixport and connectioninetport values
	if (copyrefs) {
		if (strlen(socket)<=MAXPATHLEN) {
			strcpy(connectionunixportbuffer,socket);
			connectionunixport=connectionunixportbuffer;
		} else {
			connectionunixport="";
		}
	} else {
		connectionunixport=(char *)socket;
	}
	connectioninetport=(unsigned short)port;

	// first, try for the unix port
	if (socket && socket[0]) {
		if (connected=ucs.connect(socket,-1,-1,retrytime,tries)) {
			cs=&ucs;
		}
	}

	// then try for the inet port
	if (!connected) {
		if (connected=ics.connect(server,port,-1,-1,retrytime,tries)) {
			cs=&ics;
		}
	}

	if (debug) {
		debugPreStart();
		debugPrint("Resuming Session: ");
		debugPreEnd();
	}

	if (connected) {
		if (debug) {
			debugPreStart();
			debugPrint("success");
			debugPrint("\n");
			debugPreEnd();
		}
		clearSessionFlags();
	} else {
		if (debug) {
			debugPreStart();
			debugPrint("failure");
			debugPrint("\n");
			debugPreEnd();
		}
	}

	return connected;
}
