#ifdef __cplusplus
extern "C" {
#endif


#include <Python.h>
#include <orb/orbit.h>
#include <ctype.h>

#define INSIDE_PYORBIT
#include "orbit-python.h"
#include "CORBA_Object.h"
#include "CORBA_ORB.h"
#include "CORBA_TypeCode.h"
#include "CORBA_Any.h"
#include "CORBA_fixed.h"
#include "PortableServer.h"
#include "types.h"
#include "api.h"

#ifdef DEBUG
#define __DEBUG_LEVEL__ 3
#else
#define __DEBUG_LEVEL__ 0
#endif

// TODO: this file could probably use some restructuring.

// glue for CORBA interfaces to Python objects (client side)
typedef struct {
	PyTypeObject *type;
	PyObject *class_obj;
	PyMethodDef *generic_method, *narrow_method, *is_a_method,
	            *is_equivalent_method, *hash_method, *non_existent_method;
	CORBA_InterfaceDef_FullInterfaceDescription *desc;
	
	PortableServer_ClassInfo *class_info;
	CORBA_unsigned_long class_id;
} CORBA_PyObject_Glue;


// glue for CORBA interfaces to Python objects (client side)
typedef struct {
	PyObject *class_obj;
	CORBA_InterfaceDef_FullInterfaceDescription *desc;
	
	PortableServer_ClassInfo *class_info;
	CORBA_unsigned_long class_id;
	char *repo_id;
	CORBA_PyObject_Glue *oldglue; ////
} CORBA_PyClass_Glue;

// glue for CORBA interfaces to Python objects (client side)
typedef struct {
	CORBA_ORB_PyObject *orb; // the orb that this object is attached to
	CORBA_PyClass_Glue *class_glue;
	CORBA_Object obj;
	CORBA_Environment ev;
	char *repo_id; // duplicated from class_glue for convenience
} CORBA_PyInstance_Glue;

// glue for servant classes to Python servant classes
typedef struct {
	PortableServer_ClassInfo *class_info;
	CORBA_unsigned_long class_id;
	CORBA_PyClass_Glue *interface_glue;
} Servant_PyClass_Glue;

// glue for CORBA servants to Python instances
typedef struct {
	void *_private;
	PortableServer_ServantBase__vepv *vepv;

	Servant_PyClass_Glue *class_glue;
	// impl: for delegation, an instance of the implementation class
	// for inheritance, the servant object itself
	PyObject *impl;
	// the servant object for both delegation and inheritance
	// So for inheritance, servant == impl
	PyObject *servant;
	CORBA_boolean activated;
	POA_PyObject *poa;
	PortableServer_ObjectId *oid;
} Servant_PyInstance_Glue;

/*
typedef struct {
	void *_private;
	PortableServer_ServantBase__vepv *vepv;

	CORBA_PyObject_Glue *glue;
	PyObject *impl;
} PyOrbit_Servant;

typedef struct {
	PyObject_HEAD
	PyOrbit_Servant *servant;

	CORBA_unsigned_long class_id;
	PortableServer_ClassInfo *class_info;
	CORBA_boolean activated;
	POA_PyObject *poa;
	PortableServer_ObjectId *oid;
} Servant_PyObject;

void Servant_PyObject__dealloc(Servant_PyObject *);
int Servant_PyObject__setattr(Servant_PyObject *, char *, PyObject *);
PyObject *Servant_PyObject__getattr(Servant_PyObject *, char *);

*/

PyObject *Servant_PyClass__init(PyObject *_, PyObject *, PyObject *);
PyObject *Servant_PyClass__del(PyObject *_, PyObject *, PyObject *);
PyObject *Servant_PyClass__this(PyObject *_, PyObject *, PyObject *);
PyObject *Servant_PyClass__default_POA(PyObject *_, PyObject *, PyObject *);


// Globals

////////////////////////////////////////////////////////////////////////////
// Exceptions
extern PyObject
		*OPExc_Exception,
		*OPExc_SystemException,
		*OPExc_UserException,
		*OPExc_UNKNOWN,
		*OPExc_BAD_PARAM,
		*OPExc_NO_MEMORY,
		*OPExc_IMP_LIMIT,
		*OPExc_COMM_FAILURE,
		*OPExc_INV_OBJREF,
		*OPExc_OBJECT_NOT_EXIST,
		*OPExc_NO_PERMISSION,
		*OPExc_INTERNAL,
		*OPExc_MARSHAL,
		*OPExc_INITIALIZE,
		*OPExc_NO_IMPLEMENT,
		*OPExc_BAD_TYPECODE,
		*OPExc_BAD_OPERATION,
		*OPExc_NO_RESOURCES,
		*OPExc_NO_RESPONSE,
		*OPExc_PERSIST_STORE,
		*OPExc_BAD_INV_ORDER,
		*OPExc_TRANSIENT,
		*OPExc_FREE_MEM,
		*OPExc_INV_IDENT,
		*OPExc_INV_FLAG,
		*OPExc_INTF_REPOS,
		*OPExc_BAD_CONTEXT,
		*OPExc_OBJ_ADAPTER,
		*OPExc_DATA_CONVERSION,
		*OPExc_TRANSACTION_REQUIRED,
		*OPExc_TRANSACTION_ROLLEDBACK,
		*OPExc_INVALID_TRANSACTION,
		*OPExc_WRONG_TRANSACTION;




extern PyObject *ModuleDict, *MainDict, *poa_instances,
                *main_module, *corba_object_class,
                // where to put module-less stubs and skeletons
                *global_client_module, *global_poa_module;
extern GHashTable *object_glue, *type_codes, *exceptions, *poa_modules,
                  *client_modules;
// hash on Python Class Object addresses; store Servant_PyClass_Glue
extern GHashTable *servant_class_glue;
// hash on Python Instance Object addresses; store Servant_PyInterface_Glue
extern GHashTable *servant_instance_glue;
// hash on Python Class Object addresses; store Servant_PyClass_Glue

extern GHashTable *object_instance_glue;
extern GHashTable *stub_repo_ids;
extern GHashTable *object_to_instances_hash;
extern GHashTable *orb_objects;
extern GHashTable *poa_objects;

extern POA_PyObject *root_poa;

// FIXME: make it work even when ORBIT_PYTHON_NOT_THREADED is not defined,
// then delete all #ifndef's  -- RM

#define ORBIT_PYTHON_NOT_THREADED
#ifndef ORBIT_PYTHON_NOT_THREADED
extern PyThreadState *python_thread_state;
#endif /* ORBIT_PYTHON_NOT_THREADED */



	GIOPConnection *demarshal_call(CORBA_Object, GIOPConnection *,
	                          GIOP_unsigned_long,
	                          CORBA_OperationDescription *,
	                          PyObject *, GPtrArray *, PyObject **);
	GPtrArray *marshal_call(CORBA_Object, GIOPConnection *, GIOP_unsigned_long,
	                        CORBA_OperationDescription *, PyObject *);
	CORBA_boolean parse(char *, char *);

	CORBA_boolean marshal_arg(PyObject *, GIOPSendBuffer *, CORBA_TypeCode);
	CORBA_exception_type marshal_exception(PyObject *, PyObject *, 
	                                       GIOPSendBuffer *, CORBA_TypeCode, 
	                                       CORBA_OperationDescription *);
	PyObject *demarshal_arg(GIOPRecvBuffer *, CORBA_TypeCode, CORBA_ORB);
	void demarshal_exception(GIOPRecvBuffer *, CORBA_TypeCode,
	                         CORBA_exception_type, CORBA_OperationDescription *,
	                         CORBA_ORB orb);




void ORBit_Python_init_server(void);
void ORBit_Python_init_portable_server(void);
void ORBit_Python_init_marshal(void);
// typecode functions
void ORBit_Python_init_typecodes(void);
CORBA_TypeCode find_typecode(char *);
char *find_repo_id_from_typecode(CORBA_TypeCode);
void store_typecode(char *, CORBA_TypeCode);

// exception functions
CORBA_boolean check_corba_ex(CORBA_Environment *);
void ORBit_Python_init_exceptions(void);
void raise_user_exception(char *, PyObject *);
void *raise_system_exception(PyObject *, CORBA_unsigned_long, 
                            CORBA_completion_status, char *, ...);
PyObject *UserExcept_PyClass__init(PyObject *, PyObject *, PyObject *);
PyObject *UserExcept_PyClass__str(PyObject *, PyObject *, PyObject *);
PyObject *UserExcept_PyClass__del(PyObject *, PyObject *, PyObject *);

PyObject *stub_func(CORBA_PyObject *, PyObject *);
PyObject *_stub_func(CORBA_Object, PyObject *, CORBA_OperationDescription *);

PyObject *get_attribute(CORBA_PyInstance_Glue *, CORBA_AttributeDescription *);
PyObject *set_attribute(CORBA_PyInstance_Glue *, CORBA_AttributeDescription *, PyObject *);

PyObject *create_poa_stub(PyObject *, PyObject *);
PyObject *new_poa_servant(PyObject *, PyObject *);
Servant_PyInstance_Glue *ORBit_Python_init_pserver(Servant_PyClass_Glue *, PyObject *);

CORBA_AttributeDescription *find_attribute(CORBA_PyClass_Glue *glue, char *n);
CORBA_OperationDescription *find_operation(CORBA_PyClass_Glue *glue, char *n);
Servant_PyClass_Glue *get_class_glue_from_instance(PyObject *);
ORBitSkeleton get_skel(Servant_PyInstance_Glue *self, GIOPRecvBuffer *buf,
		       gpointer *impl);
void init_local_objref(CORBA_Object obj, Servant_PyInstance_Glue *);

// idl preprocessing stuff
void process_idl_paths(char *pathstr);
GSList *get_idl_list_for_module(char *, char, char **);
GSList *get_global_idl_files(void);
void set_file_as_loaded(char *);
GSList *get_defines_for_file(char *filename);


// type checking
int compare_object_interface(CORBA_TypeCode tc, PyObject *arg);
int compare_glue_interface(CORBA_TypeCode tc, CORBA_PyObject_Glue *glue);
#define is_corba_pyobject(obj) \
	(g_hash_table_lookup(object_instance_glue, obj) != 0)
//	(obj->ob_type->tp_dealloc == (destructor)CORBA_PyObject__dealloc)


#define dupe_tc(a) (CORBA_TypeCode)CORBA_Object_duplicate((CORBA_Object)a, NULL)
#define d_error(f, a...) g_log(G_LOG_DOMAIN, G_LOG_LEVEL_ERROR, f, ##a)

#define d_message(l, f, a...) G_STMT_START { \
 if (__DEBUG_LEVEL__ >= l) \
		g_log(G_LOG_DOMAIN, G_LOG_LEVEL_DEBUG, f, ##a); \
	}G_STMT_END

#define d_warning(l, f, a...) G_STMT_START { \
 if (__DEBUG_LEVEL__ >= l) \
		g_log(G_LOG_DOMAIN, G_LOG_LEVEL_WARNING, f, ##a); \
	}G_STMT_END

#ifndef DEBUG
	#define d_assert_noval(expr) G_STMT_START { \
		if (!(expr)) { \
			raise_system_exception(OPExc_INTERNAL, 0, CORBA_COMPLETED_MAYBE, \
			"file %s: line %d (%s): assertion failed: (%s)", \
			__FILE__, __LINE__, __PRETTY_FUNCTION__, #expr); \
	      return; \
		}  } G_STMT_END

	#define d_assert_val(expr, val) G_STMT_START { \
		if (!(expr)) { \
			raise_system_exception(OPExc_INTERNAL, 0, CORBA_COMPLETED_MAYBE, \
			"file %s: line %d (%s): assertion failed: (%s)", \
			__FILE__, __LINE__, __PRETTY_FUNCTION__, #expr); \
	      return val; \
		}  } G_STMT_END

	#define d_assert(expr) d_assert_val(expr, NULL);
#else
	#define d_assert(expr) g_assert(expr)
	#define d_assert_val(expr, val) g_assert(expr)
	#define d_assert_noval(expr) g_assert(expr)
#endif

#ifdef __cplusplus
}
#endif

/* Local Variables: */
/* c-file-style: "python" */
/* End: */
