

from Ft.Server.Server import FtServerServerException, Error

import test_helper

def test_create(tester):

    tester.startTest("Session Creation")

    repo = test_helper.GetRepo(tester)

    tester.compare(0,repo.hasSession())
    global sid
    sid = repo.createSession(123)
    tester.compare(1,repo.hasSession())
    repo.txCommit()
    tester.testDone()


    tester.startTest("Get Session")
    repo = test_helper.RetrieveSession(tester,sid,123)
    tester.compare(tester.test_data['userName'],repo.getAclIdent())
    tester.compare(1,repo.hasSession())
    repo.txRollback()
    tester.testDone()

    tester.startTest("Get Session Errors")
    tester.testException(test_helper.RetrieveSession,(tester,sid,321),FtServerServerException,{'code':Error.INVALID_SESSION})
    tester.testException(test_helper.RetrieveSession,(tester,'123',123),FtServerServerException,{'code':Error.INVALID_SESSION})
    tester.testDone()


def test_session_data(tester):

    tester.startTest("Session Data")

    #Testing the exception killed the session id so create a new one
    repo = test_helper.GetRepo(tester)
    global sid
    sid = repo.createSession(123)
    repo.txCommit()
   

    repo = test_helper.RetrieveSession(tester,sid,123)

    repo.setSessionData('foo','bar')
    tester.compare('bar',repo.getSessionData('foo'))
    tester.compare(None,repo.getSessionData('foo2'))
    repo.txCommit()

    repo = test_helper.RetrieveSession(tester,sid,123)

    repo.setSessionData('foo','bar')
    tester.compare('bar',repo.getSessionData('foo'))
    tester.compare(None,repo.getSessionData('foo2'))
    repo.txRollback()


    tester.testDone()


def test_invalidate(tester):

    tester.startTest("Invalidate Session")

    repo = test_helper.RetrieveSession(tester,sid,123)

    repo.invalidateSession()

    repo.txCommit()

    tester.testException(test_helper.RetrieveSession,(tester,sid,123),FtServerServerException,{'code':Error.INVALID_SESSION})

    tester.testDone()
    


def Test(tester):

    test_create(tester)
    test_session_data(tester)
    test_invalidate(tester)
