# http://lists.fourthought.com/pipermail/4suite/2001-December/002966.html


RDF1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:dc='http://purl.org/dc/elements/1.1/' xmlns:dcq='http://purl.org/dc/terms/' xmlns:gemq='http://gemstar.ischool.washington.edu/schema/2001/04/11/gemq#'>
  <rdf:Description rdf:about='http://magma.nationalgeographic.com/pulseplanet/'>
    <dc:subject>
      <rdf:Seq>
        <rdf:li>
          <gemq:GEM-S>
            <rdf:value>Social studies</rdf:value>
          </gemq:GEM-S>
        </rdf:li>
        <rdf:li>
          <gemq:GEM-S>
            <rdf:value>Geography</rdf:value>
          </gemq:GEM-S>
        </rdf:li>
      </rdf:Seq>
    </dc:subject>
  </rdf:Description>
</rdf:RDF>
"""

def Test(tester):
    from Ft.Lib.Uri import OsPathToUri
    from Ft.Rdf import Util
    from Ft.Xml.Domlette import PrettyPrint

    scope = OsPathToUri(__file__, attemptAbsolute=True)
    scope += '-INTERNAL-XML-STRING'
    model, db = Util.DeserializeFromString(RDF1, scope=scope)
    from Ft.Rdf.Serializers.Dom import Serializer
    serializer = Serializer()
    PrettyPrint(serializer.serialize(model))
