########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Xml/Xslt/OutputParameters.py,v 1.5 2004/02/29 21:51:14 jkloth Exp $
"""
Represents XSLT output parameters governed by the xsl:output instruction
See also Ft.Xml.Xslt.OutputHandler

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Xml.Xslt.AttributeValueTemplate import AttributeValueTemplate

class OutputParameters:
    
    def __init__(self):
        self.method = None
        self.version = None
        self.encoding = None
        self.omitXmlDeclaration = None
        self.standalone = None
        self.doctypeSystem = None
        self.doctypePublic = None
        self.mediaType = None
        self.cdataSectionElements = []
        self.indent = None

    def clone(self):
        clone = OutputParameters()
        clone.__dict__.update(self.__dict__)
        return clone

    def setDefault(self, attr, value):
        if not self.__dict__.has_key(attr):
            raise AttributeError(attr)

        if self.__dict__[attr] is None:
            self.__dict__[attr] = value
        return

    def avtParse(self, owner, context):
        method = owner._method.evaluate(context)
        if method: self.method = method

        version = owner._version.evaluate(context)
        if version: self.version = version

        encoding = owner._encoding.evaluate(context)
        if encoding: self.encoding = encoding

        omit_xml_decl = owner._omit_xml_declaration.evaluate(context)
        if omit_xml_decl: self.omitXmlDeclaration = omit_xml_decl

        standalone = owner._standalone.evaluate(context)
        if standalone: self.standalone = standalone and 'yes' or 'no'

        doctype_system = owner._doctype_system.evaluate(context)
        if doctype_system: self.doctypeSystem = doctype_system

        doctype_public = owner._doctype_public.evaluate(context)
        if doctype_public: self.doctypePublic = doctype_public

        media_type = owner._media_type.evaluate(context)
        if media_type: self.mediaType = media_type

        # cdata-section-elements are merged while the others are replaced
        self.cdataSectionElements.extend(
            owner._cdata_section_elements.evaluate(context)
            )

        indent = owner._indent.evaluate(context)
        if indent: self.indent = indent
        return

    def parse(self, owner):
        """
        parses the specified node for valid xsl:output attributes
        and stores their values internally.
        if called repeatedly, it will overwrite old values (this
        is by the specs, cause the last xsl:output element is the
        the one with most precedence).
        """
        if owner._method is not None:
            self.method = owner._method

        if owner._version is not None:
            self.version = owner._version

        if owner._encoding is not None:
            self.encoding = owner._encoding

        if owner._omit_xml_declaration is not None:
            self.omitXmlDeclaration = owner._omit_xml_declaration

        if owner._standalone is not None:
            self.standalone = owner._standalone and 'yes' or 'no'

        if owner._doctype_system is not None:
            self.doctypeSystem = owner._doctype_system

        if owner._doctype_public is not None:
            self.doctypePublic = owner._doctype_public

        if owner._media_type is not None:
            self.mediaType = owner._media_type

        # cdata-section-elements are merged while the others are replaced
        self.cdataSectionElements.extend(owner._cdata_section_elements)

        if owner._indent is not None:
            self.indent = owner._indent
        return
