########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/__init__.py,v 1.14 2005/03/22 09:58:59 mbrown Exp $
"""
4Suite repository

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import __version__, FtException

__all__ = ['__version__',
           'FTSERVER_NAMESPACE', 'RESERVED_NAMESPACE',
           'SCHEMA_NSS', 'TEMP_FILE_SCHEMA',
           'SYSTEM_ID_BASE', 'SWISH_SCHEMA',
           'FTSS_URI_SCHEME',
           'FtServerBaseException',
           ]

FTSERVER_NAMESPACE = 'http://xmlns.4suite.org/reserved'
RESERVED_NAMESPACE = 'http://xmlns.4suite.org/reserved'

SCHEMA_NSS = 'http://schemas.4suite.org/4ss'
TEMP_FILE_SCHEMA='%s#temp.file' % SCHEMA_NSS
SYSTEM_ID_BASE = "urn:4suite.org:4ss:repository:"
SWISH_SCHEMA='%s#metaxml.swish' % SCHEMA_NSS

# URI scheme for 4Suite repo resources
# (might someday be changed to something like
#  'vnd.fourthought.ftss' if proposed standards are adopted).
FTSS_URI_SCHEME = 'ftss'


class FtServerBaseException(FtException):
    """
    Base class for repository-specific exceptions.

    Subclasses must define self.MessageSource as the module
    containing a g_errorMessages mapping of error codes to
    message strings.
    """
    MessageSource = None

    def __init__(self, errorCode, *args, **kwargs):
        FtException.__init__(self, errorCode,
                             self.MessageSource.g_errorMessages, args, **kwargs)

