"""
Provides tools for generating system messages
"""

from Ft import TranslateMessage as _

class Error:

    CONFIG_NOT_FOUND = 10
    CONFIG_MISSING_PROPERTY = 11
    CONFIG_FILE_MISSING = 14
    CONFIG_INVALID_CORE_ID = 15
    CONFIG_INVALID_REPOSITORY = 16
    UNKNOWN_DRIVER_ERROR = 17

    INVALID_PATH = 20
    UNKNOWN_PATH = 21
    INVALID_LOGIN = 22
    PATH_EXISTS = 23
    UNKNOWN_RESOURCE_TYPE = 24

    BROKEN_ALIAS = 30
    OBJECT_DELETED = 31
    PERMISSION_DENIED = 32
    INVALID_ACL_IDENT = 33

    XML_PARSE_EXCEPTION = 40
    XSLT_PARSE_EXCEPTION = 41

    UNKNOWN_SERVER = 50
    NOT_SUPPORTED = 51

    INVALID_XML = 60

    UNKNOWN_VALIDATION_TYPE = 70

    VALIDATION_ERROR = 100

    SWISH_NOT_SUPPORTED = 200

g_errorMessages = {
    Error.CONFIG_NOT_FOUND: _('Unable to find configuration file.  Please FTSERVER_CONFIG_FILE in your environment.'),
    Error.CONFIG_MISSING_PROPERTY: _('Missing required configuration property %(property)s.  Please specify in the configuration file'),
    Error.CONFIG_FILE_MISSING: _('Unable to find configuration file %(file)s.'),
    Error.CONFIG_INVALID_CORE_ID: _('Invalid Core ID \'%(name)s\'. Make sure config file has rdf:ID and correct namespace on Core element.'),
    Error.CONFIG_INVALID_REPOSITORY: _('Core from %(configFileName)s ID: %(coreId)s either does not exist or is misconfigured.  Please see 4ss_manager init --help for details..'),

    Error.UNKNOWN_DRIVER_ERROR: _('Driver Type %(driver)s is unknown.'),


    Error.UNKNOWN_PATH: _('Path %(path)s is unknown'),
    Error.INVALID_PATH: _('Path %(path)s is not of type %(type)s'),
    Error.PATH_EXISTS: _('Path %(path)s is already in the repository'),
    Error.INVALID_LOGIN: _('Invalid Login'),
    Error.UNKNOWN_RESOURCE_TYPE: _('Resource Type %(type)s is unknown'),

    Error.BROKEN_ALIAS: _('Alias %(uri)s is broken'),
    Error.OBJECT_DELETED: _('Object %(path)s has been deleted'),
    Error.PERMISSION_DENIED: _("You do not have '%(level)s' access to %(path)s"),
    Error.INVALID_ACL_IDENT: _("ACL identifier %(aclIdent)s is unrecognized."),


    Error.XML_PARSE_EXCEPTION: _("Xml Parse Exception Line %(lineNum)s, Line %(colNum)s: %(message)s"),
    Error.XSLT_PARSE_EXCEPTION: _("Xslt Parse Exception: %(message)s"),

    Error.UNKNOWN_SERVER : _("Unknown protocol server: %(server)s"),
    Error.NOT_SUPPORTED : _('Requested operation not supported: %(reason)s'),

    Error.INVALID_XML : _("The XML is not in proper format: %(msg)s"),

    Error.UNKNOWN_VALIDATION_TYPE : _("The validation type %(type)s is unknown"),


    Error.VALIDATION_ERROR : _('Validation Error: %(message)s'),

    Error.SWISH_NOT_SUPPORTED : _("Text indexing with swish is not supported: %(reason)s"),

}

