#!/usr/bin/env python
############################################################################
#  
#  Copyright (c)2000 Fourthought, Inc.
#  http://ftsuite.com/4ODS
#
############################################################################
#
# File Name: 		4odb grant.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Tools/4odb_grant.py.html
#


#A Tool for granting access to the database for different users

import sys
import string
from Ft.Ods.StorageManager import Adapters
from Ft.Ods.StorageManager.Adapters.Manager import UserAccessLevel


__doc__ = '''Change user access in a 4ODS database  Allowed access levels are METADETA, modify and delete metadata, OBJECT add, modify and delete objects, ALL add, modify and delete metadata and objects'''


def Run(options,args):

    level = getattr(UserAccessLevel, string.upper(args['level']), None)
    if level is None:
        print 'Invalid access level:', args['level']
        sys.exit(1)

    dbName = args['dbName']
    mang = Adapters.GetManager(options.get('adapter')) 
    adapter = Adapters.GetAdapter(options.get('adapter')) 
        
    users = args['userName']
    if type(users) != type([]):
        users = [users]
    for user in users:
        mang.grant(dbName, user, level)
        print "%s access to %s added fopr user %s" % (args['level'],dbName,user)



def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('grant',
                          'Grant access to a 4ODS database',
                          ' test ALL molson uche',                          
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('dbName',
                                                                  'The name of the database.',
                                                                  str),
                                       Arguments.RequiredArgument('level',
                                                                  'The level of access, allowed values are METADATA, OBJECT, and ALL.',
                                                                  str),
                                       Arguments.RequiredArgument('userName',
                                                                  'The name of user to set the access as.',
                                                                  str),
                                       ],
                                                               
                          )
    return cmd


