#!/usr/bin/env python
############################################################################
#  
#  Copyright (c)2000 Fourthought, Inc.
#  http://ftsuite.com/4ODS
#
############################################################################
#
# File Name: 		4odb_clean.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/Tools/4odb_clean.py.html
#


#A Tool for removing all unaccessible objects from the database (Garbage Collections)

import sys

__doc__ = 'Remove all objects from the database that are not accessible from either an extent or a bound name'

def Run(options,args):
    from Ft.Ods.StorageManager import Adapters

    dbName = args['dbName']
    mang = Adapters.GetManager(options.get('adapter')) 
    adapter = Adapters.GetAdapter(options.get('adapter')) 
    mang.clean(dbName)
    
def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('clean',
                          'Clean a 4ODS database',
                          ' test',                          
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('dbName',
                                                                  'The name of the database.',
                                                                  str),
                                       ],
                                                               
                          )
    return cmd

