


class OracleStatement:
    def queryNoArgs(self,db):
        db[1].execute(self.command)
        return db[1].fetchall()

    def query(self,db,**args):
        db[1].execute(self.command%args)
        return db[1].fetchall()

    def execute(self,db,**args):
        db[1].execute(self.command%args)
    

    def pprint(self,**args):
        print self.command%args



class NewRepoIdStatement(OracleStatement):
    command = "SELECT ftods_repoid.NEXTVAL from DUAL"
    query = OracleStatement.queryNoArgs
    
class NewRepoStatement(OracleStatement):
    command = "INSERT INTO %(tableName)s (repoid) VALUES(%(rid)d)"

class NewRepoMapStatement(OracleStatement):
    command = "INSERT INTO ftods_repomap (repoid,meta_kind,pythonclassid) VALUES(%(rid)d,%(metaKind)d, %(pythonclassid)d)"

class GetRepoStatement(OracleStatement):
    command = "SELECT meta_kind,pythonclassid FROM ftods_repomap WHERE repoid = %(rid)d"

class GetRepoTupleStatement(OracleStatement):
    command = "SELECT * from %(tableName)s where repoid = %(rid)d"

class DeleteRepoStatement(OracleStatement):
    command ="DELETE from %(tableName)s where repoid = %(rid)d"

class DeleteRepoMapStatement(OracleStatement):
    command = "DELETE FROM ftods_repomap where repoid = %(rid)d"
    

class UpdateRepoTimeStatement(OracleStatement):
    command = "UPDATE ftods_repomap set lastUpdate = %(newTime)lf where repoid = %(rid)d"

class CheckRepoTimeStatement(OracleStatement):
    command = "SELECT repoid FROM ftods_repomap where repoid = %(id)d and lastUpdate <= %(testTime)lf"



class NewExtentIdStatement(OracleStatement):
    command = "SELECT ftods_extentid.NEXTVAL from DUAL"
    query = OracleStatement.queryNoArgs

class NewExtentStatement(OracleStatement):
    command = "INSERT into ftods_extents (name,extentid,persistenttype) VALUES ('%(name)s',%(extentId)d,%(persistentType)d)"

class GetExtentIdStatement(OracleStatement):
    command = "SELECT extentid from ftods_extents where name = '%(name)s'"


class AddExtentMappingStatement(OracleStatement):
    command = 'INSERT into ftods_extentmapping (extentid,id) VALUES (%(extentId)d,%(id)d)'

class DropExtentMappingStatement(OracleStatement):
    command = 'DELETE FROM ftods_extentmapping WHERE extentid = %(extentId)d and id = %(id)d'


class DropAllExtentMappingStatement(OracleStatement):
    command = 'DELETE FROM ftods_extentmapping WHERE extentid = %(extentId)d'

class DropExtentStatement(OracleStatement):
    command = "DELETE FROM ftods_extents WHERE extentId = %(extentId)d"

class GetExtentNamesStatement(OracleStatement):
    command = "SELECT DISTINCT name from ftods_extents"
    query = OracleStatement.queryNoArgs


class GetExtentIdAndTypeStatement(OracleStatement):
    command = "SELECT extentid,persistentType from ftods_extents where name = '%(name)s'"

class GetExtentStatement(OracleStatement):
    command = "SELECT id from ftods_extentmapping where extentId = %(extentId)s"

class GetBoundObjectStatement(OracleStatement):
    command = "SELECT objid from ftods_binding where name = '%(name)s'"

class AddBoundNameStatement(OracleStatement):
    command = "INSERT INTO ftods_binding (name,objid) VALUES ('%(name)s',%(oid)d)"

class DropBoundNameStatement(OracleStatement):
    command = "DELETE FROM ftods_binding where name = '%(name)s'"

class GetBoundNamesStatement(OracleStatement):
    command = "SELECT name from ftods_binding"
    query = OracleStatement.queryNoArgs

class GetObjectBoundNamesStatement(OracleStatement):
    command = "SELECT name from ftods_binding  where objid = %(oid)d"


class NewPythonClassIdStatement(OracleStatement):
    command = "SELECT ftods_pythonclassid.NEXTVAL from DUAL"

class NewPythonClassStatement(OracleStatement):
    command = "INSERT into ftods_pythonclass (pythonclassid,pythonclassname,pythonmodulename) VALUES(%(pid)d,'%(className)s', '%(moduleName)s')"

class GetPythonClassStatement(OracleStatement):
    command = 'SELECT pythonmodulename, pythonclassname from ftods_pythonclass where pythonclassid = %(pid)i'

class GetPythonClassIdStatement(OracleStatement):
    command = "SELECT pythonclassid from ftods_pythonclass WHERE pythonmodulename = '%(moduleName)s' and pythonclassname  = '%(className)s'"

class DeletePythonClassStatement(OracleStatement):
    command = 'DELETE FROM ftods_pythonclass where pythonclassid = %(pid)d'


class NewCollectionIdStatement(OracleStatement):
    command = "SELECT ftods_collectionid.NEXTVAL from DUAL"
    query = OracleStatement.queryNoArgs

class NewCollectionStatement(OracleStatement):
    command = "INSERT INTO ftods_collectionclass (cid,pythonclassid,subtype) VALUES (%(cid)d,%(pythonclassid)d,%(subType)d)"

class UpdateCollectionIndexesAddStatement(OracleStatement):
    command = 'UPDATE %(tableName)s set rindex = rindex + 1 WHERE cid = %(cid)d and rindex >= %(index)d'

class NewCollectionEntryStatement(OracleStatement):
    command = 'INSERT INTO %(tableName)s (cid,rindex,rvalue) VALUES (%(cid)d,%(index)d,%(value)s)'

class DeleteCollectionEntryStatement(OracleStatement):
    command = 'DELETE FROM %(tableName)s WHERE cid = %(cid)d and rindex = %(index)d'

class UpdateCollectionIndexesRemoveStatement(OracleStatement):
    command = 'UPDATE %(tableName)s set rindex = rindex - 1 WHERE cid = %(cid)d and rindex >= %(index)d'

class DeleteCollectionStatement(OracleStatement):
    command = "DELETE from ftods_collectionclass where cid = %(cid)d"

class DeleteCollectionTupleStatement(OracleStatement):
    command = "DELETE from %(tableName)s where cid = %(cid)d"

class GetCollectionStatement(OracleStatement):
    command = "SELECT subtype,pythonclassid from ftods_collectionclass where cid = %(cid)d"

class GetCollectionTupleStatement(OracleStatement):
    command = "SELECT rvalue from %(tableName)s where cid = %(cid)d ORDER BY rindex"

class UpdateCollectionTimeStatement(OracleStatement):
    command = "UPDATE ftods_collectionclass set lastUpdate = %(newTime)lf where cid = %(cid)d"

class CheckCollectionTimeStatement(OracleStatement):
    command = "SELECT cid FROM ftods_collectionclass where cid = %(id)d and lastUpdate <= %(testTime)lf"

class NewObjectIdStatement(OracleStatement):
    command = "SELECT ftods_objid.NEXTVAL from DUAL"

class NewObjectMapStatement(OracleStatement):
    command = "INSERT INTO ftods_actualclass (oid,pythonclassid) VALUES(%(oid)d, %(pythonclassid)d)"

class NewObjectStatement(OracleStatement):
    command = "INSERT INTO %(tableName)s (oid) VALUES(%(oid)d)"

class UpdateObjectTimeStatement(OracleStatement):
    command = "UPDATE ftods_actualclass set lastUpdate = %(newTime)lf where oid = %(oid)d"

class GetObjectStatement(OracleStatement):
    command = "SELECT pythonclassid FROM ftods_actualclass WHERE oid = %(oid)d"

class GetObjectTupleStatement(OracleStatement):
    command = "SELECT * from %(tableName)s where oid = %(oid)d"

class GetObjectIdsStatement(OracleStatement):
    command = "SELECT oid FROM ftods_actualclass"
    
class CheckObjectTimeStatement(OracleStatement):
    command = "SELECT oid FROM ftods_actualclass where oid = %(id)d and lastUpdate <= %(testTime)lf"

class DeleteObjectStatement(OracleStatement):
    command ="DELETE from %(tableName)s where oid = %(oid)d"

class DeleteObjectMapStatement(OracleStatement):
    command = "DELETE FROM ftods_actualclass where oid = %(oid)i"
