########################################################################
#
# File Name: 		Interval.py
#
# Documentation:	http://docs.ftsuite.com/4ODS/DateFactory.py.html
#
"""
Implements the Interval interface.
WWW: http://4suite.org/4ODS         e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""
#"

SECS_IN_DAY = 3600*24
SECS_IN_HOUR = 3600

class Interval:

    def __init__(self,db,_time):

        if _time is None:
            _time = 0
        elif type(_time) == type(()):
            _time = _time[0]

        #Value is a float of seconds
        self.value = _time

        self._day = 0
        self._hour = 0
        self._minute = 0

        v = self.value
        while v > SECS_IN_DAY:
            self._day = self._day + 1
            v = v - SECS_IN_DAY
        while v > SECS_IN_HOUR:
            self._hour = self._hour + 1
            v = v - SECS_IN_HOUR

        while v > 60:
            self._minute = self._minute + 1
            v = v - 60

        self._second = int(v)



    def day(self):
        return self._day

    def hour(self):
        return self._hour

    def minute(self):
        return self._minute

    def second(self):
        return self._second

    def millisecond(self):
        return int((self.value * 1000.0) % 1000)

    def is_zero(self):
        return self.value == 0

    def plus(self,an_interval):
        return Interval(None,self.value + an_interval.value)

    def minus(self,an_interval):
        return Interval(None,self.value - an_interval.value)

    def product(self,val):
        return Interval(None,self.value * val)

    def quotient(self,val):
        return Interval(None,self.value / val)

    def is_equal(self,an_interval):
        return self.value == an_interval.value

    def is_greater(self,an_interval):
        return self.value > an_interval.value

    def is_greater_or_equal(self,an_interval):
        return self.value >= an_interval.value

    def is_less(self,an_interval):
        return self.value < an_interval.value

    def is_less_or_equal(self,an_interval):
        return self.value <= an_interval.value

    
    

    def __str__(self):
        return "<Interval at %x %s:%s:%s.%s>"% (id(self),self.day(),self.hour(),self.second(),self.millisecond())


    def _4ods_getData(self):
        return (self.value,)

    def __cmp__(self,other):
        if isinstance(other,Interval):
            return cmp(self.value,other.value)
        return 1

    def _4ods_isModified(self):
        return 1
