(**************************************************************************)
(*  Copyright (c) 2003 Mikhail Fedotov <mikhail@kittown.com>              *)
(*                                                                        *)
(*  Permission is hereby granted, free of charge, to any person           *)
(*  obtaining a copy of this software and associated documentation files  *)
(*  (the "Software"), to deal in the Software without restriction,        *)
(*  including without limitation the rights to use, copy, modify, merge,  *)
(*  publish, distribute, sublicense, and/or sell copies of the Software,  *)
(*  and to permit persons to whom the Software is furnished to do so,     *)
(*  subject to the following conditions:                                  *)
(*                                                                        *)
(*  The above copyright notice and this permission notice shall be        *)
(*  included in all copies or substantial portions of the Software.       *)
(*                                                                        *)
(*  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,       *)
(*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES       *)
(*  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND              *)
(*  NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS   *)
(*  BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN    *)
(*  ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN     *)
(*  CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE      *)
(*  SOFTWARE.                                                             *)
(**************************************************************************)

exception Sqlite_error of string
exception Sqlite_done
exception Sqlite_busy
exception Sqlite_null_value

let _ = Callback.register_exception "sqlite error"      (Sqlite_error  "Registering Callback")
let _ = Callback.register_exception "sqlite done"       (Sqlite_done)
let _ = Callback.register_exception "sqlite busy"       (Sqlite_busy)
let _ = Callback.register_exception "sqlite null value" (Sqlite_null_value)

type db
type vm

type rc =
   RC_ok
 | RC_error
 | RC_internal
 | RC_perm
 | RC_abort
 | RC_busy
 | RC_locked
 | RC_nomem
 | RC_readonly
 | RC_interrupt
 | RC_ioerr
 | RC_corrupt
 | RC_notfound
 | RC_full
 | RC_cantopen
 | RC_protocol
 | RC_empty
 | RC_schema
 | RC_toobig
 | RC_constraint
 | RC_mismatch
 | RC_misuse
 | RC_nofls
 | RC_auth
 | RC_format

external db_open  : string -> db = "caml_sqlite_open"
external db_close : db -> unit = "caml_sqlite_close"

external exec  : db -> string -> unit = "caml_sqlite_exec"

external compile        : db -> string -> int -> bool -> (vm * int * bool) = "caml_sqlite_compile"
external compile_simple : db -> string -> vm                               = "caml_sqlite_compile_simple"
external step           : vm -> string -> string array                     = "caml_sqlite_step"
external step_simple    : vm -> string array                               = "caml_sqlite_step_simple"
external step_opt       : vm -> string option array                        = "caml_sqlite_step_opt"
external finalize       : vm -> unit                                       = "caml_sqlite_vm_finalize"

external last_insert_rowid : db -> int = "caml_sqlite_last_insert_rowid"

external db_rc : db -> rc = "caml_sqlite_db_retcode"
external vm_rc : vm -> rc = "caml_sqlite_vm_retcode"

external column_names : vm -> string array = "caml_sqlite_column_names"
external column_types : vm -> string array = "caml_sqlite_column_types"
