# -*- ruby -*-
#
# Using an embedded script and a plugin object.
#

require 'xtemplate'

data = {
  'members' => [
    {"name" => "name1", "age" => 20},
    {"name" => "name2", "age" => 23},
    {"name" => "name3", "age" => 30},
  ],
}

text = <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<members>
  <member id="/members{foo(name)}" />
</members>
EOF

class MyPlugin < XTemplate::XPath::Action
  def foo(ary, x)
    ary.collect{|val| val[x].chop.concat("&") }
  end
end

t = XTemplate::XMLTemplate.new(text)
print(t.expand(data, :plugin => MyPlugin.new))
