# Web::Persistent::Store::DBM
# Copyright(c) 2002 MoonWolf <moonwolf@moonwolf.com>
require 'dbm'

module Web
  class Persistent
    module Store
      class DBM
        
        def initialize(persistent_id, options={})
          @dir = options[:dir] || '/tmp'
          @path = ::File.join(@dir, persistent_id)
          @dbm = nil
        end
        
        def key_limit
          64
        end
        
        def data_limit
          960 # 1024 - 64(key)
        end
        
        def open
          @dbm = ::DBM.open(@path)
        end

        def close
          @dbm.close
          @dbm = nil
        end
        
        def [](key)
          @dbm[key]
        end

        def []=(key,value)
          @dbm[key] = value
        end
        
        def has_key?(key)
          @dbm.has_key?(key)
        end

        def delete(key)
          @dbm.delete(key)
        end

        def keys
          @dbm.keys
        end
        
      end # DBM
    end # Store
  end # Persistent
end # Web
