/* 
 * $Id: ctkprogress.h,v 1.4 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */


#ifndef __CTKPROGRESS_H__
# define __CTKPROGRESS_H__ 

typedef struct CtkProgress_S {
	CtkWidget widget;

	gfloat value;
	gfloat min;
	gfloat max;
	
	gboolean show_text;
} CtkProgress;

void ctk_progress_init(CtkProgress *progress);
void ctk_progress_configure(CtkProgress *progress,
			    gfloat value,
			    gfloat min,
			    gfloat max);
void ctk_progress_set_show_text(CtkProgress *progress, gint show_text);
gfloat ctk_progress_get_value(CtkProgress *progress);
void ctk_progress_set_value(CtkProgress *progress, gfloat value);
void ctk_progress_set_percentage(CtkProgress *progress, gfloat percentage);

#define CTK_PROGRESS(obj)	CTK_CHECK_CAST((obj),CtkProgress,CtkTypeProgress)

#endif
