/* 
 * $Id: ctkdraw.h,v 1.11 2000/08/11 05:23:44 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#ifndef __CTKDRAW_H__
#define __CTKDRAW_H__

/* Debugging routine */
void ctk_noise(const gchar* sound);
void ctk_beep();

void ctk_redraw_screen(CtkRedraw);

void ctk_draw_combo_erase      (CtkWidget* widget);
void ctk_draw_option_menu_erase(CtkWidget* widget);

void ctk_draw_mark_changed(CtkWidget* widget);
gboolean ctk_check_clipping_xy(CtkWidget* widget, gint x, gint y);
void ctk_widget_intersect(CtkWidget* parent, CtkWidget* widget);
void ctk_draw_char(CtkWidget* widget, gint x, gint y, gchar ch);
void ctk_draw_vline(CtkWidget* widget, gint x, gint y1, gint y2);
void ctk_draw_hline(CtkWidget* widget, gint y, gint x1, gint x2);
void ctk_draw_frame(CtkWidget* widget, gint x1, gint y1, gint x2, gint y2);

gint ctk_helper_max(gint a, gint b);
gint ctk_helper_min(gint a, gint b);

void ctk_inverse_char(gint x, gint y);

#endif
