/*
   CoreLinux++ 
   Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__COLLEAGUE_HPP)
#include <Colleague.hpp>
#endif

#if   !defined(__MEDIATOR_HPP)
#include <Mediator.hpp>
#endif

namespace corelinux
{
   // Default blowout

   Colleague::Colleague( void ) throw ( Assertion )
      :
      theMediator( NULLPTR )
   {
      NEVER_GET_HERE;
   }

   // Valid initializing constructor

   Colleague::Colleague( MediatorPtr aMediator )
      throw ( NullPointerException )
      :
      theMediator( aMediator )
   {
      if( theMediator == NULLPTR )
      {
         throw NullPointerException( LOCATION );
      }
      else
      {
         ;  // do nothing
      }
   }

   // Copy constructor

   Colleague::Colleague( ColleagueCref aColleague )
      :
      theMediator( aColleague.theMediator )
   {
      ;  // do nothing
   }

   // Destructor

   Colleague::~Colleague( void )
   {
      theMediator = NULLPTR;
   }

   // Assignment operator

   ColleagueRef Colleague::operator=( ColleagueCref aColleague )
   {
      if( *this == aColleague )
      {
         ;  // do nothing
      }
      else
      {
         theMediator = aColleague.theMediator;
      }
      return ( *this );
   }

   // Equality operator

   bool Colleague::operator ==( ColleagueCref aColleague ) const
   {
      return ( this == &aColleague );
   }

   // Calls mediator with event

   void Colleague::invokeMediator( Event<Identifier> *anEvent ) 
      throw ( NullPointerException )
   {
      if( anEvent == NULLPTR )
      {
         throw NullPointerException(LOCATION);
      }
      else
      {
         ;  // do nothing
      }
      theMediator->action(anEvent);
   }
}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/07 03:45:59 $
   $Locker:  $
*/

