//LabPlot : MainWin.cc

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <iostream>

#include <qprinter.h>
#include <qfiledialog.h>
#include <qtextstream.h>
#include <qinputdialog.h>
#include <qimage.h>
#include <qcursor.h>
#include <qmessagebox.h>

#include <kpopupmenu.h>
#include <klocale.h>
#include <kstdaction.h>
#include <kmessagebox.h>
#include <khelpmenu.h>
#include <ktoolbar.h>
#include <ktoolbarbutton.h>
#include <kstatusbar.h>
#include <klibloader.h>
#include <ktrader.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kedittoolbar.h>
#include <kconfig.h>
#include <ktempfile.h>
#include <kdebug.h>
#include <kimageio.h>
#include <kfilterdev.h>
#include <kfilterbase.h>
#include <kmimetype.h>
#include <kshortcut.h>

#include "MainWin.h"
#include "GraphListDialog.h"
#include "TitleDialog.h"
#include "AxesDialog.h"
#include "FunctionDialog.h"
#include "LegendDialog.h"
#include "ObjectDialog.h"
#include "PlotSettingsDialog.h"
#include "ImportDialog.h"
#include "DataDialog.h"
#include "WorksheetDialog.h"
#include "OperationsListDialog.h"
#include "SmoothListDialog.h"
#include "AverageListDialog.h"
#include "HistListDialog.h"
#include "InterpolationListDialog.h"
#include "DifferencesListDialog.h"
#include "IntegrationListDialog.h"
#include "RegressionListDialog.h"
#include "FFTListDialog.h"
#include "ConvolutionListDialog.h"
#include "FitListDialog.h"
#include "ImageListDialog.h"

#include "PruneListDialog.h"
#include "ConfigureDialog.h"
#include "PstoEditDialog.h"
#include "ImageMagickDialog.h"
#include "ProjectDialog.h"
#include "ExplorerDialog.h"
#include "ArrangePlotDialog.h"
#include "OverlayPlotDialog.h"
#include "GRASSDialog.h"
#include "VTKDialog.h"
#include "LabPlotDialog.h"

#ifdef HAVE_GL
#include "qwt3d_io.h"
#endif
#include "ModuleFactory.h"
#include "pixmaps/pixmap.h"

using namespace std;

/*! This is the main window which controls all the dialogs and  */
MainWin::MainWin(const char *name, const char *filen)
	: KParts::MainWindow(0,name)
{
	setCaption("LabPlot "LVERSION);

	QString fn(filen);
	if(fn.contains(".lpl"))
		filename = fn;
	
	// register KImageIO formats for QImage and QPixmap
	KImageIO::registerFormats();
	
	config = KGlobal::config();
	applyMainWindowSettings(config,"LabPlotMainWindow");

	QObject::disconnect(this,0,0,0);
	this->setMouseTracking(FALSE);

	setAcceptDrops(TRUE);

	QPixmap saveAsIcon = QPixmap(saveAs_xpm);
	QPixmap projectIcon = QPixmap(project_xpm);
	QPixmap explorerIcon = QPixmap(explorer_xpm);
	QPixmap importIcon = QPixmap(import_xpm);
	QPixmap exportIcon = QPixmap(export_xpm);
	QPixmap exportPsIcon = QPixmap(exportps_xpm);
	QPixmap exportIMIcon = QPixmap(exportim_xpm);
	QPixmap printpreviewIcon = KGlobal::iconLoader()->loadIcon("filequickprint", KIcon::Toolbar);
	QPixmap spreadsheetIcon = QPixmap(spreadsheet_xpm);
	QPixmap worksheetIcon = QPixmap(worksheet_xpm);
	QPixmap plot2dIcon = QPixmap(plot2d_xpm);
	QPixmap plot3dIcon = QPixmap(plot3d_xpm);
	QPixmap plotQWT3DIcon = QPixmap(plotQWT3D_xpm);
	QPixmap plotGLIcon = QPixmap(plotGL_xpm);
	QPixmap plotsurfaceIcon = QPixmap(plotsurface_xpm);
	QPixmap plotpieIcon = QPixmap(plotpie_xpm);
	QPixmap plotpolarIcon = QPixmap(plotpolar_xpm);
	QPixmap plotternaryIcon = QPixmap(plotternary_xpm);
	QPixmap deletePlotIcon = QPixmap(deletePlot_xpm);
	QPixmap clearIcon = QPixmap(clear_xpm);
	QPixmap graphsIcon = QPixmap(graphs_xpm);
	QPixmap grassIcon = QPixmap(grass_xpm);
	QPixmap vtkIcon = QPixmap(vtk_xpm);

	QPixmap newFunctionIcon = QPixmap(newFunction_xpm);
	QPixmap new3DFunctionIcon = QPixmap(new3DFunction_xpm);
	QPixmap newDataIcon = QPixmap(newData_xpm);
	QPixmap new3DDataIcon = QPixmap(new3DData_xpm);

	QPixmap operationsIcon = QPixmap(operations_xpm);
	QPixmap smoothIcon = QPixmap(smooth_xpm);
	QPixmap averageIcon = QPixmap(average_xpm);
	QPixmap pruneIcon = QPixmap(prune_xpm);
	QPixmap histIcon = QPixmap(histogram_xpm);
	QPixmap interpolationIcon = QPixmap(interpolation_xpm);
	QPixmap differencesIcon = QPixmap(differences_xpm);
	QPixmap integrationIcon = QPixmap(integration_xpm);
	QPixmap regressionIcon = QPixmap(regression_xpm);
	QPixmap fftIcon = QPixmap(fft_xpm);
	QPixmap convolutionIcon = QPixmap(convolution_xpm);
	QPixmap fitIcon = QPixmap(fit_xpm);
	QPixmap imageproIcon = QPixmap(imagepro_xpm);

	QPixmap graphIcon = QPixmap(graph_xpm);
	QPixmap arrangeIcon = QPixmap(arrange_xpm);
	QPixmap overlayIcon = QPixmap(overlay_xpm);
	QPixmap axesIcon = QPixmap(axes_xpm);
	QPixmap titleIcon = QPixmap(title_xpm);
	QPixmap legendIcon = QPixmap(legend_xpm);
	QPixmap objectIcon = QPixmap(object_xpm);

	QPixmap autoScaleXIcon = QPixmap(autoscalex_xpm);
	QPixmap autoScaleYIcon = QPixmap(autoscaley_xpm);
	QPixmap autoScaleZIcon = QPixmap(autoscalez_xpm);
	QPixmap autoScaleAllIcon = QPixmap(autoscaleall_xpm);
	QPixmap magLensIcon = QPixmap(mag_glass_xpm);
	QPixmap panZoomIcon = QPixmap(mousepan_xpm);
	QPixmap leftIcon = QPixmap(left_xpm);
	QPixmap rightIcon = QPixmap(right_xpm);
	QPixmap upIcon = QPixmap(up_xpm);
	QPixmap downIcon = QPixmap(down_xpm);
	QPixmap helpIcon = QPixmap(help_xpm);
	QPixmap examplesIcon = QPixmap(examples_xpm);

	QPixmap fullscreenIcon = QPixmap(fullscreen_xpm);
	
	QPixmap scriptIcon = QPixmap(script_xpm);
	QPixmap qsaIcon = QPixmap(qsa_xpm);
	
	QPixmap scaleXUpIcon = QPixmap(scalexup_xpm);
	QPixmap scaleXDownIcon = QPixmap(scalexdown_xpm);
	QPixmap scaleYUpIcon = QPixmap(scaleyup_xpm);
	QPixmap scaleYDownIcon = QPixmap(scaleydown_xpm);
	QPixmap scaleZUpIcon = QPixmap(scalezup_xpm);
	QPixmap scaleZDownIcon = QPixmap(scalezdown_xpm);

	QPixmap regionIcon = QPixmap(region_xpm);
	QPixmap baselineIcon = QPixmap(baseline_xpm);
	QPixmap lineIcon = QPixmap(line_xpm);
	QPixmap labelIcon = QPixmap(label_xpm);
	QPixmap rectIcon = QPixmap(rect_xpm);
	QPixmap ellipseIcon = QPixmap(ellipse_xpm);
	QPixmap imageIcon = QPixmap(image_xpm);

	// Action !
	KAction *tmp=0;	// for WhatsThis help

	KStdAction::open(this, SLOT(open()),actionCollection());
	KStdAction::openNew(this, SLOT(New()),actionCollection());
	recent = KStdAction::openRecent(this, SLOT(open(const KURL&)), actionCollection(), "openRecent");
	recent->loadEntries(config);
	save_action = KStdAction::save(this, SLOT(save()),actionCollection());
	save_as = new KAction (i18n("S&ave As"), QIconSet(saveAsIcon),KShortcut(CTRL+Key_A), this,
		SLOT (saveAs()), actionCollection(),"saveAs");
	project_action = new KAction (i18n("Project &Infos"), QIconSet(projectIcon),
			KShortcut(ALT+Key_V), this, SLOT (projectInfo()), actionCollection(),"project");
	explorer_action = new KAction (i18n("Pro&ject Explorer"), QIconSet(explorerIcon),
			KShortcut(CTRL+Key_Less), this, SLOT (projectExplorer()), actionCollection(),"explorer");

	import_action = new KAction (i18n("&Import ..."), QIconSet(importIcon),KShortcut(CTRL+SHIFT+Key_J), this,
		SLOT (importDialog()), actionCollection(),"import");

	export_image = new KAction (i18n("&Export to Image ..."), QIconSet(exportIcon),KShortcut(CTRL+Key_R), this,
		SLOT (exportPlot()), actionCollection(),"export");
	export_ps = new KAction (i18n("Postscript (PS)"), QIconSet(exportIcon),0, this,
		SLOT (exportPS()), actionCollection(),"export_ps");
	export_eps = new KAction (i18n("Encapsulated Postscript (EPS)"), QIconSet(exportIcon),0, this,
		SLOT (exportEPS()), actionCollection(),"export_eps");
	export_pdf = new KAction (i18n("Portable Document Format (PDF)"), QIconSet(exportIcon),0, this,
		SLOT (exportPDF()), actionCollection(),"export_pdf");
	// TODO : upper case
	export_svg = new KAction (i18n("scalable vector graphics (svg)"), QIconSet(exportIcon),0, this,
		SLOT (exportSVG()), actionCollection(),"export_svg");
	export_pic = new KAction (i18n("native QPicture format (pic)"), QIconSet(exportIcon),0, this,
		SLOT (exportPIC()), actionCollection(),"export_pic");

	export_pstoedit = new KAction (i18n("E&xport via pstoedit ..."), QIconSet(exportPsIcon),KShortcut(ALT+Key_E), this,
		SLOT (exportPstoEditDialog()), actionCollection(),"export_pstoedit");
	export_ImageMagick = new KAction (i18n("Export via Image&Magick ..."), QIconSet(exportIMIcon),
		KShortcut(CTRL+SHIFT+Key_I), this,SLOT (exportImageMagickDialog()), actionCollection(),"export_ImageMagick");

	print_action = KStdAction::print(this, SLOT(print()),actionCollection(),"print");
	printpreview = new KToggleAction(i18n("Pri&nt Preview"), QIconSet(printpreviewIcon),KShortcut(ALT+Key_P),
		this, SLOT(printPreview()),actionCollection(),"print_preview");
	printpreviewchecked=FALSE;
	KStdAction::quit(this, SLOT(close()),actionCollection());

	tmp = new KAction (i18n("&New 2D Plot"), QIconSet(plot2dIcon),
			KShortcut(CTRL+SHIFT+Key_N), this, SLOT (new2DPlot()), actionCollection(),"new2DPlot");
	tmp->setWhatsThis(i18n("This adds an empty 2 dimensional plot"));
	tmp = new KAction (i18n("New &Surface Plot"), QIconSet(plotsurfaceIcon),
			KShortcut(ALT+Key_Z), this, SLOT (newSurfacePlot()), actionCollection(),"newSurfacePlot");
	tmp->setWhatsThis(i18n("This adds an empty surface plot"));
	tmp = new KAction (i18n("N&ew 3D Plot"), QIconSet(plot3dIcon),
			KShortcut(CTRL+Key_0), this, SLOT (new3DPlot()), actionCollection(),"new3DPlot");
	qwt3d_plot = new KAction (i18n("New &QWT 3D Plot"), QIconSet(plotQWT3DIcon),
			KShortcut(CTRL+SHIFT+Key_Q), this, SLOT (newQWT3DPlot()), actionCollection(),"newQWT3DPlot");
	qwt3d_plot->setWhatsThis(i18n("This adds an empty 3 dimensional qwt plot"));
	tmp = new KAction (i18n("New &GL Plot"), QIconSet(plotGLIcon),
			KShortcut(CTRL+SHIFT+Key_L), this, SLOT (newGLPlot()), actionCollection(),"newGLPlot");
	tmp->setWhatsThis(i18n("This adds an empty 3 dimensional plot"));
	tmp = new KAction (i18n("Ne&w Pie Plot"), QIconSet(plotpieIcon),
			KShortcut(ALT+Key_Period), this, SLOT (newPiePlot()), actionCollection(),"newPiePlot");
	tmp->setWhatsThis(i18n("This adds an empty pie plot"));
	tmp = new KAction (i18n("New Polar Plot"), QIconSet(plotpolarIcon),
			KShortcut(CTRL+SHIFT+Key_O), this, SLOT (newPolarPlot()), actionCollection(),"newPolarPlot");
	tmp->setWhatsThis(i18n("This adds an empty polar plot"));
	tmp = new KAction (i18n("New Ternary Plot"), QIconSet(plotternaryIcon),
			KShortcut(CTRL+SHIFT+Key_T), this, SLOT (newTernaryPlot()), actionCollection(),"newTernaryPlot");
	tmp->setWhatsThis(i18n("This adds an empty ternary plot"));
	newgrassplot = new KAction (i18n("New &GRASS Plot"), QIconSet(grassIcon),
			KShortcut(CTRL+Key_NumberSign), this, SLOT (newGRASSPlot()), actionCollection(),"newGRASSPlot");
	newgrassplot->setWhatsThis(i18n("This adds an empty GRASS plot"));
	newvtkplot = new KAction (i18n("New &VTK Plot"), QIconSet(vtkIcon),
			KShortcut(CTRL+Key_Plus), this, SLOT (newVTKPlot()), actionCollection(),"newVTKPlot");
	newvtkplot->setWhatsThis(i18n("This adds an empty VTK plot"));
	deleteplot = new KAction (i18n("&Delete Active Plot"), QIconSet(deletePlotIcon),
			KShortcut(ALT+Key_Q), this, SLOT (deletePlot()), actionCollection(),"deletePlot");
	tmp = new KAction (i18n("New S&preadsheet"), QIconSet(spreadsheetIcon),
			KShortcut(CTRL+SHIFT+Key_S), this, SLOT (newSpreadsheet()), actionCollection(),"newSpreadsheet");
	tmp->setWhatsThis(i18n("This opens a new spreadsheet"));
	tmp = new KAction (i18n("New W&orksheet"), QIconSet(worksheetIcon),
			KShortcut(ALT+Key_X), this, SLOT (newWorksheet()), actionCollection(),"newWorksheet");
	tmp->setWhatsThis(i18n("This opens a new empty 2 dimensional worksheet"));
	deleteplot->setWhatsThis(i18n("This deletes the active plot"));
	clear_action = new KAction (i18n("Clea&r"), QIconSet(clearIcon),
			KShortcut(CTRL+Key_C), this, SLOT (clear()), actionCollection(),"clear");
	clear_action->setWhatsThis(i18n("This clears the active worksheet"));
	close_action = KStdAction::close(this, SLOT(closeWin()),actionCollection(),"my_close");
	close_action->setWhatsThis(i18n("This closes the active worksheet or the print preview"));

	graph_list = new KAction (i18n("&Graph List"), QIconSet(graphsIcon),
			KShortcut(CTRL+Key_G), this, SLOT (graphDialog()), actionCollection(),"graphs");
	graph_list->setWhatsThis(i18n("This opens a list of all graphs in the active worksheet"));
	tmp = new KAction (i18n("2D &Function"), QIconSet(newFunctionIcon),
			KShortcut(CTRL+Key_E), this, SLOT (new2DFunction()), actionCollection(),"newFunction");
	tmp->setWhatsThis(i18n("This lets you insert a new 2 dimensional function in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("2D &Surface Function"), QIconSet(plotsurfaceIcon),
			KShortcut(CTRL+Key_U), this, SLOT (newSFunction()), actionCollection(),"newSFunction");
	tmp->setWhatsThis(i18n("This lets you insert a new surface function in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("2D Polar Function"), QIconSet(plotpolarIcon),
			KShortcut(ALT+Key_Less), this, SLOT (newPolarFunction()), actionCollection(),"newPolarFunction");
	tmp->setWhatsThis(i18n("This lets you insert a new polar function in the active worksheet or in a new worksheet"));
	qwt3d_func = new KAction (i18n("3D QWT Function"), QIconSet(plotQWT3DIcon),
			KShortcut(CTRL+SHIFT+Key_Z), this, SLOT (newQWT3DFunction()), actionCollection(),"newQWT3DFunction");
	qwt3d_func->setWhatsThis(i18n("This lets you insert a new 3d qwt function in the active worksheet or in a new worksheet"));

	tmp = new KAction (i18n("2D &Data"), QIconSet(newDataIcon),
			KShortcut(CTRL+Key_D), this, SLOT (new2DData()),actionCollection(),"newData" );
	tmp->setWhatsThis(i18n("This lets you insert new 2 dimensional data in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("2D S&urface Data"), QIconSet(plotsurfaceIcon),
			KShortcut(ALT+Key_Minus), this, SLOT (newSData()), actionCollection(),"newSData");
	tmp->setWhatsThis(i18n("This lets you insert a new surface graph from data in the active plot"));
	tmp = new KAction (i18n("&Pie Data"), QIconSet(plotpieIcon),
			KShortcut(ALT+Key_Comma), this, SLOT (newPieData()),actionCollection(),"newPieData" );
	tmp->setWhatsThis(i18n("This lets you insert a new pie graph from data in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("Polar Data"), QIconSet(plotpolarIcon),
			KShortcut(CTRL+Key_Comma), this, SLOT (newPolarData()),actionCollection(),"newPolarData" );
	tmp->setWhatsThis(i18n("This lets you insert a new polar graph from data in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("Ternary Data"), QIconSet(plotternaryIcon),
			KShortcut(CTRL+SHIFT+Key_Y), this, SLOT (newTernaryData()),actionCollection(),"newTernaryData" );
	tmp->setWhatsThis(i18n("This lets you insert a new ternary graph from data in the active worksheet or in a new worksheet"));

	tmp = new KAction (i18n("3D F&unction"), QIconSet(new3DFunctionIcon),
			KShortcut(CTRL+Key_F), this, SLOT (new3DFunction()),actionCollection(),"new3DFunction" );
	tmp->setWhatsThis(i18n("This lets you insert a new 3 dimensional function in the active worksheet or in a new worksheet"));
	tmp = new KAction (i18n("3D D&ata"), QIconSet(new3DDataIcon),
			KShortcut(CTRL+Key_I), this, SLOT (new3DData()), actionCollection(),"new3DData");
	tmp->setWhatsThis(i18n("This lets you insert new 3 dimensional data in the active worksheet or in a new worksheet"));
	grassdata = new KAction (i18n("G&RASS Data"), QIconSet(grassIcon),
			KShortcut(ALT+Key_NumberSign), this, SLOT (newGRASSData()),actionCollection(),"newGRASSData");
	grassdata->setWhatsThis(i18n("This lets you insert new GRASS data in the active GRASS plot"));
	vtkdata = new KAction (i18n("&VTK Data"), QIconSet(vtkIcon),
			KShortcut(ALT+Key_Plus), this, SLOT (newVTKData()),actionCollection(),"newVTKData");
	vtkdata->setWhatsThis(i18n("This lets you insert new VTK data in the active VTK plot"));
	qwt3d_data = new KAction (i18n("&QWT 3D Data"), QIconSet(plotQWT3DIcon),
			KShortcut(CTRL+SHIFT+Key_B), this, SLOT (newQWT3DData()),actionCollection(),"newQWT3DData");
	qwt3d_data->setWhatsThis(i18n("This lets you insert new 3 dimensional data in the active QWT plot"));

	operations = new KAction (i18n("&Data set operations"), QIconSet(operationsIcon),
			KShortcut(CTRL+SHIFT+Key_D), this, SLOT (operationsDialog()),actionCollection(),"operations");
	smooth = new KAction (i18n("&Smooth"), QIconSet(smoothIcon),
			KShortcut(ALT+Key_S), this, SLOT (smoothDialog()),actionCollection(),"smooth");
	prune = new KAction (i18n("&Prune"), QIconSet(pruneIcon),
			KShortcut(ALT+Key_R), this, SLOT (pruneDialog()),actionCollection(),"prune");
	average = new KAction (i18n("&Average"), QIconSet(averageIcon),
			KShortcut(ALT+Key_A), this, SLOT (averageDialog()),actionCollection(),"average");
	hist = new KAction (i18n("&Histogram"), QIconSet(histIcon),
			KShortcut(ALT+Key_H), this, SLOT (histDialog()),actionCollection(),"histogram");
	interpolation = new KAction (i18n("In&terpolation"), QIconSet(interpolationIcon),
			KShortcut(ALT+Key_I), this, SLOT (interpolationDialog()),actionCollection(),"interpolation");
	differences = new KAction (i18n("&Differences"), QIconSet(differencesIcon),
			KShortcut(ALT+Key_D), this, SLOT (differencesDialog()),actionCollection(),"differences");
	integration = new KAction (i18n("&Integration"), QIconSet(integrationIcon),
			KShortcut(ALT+Key_N), this, SLOT (integrationDialog()),actionCollection(),"integration");
	regression = new KAction (i18n("&Regression"), QIconSet(regressionIcon),
			KShortcut(ALT+Key_L), this, SLOT (regressionDialog()),actionCollection(),"regression");
	fft = new KAction (i18n("&Fourier Transform"), QIconSet(fftIcon),
			KShortcut(ALT+Key_F), this, SLOT (fftDialog()),actionCollection(),"fft");
	convolution = new KAction (i18n("&Convolution / Deconvolution"), QIconSet(convolutionIcon),
			KShortcut(ALT+Key_C), this, SLOT (convolutionDialog()),actionCollection(),"convolution");
	fit = new KAction (i18n("&Nonlinear Fit"), QIconSet(fitIcon),
			KShortcut(ALT+Key_T), this, SLOT (fitDialog()),actionCollection(),"fit");
	imagepro = new KAction (i18n("Ima&ge Manipulation"), QIconSet(imageproIcon),
			KShortcut(CTRL+SHIFT+Key_G), this, SLOT (imageDialog()),actionCollection(),"imagepro");

	arrange = new KAction (i18n("&Arrange Plots"), QIconSet(arrangeIcon),
			KShortcut(ALT+Key_Y), this, SLOT (arrangeDialog()),actionCollection(),"arrange");
	arrange->setWhatsThis(i18n("This lets you arrange the plots of the active worksheet"));
	overlay = new KAction (i18n("&Overlay Plots"), QIconSet(overlayIcon),
			KShortcut(CTRL+Key_Minus), this, SLOT (overlayDialog()),actionCollection(),"overlay");
	arrange->setWhatsThis(i18n("This lets you arrange the plots of the active worksheet"));
	worksheet_action = new KAction (i18n("&Worksheet Settings"), QIconSet(worksheetIcon),
			KShortcut(ALT+Key_W), this, SLOT (worksheetDialog()),actionCollection(),"worksheet");
	worksheet_action->setWhatsThis(i18n("This lets you change the settings of the active worksheet"));
	plot = new KAction (i18n("&Plot Settings"), QIconSet(graphIcon),
			KShortcut(CTRL+Key_J), this, SLOT (plotSettingsDialog()),actionCollection(),"plot");
	plot->setWhatsThis(i18n("This lets you change the settings of the active plot"));
	axes = new KAction (i18n("&Axes Settings"), QIconSet(axesIcon),
			KShortcut(CTRL+Key_B), this, SLOT (axesDialog()),actionCollection(),"axes");
	title = new KAction (i18n("&Title Settings"), QIconSet(titleIcon),
			KShortcut(CTRL+Key_T), this, SLOT (titleDialog()), actionCollection(),"title");
	legend = new KAction (i18n("&Legend Settings"), QIconSet(legendIcon),
			KShortcut(CTRL+Key_L), this, SLOT (legendDialog()),actionCollection(),"legend");
	objects = new KAction (i18n("&Drawing Objects"), QIconSet(objectIcon),
			KShortcut(ALT+Key_O), this, SLOT (objectDialog()),actionCollection(),"objects");

	tmp = new KAction( i18n( "Full Screen" ), fullscreenIcon, KShortcut(CTRL+SHIFT+Key_F),
	    this, SLOT( toggleFullScreen() ), actionCollection(), "fullscreen" );
	tmp->setToolTip( i18n( "View this document full-screen." ) );
	tmp->setWhatsThis( i18n( "View this document full-screen." ) );

	menubar = KStdAction::showMenubar(this, SLOT(toggleMenuBar()), actionCollection(),"showMenuBar");
	toolbar = KStdAction::showToolbar(this, SLOT(toggleToolBar()), actionCollection(),"showToolBar");
	sidetoolbar = KStdAction::showToolbar(this, SLOT(toggleSideToolBar()), actionCollection(),"showSideToolBar");
	sidetoolbar->setText(i18n("Show S&ide Toolbar"));
	analysistoolbar = KStdAction::showToolbar(this,
		SLOT(toggleAnalysisToolBar()),actionCollection(),"showAnalysisToolBar");
	analysistoolbar->setText(i18n("Show A&nalysis Toolbar"));
	drawingtoolbar = KStdAction::showToolbar(this,
		SLOT(toggleDrawingToolBar()),actionCollection(),"showDrawingToolBar");
	drawingtoolbar->setText(i18n("Show &Drawing Toolbar"));
	statusbar = KStdAction::showStatusbar(this, SLOT(toggleStatusBar()), actionCollection(),"showStatusBar");

	KStdAction::keyBindings(this, SLOT(configureKeys()), actionCollection(),"configureKeys");
	KStdAction::configureToolbars(this, SLOT(configureToolbars()), actionCollection(),"configureToolbars");
	configureAction = KStdAction::preferences(this, SLOT(configure()), actionCollection(),"configure");

	new KAction (i18n("&Save Settings"), QIconSet(legendIcon),
			KShortcut(CTRL+Key_Period), this, SLOT (saveSettings()),actionCollection(),"saveSettings");

	scriptAction = new KAction (i18n("&Load Script ..."), QIconSet(scriptIcon),
			KShortcut(CTRL+SHIFT+Key_C), this, SLOT (loadScript()),actionCollection(),"loadScript");
	ideAction = new KAction (i18n("&Open QSA Workbench ..."), QIconSet(qsaIcon),
			KShortcut(CTRL+SHIFT+Key_W), this, SLOT (openIDE()),actionCollection(),"openIDE");

	KStdAction::aboutKDE(this, SLOT(aboutKDE()), actionCollection(),"aboutKDE");
	KStdAction::reportBug(this, SLOT(reportBug()), actionCollection(),"reportBug");
	new KAction (i18n("&LabPlot Environment"), QIconSet(projectIcon),
			KShortcut(CTRL+SHIFT+Key_E), this, SLOT (Environment()),actionCollection(),"environment");
	
	new KAction (i18n("&Axes Label"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleAxesLabel()),actionCollection(),"axeslabel");
	new KAction (i18n("&Analysis"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleAnalysis()),actionCollection(),"analysis");
	new KAction (i18n("&Surface"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleSurface()),actionCollection(),"surface");
	new KAction (i18n("&3 d"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (example3d()),actionCollection(),"3d");
	new KAction (i18n("&Rydberg spectra"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleRydberg()),actionCollection(),"rydberg");
	new KAction (i18n("&Log axis scale"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleLog()),actionCollection(),"log");
	new KAction (i18n("&simple FFT"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleFFT()),actionCollection(),"simple_fft");
	new KAction (i18n("&Drawing objects"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleObjects()),actionCollection(),"objects_example");
	new KAction (i18n("&Histogram"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleHist()),actionCollection(),"hist_example");
	new KAction (i18n("&Nonlinear fitting"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleFit()),actionCollection(),"fit_example");
	new KAction (i18n("&Reading images"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleImage()),actionCollection(),"image_example");
	new KAction (i18n("&Pie Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (examplePie()),actionCollection(),"pie_example");
	new KAction (i18n("P&olar Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (examplePolar()),actionCollection(),"polar_example");
	new KAction (i18n("&Ternary Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleTernary()),actionCollection(),"ternary_example");
	new KAction (i18n("&Exponential Fit"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleExponentialFit()),actionCollection(),"exponential_fit_example");
	new KAction (i18n("&Multiple Plots"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleMultiplot()),actionCollection(),"multiplot_example");
	new KAction (i18n("&GRASS Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleGrass()),actionCollection(),"grass_example");
	new KAction (i18n("&Another Surface Plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleSurface2()),actionCollection(),"surface2_example");
	new KAction (i18n("&Reading Audio data"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleAudio()),actionCollection(),"audio_example");
	new KAction (i18n("&QWT 3D plot"), QIconSet(examplesIcon),
			KShortcut(0), this, SLOT (exampleQWT()),actionCollection(),"qwt_example");

	asx = new KAction (i18n("autoscale &x"), QIconSet(autoScaleXIcon),
			KShortcut(CTRL+Key_X), this, SLOT (autoScaleX()), actionCollection(),"autoscaleX");
	asy = new KAction (i18n("autoscale &y"), QIconSet(autoScaleYIcon),
			KShortcut(CTRL+Key_Y), this, SLOT (autoScaleY()), actionCollection(),"autoscaleY");
	asz = new KAction (i18n("autoscale &z"), QIconSet(autoScaleZIcon),
			KShortcut(CTRL+Key_Z), this, SLOT (autoScaleZ()), actionCollection(),"autoscaleZ");
	asall = new KAction (i18n("autoscale &all"), QIconSet(autoScaleAllIcon),
			KShortcut(CTRL+SHIFT+Key_A), this, SLOT (autoScaleAll()), actionCollection(),"autoscaleAll");
	maglens = new KAction (i18n("&magnify lens"), QIconSet(magLensIcon),
			KShortcut(CTRL+SHIFT+Key_M), this, SLOT (magLens()), actionCollection(),"magLens");
	panzoom = new KAction (i18n("&pan zoom"), QIconSet(panZoomIcon),
			KShortcut(CTRL+SHIFT+Key_P), this, SLOT (panZoom()), actionCollection(),"panZoom");
	sl = new KAction (i18n("shift &left"), QIconSet(leftIcon),
			KShortcut(Key_Left), this, SLOT (shiftLeft()), actionCollection(),"shiftleft");
	sr = new KAction (i18n("shift &right"), QIconSet(rightIcon),
			KShortcut(Key_Right), this, SLOT (shiftRight()), actionCollection(),"shiftright");
	su = new KAction (i18n("shift &up"), QIconSet(upIcon),
			KShortcut(Key_Up), this, SLOT (shiftUp()), actionCollection(),"shiftup");
	sd = new KAction (i18n("shift &down"), QIconSet(downIcon),
			KShortcut(Key_Down), this, SLOT (shiftDown()),actionCollection(),"shiftdown" );
	sxu = new KAction (i18n("scale x u&p"), QIconSet(scaleXUpIcon),
			KShortcut(Key_Plus), this, SLOT (scaleXUp()), actionCollection(),"scalexup");
	sxd = new KAction (i18n("scale x d&own"), QIconSet(scaleXDownIcon),
			KShortcut(Key_Minus), this, SLOT (scaleXDown()), actionCollection(),"scalexdown");
	syu = new KAction (i18n("&scale y up"), QIconSet(scaleYUpIcon),
			KShortcut(CTRL+Key_Plus), this, SLOT (scaleYUp()),actionCollection(),"scaleyup" );
	syd = new KAction (i18n("s&cale y down"), QIconSet(scaleYDownIcon),
			KShortcut(CTRL+Key_Minus), this, SLOT (scaleYDown()),actionCollection(),"scaleydown" );
	szu = new KAction (i18n("sc&ale z up"), QIconSet(scaleZUpIcon),
			KShortcut(ALT+Key_Plus), this, SLOT (scaleZUp()), actionCollection(),"scalezup");
	szd = new KAction (i18n("sca&le z down"), QIconSet(scaleZDownIcon),
			KShortcut(ALT+Key_Minus), this, SLOT (scaleZDown()), actionCollection(),"scalezdown");

	baseline = new KAction (i18n("Create &Baseline"), QIconSet(baselineIcon),
			KShortcut(ALT+Key_B), this, SLOT (defineBaseline()), actionCollection(),"baseline");
	region = new KAction (i18n("Create &Region"), QIconSet(regionIcon),
			KShortcut(ALT+Key_G), this, SLOT (defineRegion()), actionCollection(),"region");
	line = new KAction (i18n("Create &Line"), QIconSet(lineIcon),
			KShortcut(ALT+Key_J), this, SLOT (defineLine()), actionCollection(),"line");
	label = new KAction (i18n("Create L&abel"), QIconSet(labelIcon),
			KShortcut(ALT+Key_K), this, SLOT (defineLabel()), actionCollection(),"label");
	rect = new KAction (i18n("Create Re&ctangle"), QIconSet(rectIcon),
			KShortcut(CTRL+SHIFT+Key_R), this, SLOT (defineRect()), actionCollection(),"rect");
	ellipse = new KAction (i18n("Create &Ellipse"), QIconSet(ellipseIcon),
			KShortcut(ALT+Key_U), this, SLOT (defineEllipse()), actionCollection(),"ellipse");
	image = new KAction (i18n("Create &Image"), QIconSet(imageIcon),
			KShortcut(ALT+Key_M), this, SLOT (defineImage()), actionCollection(),"image");

	statusBar()->message(i18n("Welcome to LabPlot "LVERSION));
	
	createGUI(0);

	ws = new QWorkspace( this );	// LabPlot
	// TODO : Do i need this ?
	//connect(ws,SIGNAL(windowActivated(QWidget *)),this,SLOT(updateSheetList()));
	
	setCentralWidget(ws);

	// auto save
	autosaveTimer = new QTimer();
	connect(autosaveTimer,SIGNAL(timeout()),this,SLOT(save()));

	// apply user settings (config)
	readConfig();

	New();
	show();	// show MainWindow before evaluating script !
	
	// QSA
#ifdef HAVE_QSA
	qsproject = new QSProject(this);
	qsproject->addObject(this);

#ifdef HAVE_QSA_IDE
	QMimeSourceFactory *fac =  QMimeSourceFactory::defaultFactory();
	QStringList filepath = fac->filePath();
	// TODO : workbench images
	filepath +=QString("/sw/qsa-x11-free-1.1.0/src/ide/images/");
	fac->setFilePath(filepath);
	
	ide = new QSWorkbench( qsproject, this );
#endif

	readScript(fn);
#endif

	if(QFile::exists(fn) && fn.contains(".lpl")) {
		openfile(fn);
	}
	
	modified = false;

	sm = new QSignalMapper(this);
	connect(sm,SIGNAL(mapped(int)),this,SLOT(setActiveSheet(int)));
}

void MainWin::closeEvent(QCloseEvent *e) {
  	recent->saveEntries(config);
	
	if(modified) {
		int want_save = KMessageBox::warningYesNoCancel( this,
			i18n("The current project has been modified.\nDo you want to save it?"),
			i18n("Save Project"));
    		switch (want_save) {
      		case KMessageBox::Yes:
			save();
           		break;
      		case KMessageBox::No:
           		break;
      		case KMessageBox::Cancel:
           		return;
			break;
    		}
  	}
	
	// HACK : delete all LabPlot temp files
	KStandardDirs *stddirs = KGlobal::dirs();
	QStringList files = stddirs->findAllResources("tmp",QString("LabPlot*"));
	for ( QStringList::Iterator it = files.begin(); it != files.end(); ++it ) {
        	QFile file(*it);
		file.remove();
	}
	
	free(project);
	
	e->accept();
}

void MainWin::readScript(QString fn) {
#ifdef HAVE_QSA
	QSInterpreter *interpreter = qsproject->interpreter();
#ifdef HAVE_QSA_FAC
	// add module factory
	ModuleFactory factory(this,ws);
	interpreter->addObjectFactory( &factory );
#endif
	
	if(QFile::exists(fn) && fn.contains(".qs")) {
		kdDebug()<<"Reading script : "<<fn<<endl;
		QFile file(fn);
		if(!file.open(IO_ReadOnly)) {
			kdDebug()<<"Error reading script file "<<fn<<endl;
		}	
		QTextStream str(&file);
		QString code = str.read();
		kdDebug()<<"Evaluating code ... "<<endl;
		//kdDebug()<<code<<endl;
		interpreter->clear();
		interpreter->evaluate(code,this);

		// TODO : print out all values
/*		kdDebug()<<"Functions :"<<endl;
		QStringList funcs =  interpreter->functions();
		for ( QStringList::Iterator it = funcs.begin(); it != funcs.end(); ++it ) {
			kdDebug() << *it <<endl;
		}
		
		kdDebug()<<"Classes :"<<endl;
		QStringList classes =  interpreter->classes();
		for ( QStringList::Iterator it = classes.begin(); it != classes.end(); ++it ) {
			kdDebug() << *it <<endl;
		}
		
		kdDebug()<<"Variables :"<<endl;
		QStringList vars =  interpreter->variables();
		for ( QStringList::Iterator it = vars.begin(); it != vars.end(); ++it ) {
			kdDebug() << *it <<endl;
		}
*/		
	}
#endif
}

void MainWin::readConfig() {
	config->setGroup( "General Options" );
	resize(config->readNumEntry("Width",780),config->readNumEntry("Height",540));
	
	if (! config->readBoolEntry("MenubarEnabled",true))
		menuBar()->hide();
	menubar->setChecked(config->readBoolEntry("MenubarEnabled", true));

	if (! config->readBoolEntry("ToolbarEnabled",true))
		toolBar()->hide();
	toolbar->setChecked(config->readBoolEntry("ToolbarEnabled", true));

	if (! config->readBoolEntry("SideToolbarEnabled",true))
		toolBar("actions")->hide();
	sidetoolbar->setChecked(config->readBoolEntry("SideToolbarEnabled", true));

	toolBar("analysis")->hide();
	if (config->readBoolEntry("AnalysisToolbarEnabled",false))
		toolBar("analysis")->show();
	analysistoolbar->setChecked(config->readBoolEntry("AnalysisToolbarEnabled", false));

	toolBar("drawing")->hide();
	if (config->readBoolEntry("DrawingToolbarEnabled",false))
		toolBar("drawing")->show();
	drawingtoolbar->setChecked(config->readBoolEntry("DrawingToolbarEnabled", false));

	if (! config->readBoolEntry("StatusbarEnabled",true))
		statusBar()->hide();
	statusbar->setChecked(config->readBoolEntry("StatusbarEnabled", true));

	autosave=config->readBoolEntry("Autosave",true);
	autosaveinterval=config->readLongNumEntry("AutosaveInterval",600000);
	enableAutosave(autosave);
	setAutosaveInterval(autosaveinterval);
}

//! save all settings
void MainWin::saveSettings() {
	config->setGroup( "General Options" );
	config->writeEntry("Width",width());
	config->writeEntry("Height",height());
	config->writeEntry("Autosave",autosave);
	config->writeEntry("AutosaveInterval",autosaveinterval);

	config->writeEntry("MenubarEnabled",menuBar()->isVisible());
	config->writeEntry("ToolbarEnabled",toolBar()->isVisible());
	config->writeEntry("SideToolbarEnabled",toolBar("actions")->isVisible());
	config->writeEntry("AnalysisToolbarEnabled",toolBar("analysis")->isVisible());
	config->writeEntry("DrawingToolbarEnabled",toolBar("drawing")->isVisible());
	config->writeEntry("StatusbarEnabled",statusBar()->isVisible());
}

void MainWin::enableAutosave(bool as) {
	autosave=as;
	if (as) autosaveTimer->start(autosaveinterval);
	else autosaveTimer->stop();
}

void MainWin::toggleFullScreen() {
#if KDE_VERSION > 0x030004
	if (topLevelWidget()->isFullScreen())
		topLevelWidget()->showNormal();
	else
		topLevelWidget()->showFullScreen();
#else
	KMessageBox::error(this,i18n("Sorry. Fullscreen not supported in KDE 3.0!"));
#endif
}

//! Open the configure dialog
void MainWin::configure() {
	ConfigureDialog *cfgdlg = new ConfigureDialog(this,i18n("configure LabPlot"),config);
	if (cfgdlg->exec()) {
		readConfig();
	}
}

void MainWin::toggleMenuBar() {
	if(menuBar()->isVisible())
		menuBar()->hide();
	else
		menuBar()->show();
}

void MainWin::toggleToolBar() {
	if(toolBar()->isVisible())
		toolBar()->hide();
	else
		toolBar()->show();
}

void MainWin::toggleSideToolBar() {
	if(toolBar("actions")->isVisible())
		toolBar("actions")->hide();
	else
		toolBar("actions")->show();
}

void MainWin::toggleAnalysisToolBar() {
	if(toolBar("analysis")->isVisible())
		toolBar("analysis")->hide();
	else
		toolBar("analysis")->show();
}

void MainWin::toggleDrawingToolBar() {
	if(toolBar("drawing")->isVisible())
		toolBar("drawing")->hide();
	else
		toolBar("drawing")->show();
}

void MainWin::toggleStatusBar() {
	if(statusBar()->isVisible())
		statusBar()->hide();
	else
		statusBar()->show();
}

void MainWin::configureToolbars() {
	saveMainWindowSettings(config, QString("LabPlotMainWindow") );
	KEditToolbar dlg(factory());
	if ( dlg.exec() )
		applyMainWindowSettings(config, QString("LabPlotMainWindow") );
}

void MainWin::loadScript(QString fn) {
#ifdef HAVE_QSA
	if(fn.length()<1)
		fn = QFileDialog::getOpenFileName(i18n("script.qs"),QString("*.qs"),this);
	
	readScript(fn);
#else
	KMessageBox::error(this, i18n("Sorry. Your system has no scripting support!"));
#endif
}

void MainWin::openIDE() {
#ifdef HAVE_QSA
#ifdef HAVE_QSA_IDE
	// open the QSA Workbench
	ide->open();
#else
	QMessageBox::information( this, i18n("Disabled feature"),
		i18n("QSA Workbench has been disabled. Reconfigure to enable."),QMessageBox::Ok );
#endif
#endif
}

void MainWin::aboutKDE() {
	KHelpMenu *helpmenu = new KHelpMenu();
	helpmenu->aboutKDE();
}

void MainWin::reportBug() {
	KHelpMenu *helpmenu = new KHelpMenu();
	helpmenu->reportBug();
}

void MainWin::Environment() { (new LabPlotDialog(0))->show(); }

void MainWin::dropEvent(QDropEvent *e) {
	kdDebug()<<"MainWin::dropEvent()\n";

	QString text;

	// TODO : what about *.dat, etc. ?
	// TODO : handle compressed files
	if ( QTextDrag::decode(e, text) ) {
		// text = "file:/usr/dir/file.lpl"
		text = text.right(text.length()-5);

		kdDebug()<<"got file : \""<<text<<"\"\n";

		openfile(text);
    	}
}

void MainWin::newPlot(PType type) {
	Worksheet *p = activeWorksheet();

	if (p==0 || p->getPlot(p->API())->Type() == PQWT3D)
		p = newWorksheet();

	p->newPlot(type);
}

Spreadsheet* MainWin::newSpreadsheet() {
	kdDebug()<<"MainWin::newSpreadsheet()"<<endl;
	Spreadsheet *s = new Spreadsheet( ws, this, 0);
	kdDebug()<<"nr_s+nr_w = "<<nr_s<<'+'<<nr_w<<endl;
	setActiveSheet(nr_s+nr_w-1);
//	nr_spreadsheets++;

	return s;
}

Worksheet* MainWin::newWorksheet() {
	kdDebug()<<"MainWin::newWorksheet()"<<endl;
	Worksheet* p = new Worksheet( ws, this, 0);
//	nr_worksheets++;
	
	return p;
}

void MainWin::deleteActiveSheet() {
	kdDebug()<<"deleteActiveSheet()"<<endl;
	if(Worksheet *p = activeWorksheet()) { 
		delete p;
		setModified();
	}
	else if(Spreadsheet *s = activeSpreadsheet()) { 
		delete s;
		setModified();
	}
}

void MainWin::deletePlot() { 
	if(Worksheet *p = activeWorksheet())
		p->deleteActivePlot();
}

Worksheet *MainWin::activeWorksheet() {
//	kdDebug()<<"MainWin::activeWorksheet()"<<endl;
	QWidget *w = ws->activeWindow();
	if(w && w->caption().contains(i18n("Worksheet")))
		return (Worksheet *)w;
	else
		return 0;
}

Spreadsheet *MainWin::activeSpreadsheet() {
//	kdDebug()<<"MainWin::activeSpreadsheet()"<<endl;
	QWidget *w = ws->activeWindow();
	if(w && w->caption().contains(i18n("Spreadsheet")))
		return (Spreadsheet *)w;
	else
		return 0;
}

//! initialize the Main Window; open new project
void MainWin::New() {
	// close all Plots
	QWidgetList list = ws->windowList();
	for ( int i = int(list.count())-1; i >= 0; i-- ) {
		if(list.at(i)->caption().contains(i18n("Worksheet"))) {
			Worksheet *pw = ((Worksheet *) list.at(i));
			pw->close();
		}
		else if(list.at(i)->caption().contains(i18n("Spreadsheet"))) {
			Spreadsheet *s = ((Spreadsheet *) list.at(i));
			s->close();
		}
	}
	updateSheetList();

	gvpart=0;
	defining_region=0;
	defining_line=0;
	defining_rect=0;
	defining_ellipse=0;
	defining_label=false;
	defining_image=false;
	defining_baseline=false;
	defining_maglens=0;
	defining_panzoom=0;
	project = new Project();

	KTempFile *tmpfile = new KTempFile(QString::null,".lpl.gz");
	filename = tmpfile->name();
}

void MainWin::setActiveSheet(int i) {
	kdDebug()<<"set active sheet "<<i<<endl;
	ws->windowList().at(i)->setFocus();
}

void MainWin::updateSheetList() {
//	kdDebug()<<"MainWin::updateSheetList()"<<endl;
	QPtrList<KAction> sheetsActions;

	QWidgetList list = ws->windowList();
	nr_w=0, nr_s=0;
//	kdDebug()<<" number of windows = "<<list.count()<<endl;
	for ( int i = 0; i < int(list.count()); i++) {
		QString label = list.at(i)->caption();
		KKey key;
		QPixmap icon;
		if(label.contains(i18n("Worksheet"))) {
			key = KKey( "CTRL+" + QString::number(++nr_w) );	 // 1,2,3, ...
			icon = KGlobal::iconLoader()->loadIcon(QString("LabPlot"), KIcon::Desktop);
		}
		else {
			key = KKey( "ALT+" + QString::number(++nr_s) ); 	// 1,2,3, ...
			icon = QPixmap(spreadsheet_xpm);
		}
		KAction *action = new KAction(label,icon,KShortcut(),sm,SLOT(map()),actionCollection());
		action->setShortcut(KShortcut(key));	// prevent warnings for unnamed actions
		if(sm) sm->setMapping(action,i);
        	sheetsActions.append(action);
	}
	unplugActionList(QString("sheets"));
	plugActionList(QString("sheets"), sheetsActions);

	if ((int)(list.count()) == 0 || activeWorksheet()==0 || (activeWorksheet()->NrPlots()==0)) {
		save_action->setEnabled(false);
		save_as->setEnabled(false);
		project_action->setEnabled(false);
		explorer_action->setEnabled(false);
		export_image->setEnabled(false);
		export_ps->setEnabled(false);
		export_eps->setEnabled(false);
		export_pdf->setEnabled(false);
		export_svg->setEnabled(false);
		export_pic->setEnabled(false);
		export_pstoedit->setEnabled(false);
		export_ImageMagick->setEnabled(false);
		print_action->setEnabled(false);
		printpreview->setEnabled(false);
		graph_list->setEnabled(false);
		clear_action->setEnabled(false);
		close_action->setEnabled(false);
		deleteplot->setEnabled(false);
		operations->setEnabled(false);
		smooth->setEnabled(false);
		prune->setEnabled(false);
		average->setEnabled(false);
		hist->setEnabled(false);
		interpolation->setEnabled(false);
		differences->setEnabled(false);
		integration->setEnabled(false);
		regression->setEnabled(false);
		fft->setEnabled(false);
		convolution->setEnabled(false);
		fit->setEnabled(false);
		imagepro->setEnabled(false);
		arrange->setEnabled(false);
		overlay->setEnabled(false);
		plot->setEnabled(false);
		axes->setEnabled(false);
		title->setEnabled(false);
		legend->setEnabled(false);
		objects->setEnabled(false);
		asx->setEnabled(false);
		asy->setEnabled(false);
		asz->setEnabled(false);
		asall->setEnabled(false);
		panzoom->setEnabled(false);
		maglens->setEnabled(false);
		sl->setEnabled(false);
		sr->setEnabled(false);
		sd->setEnabled(false);
		su->setEnabled(false);
		sxu->setEnabled(false);
		sxd->setEnabled(false);
		syu->setEnabled(false);
		syd->setEnabled(false);
		szu->setEnabled(false);
		szd->setEnabled(false);
		region->setEnabled(false);
		baseline->setEnabled(false);
		line->setEnabled(false);
		label->setEnabled(false);
		rect->setEnabled(false);
		ellipse->setEnabled(false);
		image->setEnabled(false);
	}
	else {
		convolution->setEnabled(true);
		operations->setEnabled(true);
		save_action->setEnabled(true);
		save_as->setEnabled(true);
		project_action->setEnabled(true);
		explorer_action->setEnabled(true);
		export_image->setEnabled(true);
		export_ps->setEnabled(true);
		export_eps->setEnabled(true);
		export_pdf->setEnabled(true);
		export_svg->setEnabled(true);
		export_pic->setEnabled(true);
		export_pstoedit->setEnabled(true);
		export_ImageMagick->setEnabled(true);
		print_action->setEnabled(true);
		printpreview->setEnabled(true);
		graph_list->setEnabled(true);
		clear_action->setEnabled(true);
		close_action->setEnabled(true);
		deleteplot->setEnabled(true);
		smooth->setEnabled(true);
		prune->setEnabled(true);
		average->setEnabled(true);
		differences->setEnabled(true);
		integration->setEnabled(true);
#ifdef HAVE_GSL
		hist->setEnabled(true);
		interpolation->setEnabled(true);
		regression->setEnabled(true);
		fft->setEnabled(true);
		fit->setEnabled(true);
#endif
#if defined(HAVE_FFTW3) || defined(HAVE_FFTW)
		fft->setEnabled(true);
#endif
		arrange->setEnabled(true);
		plot->setEnabled(true);
		axes->setEnabled(true);
		title->setEnabled(true);
		legend->setEnabled(true);
		objects->setEnabled(true);
		asx->setEnabled(true);
		asy->setEnabled(true);
		asz->setEnabled(true);
		asall->setEnabled(true);
		panzoom->setEnabled(true);
		maglens->setEnabled(true);
		sl->setEnabled(true);
		sr->setEnabled(true);
		sd->setEnabled(true);
		su->setEnabled(true);
		sxu->setEnabled(true);
		sxd->setEnabled(true);
		syu->setEnabled(true);
		syd->setEnabled(true);
		szu->setEnabled(true);
		szd->setEnabled(true);
		region->setEnabled(true);
		baseline->setEnabled(true);
		line->setEnabled(true);
		label->setEnabled(true);
		rect->setEnabled(true);
		ellipse->setEnabled(true);
		image->setEnabled(true);
	}

	Worksheet *p = activeWorksheet();
	Spreadsheet *s = activeSpreadsheet();

	if(s) {
		clear_action->setEnabled(true);
		close_action->setEnabled(true);
		
		average->setEnabled(true);
		smooth->setEnabled(true);
		prune->setEnabled(true);
		differences->setEnabled(true);
		integration->setEnabled(true);
#ifdef HAVE_GSL
		hist->setEnabled(true);
		interpolation->setEnabled(true);
#endif
	}
	
	if (p) {
		worksheet_action->setEnabled(true);
		
		Plot *plot = p->getPlot(p->API());
		PType type=P2D;
		if (plot) {
			GraphList *gl = plot->getGraphList();
			type = plot->Type();
			
			if (gl->getNumber()<2) {
				convolution->setEnabled(false);
				operations->setEnabled(false);
			}
		}
		
		if(p->NrPlots()>1)
			overlay->setEnabled(true);

		if (type == PSURFACE || type == P3D) {
			smooth->setEnabled(false);
			prune->setEnabled(false);
			hist->setEnabled(false);
			differences->setEnabled(false);
			integration->setEnabled(false);
			regression->setEnabled(false);
			fft->setEnabled(false);
			fit->setEnabled(false);

			region->setEnabled(false);
			baseline->setEnabled(false);
		}
		if(type == PSURFACE)
			imagepro->setEnabled(true);
	}
	else {
		worksheet_action->setEnabled(false);
	}

	// show GRASS stuff only if GRASS is present
#ifndef HAVE_GRASS
	newgrassplot->setEnabled(false);
	grassdata->setEnabled(false);
#endif
	// show VTK stuff only if VTK is present
#ifndef HAVE_VTK
	newvtkplot->setEnabled(false);
	vtkdata->setEnabled(false);
#endif

#ifndef HAVE_GL
	qwt3d_plot->setEnabled(false);
	qwt3d_func->setEnabled(false);
	qwt3d_data->setEnabled(false);
	
#endif

	setModified();
}

void MainWin::clear() {
	Worksheet *p = activeWorksheet();
	Spreadsheet *s = activeSpreadsheet();
	if (p) p->New();
	if (s) s->Clear();

	updateSheetList();
}

void MainWin::open(QString fn) {
	if (fn.length()<1)
		fn = QFileDialog::getOpenFileName(i18n("out.lpl"),QString("*.lpl *.lpl.gz *.lpl.bz2"),this);

	openfile(fn);
}

//! Open a LabPlot project file (*.lpl) from recent url
void MainWin::open(const KURL& url) {
	QString fn;
	fn = url.path();
	openfile( fn );
}

/*! Open the project file fn ("filename" is global ) */
void MainWin::openfile(QString fn) {
	recent->addURL(fn);
	filename = fn;
	if (!fn.isEmpty()) {
		New();	// clear ws and all other stuff

		// create io device (if filterdev not found "no mime type for text/plain" generic methods are used)
		// force to return 0 if no filter is found
		QIODevice *file = KFilterDev::deviceForFile(fn,QString::null,TRUE);
		if (file==0) file = new QFile(fn);

		if ( file->open( IO_ReadOnly )) {
			QTextStream t(file);
			QString name, v;
			int version, tmpint;

			t>>name>>v>>name>>version;
			if (version>PROJECT_VERSION) {
				KMessageBox::error(this, i18n("Sorry. You need a newer version of LabPlot to open this project file!"));
				return;
			}
			project->setFilename(fn);
			project->setLabPlot(v);
			project->setVersion(version);
			if(version>8) {
				t.readLine();
				name=t.readLine();
				project->setTitle(name);
				name=t.readLine();
				project->setAuthor(name);
				if(version>14) {
					QDateTime dt;
					t>>tmpint;
					dt.setTime_t(tmpint);
					project->setCreated(dt);
					t>>tmpint;
					dt.setTime_t(tmpint);
					project->setModified(dt);
					t.readLine();
				}
				else {
					name=t.readLine();
					project->setCreated(QDateTime::fromString(name));
					name=t.readLine();
					project->setModified(QDateTime::fromString(name));
				}
				name=t.readLine();
				project->setComment(name);
			}
			else {
				// old files
				project->setCreated(QDateTime::fromString(QString("Sun Jan 1 00:00:00 2000")));
				project->setModified(QDateTime::fromString(QString("Sun Jan 1 00:00:00 2000")));
			}
			kdDebug()<<"Reading file "<<fn<<endl;
			kdDebug()<<"Found LabPlot file version "<<version<<" ("<<v<<')'<<endl;

			while (!t.eof()) {
				QString tmp;
				int i=0, type;

				t>>tmp>>i>>type;

				kdDebug()<<tmp<<" ("<<i+1<<") Type : "<<type<<endl;

				if (tmp == QString("Worksheet") ){
					if(version > 4 && version < 6)	{ // old plot style conversion
						if(type == 1)
							type = P2D;
						else if(type == 2 || type == 3)
							type = PSURFACE;
						else if(type == 4)
							type = P3D;

						kdDebug()<<"TYPE now : "<<type<<endl;
					}
					Worksheet *p = newWorksheet();
					p->open(&t,version,(PType)type);
				}
				else if (tmp == QString("Spreadsheet") ){
					Spreadsheet *s = newSpreadsheet();
					s->open(&t,version);
				}
			}

			statusBar()->message(i18n("Opened ")+fn);
		}
		delete file;
	}
}

void MainWin::save(QString fn) {
	if(fn.length()>0)
		filename=fn;

	kdDebug()<<"MainWin::save() filename = "<<filename<<endl;

	if (filename.length() < 1)
		saveAs();
	else {
		QIODevice *file = KFilterDev::deviceForFile(filename,QString::null,TRUE);
		if (file==0) file = new QFile(filename);
		
		if ( file->open( IO_WriteOnly )) {
			QTextStream t(file);
			t.precision(15);

			project->setFilename(filename);
			project->setVersion(PROJECT_VERSION);
			t<<"LabPlot " <<LVERSION <<" : "<<PROJECT_VERSION<<endl;
			t<<project->Title()<<endl;
			t<<project->Author()<<endl;
#if QT_VERSION > 0x030007
			t<<project->Created().toTime_t()<<endl;
			t<<QDateTime::currentDateTime().toTime_t()<<endl;
#else
			QDateTime stoneage(QDate(1970,1,1));
			t<<stoneage.secsTo(project->Created())<<endl;
			t<<stoneage.secsTo(QDateTime::currentDateTime())<<endl;
#endif
			project->setModified(QDateTime::currentDateTime());
			t<<project->Comment()<<endl;

			QWidgetList list = ws->windowList();
			int tmpw=0,tmps=0;
			for ( int i = 0; i < int(list.count()); i++ ) {
				if((list.at(i))->caption().contains("Worksheet")) {
					Worksheet *pw = ((Worksheet *) list.at(i));
					t<<"Worksheet "<<tmpw++<<' '<<pw->getPlot(pw->API())->Type()<<endl;
				        pw->save(&t);
				}
				else if((list.at(i))->caption().contains("Spreadsheet")) {
					Spreadsheet *s = ((Spreadsheet *) list.at(i));
					t<<"Spreadsheet "<<tmps++<<' '<<"0"<<endl;
				        s->save(&t);
				}
			}
			statusBar()->message(i18n("Saved ")+filename);
		}
		else {
			KMessageBox::error(this, i18n("Sorry. Could not open project file for writing!"));
		}
		delete file;
	}
}

void MainWin::importData(QString fn) { ImportDialog *d = new ImportDialog(this,fn,0); d->OK();}
void MainWin::exportPstoEdit(QString fn, int f, int s, double sc, double r) { 
	kdDebug()<<"exportPstoEdit()"<<endl;
	PstoEditDialog *d = new PstoEditDialog(this,fn,f,s,sc,r); 
	d->OK();
}
void MainWin::exportImageMagick(QString fn, int f, int sx, int sy, double r) { 
	kdDebug()<<"exportImageMagick()"<<endl;
	ImageMagickDialog *d = new ImageMagickDialog(this,fn,f,sx,sy,r); 
	d->OK();
}

void MainWin::graphDialog() { (new GraphListDialog(this))->show(); }
void MainWin::importDialog() { (new ImportDialog(this))->show(); }
void MainWin::exportPstoEditDialog() { (new PstoEditDialog(this))->show();}
void MainWin::exportImageMagickDialog() { (new ImageMagickDialog(this))->show(); }


void MainWin::exportPlot(QString fn, QString format) {
	QPopupMenu *exportpm = new QPopupMenu( 0 );
	QIntDict<QString> formats;
	formats.setAutoDelete( TRUE );

	// get format
	if(format.length()<1) {
		Worksheet *w = activeWorksheet();
		// Qwt3D IO formats
		if(w && w->getPlot(w->API())->Type() == PQWT3D) {
#ifdef HAVE_GL
			QStringList l = Qwt3D::IO::outputFormatList();
			for ( QStringList::Iterator it = l.begin(); it != l.end(); ++it )
				formats.insert( exportpm->insertItem( QString( "%1..." ).arg( *it ) ), new QString( *it ) );
#endif
		}
		else {
			// QImageIO formats
			for ( unsigned int i = 0; i < QImageIO::outputFormats().count(); i++ ) {
				QString str = QString( QImageIO::outputFormats().at( i ) );
				formats.insert( exportpm->insertItem( QString( "%1..." ).arg( str ) ), new QString( str ) );
    			}
		}

		exportpm->setMouseTracking( TRUE );
		int id = exportpm->exec(QCursor::pos());
		
		if(id == -1) return;
				
		if(format.length()<1)
			format = *formats[ id ];
	}

	if(fn.length()<1)
		fn = QFileDialog::getSaveFileName( QString::null, QString( "*.%1" ).arg( format.lower() ), this );

	// check if image file exists
	if ( QFile::exists(fn) ) {
		int answer = KMessageBox::warningYesNoCancel( this, i18n( "Overwrite\n\'%1\'?" ).arg( fn ), i18n("Save Project"));
			if (answer != KMessageBox::Yes)
				return;
	}

	Worksheet *p = activeWorksheet();
	if (p && !fn.isEmpty() )
		p->Export(fn,format);

	statusBar()->message(i18n("Plot Exported"));
}

//! export worksheet into file with svg format
void MainWin::exportSVG(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportSVG(fn);
	statusBar()->message(i18n("Exported File to svg format"));
}

//! export worksheet into file with pic format
void MainWin::exportPIC(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportPIC(fn);
	statusBar()->message(i18n("Exported File to pic format"));
}

//! export worksheet into file via gs to PS
void MainWin::exportPS(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportPS(fn);
	statusBar()->message(i18n("Exported File to postscript format"));
}

//! export worksheet into file via gs to EPS
void MainWin::exportEPS(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportEPS(fn);
	statusBar()->message(i18n("Exported File to eps format"));
}

//! export worksheet into file via gs to PDF
void MainWin::exportPDF(QString fn) {
	if (Worksheet *p = activeWorksheet()) p->ExportPDF(fn);
	statusBar()->message(i18n("Exported File to pdf format"));
}

//! Save project as
void MainWin::saveAs(QString fn) {
	if(fn.length()>0)
		filename = fn;
	else
		filename = QFileDialog::getSaveFileName(i18n("out.lpl"),QString("*.lpl *.lpl.gz *.lpl.bz2"),this);
	if (filename) {
		QFile file(filename);
		
		// check if project file exists
		if ( file.exists() ) {
			int answer = KMessageBox::warningYesNoCancel( this, 
				i18n( "Overwrite\n\'%1\'?" ).arg( filename ), i18n("Save Project"));
			if (answer == KMessageBox::Yes)
				save();
		}
		else {
			save();
		}
	}
//	else
//			KMessageBox::error(this, i18n("Could not save project. Wrong filename specified!"));
}

/*! edit project infos */
void MainWin::projectInfo() {
	if (Worksheet *p = activeWorksheet()) { (new ProjectDialog(p,0))->show();}
	setModified();
}

//! project explorer
void MainWin::projectExplorer() { if (Worksheet *p = activeWorksheet()) (new ExplorerDialog(p,0))->show(); }

//! Print active plot to Printer or File
void MainWin::print() {
	// TODO : make script interface
	if (Worksheet *p = activeWorksheet()) p->Print("out.ps");
	statusBar()->message(i18n("Plotted File"));
}

//! Print preview the activ plot
void MainWin::printPreview() {
	kdDebug()<<"MainWin::printPreview() : "<<printpreviewchecked<<endl;
	if (printpreviewchecked) {
//		kdDebug()<<"print preview is checked"<<endl;
		delete gvpart;
		gvpart=0;
		setCentralWidget(ws);
		printpreview->setChecked(FALSE);
		printpreviewchecked=FALSE;
		Worksheet *w = activeWorksheet();
		if(w) {
			Plot * p = w->getPlot(w->API());
#ifdef HAVE_GL
			if( p->Type() == PQWT3D) 
				p->draw(0,w->width(),w->height());		// update QWt3D plot
#endif
		}
		// how to delete the gv part gui elements ?
	}
	else {
//		kdDebug()<<"print preview not checked"<<endl;
		KLibFactory *factory = KLibLoader::self()->factory( "libkghostview" );

		// if not found try this (KDE 3.1)
		if (!factory)
			factory = KLibLoader::self()->factory( "libkghostviewpart" );

		if (factory) {
			kdDebug()<<"   factory found."<<endl;
			gvpart = (KParts::ReadOnlyPart *)factory->create( this,"kgvpart","KParts::ReadOnlyPart" );

			Worksheet *p = activeWorksheet();

			KTempFile *tmpfile = new KTempFile(QString::null,".ps");
			tmpfile->setAutoDelete(true);
			QString filename = tmpfile->name();

			if (p)	p->Print(filename);
			KURL url = KURL(filename);
			if(gvpart) {
				kdDebug()<<"   gvpart OK. filename = "<<filename<<endl;
				setCentralWidget( gvpart->widget() );
				gvpart->openURL(url);
				gvpart->widget()->show();
				//createGUI(gvpart);
			}
		}
		else
			KMessageBox::error(this, i18n("No libkghostview found !"));

		printpreview->setChecked(TRUE);
		printpreviewchecked=TRUE;
	}
}

/*! Close active Plot */
void MainWin::closeWin() {
	kdDebug()<<"close active sheet()"<<endl;
	// close the print preview if active
	if (gvpart) {
		delete gvpart;
		gvpart=0;
		setCentralWidget(ws);
		printpreview->setChecked(FALSE);
		printpreviewchecked=FALSE;
	}
	else {
        	Worksheet *p = activeWorksheet();
		Spreadsheet *s = activeSpreadsheet();
		// delete p;	-> crashes LabPlot
		if (p)  p->close();
		if (s) s->close();
	}
	updateSheetList();
}


/*! Open DataDialog (0) or FunctionDialog (1) for creating new <type> graph */
void MainWin::newDialog(bool d, PType type) {
	Worksheet *p = activeWorksheet();

	if (p==0)
		p = newWorksheet();

	Plot *plot = p->getPlot(p->API());
	
	// new worksheet if active plot is qwt3d
	if(plot &&  plot->Type() == PQWT3D)
		p = newWorksheet();
		
	if (!plot || plot->Type() != type) {
		kdDebug()<<"MainWin::newDialog() : open new plot"<<endl;
		p->newPlot(type);
	}
	
	if (d) {
		(new FunctionDialog(p,0,0,-1,type))->show();
	}
	else {	
		if (type == PGRASS)
			(new GRASSDialog(p,0,-1))->show();
		else if (type == PVTK)
			(new VTKDialog(p,0,-1))->show();
		else
			(new DataDialog(p,0,0,-1,type))->show();
	}
}

//! open functions with the active plot
void MainWin::averageDialog() { (new AverageListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();}
void MainWin::pruneDialog() { (new PruneListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::smoothDialog() { (new SmoothListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::operationsDialog() { (new OperationsListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::histDialog() { (new HistListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::interpolationDialog() { (new InterpolationListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::differencesDialog() { (new DifferencesListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::integrationDialog() { (new IntegrationListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::regressionDialog() { (new RegressionListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::fftDialog() { (new FFTListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::convolutionDialog() { (new ConvolutionListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::fitDialog() { (new FitListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }
void MainWin::imageDialog() { (new ImageListDialog(activeWorksheet(),activeSpreadsheet(),0))->show();  }

void MainWin::arrangeDialog() 
{ if (Worksheet *p = activeWorksheet()) (new ArrangePlotDialog(p,"ArrangeDialog"))->show(); }
void MainWin::overlayDialog() 
{ if (Worksheet *p = activeWorksheet()) (new OverlayPlotDialog(p,"OverlayDialog"))->show();}
void MainWin::worksheetDialog() 
{ if (Worksheet *p = activeWorksheet()) (new WorksheetDialog(p,"WorksheetDialog"))->show();}
void MainWin::plotSettingsDialog() { if (Worksheet *p = activeWorksheet()) (new PlotSettingsDialog(p,"PlotSettingsDialog"))->show(); } 
void MainWin::axesDialog() { if (Worksheet *p = activeWorksheet()) (new AxesDialog(p,"AxesDialog",0))->show(); }
void MainWin::titleDialog() { if (Worksheet *p = activeWorksheet()) (new TitleDialog(p,"TitleDialog"))->show(); } 
void MainWin::legendDialog() { if (Worksheet *p = activeWorksheet()) (new LegendDialog(p,"LegendDialog"))->show(); }
void MainWin::objectDialog() { if (Worksheet *p = activeWorksheet()) (new ObjectDialog(p,"ObjectDialog",0))->show();} 

void MainWin::autoScaleX() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->autoScaleX();
		p->updatePixmap();
	}
}

void MainWin::autoScaleY() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->autoScaleY();
		p->updatePixmap();
	}
}

void MainWin::autoScaleZ() {
	Worksheet *p = activeWorksheet();
	if (p && p->getPlot(p->API())->Type() == P3D) {
		p->getPlot(p->API())->autoScaleZ();
		p->updatePixmap();
	}
}

void MainWin::autoScaleAll() {
	autoScaleX();
	autoScaleY();
	autoScaleZ();
}

//! magnify selected range
void MainWin::magLens() {
	Worksheet *p = activeWorksheet();
	p->setCursor(QCursor(Qt::CrossCursor));
	
	defining_maglens=1;
}

//! pan zoom 
void MainWin::panZoom() { defining_panzoom=1; }

void MainWin::shiftLeft() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftLeft();
		p->updatePixmap();
	}
}

void MainWin::shiftRight() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftRight();
		p->updatePixmap();
	}
}

void MainWin::shiftUp() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftUp();
		p->updatePixmap();
	}
}

void MainWin::shiftDown() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->shiftDown();
		p->updatePixmap();
	}
}

void MainWin::scaleXUp() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleXUp();
		p->updatePixmap();
	}
}

void MainWin::scaleXDown() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleXDown();
		p->updatePixmap();
	}
}

void MainWin::scaleYUp() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleYUp();
		p->updatePixmap();
	}
}

void MainWin::scaleYDown() {
	if (Worksheet *p = activeWorksheet()) {
		p->getPlot(p->API())->scaleYDown();
		p->updatePixmap();
	}
}

void MainWin::scaleZUp() {
	Worksheet *p = activeWorksheet();
	if (p && p->getPlot(p->API())->Type() == P3D) {
		p->getPlot(p->API())->scaleZUp();
		p->updatePixmap();
	}
}

void MainWin::scaleZDown() {
	Worksheet *p = activeWorksheet();
	if (p && p->getPlot(p->API())->Type() == P3D) {
		p->getPlot(p->API())->scaleZDown();
		p->updatePixmap();
	}
}

void MainWin::defineRegion() {
	statusBar()->message(i18n("Create Region : click on left position"));
	defining_region=1;
}

void MainWin::defineBaseline() {
	statusBar()->message(i18n("Create Baseline : click on position"));
	defining_baseline=true;
}

void MainWin::defineLine() {
	statusBar()->message(i18n("Create Line : click on first position"));
	defining_line=1;
}

void MainWin::defineLabel() {
	statusBar()->message(i18n("Create Label : click on position"));
	defining_label=true;
}

void MainWin::defineRect() {
	statusBar()->message(i18n("Create Rectangle : click on upper left corner"));
	defining_rect=1;
}

void MainWin::defineEllipse() {
	statusBar()->message(i18n("Create Ellipse : click on upper left corner"));
	defining_ellipse=1;
}

void MainWin::defineImage() {
	statusBar()->message(i18n("Create Image : click on position"));
	defining_image=true;
}

QString MainWin::parseExpression(QString tmp,double value,int j) {
	int pos;
	char buf[100];
	sprintf(buf,"(%f)",value);
	do {
		pos = tmp.find(QRegExp(QChar(97+j)+QString("\\W")));
		if (pos>=0) {
			tmp.replace(pos,1," ");
			tmp.insert(pos,buf);
		}
	} while(pos>=0);
	do {
		pos = tmp.find(QRegExp(QString("\\W")+QChar(97+j)));
		if (pos>=0) {
			tmp.replace(pos+1,1," ");
			tmp.insert(pos+1,buf);
		}
	} while(pos>=0);

	return tmp;
}

double MainWin::formatLabel(QString value,int item) {
	double v;
	switch(item) {
	case 4: {		// datetime iso
		QDateTime datetime;
		datetime = datetime.fromString(value,Qt::ISODate);
//		kdDebug()<<"DATETIME : "<<datetime.toString()<<endl;
//		kdDebug()<<"\tsecsTo1970 : "<<-datetime.secsTo(QDate(1970,1,1))<<endl;
		v = -1.0*datetime.secsTo(QDate(1970,1,1));
		} break;
	case 3: {		// datetime text 
		QDateTime datetime;
		datetime = datetime.fromString(value,Qt::TextDate);
//		kdDebug()<<"DATETIME : "<<datetime.toString()<<endl;
//		kdDebug()<<"\tsecsTo1970 : "<<-datetime.secsTo(QDate(1970,1,1))<<endl;
		v = -1.0*datetime.secsTo(QDate(1970,1,1));
		} break;
	case 2: {		// date
		QDate date;
		date = date.fromString(value,Qt::ISODate);		// must be YYYY-MM-DD
		//kdDebug()<<"DATE : "<<date.toString()<<endl;
		//kdDebug()<<"\tdaysTo1970 : "<<date.daysTo(QDate(1970,1,1))<<endl;
		v = -1.0*date.daysTo(QDate(1970,1,1));
		} break;
	case 1: {		// time
		QTime time;
		time = time.fromString(value);
		v = -1.0/1000.0*time.msecsTo(QTime()); // for reading msecs
		} break;
	default:
		v=value.toDouble();
	}
	
	return v;
}
