// //LabPlot : DifferencesListDialog.cc

#include <stdio.h>
#include <stdlib.h>
#include <iostream>
#include <math.h>
#include <qstring.h>
#include <qlabel.h>
#include <qfiledialog.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#ifdef HAVE_GSL
#endif
#include "DifferencesListDialog.h"

using namespace std;

DifferencesListDialog::DifferencesListDialog(Worksheet *p, Spreadsheet *s, const char *name)
	: ListDialog(p, s, name)
{
	setCaption(i18n("Differences Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	Style style;
	Symbol symbol;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw);
	else
		styletab = simpleStyle(tw,0, &style, &symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void DifferencesListDialog::apply_clicked() {
	// TODO : more selected graphs ???
	
	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		// add column if needed
		bool empty=TRUE;
		for(int i=0;i<table->numRows();i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =FALSE;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows()-1;i++) {
			
			// insert into last column
			table->setText(i,newcol,QString::number(table->text(i+1,col).toDouble()-table->text(i,col).toDouble()));
		}
		return;	
	}
	
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->getNumber()==0)
		return;
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GRAPHType s = gl->getStruct(item);

	if (s == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();

		double xmin=0, xmax=1, ymin=0, ymax=1;
		for (int i = 0;i<nx-1;i++) {
			double x=(a[i].X()+a[i+1].X())/2;
			double y=(a[i+1].Y()-a[i].Y())/(a[i+1].X()-a[i].X());
			
			// new ranges
			if (i==0) {
				xmin=xmax=x;
				ymin=ymax=y;
			}
			else {
				x<xmin?xmin=x:0;
				x>xmax?xmax=x:0;
				y<ymin?ymin=y:0;
				y>ymax?ymax=y:0;
			}

			ptr[i].setPoint(x,y);
		}

		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString("differences of "+g->Label());

		Style style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		Symbol symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
		
		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,nx-1);
		p->addGraph2D(ng);
	}
	else if (s == GRAPH3D) {
		// TODO
	}
	else if (s == GRAPHM) {
		// TODO
	}

	updateList();
}
